"""The namespace contains types [MS-EMF]: Enhanced Metafile Format.
            2.3 EMF Records"""
from typing import List, Optional, Dict, Iterable
import enum
import aspose.pycore
import aspose.pydrawing
import aspose.imaging
import aspose.imaging.apsbuilder
import aspose.imaging.apsbuilder.dib
import aspose.imaging.asynctask
import aspose.imaging.brushes
import aspose.imaging.dithering
import aspose.imaging.exif
import aspose.imaging.exif.enums
import aspose.imaging.extensions
import aspose.imaging.fileformats
import aspose.imaging.fileformats.apng
import aspose.imaging.fileformats.bigtiff
import aspose.imaging.fileformats.bmp
import aspose.imaging.fileformats.bmp.structures
import aspose.imaging.fileformats.cdr
import aspose.imaging.fileformats.cdr.const
import aspose.imaging.fileformats.cdr.enum
import aspose.imaging.fileformats.cdr.objects
import aspose.imaging.fileformats.cdr.types
import aspose.imaging.fileformats.cmx
import aspose.imaging.fileformats.cmx.objectmodel
import aspose.imaging.fileformats.cmx.objectmodel.enums
import aspose.imaging.fileformats.cmx.objectmodel.specs
import aspose.imaging.fileformats.cmx.objectmodel.styles
import aspose.imaging.fileformats.core
import aspose.imaging.fileformats.core.vectorpaths
import aspose.imaging.fileformats.dicom
import aspose.imaging.fileformats.djvu
import aspose.imaging.fileformats.dng
import aspose.imaging.fileformats.dng.decoder
import aspose.imaging.fileformats.emf
import aspose.imaging.fileformats.emf.dtyp
import aspose.imaging.fileformats.emf.dtyp.commondatastructures
import aspose.imaging.fileformats.emf.emf
import aspose.imaging.fileformats.emf.emf.consts
import aspose.imaging.fileformats.emf.emf.objects
import aspose.imaging.fileformats.emf.emf.records
import aspose.imaging.fileformats.emf.emfplus
import aspose.imaging.fileformats.emf.emfplus.consts
import aspose.imaging.fileformats.emf.emfplus.objects
import aspose.imaging.fileformats.emf.emfplus.records
import aspose.imaging.fileformats.emf.emfspool
import aspose.imaging.fileformats.emf.emfspool.records
import aspose.imaging.fileformats.emf.graphics
import aspose.imaging.fileformats.eps
import aspose.imaging.fileformats.eps.consts
import aspose.imaging.fileformats.gif
import aspose.imaging.fileformats.gif.blocks
import aspose.imaging.fileformats.ico
import aspose.imaging.fileformats.jpeg
import aspose.imaging.fileformats.jpeg2000
import aspose.imaging.fileformats.opendocument
import aspose.imaging.fileformats.opendocument.enums
import aspose.imaging.fileformats.opendocument.objects
import aspose.imaging.fileformats.opendocument.objects.brush
import aspose.imaging.fileformats.opendocument.objects.font
import aspose.imaging.fileformats.opendocument.objects.graphic
import aspose.imaging.fileformats.opendocument.objects.pen
import aspose.imaging.fileformats.pdf
import aspose.imaging.fileformats.png
import aspose.imaging.fileformats.psd
import aspose.imaging.fileformats.svg
import aspose.imaging.fileformats.svg.graphics
import aspose.imaging.fileformats.tga
import aspose.imaging.fileformats.tiff
import aspose.imaging.fileformats.tiff.enums
import aspose.imaging.fileformats.tiff.filemanagement
import aspose.imaging.fileformats.tiff.filemanagement.bigtiff
import aspose.imaging.fileformats.tiff.instancefactory
import aspose.imaging.fileformats.tiff.pathresources
import aspose.imaging.fileformats.tiff.tifftagtypes
import aspose.imaging.fileformats.webp
import aspose.imaging.fileformats.wmf
import aspose.imaging.fileformats.wmf.consts
import aspose.imaging.fileformats.wmf.graphics
import aspose.imaging.fileformats.wmf.objects
import aspose.imaging.fileformats.wmf.objects.escaperecords
import aspose.imaging.imagefilters
import aspose.imaging.imagefilters.complexutils
import aspose.imaging.imagefilters.convolution
import aspose.imaging.imagefilters.filteroptions
import aspose.imaging.imageloadoptions
import aspose.imaging.imageoptions
import aspose.imaging.interfaces
import aspose.imaging.magicwand
import aspose.imaging.magicwand.imagemasks
import aspose.imaging.masking
import aspose.imaging.masking.options
import aspose.imaging.masking.result
import aspose.imaging.memorymanagement
import aspose.imaging.multithreading
import aspose.imaging.palettehelper
import aspose.imaging.progressmanagement
import aspose.imaging.shapes
import aspose.imaging.shapesegments
import aspose.imaging.sources
import aspose.imaging.watermark
import aspose.imaging.watermark.options
import aspose.imaging.xmp
import aspose.imaging.xmp.schemas
import aspose.imaging.xmp.schemas.dicom
import aspose.imaging.xmp.schemas.dublincore
import aspose.imaging.xmp.schemas.pdf
import aspose.imaging.xmp.schemas.photoshop
import aspose.imaging.xmp.schemas.xmpbaseschema
import aspose.imaging.xmp.schemas.xmpdm
import aspose.imaging.xmp.schemas.xmpmm
import aspose.imaging.xmp.schemas.xmprm
import aspose.imaging.xmp.types
import aspose.imaging.xmp.types.basic
import aspose.imaging.xmp.types.complex
import aspose.imaging.xmp.types.complex.colorant
import aspose.imaging.xmp.types.complex.dimensions
import aspose.imaging.xmp.types.complex.font
import aspose.imaging.xmp.types.complex.resourceevent
import aspose.imaging.xmp.types.complex.resourceref
import aspose.imaging.xmp.types.complex.thumbnail
import aspose.imaging.xmp.types.complex.version
import aspose.imaging.xmp.types.derived

class EmfAbortPath(EmfPathBracketRecordType):
    '''This record aborts a path bracket or discards the path from a closed path bracket.'''
    
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    ...

class EmfAlphaBlend(EmfBitmapRecordType):
    '''The EMR_ALPHABLEND record specifies a block transfer of pixels from a source bitmap to a
    destination rectangle, including alpha transparency data, according to a specified blending operation.'''
    
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets a WMF RectL object ([MS-WMF] section 2.2.2.19) that defines the
        destination bounding rectangle in device units.'''
        ...
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle):
        '''Sets a WMF RectL object ([MS-WMF] section 2.2.2.19) that defines the
        destination bounding rectangle in device units.'''
        ...
    
    @property
    def x_dest(self) -> int:
        ...
    
    @x_dest.setter
    def x_dest(self, value : int):
        ...
    
    @property
    def y_dest(self) -> int:
        ...
    
    @y_dest.setter
    def y_dest(self, value : int):
        ...
    
    @property
    def cx_dest(self) -> int:
        ...
    
    @cx_dest.setter
    def cx_dest(self, value : int):
        ...
    
    @property
    def cy_dest(self) -> int:
        ...
    
    @cy_dest.setter
    def cy_dest(self, value : int):
        ...
    
    @property
    def blend_function(self) -> aspose.imaging.fileformats.emf.emf.records.EmfBlendFunction:
        ...
    
    @blend_function.setter
    def blend_function(self, value : aspose.imaging.fileformats.emf.emf.records.EmfBlendFunction):
        ...
    
    @property
    def x_src(self) -> int:
        ...
    
    @x_src.setter
    def x_src(self, value : int):
        ...
    
    @property
    def y_src(self) -> int:
        ...
    
    @y_src.setter
    def y_src(self, value : int):
        ...
    
    @property
    def xform_sr(self) -> aspose.imaging.Matrix:
        ...
    
    @xform_sr.setter
    def xform_sr(self, value : aspose.imaging.Matrix):
        ...
    
    @property
    def bk_src_argb_32_color(self) -> int:
        ...
    
    @bk_src_argb_32_color.setter
    def bk_src_argb_32_color(self, value : int):
        ...
    
    @property
    def usage_src(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfDibColors:
        ...
    
    @usage_src.setter
    def usage_src(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfDibColors):
        ...
    
    @property
    def cx_src(self) -> int:
        ...
    
    @cx_src.setter
    def cx_src(self, value : int):
        ...
    
    @property
    def cy_src(self) -> int:
        ...
    
    @cy_src.setter
    def cy_src(self, value : int):
        ...
    
    @property
    def source_bitmap(self) -> aspose.imaging.fileformats.wmf.objects.WmfDeviceIndependentBitmap:
        ...
    
    @source_bitmap.setter
    def source_bitmap(self, value : aspose.imaging.fileformats.wmf.objects.WmfDeviceIndependentBitmap):
        ...
    
    ...

class EmfAngleArc(EmfDrawingRecordType):
    '''The EMR_ANGLEARC record specifies a line segment of an arc. The line segment is drawn from the
    current position to the beginning of the arc. The arc is drawn along the perimeter of a circle with the
    given radius and center. The length of the arc is defined by the given start and sweep angles'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def center(self) -> aspose.imaging.Point:
        '''Gets a 64-bit WMF PointL object, specified in [MS-WMF] section 2.2.2.15, which
        specifies the logical coordinates of the circle's center.'''
        ...
    
    @center.setter
    def center(self, value : aspose.imaging.Point):
        '''Sets a 64-bit WMF PointL object, specified in [MS-WMF] section 2.2.2.15, which
        specifies the logical coordinates of the circle's center.'''
        ...
    
    @property
    def radius(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the circle's radius, in logical units.'''
        ...
    
    @radius.setter
    def radius(self, value : int):
        '''Sets a 32-bit unsigned integer that specifies the circle's radius, in logical units.'''
        ...
    
    @property
    def start_angle(self) -> float:
        ...
    
    @start_angle.setter
    def start_angle(self, value : float):
        ...
    
    @property
    def sweep_angle(self) -> float:
        ...
    
    @sweep_angle.setter
    def sweep_angle(self, value : float):
        ...
    
    ...

class EmfArc(EmfDrawingRecordType):
    '''The EMR_ARC record specifies an elliptical arc.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def box(self) -> aspose.imaging.Rectangle:
        '''Gets a 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19, which
        specifies the inclusive-inclusive bounding rectangle.'''
        ...
    
    @box.setter
    def box(self, value : aspose.imaging.Rectangle):
        '''Sets a 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19, which
        specifies the inclusive-inclusive bounding rectangle.'''
        ...
    
    @property
    def start(self) -> aspose.imaging.Point:
        '''Gets a 64-bit WMF PointL object, specified in [MS-WMF] section 2.2.2.15, which
        specifies the coordinates, in logical units, of the ending point of the radial line defining the
        starting point of the arc.'''
        ...
    
    @start.setter
    def start(self, value : aspose.imaging.Point):
        '''Sets a 64-bit WMF PointL object, specified in [MS-WMF] section 2.2.2.15, which
        specifies the coordinates, in logical units, of the ending point of the radial line defining the
        starting point of the arc.'''
        ...
    
    @property
    def end(self) -> aspose.imaging.Point:
        '''Gets a 64-bit WMF PointL object that specifies the coordinates, in logical units, of
        the ending point of the radial line defining the ending point of the arc.'''
        ...
    
    @end.setter
    def end(self, value : aspose.imaging.Point):
        '''Sets a 64-bit WMF PointL object that specifies the coordinates, in logical units, of
        the ending point of the radial line defining the ending point of the arc.'''
        ...
    
    ...

class EmfArcTo(EmfDrawingRecordType):
    '''The EMR_ARCTO record specifies an elliptical arc. It resets the current position to the end point of the arc.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def box(self) -> aspose.imaging.Rectangle:
        '''Gets a 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19, which
        specifies the bounding rectangle.'''
        ...
    
    @box.setter
    def box(self, value : aspose.imaging.Rectangle):
        '''Sets a 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19, which
        specifies the bounding rectangle.'''
        ...
    
    @property
    def start(self) -> aspose.imaging.Point:
        '''Gets a 64-bit WMF PointL object, specified in [MS-WMF] section 2.2.2.15, which
        specifies the coordinates of the first radial ending point, in logical units.'''
        ...
    
    @start.setter
    def start(self, value : aspose.imaging.Point):
        '''Sets a 64-bit WMF PointL object, specified in [MS-WMF] section 2.2.2.15, which
        specifies the coordinates of the first radial ending point, in logical units.'''
        ...
    
    @property
    def end(self) -> aspose.imaging.Point:
        '''Gets a 64-bit WMF PointL object that specifies the coordinates of the second radial
        ending point, in logical units.'''
        ...
    
    @end.setter
    def end(self, value : aspose.imaging.Point):
        '''Sets a 64-bit WMF PointL object that specifies the coordinates of the second radial
        ending point, in logical units.'''
        ...
    
    ...

class EmfBeginPath(EmfPathBracketRecordType):
    '''This record opens a path bracket in the current playback device context.
    After a path bracket is open, an application can begin processing records to define
    the points that lie in the path.An application MUST close an open path bracket by
    processing the EMR_ENDPATH record.
    When an application processes the EMR_BEGINPATH record, all previous paths
    MUST be discarded from the playback device context.'''
    
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    ...

class EmfBitBlt(EmfBitmapRecordType):
    '''The EMR_BITBLT record specifies a block transfer of pixels from a source bitmap to a destination
    rectangle, optionally in combination with a brush pattern, according to a specified raster operation.'''
    
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets a WMF RectL object ([MS-WMF] section 2.2.2.19) that defines the
        destination bounding rectangle in device units.'''
        ...
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle):
        '''Sets a WMF RectL object ([MS-WMF] section 2.2.2.19) that defines the
        destination bounding rectangle in device units.'''
        ...
    
    @property
    def x_dest(self) -> int:
        ...
    
    @x_dest.setter
    def x_dest(self, value : int):
        ...
    
    @property
    def y_dest(self) -> int:
        ...
    
    @y_dest.setter
    def y_dest(self, value : int):
        ...
    
    @property
    def cx_dest(self) -> int:
        ...
    
    @cx_dest.setter
    def cx_dest(self, value : int):
        ...
    
    @property
    def cy_dest(self) -> int:
        ...
    
    @cy_dest.setter
    def cy_dest(self, value : int):
        ...
    
    @property
    def bit_blt_raster_operation(self) -> aspose.imaging.fileformats.wmf.consts.WmfTernaryRasterOperation:
        ...
    
    @bit_blt_raster_operation.setter
    def bit_blt_raster_operation(self, value : aspose.imaging.fileformats.wmf.consts.WmfTernaryRasterOperation):
        ...
    
    @property
    def x_src(self) -> int:
        ...
    
    @x_src.setter
    def x_src(self, value : int):
        ...
    
    @property
    def y_src(self) -> int:
        ...
    
    @y_src.setter
    def y_src(self, value : int):
        ...
    
    @property
    def xform_src(self) -> aspose.imaging.Matrix:
        ...
    
    @xform_src.setter
    def xform_src(self, value : aspose.imaging.Matrix):
        ...
    
    @property
    def bk_src_argb_32_color(self) -> int:
        ...
    
    @bk_src_argb_32_color.setter
    def bk_src_argb_32_color(self, value : int):
        ...
    
    @property
    def usage_src(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfDibColors:
        ...
    
    @usage_src.setter
    def usage_src(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfDibColors):
        ...
    
    @property
    def source_bitmap(self) -> aspose.imaging.fileformats.wmf.objects.WmfDeviceIndependentBitmap:
        ...
    
    @source_bitmap.setter
    def source_bitmap(self, value : aspose.imaging.fileformats.wmf.objects.WmfDeviceIndependentBitmap):
        ...
    
    ...

class EmfBitmapRecordType(EmfRecord):
    '''The bitmap record types perform block transfers of bitmap images.'''
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    ...

class EmfBlendFunction:
    '''A structure that specifies the blending operations for source and destination bitmaps.'''
    
    @overload
    def __init__(self, dword_data: int):
        '''Initializes a new instance of the  class.
        
        :param dword_data: The dword data.'''
        ...
    
    @overload
    def __init__(self):
        ...
    
    def to_int(self) -> int:
        '''Converts the string representation of a number to an integer.
        
        :returns: The DWORD value of structure.'''
        ...
    
    @property
    def blend_operation(self) -> byte:
        ...
    
    @property
    def blend_flags(self) -> byte:
        ...
    
    @property
    def src_constant_alpha(self) -> byte:
        ...
    
    @property
    def alpha_format(self) -> EmfBlendFunction.AlphaFormatEnum:
        ...
    
    ...

class EmfChord(EmfDrawingRecordType):
    '''The EMR_CHORD record specifies a chord, which is a region bounded by the intersection of an
    ellipse and a line segment, called a secant. The chord is outlined by using the current pen and filled
    by using the current brush.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def box(self) -> aspose.imaging.Rectangle:
        '''Gets a 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19, which
        specifies the inclusive-inclusive bounding rectangle.'''
        ...
    
    @box.setter
    def box(self, value : aspose.imaging.Rectangle):
        '''Sets a 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19, which
        specifies the inclusive-inclusive bounding rectangle.'''
        ...
    
    @property
    def start(self) -> aspose.imaging.Point:
        '''Gets a 64-bit WMF PointL object, specified in [MS-WMF] section 2.2.2.15, which
        specifies the logical coordinates of the endpoint of the radial defining the beginning of the chord.'''
        ...
    
    @start.setter
    def start(self, value : aspose.imaging.Point):
        '''Sets a 64-bit WMF PointL object, specified in [MS-WMF] section 2.2.2.15, which
        specifies the logical coordinates of the endpoint of the radial defining the beginning of the chord.'''
        ...
    
    @property
    def end(self) -> aspose.imaging.Point:
        '''Gets a 64-bit WMF PointL object that specifies the logical coordinates of the
        endpoint of the radial defining the end of the chord.'''
        ...
    
    @end.setter
    def end(self, value : aspose.imaging.Point):
        '''Sets a 64-bit WMF PointL object that specifies the logical coordinates of the
        endpoint of the radial defining the end of the chord.'''
        ...
    
    ...

class EmfClippingRecordType(EmfRecord):
    '''The clipping record types specify and manage clipping regions.
    Note  The EMR_SETMETARGN record does not specify parameters.'''
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    ...

class EmfCloseFigure(EmfPathBracketRecordType):
    '''This record closes an open figure in a path.
    Processing the EMR_CLOSEFIGURE record MUST close the figure by drawing a line
    from the current position to the first point of the figure, and then it MUST connect
    the lines by using the line join style.If a figure is closed by processing the
    EMR_LINETO record instead of the EMR_CLOSEFIGURE record, end caps are
    used to create the corner instead of a join.EMR_LINETO is specified in section
    2.3.5.13.
    The EMR_CLOSEFIGURE record SHOULD only be used if there is an open path
    bracket in the playback device context.
    A figure in a path is open unless it is explicitly closed by processing this record.'''
    
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    ...

class EmfColorCorrectPalette(EmfObjectManipulationRecordType):
    '''The EMR_COLORCORRECTPALETTE record specifies how to correct the entries of a logical palette
    object using WCS 1.0 values.'''
    
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def ih_palette(self) -> int:
        ...
    
    @ih_palette.setter
    def ih_palette(self, value : int):
        ...
    
    @property
    def n_first_entry(self) -> int:
        ...
    
    @n_first_entry.setter
    def n_first_entry(self, value : int):
        ...
    
    @property
    def n_pal_entries(self) -> int:
        ...
    
    @n_pal_entries.setter
    def n_pal_entries(self, value : int):
        ...
    
    ...

class EmfColorMatchToTargetW(EmfStateRecordType):
    '''The EMR_COLORMATCHTOTargetW record specifies whether to perform color matching with a color
    profile that is specified in a file with a name consisting of Unicode characters.'''
    
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def dw_action(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfColorSpace:
        ...
    
    @dw_action.setter
    def dw_action(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfColorSpace):
        ...
    
    @property
    def dw_flags(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfColorMatchToTarget:
        ...
    
    @dw_flags.setter
    def dw_flags(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfColorMatchToTarget):
        ...
    
    @property
    def cb_name(self) -> int:
        ...
    
    @cb_name.setter
    def cb_name(self, value : int):
        ...
    
    @property
    def cb_data(self) -> int:
        ...
    
    @cb_data.setter
    def cb_data(self, value : int):
        ...
    
    @property
    def data(self) -> bytes:
        '''Gets an array of size (cbName + cbData) in bytes, which specifies the UTF16-LE
        name and raw data of the desired color profile.'''
        ...
    
    @data.setter
    def data(self, value : bytes):
        '''Sets an array of size (cbName + cbData) in bytes, which specifies the UTF16-LE
        name and raw data of the desired color profile.'''
        ...
    
    @property
    def name(self) -> str:
        '''Gets the name'''
        ...
    
    @property
    def raw_data(self) -> bytes:
        ...
    
    ...

class EmfComment(EmfCommentRecordType):
    '''The EMR_COMMENT record contains arbitrary private data.
    Note  Fields that are not described in this section are specified in section 2.3.3.'''
    
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def data_size(self) -> int:
        ...
    
    @data_size.setter
    def data_size(self, value : int):
        ...
    
    @property
    def comment_identifier(self) -> EmfCommentRecordType.CommentIdentifierEnum:
        ...
    
    @comment_identifier.setter
    def comment_identifier(self, value : EmfCommentRecordType.CommentIdentifierEnum):
        ...
    
    @property
    def private_data(self) -> bytes:
        ...
    
    @private_data.setter
    def private_data(self, value : bytes):
        ...
    
    ...

class EmfCommentBeginGroup(EmfCommentPublicRecordType):
    '''The EMR_COMMENT_BEGINGROUP record specifies the beginning of a group of drawing records.'''
    
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def data_size(self) -> int:
        ...
    
    @data_size.setter
    def data_size(self, value : int):
        ...
    
    @property
    def comment_identifier(self) -> EmfCommentRecordType.CommentIdentifierEnum:
        ...
    
    @comment_identifier.setter
    def comment_identifier(self, value : EmfCommentRecordType.CommentIdentifierEnum):
        ...
    
    @property
    def public_comment_identifier(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfEmrComment:
        ...
    
    @public_comment_identifier.setter
    def public_comment_identifier(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfEmrComment):
        ...
    
    @property
    def rectangle(self) -> aspose.imaging.Rectangle:
        '''Gets a WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the
        output rectangle in logical coordinates.'''
        ...
    
    @rectangle.setter
    def rectangle(self, value : aspose.imaging.Rectangle):
        '''Sets a WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the
        output rectangle in logical coordinates.'''
        ...
    
    @property
    def n_description(self) -> int:
        ...
    
    @n_description.setter
    def n_description(self, value : int):
        ...
    
    @property
    def description(self) -> str:
        '''Gets an optional, null-terminated Unicode string that describes this group of records.'''
        ...
    
    @description.setter
    def description(self, value : str):
        '''Sets an optional, null-terminated Unicode string that describes this group of records.'''
        ...
    
    ...

class EmfCommentEmfPlus(EmfCommentRecordType):
    '''The EMR_COMMENT_EMFPLUS record contains embedded EMF+ records.
    Note  Fields that are not described in this section are specified in section 2.3.3.'''
    
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def data_size(self) -> int:
        ...
    
    @data_size.setter
    def data_size(self, value : int):
        ...
    
    @property
    def comment_identifier(self) -> EmfCommentRecordType.CommentIdentifierEnum:
        ...
    
    @comment_identifier.setter
    def comment_identifier(self, value : EmfCommentRecordType.CommentIdentifierEnum):
        ...
    
    @property
    def emf_plus_records(self) -> List[aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord]:
        ...
    
    @emf_plus_records.setter
    def emf_plus_records(self, value : List[aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord]):
        ...
    
    ...

class EmfCommentEmfSpool(EmfCommentRecordType):
    '''The EMR_COMMENT_EMFSPOOL record contains embedded EMFSPOOL records.
    Note  Fields that are not described in this section are specified in section 2.3.3.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def data_size(self) -> int:
        ...
    
    @data_size.setter
    def data_size(self, value : int):
        ...
    
    @property
    def comment_identifier(self) -> EmfCommentRecordType.CommentIdentifierEnum:
        ...
    
    @comment_identifier.setter
    def comment_identifier(self, value : EmfCommentRecordType.CommentIdentifierEnum):
        ...
    
    @property
    def emf_spool_record_identifier(self) -> EmfCommentEmfSpool.EmfSpoolRecordIdentifierEnum:
        ...
    
    @emf_spool_record_identifier.setter
    def emf_spool_record_identifier(self, value : EmfCommentEmfSpool.EmfSpoolRecordIdentifierEnum):
        ...
    
    @property
    def emf_spool_records(self) -> List[aspose.imaging.fileformats.emf.emfspool.records.EmfSpoolFontDefinitionRecordType]:
        ...
    
    @emf_spool_records.setter
    def emf_spool_records(self, value : List[aspose.imaging.fileformats.emf.emfspool.records.EmfSpoolFontDefinitionRecordType]):
        ...
    
    ...

class EmfCommentEndGroup(EmfCommentPublicRecordType):
    '''The EMR_COMMENT_ENDGROUP record specifies the end of a group of drawing records.'''
    
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def data_size(self) -> int:
        ...
    
    @data_size.setter
    def data_size(self, value : int):
        ...
    
    @property
    def comment_identifier(self) -> EmfCommentRecordType.CommentIdentifierEnum:
        ...
    
    @comment_identifier.setter
    def comment_identifier(self, value : EmfCommentRecordType.CommentIdentifierEnum):
        ...
    
    @property
    def public_comment_identifier(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfEmrComment:
        ...
    
    @public_comment_identifier.setter
    def public_comment_identifier(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfEmrComment):
        ...
    
    ...

class EmfCommentMultiFormats(EmfCommentPublicRecordType):
    '''The EMR_COMMENT_MULTIFORMATS record specifies an image in multiple graphics formats.'''
    
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def data_size(self) -> int:
        ...
    
    @data_size.setter
    def data_size(self, value : int):
        ...
    
    @property
    def comment_identifier(self) -> EmfCommentRecordType.CommentIdentifierEnum:
        ...
    
    @comment_identifier.setter
    def comment_identifier(self, value : EmfCommentRecordType.CommentIdentifierEnum):
        ...
    
    @property
    def public_comment_identifier(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfEmrComment:
        ...
    
    @public_comment_identifier.setter
    def public_comment_identifier(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfEmrComment):
        ...
    
    @property
    def output_rect(self) -> aspose.imaging.Rectangle:
        ...
    
    @output_rect.setter
    def output_rect(self, value : aspose.imaging.Rectangle):
        ...
    
    @property
    def a_formats(self) -> List[aspose.imaging.fileformats.emf.emf.objects.EmfFormat]:
        ...
    
    @a_formats.setter
    def a_formats(self, value : List[aspose.imaging.fileformats.emf.emf.objects.EmfFormat]):
        ...
    
    @property
    def format_data(self) -> List[bytes]:
        ...
    
    @format_data.setter
    def format_data(self, value : List[bytes]):
        ...
    
    ...

class EmfCommentPublicRecordType(EmfCommentRecordType):
    '''The EMR_COMMENT_PUBLIC record types specify extensions to EMF processing.'''
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def data_size(self) -> int:
        ...
    
    @data_size.setter
    def data_size(self, value : int):
        ...
    
    @property
    def comment_identifier(self) -> EmfCommentRecordType.CommentIdentifierEnum:
        ...
    
    @comment_identifier.setter
    def comment_identifier(self, value : EmfCommentRecordType.CommentIdentifierEnum):
        ...
    
    @property
    def public_comment_identifier(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfEmrComment:
        ...
    
    @public_comment_identifier.setter
    def public_comment_identifier(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfEmrComment):
        ...
    
    ...

class EmfCommentRecordType(EmfRecord):
    '''The comment record types define formats for specifying arbitrary private data, embedding records
    in other metafile formats, and adding new or special-purpose commands.'''
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def data_size(self) -> int:
        ...
    
    @data_size.setter
    def data_size(self, value : int):
        ...
    
    @property
    def comment_identifier(self) -> EmfCommentRecordType.CommentIdentifierEnum:
        ...
    
    @comment_identifier.setter
    def comment_identifier(self, value : EmfCommentRecordType.CommentIdentifierEnum):
        ...
    
    ...

class EmfCommentWindowsMetaFile(EmfCommentPublicRecordType):
    '''The EMR_COMMENT_WINDOWS_METAFILE record specifies an image in an embedded WMF metafile.'''
    
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def data_size(self) -> int:
        ...
    
    @data_size.setter
    def data_size(self, value : int):
        ...
    
    @property
    def comment_identifier(self) -> EmfCommentRecordType.CommentIdentifierEnum:
        ...
    
    @comment_identifier.setter
    def comment_identifier(self, value : EmfCommentRecordType.CommentIdentifierEnum):
        ...
    
    @property
    def public_comment_identifier(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfEmrComment:
        ...
    
    @public_comment_identifier.setter
    def public_comment_identifier(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfEmrComment):
        ...
    
    @property
    def version(self) -> aspose.imaging.fileformats.wmf.consts.WmfMetafileVersion:
        '''Gets a 16-bit unsigned integer that specifies the WMF metafile version in terms
        of support for device-independent bitmaps (DIBs), from the WMF MetafileVersion
        enumeration ([MS-WMF] section 2.1.1.19).'''
        ...
    
    @version.setter
    def version(self, value : aspose.imaging.fileformats.wmf.consts.WmfMetafileVersion):
        '''Sets a 16-bit unsigned integer that specifies the WMF metafile version in terms
        of support for device-independent bitmaps (DIBs), from the WMF MetafileVersion
        enumeration ([MS-WMF] section 2.1.1.19).'''
        ...
    
    @property
    def checksum(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the checksum for this record.'''
        ...
    
    @checksum.setter
    def checksum(self, value : int):
        '''Sets a 32-bit unsigned integer that specifies the checksum for this record.'''
        ...
    
    @property
    def flags(self) -> int:
        '''Gets a 32-bit value that MUST be 0x00000000 and MUST be ignored.'''
        ...
    
    @flags.setter
    def flags(self, value : int):
        '''Sets a 32-bit value that MUST be 0x00000000 and MUST be ignored.'''
        ...
    
    @property
    def win_metafile_size(self) -> int:
        ...
    
    @win_metafile_size.setter
    def win_metafile_size(self, value : int):
        ...
    
    @property
    def win_metafile(self) -> aspose.imaging.fileformats.emf.MetaImage:
        ...
    
    @win_metafile.setter
    def win_metafile(self, value : aspose.imaging.fileformats.emf.MetaImage):
        ...
    
    ...

class EmfControlRecordType(EmfRecord):
    '''The control record types define the start and end of an EMF metafile and properties of the metafile.'''
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    ...

class EmfCreateBrushIndirect(EmfObjectCreationRecordType):
    '''The EMR_CREATEBRUSHINDIRECT record defines a logical brush for graphics operations.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def ih_brush(self) -> int:
        ...
    
    @ih_brush.setter
    def ih_brush(self, value : int):
        ...
    
    @property
    def log_brush(self) -> aspose.imaging.fileformats.emf.emf.objects.EmfLogBrushEx:
        ...
    
    @log_brush.setter
    def log_brush(self, value : aspose.imaging.fileformats.emf.emf.objects.EmfLogBrushEx):
        ...
    
    ...

class EmfCreateColorSpace(EmfObjectCreationRecordType):
    '''The EMR_CREATECOLORSPACE record creates a logical color space object from a color profile with a
    name consisting of ASCII characters.'''
    
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def ih_cs(self) -> int:
        ...
    
    @ih_cs.setter
    def ih_cs(self, value : int):
        ...
    
    @property
    def lcs(self) -> aspose.imaging.fileformats.wmf.objects.WmfLogColorSpace:
        '''Gets a WMF LogColorSpace object ([MS-WMF] section 2.2.2.11), which can specify
        the name of a color profile in ASCII characters.'''
        ...
    
    @lcs.setter
    def lcs(self, value : aspose.imaging.fileformats.wmf.objects.WmfLogColorSpace):
        '''Sets a WMF LogColorSpace object ([MS-WMF] section 2.2.2.11), which can specify
        the name of a color profile in ASCII characters.'''
        ...
    
    ...

class EmfCreateColorSpaceW(EmfObjectCreationRecordType):
    '''The EMR_CREATECOLORSPACEW record creates a logical color space object from a color profile with
    a name consisting of Unicode characters.'''
    
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def ih_cs(self) -> int:
        ...
    
    @ih_cs.setter
    def ih_cs(self, value : int):
        ...
    
    @property
    def lcs(self) -> aspose.imaging.fileformats.wmf.objects.WmfLogColorSpaceW:
        '''Gets a WMF LogColorSpaceW object ([MS-WMF] section 2.2.2.12) that can specify
        the name of a color profile in Unicode UTF16-LE characters'''
        ...
    
    @lcs.setter
    def lcs(self, value : aspose.imaging.fileformats.wmf.objects.WmfLogColorSpaceW):
        '''Sets a WMF LogColorSpaceW object ([MS-WMF] section 2.2.2.12) that can specify
        the name of a color profile in Unicode UTF16-LE characters'''
        ...
    
    @property
    def dw_flags(self) -> int:
        ...
    
    @dw_flags.setter
    def dw_flags(self, value : int):
        ...
    
    @property
    def cb_data(self) -> int:
        ...
    
    @cb_data.setter
    def cb_data(self, value : int):
        ...
    
    @property
    def data(self) -> bytes:
        '''Gets an optional array of bytes that specifies color profile data.'''
        ...
    
    @data.setter
    def data(self, value : bytes):
        '''Sets an optional array of bytes that specifies color profile data.'''
        ...
    
    ...

class EmfCreateDibPatternBrushPt(EmfObjectCreationRecordType):
    '''The EMR_CREATEDIBPATTERNBRUSHPT record defines a pattern brush for graphics operations. The
    pattern is specified by a DIB.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def ih_brush(self) -> int:
        ...
    
    @ih_brush.setter
    def ih_brush(self, value : int):
        ...
    
    @property
    def usage(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfDibColors:
        '''Gets a 32-bit unsigned integer that specifies how to interpret values in the color
        table in the DIB header. This value MUST be in the DIBColors enumeration (section 2.1.9).'''
        ...
    
    @usage.setter
    def usage(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfDibColors):
        '''Sets a 32-bit unsigned integer that specifies how to interpret values in the color
        table in the DIB header. This value MUST be in the DIBColors enumeration (section 2.1.9).'''
        ...
    
    @property
    def bitmap_buffer(self) -> aspose.imaging.fileformats.wmf.objects.WmfDeviceIndependentBitmap:
        ...
    
    @bitmap_buffer.setter
    def bitmap_buffer(self, value : aspose.imaging.fileformats.wmf.objects.WmfDeviceIndependentBitmap):
        ...
    
    ...

class EmfCreateMonoBrush(EmfObjectCreationRecordType):
    '''The EMR_CREATEMONOBRUSH record defines a monochrome pattern brush for graphics operations.
    The pattern is specified by a monochrome DIB.'''
    
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def ih_brush(self) -> int:
        ...
    
    @ih_brush.setter
    def ih_brush(self, value : int):
        ...
    
    @property
    def usage(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfDibColors:
        '''Gets a 32-bit unsigned integer that specifies how to interpret values in the color
        table in the DIB header. This value MUST be in the DIBColors enumeration (section 2.1.9).'''
        ...
    
    @usage.setter
    def usage(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfDibColors):
        '''Sets a 32-bit unsigned integer that specifies how to interpret values in the color
        table in the DIB header. This value MUST be in the DIBColors enumeration (section 2.1.9).'''
        ...
    
    @property
    def bitmap_buffer(self) -> aspose.imaging.fileformats.wmf.objects.WmfDeviceIndependentBitmap:
        ...
    
    @bitmap_buffer.setter
    def bitmap_buffer(self, value : aspose.imaging.fileformats.wmf.objects.WmfDeviceIndependentBitmap):
        ...
    
    ...

class EmfCreatePalette(EmfObjectCreationRecordType):
    '''The EMR_CREATEPALETTE record defines a logical palette for graphics operations.'''
    
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def ih_pal(self) -> int:
        ...
    
    @ih_pal.setter
    def ih_pal(self, value : int):
        ...
    
    @property
    def log_palette(self) -> aspose.imaging.fileformats.emf.emf.objects.EmfLogPalette:
        ...
    
    @log_palette.setter
    def log_palette(self, value : aspose.imaging.fileformats.emf.emf.objects.EmfLogPalette):
        ...
    
    ...

class EmfCreatePen(EmfObjectCreationRecordType):
    '''The EMR_CREATEPEN record defines a logical pen for graphics operations.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def ih_pen(self) -> int:
        ...
    
    @ih_pen.setter
    def ih_pen(self, value : int):
        ...
    
    @property
    def log_pen(self) -> aspose.imaging.fileformats.emf.emf.objects.EmfLogPen:
        ...
    
    @log_pen.setter
    def log_pen(self, value : aspose.imaging.fileformats.emf.emf.objects.EmfLogPen):
        ...
    
    ...

class EmfDeleteColorSpace(EmfObjectManipulationRecordType):
    '''The EMR_DELETECOLORSPACE record deletes a logical color space object.'''
    
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def ih_cs(self) -> int:
        ...
    
    @ih_cs.setter
    def ih_cs(self, value : int):
        ...
    
    ...

class EmfDeleteObject(EmfRecord):
    '''The EMR_DELETEOBJECT record deletes a graphics object, which is specified by its index in the EMF Object Table(section 3.1.1.1).'''
    
    @overload
    def __init__(self, record: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param record: The record.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def object_handle(self) -> int:
        ...
    
    @object_handle.setter
    def object_handle(self, value : int):
        ...
    
    ...

class EmfDrawEscape(EmfEscapeRecordType):
    '''The EMR_DRAWESCAPE record passes arbitrary information to a printer driver. The intent is that the
    information will result in drawing being done.'''
    
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def escape(self) -> aspose.imaging.fileformats.wmf.consts.WmfMetafileEscapes:
        ...
    
    @escape.setter
    def escape(self, value : aspose.imaging.fileformats.wmf.consts.WmfMetafileEscapes):
        ...
    
    @property
    def cj_in(self) -> int:
        ...
    
    @cj_in.setter
    def cj_in(self, value : int):
        ...
    
    @property
    def data(self) -> bytes:
        '''Gets the data to pass to the printer driver. There MUST be cjIn bytes available.'''
        ...
    
    @data.setter
    def data(self, value : bytes):
        '''Sets the data to pass to the printer driver. There MUST be cjIn bytes available.'''
        ...
    
    ...

class EmfDrawingRecordType(EmfRecord):
    '''The drawing record types perform graphics drawing.'''
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    ...

class EmfEllipse(EmfDrawingRecordType):
    '''The EMR_ELLIPSE record specifies an ellipse. The center of the ellipse is the center of the specified
    bounding rectangle. The ellipse is outlined by using the current pen and is filled by using the current brush.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def box(self) -> aspose.imaging.Rectangle:
        '''Gets a 128-bit (WMF) RectL object, specified in [MS-WMF] section 2.2.2.19, which
        specifies the inclusive-inclusive bounding rectangle.'''
        ...
    
    @box.setter
    def box(self, value : aspose.imaging.Rectangle):
        '''Sets a 128-bit (WMF) RectL object, specified in [MS-WMF] section 2.2.2.19, which
        specifies the inclusive-inclusive bounding rectangle.'''
        ...
    
    ...

class EmfEndPath(EmfPathBracketRecordType):
    '''This record closes a path bracket and selects the path defined by the bracket into
    the playback device context.'''
    
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    ...

class EmfEof(EmfControlRecordType):
    '''The EMR_EOF record indicates the end of the metafile and specifies a palette.'''
    
    @overload
    def __init__(self, record: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param record: The record.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def palette_argb_32_entries(self) -> List[int]:
        ...
    
    @palette_argb_32_entries.setter
    def palette_argb_32_entries(self, value : List[int]):
        ...
    
    @property
    def size_last(self) -> int:
        ...
    
    @size_last.setter
    def size_last(self, value : int):
        ...
    
    ...

class EmfEscapeRecordType(EmfRecord):
    '''The escape record types execute printer driver functions.'''
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def escape(self) -> aspose.imaging.fileformats.wmf.consts.WmfMetafileEscapes:
        ...
    
    @escape.setter
    def escape(self, value : aspose.imaging.fileformats.wmf.consts.WmfMetafileEscapes):
        ...
    
    ...

class EmfExcludeClipRect(EmfClippingRecordType):
    '''The EMR_EXCLUDECLIPRECT record specifies a new clipping region that consists of the existing
    clipping region minus the specified rectangle.
    Note  Fields that are not described in this section are specified in section 2.3.2.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def clip(self) -> aspose.imaging.Rectangle:
        '''Gets a WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the clipping
        rectangle in logical units.'''
        ...
    
    @clip.setter
    def clip(self, value : aspose.imaging.Rectangle):
        '''Sets a WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the clipping
        rectangle in logical units.'''
        ...
    
    ...

class EmfExtCreateFontIndirectW(EmfObjectCreationRecordType):
    '''The EMR_EXTCREATEFONTINDIRECTW record defines a logical font for graphics operations.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def ih_fonts(self) -> int:
        ...
    
    @ih_fonts.setter
    def ih_fonts(self, value : int):
        ...
    
    @property
    def elw(self) -> aspose.imaging.fileformats.emf.emf.objects.EmfLogFont:
        '''Gets a LogFontExDv object (section 2.2.15), which specifies the logical font. A
        LogFont object 2.2.13 MAY be present instead.[90]The process for determining the type of
        object in this field is described below.'''
        ...
    
    @elw.setter
    def elw(self, value : aspose.imaging.fileformats.emf.emf.objects.EmfLogFont):
        '''Sets a LogFontExDv object (section 2.2.15), which specifies the logical font. A
        LogFont object 2.2.13 MAY be present instead.[90]The process for determining the type of
        object in this field is described below.'''
        ...
    
    ...

class EmfExtCreatePen(EmfObjectCreationRecordType):
    '''The EMR_EXTCREATEPEN record defines an extended logical pen for graphics operations. An
    optional DIB can be specified to use as the line style.'''
    
    @overload
    def __init__(self, record: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param record: The record.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def ih_pen(self) -> int:
        ...
    
    @ih_pen.setter
    def ih_pen(self, value : int):
        ...
    
    @property
    def elp(self) -> aspose.imaging.fileformats.emf.emf.objects.EmfLogPenEx:
        '''Gets a LogPenEx object (section 2.2.20) that specifies an extended logical
        pen with attributes including an optional line style array.'''
        ...
    
    @elp.setter
    def elp(self, value : aspose.imaging.fileformats.emf.emf.objects.EmfLogPenEx):
        '''Sets a LogPenEx object (section 2.2.20) that specifies an extended logical
        pen with attributes including an optional line style array.'''
        ...
    
    @property
    def bitmap_buffer(self) -> aspose.imaging.fileformats.wmf.objects.WmfDeviceIndependentBitmap:
        ...
    
    @bitmap_buffer.setter
    def bitmap_buffer(self, value : aspose.imaging.fileformats.wmf.objects.WmfDeviceIndependentBitmap):
        ...
    
    ...

class EmfExtEscape(EmfEscapeRecordType):
    '''The EMR_EXTESCAPE record passes arbitrary information to a printer driver. The intent is that the
    information will not result in drawing being done.'''
    
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def escape(self) -> aspose.imaging.fileformats.wmf.consts.WmfMetafileEscapes:
        ...
    
    @escape.setter
    def escape(self, value : aspose.imaging.fileformats.wmf.consts.WmfMetafileEscapes):
        ...
    
    @property
    def cj_in(self) -> int:
        ...
    
    @cj_in.setter
    def cj_in(self, value : int):
        ...
    
    @property
    def data(self) -> bytes:
        '''Gets the data to pass to the printer driver. There MUST be cjIn bytes available.'''
        ...
    
    @data.setter
    def data(self, value : bytes):
        '''Sets the data to pass to the printer driver. There MUST be cjIn bytes available.'''
        ...
    
    ...

class EmfExtFloodFill(EmfDrawingRecordType):
    '''The EMR_EXTFLOODFILL record fills an area of the display surface with the current brush'''
    
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def start(self) -> aspose.imaging.Point:
        '''Gets a WMF PointL object ([MS-WMF] section 2.2.2.15), which specifies the
        coordinates, in logical units, where filling begins.'''
        ...
    
    @start.setter
    def start(self, value : aspose.imaging.Point):
        '''Sets a WMF PointL object ([MS-WMF] section 2.2.2.15), which specifies the
        coordinates, in logical units, where filling begins.'''
        ...
    
    @property
    def argb_32_color(self) -> int:
        ...
    
    @argb_32_color.setter
    def argb_32_color(self, value : int):
        ...
    
    @property
    def flood_fill_mode(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfFloodFill:
        ...
    
    @flood_fill_mode.setter
    def flood_fill_mode(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfFloodFill):
        ...
    
    ...

class EmfExtSelectClipRgn(EmfClippingRecordType):
    '''The EMR_EXTSELECTCLIPRGN record combines the specified region with the current clip region
    using the specified mode.
    Note  Fields that are not described in this section are specified in section 2.3.2.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def rgn_data_size(self) -> int:
        ...
    
    @rgn_data_size.setter
    def rgn_data_size(self, value : int):
        ...
    
    @property
    def region_mode(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRegionMode:
        ...
    
    @region_mode.setter
    def region_mode(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRegionMode):
        ...
    
    @property
    def rgn_data(self) -> aspose.imaging.fileformats.emf.emf.objects.EmfRegionData:
        ...
    
    @rgn_data.setter
    def rgn_data(self, value : aspose.imaging.fileformats.emf.emf.objects.EmfRegionData):
        ...
    
    ...

class EmfExtTextOutA(EmfDrawingRecordType):
    '''The EMR_EXTTEXTOUTA record draws an ASCII text string using the current font and text colors.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets a WMF RectL object ([MS-WMF] section 2.2.2.19). It is not used and
        MUST be ignored on receipt.'''
        ...
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle):
        '''Sets a WMF RectL object ([MS-WMF] section 2.2.2.19). It is not used and
        MUST be ignored on receipt.'''
        ...
    
    @property
    def graphics_mode(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfGraphicsMode:
        ...
    
    @graphics_mode.setter
    def graphics_mode(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfGraphicsMode):
        ...
    
    @property
    def ex_scale(self) -> float:
        ...
    
    @ex_scale.setter
    def ex_scale(self, value : float):
        ...
    
    @property
    def ey_scale(self) -> float:
        ...
    
    @ey_scale.setter
    def ey_scale(self, value : float):
        ...
    
    @property
    def a_emr_text(self) -> aspose.imaging.fileformats.emf.emf.objects.EmfText:
        ...
    
    @a_emr_text.setter
    def a_emr_text(self, value : aspose.imaging.fileformats.emf.emf.objects.EmfText):
        ...
    
    ...

class EmfExtTextOutW(EmfDrawingRecordType):
    '''The EMR_EXTTEXTOUTW record draws an ASCII text string using the current font and text colors.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets a WMF RectL object ([MS-WMF] section 2.2.2.19). It is not used and
        MUST be ignored on receipt.'''
        ...
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle):
        '''Sets a WMF RectL object ([MS-WMF] section 2.2.2.19). It is not used and
        MUST be ignored on receipt.'''
        ...
    
    @property
    def graphics_mode(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfGraphicsMode:
        ...
    
    @graphics_mode.setter
    def graphics_mode(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfGraphicsMode):
        ...
    
    @property
    def ex_scale(self) -> float:
        ...
    
    @ex_scale.setter
    def ex_scale(self, value : float):
        ...
    
    @property
    def ey_scale(self) -> float:
        ...
    
    @ey_scale.setter
    def ey_scale(self, value : float):
        ...
    
    @property
    def w_emr_text(self) -> aspose.imaging.fileformats.emf.emf.objects.EmfText:
        ...
    
    @w_emr_text.setter
    def w_emr_text(self, value : aspose.imaging.fileformats.emf.emf.objects.EmfText):
        ...
    
    ...

class EmfFillPath(EmfDrawingRecordType):
    '''The EMR_FILLPATH record closes any open figures in the current path and fills the path's interior by
    using the current brush and polygon-filling mode.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets a 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19,
        which specifies bounding rectangle, in device units.'''
        ...
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle):
        '''Sets a 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19,
        which specifies bounding rectangle, in device units.'''
        ...
    
    ...

class EmfFillRgn(EmfDrawingRecordType):
    '''The EMR_FILLRGN record fills the specified region by using the specified brush.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets a 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19,
        which specifies the bounding rectangle.'''
        ...
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle):
        '''Sets a 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19,
        which specifies the bounding rectangle.'''
        ...
    
    @property
    def rgn_data_size(self) -> int:
        ...
    
    @rgn_data_size.setter
    def rgn_data_size(self, value : int):
        ...
    
    @property
    def ih_brush(self) -> int:
        ...
    
    @ih_brush.setter
    def ih_brush(self, value : int):
        ...
    
    @property
    def rgn_data(self) -> aspose.imaging.fileformats.emf.emf.objects.EmfRegionData:
        ...
    
    @rgn_data.setter
    def rgn_data(self, value : aspose.imaging.fileformats.emf.emf.objects.EmfRegionData):
        ...
    
    ...

class EmfFlatternPath(EmfPathBracketRecordType):
    '''This record transforms any curves in the selected path into the playback device
    context; each curve MUST be turned into a sequence of lines.'''
    
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    ...

class EmfForceUfiMapping(EmfStateRecordType):
    '''The EMR_FORCEUFIMAPPING record forces the font mapper to match fonts based on their
    UniversalFontId in preference to their LogFont (section 2.2.13) information.'''
    
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def ufi(self) -> aspose.imaging.fileformats.emf.emf.objects.EmfUniversalFontId:
        '''Gets the font id to use, specified as a UniversalFontId (section 2.2.27).'''
        ...
    
    @ufi.setter
    def ufi(self, value : aspose.imaging.fileformats.emf.emf.objects.EmfUniversalFontId):
        '''Sets the font id to use, specified as a UniversalFontId (section 2.2.27).'''
        ...
    
    ...

class EmfFrameRgn(EmfDrawingRecordType):
    '''The EMR_FRAMERGN record draws a border around the specified region using the specified brush.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19, which
        specifies the bounding rectangle.'''
        ...
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle):
        '''Sets 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19, which
        specifies the bounding rectangle.'''
        ...
    
    @property
    def rgn_data_size(self) -> int:
        ...
    
    @rgn_data_size.setter
    def rgn_data_size(self, value : int):
        ...
    
    @property
    def ih_brush(self) -> int:
        ...
    
    @ih_brush.setter
    def ih_brush(self, value : int):
        ...
    
    @property
    def width(self) -> int:
        '''Gets a 32-bit signed integer that specifies the width of the vertical brush stroke, in logical units.'''
        ...
    
    @width.setter
    def width(self, value : int):
        '''Sets a 32-bit signed integer that specifies the width of the vertical brush stroke, in logical units.'''
        ...
    
    @property
    def height(self) -> int:
        '''Gets a 32-bit signed integer that specifies the height of the horizontal brush
        stroke, in logical units.'''
        ...
    
    @height.setter
    def height(self, value : int):
        '''Sets a 32-bit signed integer that specifies the height of the horizontal brush
        stroke, in logical units.'''
        ...
    
    @property
    def rgn_data(self) -> aspose.imaging.fileformats.emf.emf.objects.EmfRegionData:
        ...
    
    @rgn_data.setter
    def rgn_data(self, value : aspose.imaging.fileformats.emf.emf.objects.EmfRegionData):
        ...
    
    ...

class EmfGlsBoundedRecord(EmfOpenGlRecordType):
    '''The EMR_GLSBOUNDEDRECORD record specifies an OpenGL function with a bounding rectangle for output.'''
    
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets a WMF RectL object ([MS-WMF] section 2.2.2.19) that defines a bounding
        rectangle, in device units, for output produced by executing the OpenGL function.'''
        ...
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle):
        '''Sets a WMF RectL object ([MS-WMF] section 2.2.2.19) that defines a bounding
        rectangle, in device units, for output produced by executing the OpenGL function.'''
        ...
    
    @property
    def cb_data(self) -> int:
        ...
    
    @cb_data.setter
    def cb_data(self, value : int):
        ...
    
    @property
    def data(self) -> bytes:
        '''Gets an optional array of bytes of cbData length that specifies data for the OpenGL function.'''
        ...
    
    @data.setter
    def data(self, value : bytes):
        '''Sets an optional array of bytes of cbData length that specifies data for the OpenGL function.'''
        ...
    
    ...

class EmfGlsRecord(EmfOpenGlRecordType):
    '''The EMR_GLSRECORD record specifies an OpenGL function.'''
    
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def cb_data(self) -> int:
        ...
    
    @cb_data.setter
    def cb_data(self, value : int):
        ...
    
    @property
    def data(self) -> bytes:
        '''Gets an optional array of bytes of cbData length that specifies data for the OpenGL function.'''
        ...
    
    @data.setter
    def data(self, value : bytes):
        '''Sets an optional array of bytes of cbData length that specifies data for the OpenGL function.'''
        ...
    
    ...

class EmfGradientFill(EmfDrawingRecordType):
    '''The EMR_GRADIENTFILL record specifies filling rectangles or triangles with gradients of color.'''
    
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets a WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies a
        bounding rectangle, in inclusive-inclusive device units.'''
        ...
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle):
        '''Sets a WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies a
        bounding rectangle, in inclusive-inclusive device units.'''
        ...
    
    @property
    def n_ver(self) -> int:
        ...
    
    @n_ver.setter
    def n_ver(self, value : int):
        ...
    
    @property
    def n_tri(self) -> int:
        ...
    
    @n_tri.setter
    def n_tri(self, value : int):
        ...
    
    @property
    def ul_mode(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfGradientFill:
        ...
    
    @ul_mode.setter
    def ul_mode(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfGradientFill):
        ...
    
    @property
    def vertex_data(self) -> aspose.imaging.fileformats.emf.emf.records.EmfVertexData:
        ...
    
    @vertex_data.setter
    def vertex_data(self, value : aspose.imaging.fileformats.emf.emf.records.EmfVertexData):
        ...
    
    ...

class EmfIntersectClipRect(EmfClippingRecordType):
    '''The EMR_INTERSECTCLIPRECT record specifies a new clipping region from the intersection of the
    current clipping region and the specified rectangle.
    Note  Fields that are not described in this section are specified in section 2.3.2.'''
    
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def clip(self) -> aspose.imaging.Rectangle:
        '''Gets a WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the rectangle in logical units.'''
        ...
    
    @clip.setter
    def clip(self, value : aspose.imaging.Rectangle):
        '''Sets a WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the rectangle in logical units.'''
        ...
    
    ...

class EmfInvertRgn(EmfStateRecordType):
    '''The EMR_INVERTRGN record inverts the colors in the specified region.'''
    
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets a 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19,
        which specifies the bounding rectangle.'''
        ...
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle):
        '''Sets a 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19,
        which specifies the bounding rectangle.'''
        ...
    
    @property
    def rgn_data_size(self) -> int:
        ...
    
    @rgn_data_size.setter
    def rgn_data_size(self, value : int):
        ...
    
    @property
    def rgn_data(self) -> bytes:
        ...
    
    @rgn_data.setter
    def rgn_data(self, value : bytes):
        ...
    
    ...

class EmfLineTo(EmfRecord):
    '''The EMR_LINETO record specifies a line from the current position up to, but not including, the
    specified point.It resets the current position to the specified point.'''
    
    @overload
    def __init__(self, record: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param record: The record.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def point(self) -> aspose.imaging.Point:
        '''Gets 64-bit WMF PointL object, specified in [MS-WMF] section 2.2.2.15,
        which specifies the coordinates of the line's ending point.'''
        ...
    
    @point.setter
    def point(self, value : aspose.imaging.Point):
        '''Sets 64-bit WMF PointL object, specified in [MS-WMF] section 2.2.2.15,
        which specifies the coordinates of the line's ending point.'''
        ...
    
    ...

class EmfMaskBlt(EmfBitmapRecordType):
    '''The EMR_MASKBLT record specifies a block transfer of pixels from a source bitmap to a destination
    rectangle, optionally in combination with a brush pattern and with the application of a color mask
    bitmap, according to specified foreground and background raster operations.'''
    
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets a WMF RectL object ([MS-WMF] section 2.2.2.19) that defines the
        destination bounding rectangle in device units.'''
        ...
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle):
        '''Sets a WMF RectL object ([MS-WMF] section 2.2.2.19) that defines the
        destination bounding rectangle in device units.'''
        ...
    
    @property
    def x_dest(self) -> int:
        ...
    
    @x_dest.setter
    def x_dest(self, value : int):
        ...
    
    @property
    def y_dest(self) -> int:
        ...
    
    @y_dest.setter
    def y_dest(self, value : int):
        ...
    
    @property
    def cx_dest(self) -> int:
        ...
    
    @cx_dest.setter
    def cx_dest(self, value : int):
        ...
    
    @property
    def cy_dest(self) -> int:
        ...
    
    @cy_dest.setter
    def cy_dest(self, value : int):
        ...
    
    @property
    def rop4(self) -> aspose.imaging.fileformats.emf.emf.records.EmfRop4:
        '''Gets a quaternary raster operation, which specifies ternary raster operations for
        the foreground and background colors of a bitmap. These values define how the color data of
        the source rectangle is to be combined with the color data of the destination rectangle.'''
        ...
    
    @rop4.setter
    def rop4(self, value : aspose.imaging.fileformats.emf.emf.records.EmfRop4):
        '''Sets a quaternary raster operation, which specifies ternary raster operations for
        the foreground and background colors of a bitmap. These values define how the color data of
        the source rectangle is to be combined with the color data of the destination rectangle.'''
        ...
    
    @property
    def x_src(self) -> int:
        ...
    
    @x_src.setter
    def x_src(self, value : int):
        ...
    
    @property
    def y_src(self) -> int:
        ...
    
    @y_src.setter
    def y_src(self, value : int):
        ...
    
    @property
    def xform_src(self) -> aspose.imaging.Matrix:
        ...
    
    @xform_src.setter
    def xform_src(self, value : aspose.imaging.Matrix):
        ...
    
    @property
    def argb_32_bk_color_src(self) -> int:
        ...
    
    @argb_32_bk_color_src.setter
    def argb_32_bk_color_src(self, value : int):
        ...
    
    @property
    def usage_src(self) -> int:
        ...
    
    @usage_src.setter
    def usage_src(self, value : int):
        ...
    
    @property
    def x_mask(self) -> int:
        ...
    
    @x_mask.setter
    def x_mask(self, value : int):
        ...
    
    @property
    def y_mask(self) -> int:
        ...
    
    @y_mask.setter
    def y_mask(self, value : int):
        ...
    
    @property
    def usage_mask(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfDibColors:
        ...
    
    @usage_mask.setter
    def usage_mask(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfDibColors):
        ...
    
    @property
    def source_bitmap(self) -> aspose.imaging.fileformats.wmf.objects.WmfDeviceIndependentBitmap:
        ...
    
    @source_bitmap.setter
    def source_bitmap(self, value : aspose.imaging.fileformats.wmf.objects.WmfDeviceIndependentBitmap):
        ...
    
    @property
    def mask_bitmap(self) -> aspose.imaging.fileformats.wmf.objects.WmfDeviceIndependentBitmap:
        ...
    
    @mask_bitmap.setter
    def mask_bitmap(self, value : aspose.imaging.fileformats.wmf.objects.WmfDeviceIndependentBitmap):
        ...
    
    ...

class EmfMetafileHeader(EmfRecord):
    '''The EMR_HEADER record types define the starting points of EMF metafiles
    and specify properties of the device on which the image in the metafile
    was created. The information in the header record makes it possible for
    EMF metafiles to be independent of any specific output device.
    The value of the Size field can be used to distinguish between the different
    EMR_HEADER record types listed earlier in this section.
    There are three possible headers:
    The base header, which is the EmfMetafileHeader record.
    The fixed-size part of this header is 88 bytes, and it contains a Header object.
    The first extension header, which is the EmfMetafileHeaderExtension1 record.
    The fixed-size part of this header is 100 bytes, and it contains a Header object
    and a HeaderExtension1 object (section 2.2.10).
    The second extension header, which is the EmfMetafileHeaderExtension2 record.
    The fixed-size part of this header is 108 bytes, and it contains a Header object,
    a HeaderExtension1 object, and a HeaderExtension2 object (section 2.2.11).'''
    
    @overload
    def __init__(self, record: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param record: The record.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @overload
    def __init__(self, header: aspose.imaging.fileformats.emf.emf.records.EmfMetafileHeader):
        '''Initializes a new instance of the  class.
        
        :param header: The header.'''
        ...
    
    @staticmethod
    def create_from_record(record: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfMetafileHeader:
        '''Initializes a new instance of the  class.
        
        :param record: The record.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @staticmethod
    def create_from_header(header: aspose.imaging.fileformats.emf.emf.records.EmfMetafileHeader) -> aspose.imaging.fileformats.emf.emf.records.EmfMetafileHeader:
        '''Initializes a new instance of the  class.
        
        :param header: The header.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def emf_header(self) -> aspose.imaging.fileformats.emf.emf.objects.EmfHeaderObject:
        ...
    
    @emf_header.setter
    def emf_header(self, value : aspose.imaging.fileformats.emf.emf.objects.EmfHeaderObject):
        ...
    
    @property
    def emf_header_record_buffer(self) -> bytes:
        ...
    
    @emf_header_record_buffer.setter
    def emf_header_record_buffer(self, value : bytes):
        ...
    
    @property
    def emf_description_buffer(self) -> bytes:
        ...
    
    @emf_description_buffer.setter
    def emf_description_buffer(self, value : bytes):
        ...
    
    @property
    def emf_description(self) -> str:
        ...
    
    @emf_description.setter
    def emf_description(self, value : str):
        ...
    
    ...

class EmfMetafileHeaderExtension1(EmfMetafileHeader):
    '''The EmfMetafileHeaderExtension1 record is the header record used in the first extension to EMF metafiles.
    Following the EmfHeaderExtension1 field, the remaining fields are optional and can be present in any order.'''
    
    @overload
    def __init__(self, header: aspose.imaging.fileformats.emf.emf.records.EmfMetafileHeader):
        '''Initializes a new instance of the  class.
        
        :param header: The header.'''
        ...
    
    @overload
    def __init__(self, header: aspose.imaging.fileformats.emf.emf.records.EmfMetafileHeaderExtension1):
        '''Initializes a new instance of the  class.
        
        :param header: The header.'''
        ...
    
    @staticmethod
    def create_from_record(record: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfMetafileHeader:
        '''Initializes a new instance of the  class.
        
        :param record: The record.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @staticmethod
    def create_from_header(header: aspose.imaging.fileformats.emf.emf.records.EmfMetafileHeader) -> aspose.imaging.fileformats.emf.emf.records.EmfMetafileHeaderExtension1:
        '''Initializes a new instance of the  class.
        
        :param header: The header.'''
        ...
    
    @staticmethod
    def create_from_header_extension1(header: aspose.imaging.fileformats.emf.emf.records.EmfMetafileHeaderExtension1) -> aspose.imaging.fileformats.emf.emf.records.EmfMetafileHeaderExtension1:
        '''Initializes a new instance of the  class.
        
        :param header: The header.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def emf_header(self) -> aspose.imaging.fileformats.emf.emf.objects.EmfHeaderObject:
        ...
    
    @emf_header.setter
    def emf_header(self, value : aspose.imaging.fileformats.emf.emf.objects.EmfHeaderObject):
        ...
    
    @property
    def emf_header_record_buffer(self) -> bytes:
        ...
    
    @emf_header_record_buffer.setter
    def emf_header_record_buffer(self, value : bytes):
        ...
    
    @property
    def emf_description_buffer(self) -> bytes:
        ...
    
    @emf_description_buffer.setter
    def emf_description_buffer(self, value : bytes):
        ...
    
    @property
    def emf_description(self) -> str:
        ...
    
    @emf_description.setter
    def emf_description(self, value : str):
        ...
    
    @property
    def emf_header_extension1(self) -> aspose.imaging.fileformats.emf.emf.objects.EmfHeaderExtension1:
        ...
    
    @emf_header_extension1.setter
    def emf_header_extension1(self, value : aspose.imaging.fileformats.emf.emf.objects.EmfHeaderExtension1):
        ...
    
    @property
    def emf_pixel_format_buffer(self) -> bytes:
        ...
    
    @emf_pixel_format_buffer.setter
    def emf_pixel_format_buffer(self, value : bytes):
        ...
    
    ...

class EmfMetafileHeaderExtension2(EmfMetafileHeaderExtension1):
    '''The EmfMetafileHeaderExtension2 record is the header record used in the second extension to EMF
    metafiles. Following the EmfHeaderExtension2 field, the remaining fields are optional and
    can be present in any order.'''
    
    @overload
    def __init__(self, header: aspose.imaging.fileformats.emf.emf.records.EmfMetafileHeaderExtension1):
        '''Initializes a new instance of the  class.
        
        :param header: The header.'''
        ...
    
    @overload
    def __init__(self, header: aspose.imaging.fileformats.emf.emf.records.EmfMetafileHeaderExtension2):
        '''Initializes a new instance of the  class.
        
        :param header: The header.'''
        ...
    
    @staticmethod
    def create_from_record(record: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfMetafileHeader:
        '''Initializes a new instance of the  class.
        
        :param record: The record.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @staticmethod
    def create_from_header(header: aspose.imaging.fileformats.emf.emf.records.EmfMetafileHeader) -> aspose.imaging.fileformats.emf.emf.records.EmfMetafileHeaderExtension1:
        '''Initializes a new instance of the  class.
        
        :param header: The header.'''
        ...
    
    @staticmethod
    def create_from_header_extension1(header: aspose.imaging.fileformats.emf.emf.records.EmfMetafileHeaderExtension1) -> aspose.imaging.fileformats.emf.emf.records.EmfMetafileHeaderExtension2:
        '''Initializes a new instance of the  class.
        
        :param header: The header.'''
        ...
    
    @staticmethod
    def create_from_header_extension2(header: aspose.imaging.fileformats.emf.emf.records.EmfMetafileHeaderExtension2) -> aspose.imaging.fileformats.emf.emf.records.EmfMetafileHeaderExtension2:
        '''Initializes a new instance of the  class.
        
        :param header: The header.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def emf_header(self) -> aspose.imaging.fileformats.emf.emf.objects.EmfHeaderObject:
        ...
    
    @emf_header.setter
    def emf_header(self, value : aspose.imaging.fileformats.emf.emf.objects.EmfHeaderObject):
        ...
    
    @property
    def emf_header_record_buffer(self) -> bytes:
        ...
    
    @emf_header_record_buffer.setter
    def emf_header_record_buffer(self, value : bytes):
        ...
    
    @property
    def emf_description_buffer(self) -> bytes:
        ...
    
    @emf_description_buffer.setter
    def emf_description_buffer(self, value : bytes):
        ...
    
    @property
    def emf_description(self) -> str:
        ...
    
    @emf_description.setter
    def emf_description(self, value : str):
        ...
    
    @property
    def emf_header_extension1(self) -> aspose.imaging.fileformats.emf.emf.objects.EmfHeaderExtension1:
        ...
    
    @emf_header_extension1.setter
    def emf_header_extension1(self, value : aspose.imaging.fileformats.emf.emf.objects.EmfHeaderExtension1):
        ...
    
    @property
    def emf_pixel_format_buffer(self) -> bytes:
        ...
    
    @emf_pixel_format_buffer.setter
    def emf_pixel_format_buffer(self, value : bytes):
        ...
    
    @property
    def emf_header_extension2(self) -> aspose.imaging.fileformats.emf.emf.objects.EmfHeaderExtension2:
        ...
    
    @emf_header_extension2.setter
    def emf_header_extension2(self, value : aspose.imaging.fileformats.emf.emf.objects.EmfHeaderExtension2):
        ...
    
    ...

class EmfModifyWorldTransform(EmfTransformRecordType):
    '''The EMR_MODIFYWORLDTRANSFORM record modifies the current world-space to page-space
    transform in the playback device context.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def xform(self) -> aspose.imaging.Matrix:
        '''Gets an XForm object (section 2.2.28), which defines a world-space to page space transform.'''
        ...
    
    @xform.setter
    def xform(self, value : aspose.imaging.Matrix):
        '''Sets an XForm object (section 2.2.28), which defines a world-space to page space transform.'''
        ...
    
    @property
    def modify_world_transform_mode(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfModifyWorldTransformMode:
        ...
    
    @modify_world_transform_mode.setter
    def modify_world_transform_mode(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfModifyWorldTransformMode):
        ...
    
    ...

class EmfMoveToEx(EmfRecord):
    '''The EMR_MOVETOEX record specifies coordinates of the new current position, in logical units.'''
    
    @overload
    def __init__(self, record: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param record: The record.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def offset(self) -> aspose.imaging.Point:
        '''Gets a 64-bit WMF PointL object, specified in [MS-WMF] section 2.2.2.15,
        which specifies coordinates of the new current position in logical units.'''
        ...
    
    @offset.setter
    def offset(self, value : aspose.imaging.Point):
        '''Sets a 64-bit WMF PointL object, specified in [MS-WMF] section 2.2.2.15,
        which specifies coordinates of the new current position in logical units.'''
        ...
    
    ...

class EmfNamedEscape(EmfEscapeRecordType):
    '''The MR_NAMEDESCAPE record passes arbitrary information to a specified printer driver.'''
    
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def escape(self) -> aspose.imaging.fileformats.wmf.consts.WmfMetafileEscapes:
        ...
    
    @escape.setter
    def escape(self, value : aspose.imaging.fileformats.wmf.consts.WmfMetafileEscapes):
        ...
    
    @property
    def cj_driver(self) -> int:
        ...
    
    @cj_driver.setter
    def cj_driver(self, value : int):
        ...
    
    @property
    def cj_in(self) -> int:
        ...
    
    @cj_in.setter
    def cj_in(self, value : int):
        ...
    
    @property
    def driver_name(self) -> str:
        ...
    
    @driver_name.setter
    def driver_name(self, value : str):
        ...
    
    @property
    def data(self) -> bytes:
        '''Gets The data to pass to the printer driver. There MUST be cjIn bytes available.'''
        ...
    
    @data.setter
    def data(self, value : bytes):
        '''Sets The data to pass to the printer driver. There MUST be cjIn bytes available.'''
        ...
    
    ...

class EmfObjectCreationRecordType(EmfRecord):
    '''The object creation record types create graphics objects.'''
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    ...

class EmfObjectManipulationRecordType(EmfRecord):
    '''The object manipulation record types manage and modify graphics objects.'''
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    ...

class EmfOffsetClipRgn(EmfClippingRecordType):
    '''The EMR_OFFSETCLIPRGN record moves the current clipping region in the playback device context
    by the specified offsets.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def offset(self) -> aspose.imaging.Point:
        '''Gets a WMF PointL object ([MS-WMF] section 2.2.2.15) that specifies the
        horizontal and vertical offsets in logical units.'''
        ...
    
    @offset.setter
    def offset(self, value : aspose.imaging.Point):
        '''Sets a WMF PointL object ([MS-WMF] section 2.2.2.15) that specifies the
        horizontal and vertical offsets in logical units.'''
        ...
    
    ...

class EmfOpenGlRecordType(EmfRecord):
    '''The OpenGL record types specify OpenGL functions.'''
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    ...

class EmfPaintRgn(EmfDrawingRecordType):
    '''The EMR_PAINTRGN record paints the specified region by using the brush currently selected into the
    playback device context.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets a 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19,
        which specifies the bounding rectangle.'''
        ...
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle):
        '''Sets a 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19,
        which specifies the bounding rectangle.'''
        ...
    
    @property
    def rgn_data_size(self) -> int:
        ...
    
    @rgn_data_size.setter
    def rgn_data_size(self, value : int):
        ...
    
    @property
    def rgn_data(self) -> aspose.imaging.fileformats.emf.emf.objects.EmfRegionData:
        ...
    
    @rgn_data.setter
    def rgn_data(self, value : aspose.imaging.fileformats.emf.emf.objects.EmfRegionData):
        ...
    
    ...

class EmfPathBracketRecordType(EmfRecord):
    '''The path bracket record types specify and manipulate paths in path brackets.
    Note: None of the path bracket records specify parameters.'''
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    ...

class EmfPie(EmfDrawingRecordType):
    '''The EMR_PIE record specifies a pie-shaped wedge bounded by the intersection of an ellipse and two
    radials. The pie is outlined by using the current pen and filled by using the current brush.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def box(self) -> aspose.imaging.Rectangle:
        '''Gets a 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19, which
        specifies the inclusive-inclusive bounding rectangle.'''
        ...
    
    @box.setter
    def box(self, value : aspose.imaging.Rectangle):
        '''Sets a 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19, which
        specifies the inclusive-inclusive bounding rectangle.'''
        ...
    
    @property
    def start(self) -> aspose.imaging.Point:
        '''Gets a 64-bit WMF PointL objects, specified in [MS-WMF] section 2.2.2.15, which
        specifies the coordinates, in logical units, of the endpoint of the first radial.'''
        ...
    
    @start.setter
    def start(self, value : aspose.imaging.Point):
        '''Sets a 64-bit WMF PointL objects, specified in [MS-WMF] section 2.2.2.15, which
        specifies the coordinates, in logical units, of the endpoint of the first radial.'''
        ...
    
    @property
    def end(self) -> aspose.imaging.Point:
        '''Gets a 64-bit PointL object that specifies the coordinates, in logical units, of the
        endpoint of the second radial.'''
        ...
    
    @end.setter
    def end(self, value : aspose.imaging.Point):
        '''Sets a 64-bit PointL object that specifies the coordinates, in logical units, of the
        endpoint of the second radial.'''
        ...
    
    ...

class EmfPixelFormat(EmfStateRecordType):
    '''The EMR_PIXELFORMAT record specifies the pixel format to use for graphics operations.'''
    
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def pfd(self) -> aspose.imaging.fileformats.emf.emf.objects.EmfPixelFormatDescriptor:
        '''Gets a PixelFormatDescriptor object (section 2.2.22) that specifies pixel format data.'''
        ...
    
    @pfd.setter
    def pfd(self, value : aspose.imaging.fileformats.emf.emf.objects.EmfPixelFormatDescriptor):
        '''Sets a PixelFormatDescriptor object (section 2.2.22) that specifies pixel format data.'''
        ...
    
    ...

class EmfPlgBlt(EmfBitmapRecordType):
    '''The EMR_PLGBLT record specifies a block transfer of pixels from a source bitmap to a destination
    parallelogram, with the application of a color mask bitmap.'''
    
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets a WMF RectL object ([MS-WMF] section 2.2.2.19) that defines the
        bounding rectangle, in device units, for output to the destination.'''
        ...
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle):
        '''Sets a WMF RectL object ([MS-WMF] section 2.2.2.19) that defines the
        bounding rectangle, in device units, for output to the destination.'''
        ...
    
    @property
    def aptl_dest(self) -> List[aspose.imaging.Point]:
        ...
    
    @aptl_dest.setter
    def aptl_dest(self, value : List[aspose.imaging.Point]):
        ...
    
    @property
    def x_src(self) -> int:
        ...
    
    @x_src.setter
    def x_src(self, value : int):
        ...
    
    @property
    def y_src(self) -> int:
        ...
    
    @y_src.setter
    def y_src(self, value : int):
        ...
    
    @property
    def cx_src(self) -> int:
        ...
    
    @cx_src.setter
    def cx_src(self, value : int):
        ...
    
    @property
    def cy_src(self) -> int:
        ...
    
    @cy_src.setter
    def cy_src(self, value : int):
        ...
    
    @property
    def x_form_src(self) -> aspose.imaging.Matrix:
        ...
    
    @x_form_src.setter
    def x_form_src(self, value : aspose.imaging.Matrix):
        ...
    
    @property
    def bk_src_argb_32_color(self) -> int:
        ...
    
    @bk_src_argb_32_color.setter
    def bk_src_argb_32_color(self, value : int):
        ...
    
    @property
    def usage_src(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfDibColors:
        ...
    
    @usage_src.setter
    def usage_src(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfDibColors):
        ...
    
    @property
    def x_mask(self) -> int:
        ...
    
    @x_mask.setter
    def x_mask(self, value : int):
        ...
    
    @property
    def y_mask(self) -> int:
        ...
    
    @y_mask.setter
    def y_mask(self, value : int):
        ...
    
    @property
    def usage_mask(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfDibColors:
        ...
    
    @usage_mask.setter
    def usage_mask(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfDibColors):
        ...
    
    @property
    def source_bitmap(self) -> aspose.imaging.fileformats.wmf.objects.WmfDeviceIndependentBitmap:
        ...
    
    @source_bitmap.setter
    def source_bitmap(self, value : aspose.imaging.fileformats.wmf.objects.WmfDeviceIndependentBitmap):
        ...
    
    @property
    def mask_bitmap(self) -> aspose.imaging.fileformats.wmf.objects.WmfDeviceIndependentBitmap:
        ...
    
    @mask_bitmap.setter
    def mask_bitmap(self, value : aspose.imaging.fileformats.wmf.objects.WmfDeviceIndependentBitmap):
        ...
    
    ...

class EmfPolyBezier(EmfDrawingRecordType):
    '''The EMR_POLYBEZIER record specifies one or more Bezier curves.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets a 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies
        the bounding rectangle in device units.'''
        ...
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle):
        '''Sets a 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies
        the bounding rectangle in device units.'''
        ...
    
    @property
    def a_points(self) -> List[aspose.imaging.Point]:
        ...
    
    @a_points.setter
    def a_points(self, value : List[aspose.imaging.Point]):
        ...
    
    ...

class EmfPolyBezier16(EmfDrawingRecordType):
    '''The EMR_POLYBEZIER16 record specifies one or more Bezier curves. The curves are drawn using
    the current pen.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets a 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19,
        which specifies the bounding rectangle, in device units.'''
        ...
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle):
        '''Sets a 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19,
        which specifies the bounding rectangle, in device units.'''
        ...
    
    @property
    def a_points(self) -> List[aspose.imaging.Point]:
        ...
    
    @a_points.setter
    def a_points(self, value : List[aspose.imaging.Point]):
        ...
    
    ...

class EmfPolyBezierTo(EmfDrawingRecordType):
    '''The EMR_POLYBEZIERTO record specifies one or more Bezier curves based upon the current position.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets a 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies
        the bounding rectangle, in device units.'''
        ...
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle):
        '''Sets a 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies
        the bounding rectangle, in device units.'''
        ...
    
    @property
    def a_points(self) -> List[aspose.imaging.Point]:
        ...
    
    @a_points.setter
    def a_points(self, value : List[aspose.imaging.Point]):
        ...
    
    ...

class EmfPolyBezierTo16(EmfRecord):
    '''The EMR_POLYBEZIERTO16 record specifies one or more Bezier curves based on the current position.'''
    
    @overload
    def __init__(self, record: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param record: The record.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets a 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19,
        which specifies the bounding rectangle, in device units.'''
        ...
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle):
        '''Sets a 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19,
        which specifies the bounding rectangle, in device units.'''
        ...
    
    @property
    def a_points(self) -> List[aspose.imaging.Point]:
        ...
    
    @a_points.setter
    def a_points(self, value : List[aspose.imaging.Point]):
        ...
    
    ...

class EmfPolyDraw(EmfDrawingRecordType):
    '''The EMR_POLYDRAW record specifies a set of line segments and Bezier curves.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets a 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19,
        which specifies the bounding rectangle, in device units.'''
        ...
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle):
        '''Sets a 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19,
        which specifies the bounding rectangle, in device units.'''
        ...
    
    @property
    def a_points(self) -> List[aspose.imaging.Point]:
        ...
    
    @a_points.setter
    def a_points(self, value : List[aspose.imaging.Point]):
        ...
    
    @property
    def ab_types(self) -> List[aspose.imaging.fileformats.emf.emf.consts.EmfPointEnum]:
        ...
    
    @ab_types.setter
    def ab_types(self, value : List[aspose.imaging.fileformats.emf.emf.consts.EmfPointEnum]):
        ...
    
    ...

class EmfPolyDraw16(EmfDrawingRecordType):
    '''The EMR_POLYDRAW16 record specifies a set of line segments and Bezier curves.'''
    
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets a 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19,
        which specifies the bounding rectangle, in device units.'''
        ...
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle):
        '''Sets a 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19,
        which specifies the bounding rectangle, in device units.'''
        ...
    
    @property
    def a_points(self) -> List[aspose.imaging.Point]:
        ...
    
    @a_points.setter
    def a_points(self, value : List[aspose.imaging.Point]):
        ...
    
    @property
    def ab_types(self) -> List[aspose.imaging.fileformats.emf.emf.consts.EmfPointEnum]:
        ...
    
    @ab_types.setter
    def ab_types(self, value : List[aspose.imaging.fileformats.emf.emf.consts.EmfPointEnum]):
        ...
    
    ...

class EmfPolyPolygon(EmfDrawingRecordType):
    '''The EMR_POLYPOLYGON record specifies a series of closed polygons.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets a WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the
        bounding rectangle, in device units.'''
        ...
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle):
        '''Sets a WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the
        bounding rectangle, in device units.'''
        ...
    
    @property
    def a_points(self) -> List[List[aspose.imaging.Point]]:
        ...
    
    @a_points.setter
    def a_points(self, value : List[List[aspose.imaging.Point]]):
        ...
    
    ...

class EmfPolyPolygon16(EmfDrawingRecordType):
    '''The EMR_POLYPOLYGON16 record specifies a series of closed polygons. Each polygon is outlined
    using the current pen, and filled using the current brush and polygon fill mode. The polygons drawn
    by this record can overlap.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets a 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19,
        which specifies the bounding rectangle, in device units.'''
        ...
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle):
        '''Sets a 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19,
        which specifies the bounding rectangle, in device units.'''
        ...
    
    @property
    def a_points(self) -> List[List[aspose.imaging.Point]]:
        ...
    
    @a_points.setter
    def a_points(self, value : List[List[aspose.imaging.Point]]):
        ...
    
    ...

class EmfPolyPolyline(EmfDrawingRecordType):
    '''The EMR_POLYPOLYLINE record specifies multiple series of connected line segments.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets a 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies
        the bounding rectangle in device units.'''
        ...
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle):
        '''Sets a 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies
        the bounding rectangle in device units.'''
        ...
    
    @property
    def a_points(self) -> List[List[aspose.imaging.Point]]:
        ...
    
    @a_points.setter
    def a_points(self, value : List[List[aspose.imaging.Point]]):
        ...
    
    ...

class EmfPolyPolyline16(EmfDrawingRecordType):
    '''The EMR_POLYPOLYLINE16 record specifies multiple series of connected line segments.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets a 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies
        the bounding rectangle in device units.'''
        ...
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle):
        '''Sets a 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies
        the bounding rectangle in device units.'''
        ...
    
    @property
    def a_points(self) -> List[List[aspose.imaging.Point]]:
        ...
    
    @a_points.setter
    def a_points(self, value : List[List[aspose.imaging.Point]]):
        ...
    
    ...

class EmfPolyTextOutA(EmfDrawingRecordType):
    '''The EMR_POLYTEXTOUTA record draws one or more ASCII text strings using the current font and text colors.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets a WMF RectL object ([MS-WMF] section 2.2.2.19), which specifies the
        bounding rectangle in device units.'''
        ...
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle):
        '''Sets a WMF RectL object ([MS-WMF] section 2.2.2.19), which specifies the
        bounding rectangle in device units.'''
        ...
    
    @property
    def graphics_mode(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfGraphicsMode:
        ...
    
    @graphics_mode.setter
    def graphics_mode(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfGraphicsMode):
        ...
    
    @property
    def ex_scale(self) -> float:
        ...
    
    @ex_scale.setter
    def ex_scale(self, value : float):
        ...
    
    @property
    def ey_scale(self) -> float:
        ...
    
    @ey_scale.setter
    def ey_scale(self, value : float):
        ...
    
    @property
    def a_emr_text(self) -> List[aspose.imaging.fileformats.emf.emf.objects.EmfText]:
        ...
    
    @a_emr_text.setter
    def a_emr_text(self, value : List[aspose.imaging.fileformats.emf.emf.objects.EmfText]):
        ...
    
    ...

class EmfPolyTextOutW(EmfDrawingRecordType):
    '''The EMR_POLYTEXTOUTW record draws one or more Unicode text strings using the current font and text colors.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets a WMF RectL object ([MS-WMF] section 2.2.2.19), which specifies the
        bounding rectangle in device units.'''
        ...
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle):
        '''Sets a WMF RectL object ([MS-WMF] section 2.2.2.19), which specifies the
        bounding rectangle in device units.'''
        ...
    
    @property
    def graphics_mode(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfGraphicsMode:
        ...
    
    @graphics_mode.setter
    def graphics_mode(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfGraphicsMode):
        ...
    
    @property
    def ex_scale(self) -> float:
        ...
    
    @ex_scale.setter
    def ex_scale(self, value : float):
        ...
    
    @property
    def ey_scale(self) -> float:
        ...
    
    @ey_scale.setter
    def ey_scale(self, value : float):
        ...
    
    @property
    def w_emr_text(self) -> List[aspose.imaging.fileformats.emf.emf.objects.EmfText]:
        ...
    
    @w_emr_text.setter
    def w_emr_text(self, value : List[aspose.imaging.fileformats.emf.emf.objects.EmfText]):
        ...
    
    ...

class EmfPolygon(EmfDrawingRecordType):
    '''The EMR_POLYGON record specifies a polygon consisting of two or more vertexes connected by
    straight lines.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets a 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies
        the bounding rectangle in device units.'''
        ...
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle):
        '''Sets a 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies
        the bounding rectangle in device units.'''
        ...
    
    @property
    def a_points(self) -> List[aspose.imaging.Point]:
        ...
    
    @a_points.setter
    def a_points(self, value : List[aspose.imaging.Point]):
        ...
    
    ...

class EmfPolygon16(EmfDrawingRecordType):
    '''The EMR_POLYGON16 record specifies a polygon consisting of two or more vertexes connected by
    straight lines. The polygon is outlined by using the current pen and filled by using the current brush
    and polygon fill mode. The polygon is closed automatically by drawing a line from the last vertex to the first.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets a 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19,
        which specifies the bounding rectangle, in device units.'''
        ...
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle):
        '''Sets a 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19,
        which specifies the bounding rectangle, in device units.'''
        ...
    
    @property
    def a_points(self) -> List[aspose.imaging.Point]:
        ...
    
    @a_points.setter
    def a_points(self, value : List[aspose.imaging.Point]):
        ...
    
    ...

class EmfPolyline(EmfDrawingRecordType):
    '''The EMR_POLYLINE record specifies a series of line segments by connecting the points in the
    specified array.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets a 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies
        the bounding rectangle, in device units.'''
        ...
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle):
        '''Sets a 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies
        the bounding rectangle, in device units.'''
        ...
    
    @property
    def a_points(self) -> List[aspose.imaging.Point]:
        ...
    
    @a_points.setter
    def a_points(self, value : List[aspose.imaging.Point]):
        ...
    
    ...

class EmfPolyline16(EmfDrawingRecordType):
    '''The EMR_POLYLINE16 record specifies a series of line segments by connecting the points in the
    specified array.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets a 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19,
        which specifies the bounding rectangle, in device units.'''
        ...
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle):
        '''Sets a 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19,
        which specifies the bounding rectangle, in device units.'''
        ...
    
    @property
    def a_points(self) -> List[aspose.imaging.Point]:
        ...
    
    @a_points.setter
    def a_points(self, value : List[aspose.imaging.Point]):
        ...
    
    ...

class EmfPolylineTo(EmfDrawingRecordType):
    '''The EMR_POLYLINETO record specifies one or more straight lines based upon the current position.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets a 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies
        the bounding rectangle, in device units.'''
        ...
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle):
        '''Sets a 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies
        the bounding rectangle, in device units.'''
        ...
    
    @property
    def a_points(self) -> List[aspose.imaging.Point]:
        ...
    
    @a_points.setter
    def a_points(self, value : List[aspose.imaging.Point]):
        ...
    
    ...

class EmfPolylineTo16(EmfDrawingRecordType):
    '''The EMR_POLYLINETO16 record specifies one or more straight lines based upon the current position.
    A line is drawn from the current position to the first point specified by the aPoints field by using the
    current pen. For each additional line, drawing is performed from the ending point of the previous
    line to the next point specified by aPoints.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets a 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19,
        which specifies the bounding rectangle, in device units.'''
        ...
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle):
        '''Sets a 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19,
        which specifies the bounding rectangle, in device units.'''
        ...
    
    @property
    def a_points(self) -> List[aspose.imaging.Point]:
        ...
    
    @a_points.setter
    def a_points(self, value : List[aspose.imaging.Point]):
        ...
    
    ...

class EmfRealizePalette(EmfStateRecordType):
    '''This record maps palette entries from the current
    LogPalette object (section 2.2.17) to the system_palette.
    This EMF record specifies no parameters.'''
    
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    ...

class EmfRecord(aspose.imaging.fileformats.emf.MetaObject):
    '''Base class for EMF records
    All EMF records MUST have a length that is a multiple of 4 bytes. This is depicted in the
    generic structures of the preceding EMF record types by including AlignmentPadding fields
    where appropriate at the ends of these structures. The contents of AlignmentPadding fields
    MUST always be ignored. For brevity, these fields are not shown in every individual EMF
    record definition.'''
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self, type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    ...

class EmfRectangle(EmfDrawingRecordType):
    '''The EMR_RECTANGLE record draws a rectangle. The rectangle is outlined by using the current pen
    and filled by using the current brush.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def box(self) -> aspose.imaging.Rectangle:
        '''Gets a 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19, which
        specifies the inclusive-inclusive rectangle to draw.'''
        ...
    
    @box.setter
    def box(self, value : aspose.imaging.Rectangle):
        '''Sets a 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19, which
        specifies the inclusive-inclusive rectangle to draw.'''
        ...
    
    ...

class EmfResizePalette(EmfObjectManipulationRecordType):
    '''The EMR_RESIZEPALETTE record increases or decreases the size of an existing LogPalette object (section 2.2.17).'''
    
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def ih_pal(self) -> int:
        ...
    
    @ih_pal.setter
    def ih_pal(self, value : int):
        ...
    
    ...

class EmfRestoreDc(EmfStateRecordType):
    '''The EMR_RESTOREDC record restores the playback device context to the specified state. The
    playback device context is restored by popping state information off a stack that was created by
    prior EMR_SAVEDC records (section 2.3.11).'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def saved_dc(self) -> int:
        ...
    
    @saved_dc.setter
    def saved_dc(self, value : int):
        ...
    
    ...

class EmfRop4:
    '''A quaternary raster operation, which specifies ternary raster operations for
    the foreground and background colors of a bitmap. These values define how the color data of
    the source rectangle is to be combined with the color data of the destination rectangle.'''
    
    def __init__(self, dword_data: int):
        '''Initializes a new instance of the  class.
        
        :param dword_data: The dword data.'''
        ...
    
    @property
    def background_rop3(self) -> byte:
        ...
    
    @property
    def foreground_rop3(self) -> byte:
        ...
    
    ...

class EmfRoundRect(EmfDrawingRecordType):
    '''The EMR_ROUNDRECT record specifies a rectangle with rounded corners. The rectangle is outlined
    by using the current pen and filled by using the current brush.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def box(self) -> aspose.imaging.Rectangle:
        '''Gets a 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19, which
        specifies the inclusive-inclusive rectangle to draw.'''
        ...
    
    @box.setter
    def box(self, value : aspose.imaging.Rectangle):
        '''Sets a 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19, which
        specifies the inclusive-inclusive rectangle to draw.'''
        ...
    
    @property
    def corner(self) -> aspose.imaging.Size:
        '''Gets a 64-bit WMF SizeL object, specified in [MS-WMF] section 2.2.2.22, which
        specifies the width and height, in logical coordinates, of the ellipse used to draw the rounded corners.'''
        ...
    
    @corner.setter
    def corner(self, value : aspose.imaging.Size):
        '''Sets a 64-bit WMF SizeL object, specified in [MS-WMF] section 2.2.2.22, which
        specifies the width and height, in logical coordinates, of the ellipse used to draw the rounded corners.'''
        ...
    
    ...

class EmfSaveDc(EmfStateRecordType):
    '''Saves the current state of playback device context on a
    stack of states saved by preceding EMR_SAVEDC
    records, if any. The state consists of graphics properties
    and objects, including the currently selected bitmap,
    brush, palette, font, pen, and region. An
    EMR_RESTOREDC record is used to restore the state.
    This EMF record specifies no parameters.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    ...

class EmfScaleViewportExtex(EmfStateRecordType):
    '''The EMR_SCALEVIEWPORTEXTEX record respecifies the viewport for a device context by using the
    ratios formed by the specified multiplicands and divisors.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def x_num(self) -> int:
        ...
    
    @x_num.setter
    def x_num(self, value : int):
        ...
    
    @property
    def x_denom(self) -> int:
        ...
    
    @x_denom.setter
    def x_denom(self, value : int):
        ...
    
    @property
    def y_num(self) -> int:
        ...
    
    @y_num.setter
    def y_num(self, value : int):
        ...
    
    @property
    def y_denom(self) -> int:
        ...
    
    @y_denom.setter
    def y_denom(self, value : int):
        ...
    
    ...

class EmfScaleWindowExtex(EmfStateRecordType):
    '''The EMR_SCALEWINDOWEXTEX record respecifies the window for a playback device context by
    using the ratios formed by the specified multiplicands and divisors.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def x_num(self) -> int:
        ...
    
    @x_num.setter
    def x_num(self, value : int):
        ...
    
    @property
    def x_denom(self) -> int:
        ...
    
    @x_denom.setter
    def x_denom(self, value : int):
        ...
    
    @property
    def y_num(self) -> int:
        ...
    
    @y_num.setter
    def y_num(self, value : int):
        ...
    
    @property
    def y_denom(self) -> int:
        ...
    
    @y_denom.setter
    def y_denom(self, value : int):
        ...
    
    ...

class EmfSelectClipPath(EmfClippingRecordType):
    '''The EMR_SELECTCLIPPATH record specifies the current path as a clipping region for a playback
    device context, combining the new region with any existing clipping region using the specified mode.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def region_mode(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRegionMode:
        ...
    
    @region_mode.setter
    def region_mode(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRegionMode):
        ...
    
    ...

class EmfSelectObject(EmfRecord):
    '''The EMR_SELECTOBJECT record adds a graphics object to the current metafile playback device
    context. The object is specified either by its index in the EMF Object Table(section 3.1.1.1) or by its
    value from the StockObject enumeration(section 2.1.31).'''
    
    @overload
    def __init__(self, record: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param record: The record.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def object_handle(self) -> int:
        ...
    
    @object_handle.setter
    def object_handle(self, value : int):
        ...
    
    ...

class EmfSelectPalette(EmfObjectManipulationRecordType):
    '''The EMR_SELECTPALETTE record specifies a logical palette for the playback device context.'''
    
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def ih_pal(self) -> int:
        ...
    
    @ih_pal.setter
    def ih_pal(self, value : int):
        ...
    
    ...

class EmfSetArcDirection(EmfStateRecordType):
    '''The EMR_SETARCDIRECTION record specifies the drawing direction to be used for arc and rectangle output.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def arc_direction(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfArcDirection:
        ...
    
    @arc_direction.setter
    def arc_direction(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfArcDirection):
        ...
    
    ...

class EmfSetBkColor(EmfStateRecordType):
    '''The EMR_SETBKCOLOR record specifies the background color.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def argb_32_color(self) -> int:
        ...
    
    @argb_32_color.setter
    def argb_32_color(self, value : int):
        ...
    
    ...

class EmfSetBkMode(EmfStateRecordType):
    '''The EMR_SETBKMODE record specifies the background mix mode of the playback device context.
    The background mix mode is used with text, hatched brushes, and pen styles that are not solid lines.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def background_mode(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfBackgroundMode:
        ...
    
    @background_mode.setter
    def background_mode(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfBackgroundMode):
        ...
    
    ...

class EmfSetBrushOrgEx(EmfStateRecordType):
    '''The EMR_SETBRUSHORGEX record specifies the origin of the current brush.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def origin(self) -> aspose.imaging.Point:
        '''Gets a 64-bit WMF PointL object, specified in [MS-WMF] section 2.2.2.15, which
        specifies the brush's horizontal and vertical origin in device units.'''
        ...
    
    @origin.setter
    def origin(self, value : aspose.imaging.Point):
        '''Sets a 64-bit WMF PointL object, specified in [MS-WMF] section 2.2.2.15, which
        specifies the brush's horizontal and vertical origin in device units.'''
        ...
    
    ...

class EmfSetColorAdjustment(EmfStateRecordType):
    '''The EMR_SETCOLORADJUSTMENT record specifies color adjustment properties in the playback
    device context.'''
    
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def color_adjustment(self) -> aspose.imaging.fileformats.emf.emf.objects.EmfColorAdjustment:
        ...
    
    @color_adjustment.setter
    def color_adjustment(self, value : aspose.imaging.fileformats.emf.emf.objects.EmfColorAdjustment):
        ...
    
    ...

class EmfSetColorSpace(EmfObjectManipulationRecordType):
    '''The EMR_SETCOLORSPACE record defines the current logical color space object for graphics operations.'''
    
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def ih_cs(self) -> int:
        ...
    
    @ih_cs.setter
    def ih_cs(self, value : int):
        ...
    
    ...

class EmfSetDiBitsToDevice(EmfBitmapRecordType):
    '''The EMR_SETDIBITSTODEVICE record specifies a block transfer of pixels from specified scan lines of
    a source bitmap to a destination rectangle.'''
    
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets a WMF RectL object ([MS-WMF] section 2.2.2.19) that defines the
        destination bounding rectangle in device units.'''
        ...
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle):
        '''Sets a WMF RectL object ([MS-WMF] section 2.2.2.19) that defines the
        destination bounding rectangle in device units.'''
        ...
    
    @property
    def x_dest(self) -> int:
        ...
    
    @x_dest.setter
    def x_dest(self, value : int):
        ...
    
    @property
    def y_dest(self) -> int:
        ...
    
    @y_dest.setter
    def y_dest(self, value : int):
        ...
    
    @property
    def x_src(self) -> int:
        ...
    
    @x_src.setter
    def x_src(self, value : int):
        ...
    
    @property
    def y_src(self) -> int:
        ...
    
    @y_src.setter
    def y_src(self, value : int):
        ...
    
    @property
    def cx_src(self) -> int:
        ...
    
    @cx_src.setter
    def cx_src(self, value : int):
        ...
    
    @property
    def cy_src(self) -> int:
        ...
    
    @cy_src.setter
    def cy_src(self, value : int):
        ...
    
    @property
    def usage_src(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfDibColors:
        ...
    
    @usage_src.setter
    def usage_src(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfDibColors):
        ...
    
    @property
    def start_scan(self) -> int:
        ...
    
    @start_scan.setter
    def start_scan(self, value : int):
        ...
    
    @property
    def c_scans(self) -> int:
        ...
    
    @c_scans.setter
    def c_scans(self, value : int):
        ...
    
    @property
    def source_bitmap(self) -> aspose.imaging.fileformats.wmf.objects.WmfDeviceIndependentBitmap:
        ...
    
    @source_bitmap.setter
    def source_bitmap(self, value : aspose.imaging.fileformats.wmf.objects.WmfDeviceIndependentBitmap):
        ...
    
    ...

class EmfSetIcmMode(EmfStateRecordType):
    '''The EMR_SETICMMODE record specifies the mode of Image Color Management (ICM) for graphics operations.'''
    
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def icm_mode(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfIcmMode:
        ...
    
    @icm_mode.setter
    def icm_mode(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfIcmMode):
        ...
    
    ...

class EmfSetIcmProfileA(EmfStateRecordType):
    '''The EMR_SETICMPROFILEA record specifies a color profile in a file with a name consisting of ASCII
    characters, for graphics output.'''
    
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def dw_flags(self) -> int:
        ...
    
    @dw_flags.setter
    def dw_flags(self, value : int):
        ...
    
    @property
    def cb_name(self) -> int:
        ...
    
    @cb_name.setter
    def cb_name(self, value : int):
        ...
    
    @property
    def cb_data(self) -> int:
        ...
    
    @cb_data.setter
    def cb_data(self, value : int):
        ...
    
    @property
    def data(self) -> bytes:
        '''Gets an array of size (cbName + cbData) in bytes, which specifies the ASCII
        name and raw data of the desired color profile.'''
        ...
    
    @data.setter
    def data(self, value : bytes):
        '''Sets an array of size (cbName + cbData) in bytes, which specifies the ASCII
        name and raw data of the desired color profile.'''
        ...
    
    @property
    def name(self) -> str:
        '''Gets the name'''
        ...
    
    @property
    def raw_data(self) -> bytes:
        ...
    
    ...

class EmfSetIcmProfileW(EmfStateRecordType):
    '''The EMR_SETICMPROFILEW record specifies a color profile in a file with a name consisting of
    Unicode characters, for graphics output.'''
    
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def dw_flags(self) -> int:
        ...
    
    @dw_flags.setter
    def dw_flags(self, value : int):
        ...
    
    @property
    def cb_name(self) -> int:
        ...
    
    @cb_name.setter
    def cb_name(self, value : int):
        ...
    
    @property
    def cb_data(self) -> int:
        ...
    
    @cb_data.setter
    def cb_data(self, value : int):
        ...
    
    @property
    def data(self) -> bytes:
        '''Gets an array of size (cbName + cbData) in bytes, which specifies the UTF16-LE
        name and raw data of the desired color profile.'''
        ...
    
    @data.setter
    def data(self, value : bytes):
        '''Sets an array of size (cbName + cbData) in bytes, which specifies the UTF16-LE
        name and raw data of the desired color profile.'''
        ...
    
    @property
    def name(self) -> str:
        '''Gets the name'''
        ...
    
    @property
    def raw_data(self) -> bytes:
        ...
    
    ...

class EmfSetLayout(EmfStateRecordType):
    '''The EMR_SETLAYOUT record specifies the order in which text and graphics are drawn.'''
    
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def layout_mode(self) -> EmfSetLayout.LayoutModeEnum:
        ...
    
    @layout_mode.setter
    def layout_mode(self, value : EmfSetLayout.LayoutModeEnum):
        ...
    
    ...

class EmfSetLinkedUfis(EmfStateRecordType):
    '''The EMR_SETLINKEDUFIS record sets the UniversalFontIds (section 2.2.27) of the linked fonts to
    use during character lookup.'''
    
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def ufis(self) -> List[aspose.imaging.fileformats.emf.emf.objects.EmfUniversalFontId]:
        '''Gets an array of uNumLinkedUFI elements of type UniversalFontId, which specifies
        the identifiers of the linked fonts.'''
        ...
    
    @ufis.setter
    def ufis(self, value : List[aspose.imaging.fileformats.emf.emf.objects.EmfUniversalFontId]):
        '''Sets an array of uNumLinkedUFI elements of type UniversalFontId, which specifies
        the identifiers of the linked fonts.'''
        ...
    
    ...

class EmfSetMapMode(EmfRecord):
    '''The EMR_SETMAPMODE record specifies the mapping mode of the playback device context.
    The mapping mode specifies the unit of measure used to transform page space units
    into device space units, and also specifies the orientation of the device's x-axis and y-axis.'''
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @overload
    def __init__(self, record: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param record: The record.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def map_mode(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfMapMode:
        ...
    
    @map_mode.setter
    def map_mode(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfMapMode):
        ...
    
    ...

class EmfSetMapperFlags(EmfStateRecordType):
    '''The EMR_SETMAPPERFLAGS record specifies parameters of the process of matching logical fonts to
    physical fonts, which is performed by the font mapper.'''
    
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def flags(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies parameters of the font matching process.'''
        ...
    
    @flags.setter
    def flags(self, value : int):
        '''Sets a 32-bit unsigned integer that specifies parameters of the font matching process.'''
        ...
    
    ...

class EmfSetMetaRgn(EmfClippingRecordType):
    '''Inter sets the current meta region with the current clipping region
    to form a new meta region for the playback device context. The
    current clipping region SHOULD be reset to null.
    This EMF record specifies no parameters.'''
    
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    ...

class EmfSetMiterLimit(EmfStateRecordType):
    '''The EMR_SETMITERLIMIT record specifies the limit for the length of miter joins for the playback device context.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def miter_limit(self) -> int:
        ...
    
    @miter_limit.setter
    def miter_limit(self, value : int):
        ...
    
    ...

class EmfSetPaletteEntries(EmfObjectManipulationRecordType):
    '''The EMR_SETPALETTEENTRIES record defines RGB color values in a range of entries for an existing
    LogPalette (section 2.2.17) object.'''
    
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def ih_pal(self) -> int:
        ...
    
    @ih_pal.setter
    def ih_pal(self, value : int):
        ...
    
    @property
    def start(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the index of the first entry to set.'''
        ...
    
    @start.setter
    def start(self, value : int):
        '''Sets a 32-bit unsigned integer that specifies the index of the first entry to set.'''
        ...
    
    @property
    def numberof_entries(self) -> int:
        ...
    
    @numberof_entries.setter
    def numberof_entries(self, value : int):
        ...
    
    @property
    def argb_32_pal_entries(self) -> List[int]:
        ...
    
    @argb_32_pal_entries.setter
    def argb_32_pal_entries(self, value : List[int]):
        ...
    
    ...

class EmfSetPixelV(EmfDrawingRecordType):
    '''The EMR_SETPIXELV record defines the color of the pixel at the specified logical coordinates.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def pixel(self) -> aspose.imaging.Point:
        '''Gets a 64-bit WMF PointL object ([MS-WMF] section 2.2.2.15) that specifies the
        logical coordinates for the pixel.'''
        ...
    
    @pixel.setter
    def pixel(self, value : aspose.imaging.Point):
        '''Sets a 64-bit WMF PointL object ([MS-WMF] section 2.2.2.15) that specifies the
        logical coordinates for the pixel.'''
        ...
    
    @property
    def argb_32_color(self) -> int:
        ...
    
    @argb_32_color.setter
    def argb_32_color(self, value : int):
        ...
    
    ...

class EmfSetPolyFillMode(EmfStateRecordType):
    '''The EMR_SETPOLYFILLMODE record defines polygon fill mode.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def polygon_fill_mode(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfPolygonFillMode:
        ...
    
    @polygon_fill_mode.setter
    def polygon_fill_mode(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfPolygonFillMode):
        ...
    
    ...

class EmfSetRop2(EmfStateRecordType):
    '''The EMR_SETROP2 record defines a binary raster operation mode.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def rop_2_mode(self) -> aspose.imaging.fileformats.wmf.consts.WmfBinaryRasterOperation:
        ...
    
    @rop_2_mode.setter
    def rop_2_mode(self, value : aspose.imaging.fileformats.wmf.consts.WmfBinaryRasterOperation):
        ...
    
    ...

class EmfSetStrechBltMode(EmfStateRecordType):
    '''The EMR_SETSTRETCHBLTMODE record specifies bitmap stretch mode.'''
    
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def stretch_mode(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfStretchMode:
        ...
    
    @stretch_mode.setter
    def stretch_mode(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfStretchMode):
        ...
    
    ...

class EmfSetTextAlign(EmfStateRecordType):
    '''The EMR_SETTEXTALIGN record specifies text alignment.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def text_alignment_mode(self) -> int:
        ...
    
    @text_alignment_mode.setter
    def text_alignment_mode(self, value : int):
        ...
    
    ...

class EmfSetTextColor(EmfStateRecordType):
    '''The EMR_SETTEXTCOLOR record defines the current text color.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def argb_32_color(self) -> int:
        ...
    
    @argb_32_color.setter
    def argb_32_color(self, value : int):
        ...
    
    ...

class EmfSetTextJustification(EmfStateRecordType):
    '''The EMR_SETTEXTJUSTIFICATION record specifies the amount of extra space to add to break
    characters for text justification.'''
    
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def n_break_extra(self) -> int:
        ...
    
    @n_break_extra.setter
    def n_break_extra(self, value : int):
        ...
    
    @property
    def n_break_count(self) -> int:
        ...
    
    @n_break_count.setter
    def n_break_count(self, value : int):
        ...
    
    ...

class EmfSetViewportExtEx(EmfStateRecordType):
    '''The EMR_SETVIEWPORTEXTEX record defines the viewport extent.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def extent(self) -> aspose.imaging.Size:
        '''Gets a 64-bit WMF SizeL object ([MS-WMF] section 2.2.2.22) that specifies the
        horizontal and vertical extents in device units.'''
        ...
    
    @extent.setter
    def extent(self, value : aspose.imaging.Size):
        '''Sets a 64-bit WMF SizeL object ([MS-WMF] section 2.2.2.22) that specifies the
        horizontal and vertical extents in device units.'''
        ...
    
    ...

class EmfSetViewportOrgEx(EmfStateRecordType):
    '''The EMR_SETVIEWPORTORGEX record defines the viewport origin.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def origin(self) -> aspose.imaging.Point:
        '''Gets a 64-bit WMF PointL object ([MS-WMF] section 2.2.2.15) that specifies the
        window horizontal and vertical origin in device units.'''
        ...
    
    @origin.setter
    def origin(self, value : aspose.imaging.Point):
        '''Sets a 64-bit WMF PointL object ([MS-WMF] section 2.2.2.15) that specifies the
        window horizontal and vertical origin in device units.'''
        ...
    
    ...

class EmfSetWindowExtEx(EmfStateRecordType):
    '''The EMR_SETWINDOWEXTEX record defines the window extent.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def extent(self) -> aspose.imaging.Size:
        '''Gets a 64-bit WMF SizeL object ([MS-WMF] section 2.2.2.22) that specifies the
        horizontal and vertical extents in logical units.'''
        ...
    
    @extent.setter
    def extent(self, value : aspose.imaging.Size):
        '''Sets a 64-bit WMF SizeL object ([MS-WMF] section 2.2.2.22) that specifies the
        horizontal and vertical extents in logical units.'''
        ...
    
    ...

class EmfSetWindowOrgEx(EmfStateRecordType):
    '''The EMR_SETWINDOWORGEX record defines the window origin.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def origin(self) -> aspose.imaging.Point:
        '''Gets a 64-bit WMF PointL object ([MS-WMF] section 2.2.2.15) that specifies the
        window horizontal and vertical origin in logical units.'''
        ...
    
    @origin.setter
    def origin(self, value : aspose.imaging.Point):
        '''Sets a 64-bit WMF PointL object ([MS-WMF] section 2.2.2.15) that specifies the
        window horizontal and vertical origin in logical units.'''
        ...
    
    ...

class EmfSetWorldTransform(EmfTransformRecordType):
    '''The EMR_SETWORLDTRANSFORM record specifies a transform for the current world-space to page space transform in the playback device context.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def xform(self) -> aspose.imaging.Matrix:
        '''Gets an XForm object (section 2.2.28), which defines a world-space to page space transform.'''
        ...
    
    @xform.setter
    def xform(self, value : aspose.imaging.Matrix):
        '''Sets an XForm object (section 2.2.28), which defines a world-space to page space transform.'''
        ...
    
    ...

class EmfSmallTextOut(EmfDrawingRecordType):
    '''The EMR_SMALLTEXTOUT record outputs a string.'''
    
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def x(self) -> int:
        '''Gets a 32-bit signed integer specifying the x-coordinate of where to place the string.'''
        ...
    
    @x.setter
    def x(self, value : int):
        '''Sets a 32-bit signed integer specifying the x-coordinate of where to place the string.'''
        ...
    
    @property
    def y(self) -> int:
        '''Gets a 32-bit signed integer specifying the y-coordinate of where to place the string.'''
        ...
    
    @y.setter
    def y(self, value : int):
        '''Sets a 32-bit signed integer specifying the y-coordinate of where to place the string.'''
        ...
    
    @property
    def c_chars(self) -> int:
        ...
    
    @c_chars.setter
    def c_chars(self, value : int):
        ...
    
    @property
    def fu_options(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfExtTextOutOptions:
        ...
    
    @fu_options.setter
    def fu_options(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfExtTextOutOptions):
        ...
    
    @property
    def graphics_mode(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfGraphicsMode:
        ...
    
    @graphics_mode.setter
    def graphics_mode(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfGraphicsMode):
        ...
    
    @property
    def ex_scale(self) -> float:
        ...
    
    @ex_scale.setter
    def ex_scale(self, value : float):
        ...
    
    @property
    def ey_scale(self) -> float:
        ...
    
    @ey_scale.setter
    def ey_scale(self, value : float):
        ...
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets an optional, 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that
        specifies the bounding rectangle in device units.'''
        ...
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle):
        '''Sets an optional, 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that
        specifies the bounding rectangle in device units.'''
        ...
    
    @property
    def text_string(self) -> str:
        ...
    
    @text_string.setter
    def text_string(self, value : str):
        ...
    
    ...

class EmfStateRecordType(EmfRecord):
    '''The state record types specify and manage graphics properties that define the state of the playback device context.'''
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    ...

class EmfStretchBlt(EmfBitmapRecordType):
    '''The EMR_STRETCHBLT record specifies a block transfer of pixels from a source bitmap to a
    destination rectangle, optionally in combination with a brush pattern, according to a specified raster
    operation, stretching or compressing the output to fit the dimensions of the destination, if necessary.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets a WMF RectL object ([MS-WMF] section 2.2.2.19) that defines the
        destination bounding rectangle in device units.'''
        ...
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle):
        '''Sets a WMF RectL object ([MS-WMF] section 2.2.2.19) that defines the
        destination bounding rectangle in device units.'''
        ...
    
    @property
    def x_dest(self) -> int:
        ...
    
    @x_dest.setter
    def x_dest(self, value : int):
        ...
    
    @property
    def y_dest(self) -> int:
        ...
    
    @y_dest.setter
    def y_dest(self, value : int):
        ...
    
    @property
    def cx_dest(self) -> int:
        ...
    
    @cx_dest.setter
    def cx_dest(self, value : int):
        ...
    
    @property
    def cy_dest(self) -> int:
        ...
    
    @cy_dest.setter
    def cy_dest(self, value : int):
        ...
    
    @property
    def bit_blt_raster_operation(self) -> aspose.imaging.fileformats.wmf.consts.WmfTernaryRasterOperation:
        ...
    
    @bit_blt_raster_operation.setter
    def bit_blt_raster_operation(self, value : aspose.imaging.fileformats.wmf.consts.WmfTernaryRasterOperation):
        ...
    
    @property
    def x_src(self) -> int:
        ...
    
    @x_src.setter
    def x_src(self, value : int):
        ...
    
    @property
    def y_src(self) -> int:
        ...
    
    @y_src.setter
    def y_src(self, value : int):
        ...
    
    @property
    def xform_src(self) -> aspose.imaging.Matrix:
        ...
    
    @xform_src.setter
    def xform_src(self, value : aspose.imaging.Matrix):
        ...
    
    @property
    def argb_32_bk_color_src(self) -> int:
        ...
    
    @argb_32_bk_color_src.setter
    def argb_32_bk_color_src(self, value : int):
        ...
    
    @property
    def usage_src(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfDibColors:
        ...
    
    @usage_src.setter
    def usage_src(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfDibColors):
        ...
    
    @property
    def cx_src(self) -> int:
        ...
    
    @cx_src.setter
    def cx_src(self, value : int):
        ...
    
    @property
    def cy_src(self) -> int:
        ...
    
    @cy_src.setter
    def cy_src(self, value : int):
        ...
    
    @property
    def source_bitmap(self) -> aspose.imaging.fileformats.wmf.objects.WmfDeviceIndependentBitmap:
        ...
    
    @source_bitmap.setter
    def source_bitmap(self, value : aspose.imaging.fileformats.wmf.objects.WmfDeviceIndependentBitmap):
        ...
    
    @property
    def src_rect(self) -> aspose.imaging.Rectangle:
        ...
    
    @src_rect.setter
    def src_rect(self, value : aspose.imaging.Rectangle):
        ...
    
    @property
    def dest_rect(self) -> aspose.imaging.Rectangle:
        ...
    
    @dest_rect.setter
    def dest_rect(self, value : aspose.imaging.Rectangle):
        ...
    
    ...

class EmfStretchDiBits(EmfBitmapRecordType):
    '''The EMR_STRETCHDIBITS record specifies a block transfer of pixels from a source bitmap to a
    destination rectangle, optionally in combination with a brush pattern, according to a specified raster
    operation, stretching or compressing the output to fit the dimensions of the destination, if necessary.'''
    
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets a WMF RectL object ([MS-WMF] section 2.2.2.19) that defines the
        destination bounding rectangle in device units.'''
        ...
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle):
        '''Sets a WMF RectL object ([MS-WMF] section 2.2.2.19) that defines the
        destination bounding rectangle in device units.'''
        ...
    
    @property
    def x_dest(self) -> int:
        ...
    
    @x_dest.setter
    def x_dest(self, value : int):
        ...
    
    @property
    def y_dest(self) -> int:
        ...
    
    @y_dest.setter
    def y_dest(self, value : int):
        ...
    
    @property
    def x_src(self) -> int:
        ...
    
    @x_src.setter
    def x_src(self, value : int):
        ...
    
    @property
    def y_src(self) -> int:
        ...
    
    @y_src.setter
    def y_src(self, value : int):
        ...
    
    @property
    def cx_src(self) -> int:
        ...
    
    @cx_src.setter
    def cx_src(self, value : int):
        ...
    
    @property
    def cy_src(self) -> int:
        ...
    
    @cy_src.setter
    def cy_src(self, value : int):
        ...
    
    @property
    def usage_src(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfDibColors:
        ...
    
    @usage_src.setter
    def usage_src(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfDibColors):
        ...
    
    @property
    def bit_blt_raster_operation(self) -> aspose.imaging.fileformats.wmf.consts.WmfTernaryRasterOperation:
        ...
    
    @bit_blt_raster_operation.setter
    def bit_blt_raster_operation(self, value : aspose.imaging.fileformats.wmf.consts.WmfTernaryRasterOperation):
        ...
    
    @property
    def cx_dest(self) -> int:
        ...
    
    @cx_dest.setter
    def cx_dest(self, value : int):
        ...
    
    @property
    def cy_dest(self) -> int:
        ...
    
    @cy_dest.setter
    def cy_dest(self, value : int):
        ...
    
    @property
    def source_bitmap(self) -> aspose.imaging.fileformats.wmf.objects.WmfDeviceIndependentBitmap:
        ...
    
    @source_bitmap.setter
    def source_bitmap(self, value : aspose.imaging.fileformats.wmf.objects.WmfDeviceIndependentBitmap):
        ...
    
    ...

class EmfStrokeAndFillPath(EmfDrawingRecordType):
    '''The EMR_STROKEANDFILLPATH record closes any open figures in a path, strokes the outline of the
    path by using the current pen, and fills its interior by using the current brush.'''
    
    @overload
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets a 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies
        the bounding rectangle, in device units.'''
        ...
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle):
        '''Sets a 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies
        the bounding rectangle, in device units.'''
        ...
    
    ...

class EmfStrokePath(EmfDrawingRecordType):
    '''EMR_STROKEPATH class'''
    
    @overload
    def __init__(self, record: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param record: The record.'''
        ...
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets a 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the bounding rectangle in device units'''
        ...
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle):
        '''Sets a 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the bounding rectangle in device units'''
        ...
    
    ...

class EmfTransformRecordType(EmfRecord):
    '''The transform record types specify and modify world-space to page-space transforms.'''
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def xform(self) -> aspose.imaging.Matrix:
        '''Gets an XForm object (section 2.2.28), which defines a world-space to page space transform.'''
        ...
    
    @xform.setter
    def xform(self, value : aspose.imaging.Matrix):
        '''Sets an XForm object (section 2.2.28), which defines a world-space to page space transform.'''
        ...
    
    ...

class EmfTransparentBlt(EmfBitmapRecordType):
    '''The EMR_TRANSPARENTBLT record specifies a block transfer of pixels from a source bitmap to a
    destination rectangle, treating a specified color as transparent, stretching or compressing the output
    to fit the dimensions of the destination, if necessary'''
    
    def __init__(self, source: aspose.imaging.fileformats.emf.emf.records.EmfRecord):
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets a WMF RectL object ([MS-WMF] section 2.2.2.19) that defines the
        destination bounding rectangle in device units.'''
        ...
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle):
        '''Sets a WMF RectL object ([MS-WMF] section 2.2.2.19) that defines the
        destination bounding rectangle in device units.'''
        ...
    
    @property
    def x_dest(self) -> int:
        ...
    
    @x_dest.setter
    def x_dest(self, value : int):
        ...
    
    @property
    def y_dest(self) -> int:
        ...
    
    @y_dest.setter
    def y_dest(self, value : int):
        ...
    
    @property
    def cx_dest(self) -> int:
        ...
    
    @cx_dest.setter
    def cx_dest(self, value : int):
        ...
    
    @property
    def cy_dest(self) -> int:
        ...
    
    @cy_dest.setter
    def cy_dest(self, value : int):
        ...
    
    @property
    def transparent_argb_32_color(self) -> int:
        ...
    
    @transparent_argb_32_color.setter
    def transparent_argb_32_color(self, value : int):
        ...
    
    @property
    def x_src(self) -> int:
        ...
    
    @x_src.setter
    def x_src(self, value : int):
        ...
    
    @property
    def y_src(self) -> int:
        ...
    
    @y_src.setter
    def y_src(self, value : int):
        ...
    
    @property
    def xform_src(self) -> aspose.imaging.Matrix:
        ...
    
    @xform_src.setter
    def xform_src(self, value : aspose.imaging.Matrix):
        ...
    
    @property
    def src_bk_argb_32_color(self) -> int:
        ...
    
    @src_bk_argb_32_color.setter
    def src_bk_argb_32_color(self, value : int):
        ...
    
    @property
    def usage_src(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfDibColors:
        ...
    
    @usage_src.setter
    def usage_src(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfDibColors):
        ...
    
    @property
    def cx_src(self) -> int:
        ...
    
    @cx_src.setter
    def cx_src(self, value : int):
        ...
    
    @property
    def cy_src(self) -> int:
        ...
    
    @cy_src.setter
    def cy_src(self, value : int):
        ...
    
    @property
    def source_bitmap(self) -> aspose.imaging.fileformats.wmf.objects.WmfDeviceIndependentBitmap:
        ...
    
    @source_bitmap.setter
    def source_bitmap(self, value : aspose.imaging.fileformats.wmf.objects.WmfDeviceIndependentBitmap):
        ...
    
    ...

class EmfVertexData:
    '''Objects that specify the vertexes of either rectangles or triangles and
    the colors that correspond to them.'''
    
    def __init__(self):
        ...
    
    @property
    def vertex_objects(self) -> List[aspose.imaging.fileformats.emf.emf.objects.EmfTriVertex]:
        ...
    
    @vertex_objects.setter
    def vertex_objects(self, value : List[aspose.imaging.fileformats.emf.emf.objects.EmfTriVertex]):
        ...
    
    @property
    def vertex_indexes(self) -> List[aspose.imaging.fileformats.emf.emf.objects.EmfGradientRectangle]:
        ...
    
    @vertex_indexes.setter
    def vertex_indexes(self, value : List[aspose.imaging.fileformats.emf.emf.objects.EmfGradientRectangle]):
        ...
    
    @property
    def vertex_padding(self) -> bytes:
        ...
    
    @vertex_padding.setter
    def vertex_padding(self, value : bytes):
        ...
    
    ...

class EmfWidenPath(EmfPathBracketRecordType):
    '''This record redefines the current path as the area that would be painted if the path
    were drawn using the pen currently selected into the playback device context.'''
    
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @staticmethod
    def create_from_record(source: aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param source: The source.'''
        ...
    
    @staticmethod
    def create_from_type(type: aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the  class.
        
        :param type: The record type.'''
        ...
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        ...
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType):
        '''Sets the type.'''
        ...
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        ...
    
    @size.setter
    def size(self, value : int):
        '''Sets the size of the record'''
        ...
    
    ...

