# generated by datamodel-codegen:
#   filename:  acp-openapi3.yaml
#   timestamp: 2025-07-31T02:27:18+00:00

from __future__ import annotations

from datetime import datetime
from enum import Enum
from typing import Any, Dict, List, Optional, Union

from pydantic import AnyUrl, BaseModel, ConfigDict, Field, RootModel


class Jsonrpc(Enum):
    field_2_0 = '2.0'


class Method(Enum):
    tasks_create = 'tasks.create'
    tasks_send = 'tasks.send'
    tasks_get = 'tasks.get'
    tasks_cancel = 'tasks.cancel'
    tasks_subscribe = 'tasks.subscribe'
    stream_start = 'stream.start'
    stream_message = 'stream.message'
    stream_end = 'stream.end'
    task_notification = 'task.notification'
    stream_chunk = 'stream.chunk'


class RpcError(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    code: int = Field(
        ...,
        description='Standard JSON-RPC error codes: -32700: Parse error -32600: Invalid Request   -32601: Method not found -32602: Invalid params -32603: Internal error\nACP-specific error codes: -40001: Task not found -40002: Task already completed -40003: Stream not found -40004: Stream already closed -40005: Agent not available -40006: Permission denied -40007: Authentication failed -40008: Insufficient OAuth2 scope -40009: OAuth2 token expired\n',
    )
    message: str
    data: Optional[Any] = Field(None, description='Additional error context')


class Status(Enum):
    submitted = 'SUBMITTED'
    working = 'WORKING'
    input_required = 'INPUT_REQUIRED'
    completed = 'COMPLETED'
    failed = 'FAILED'
    canceled = 'CANCELED'


class Priority(Enum):
    low = 'LOW'
    normal = 'NORMAL'
    high = 'HIGH'
    urgent = 'URGENT'


class TasksGetParams(BaseModel):
    task_id: str = Field(..., alias='taskId')
    include_messages: Optional[bool] = Field(True, alias='includeMessages')
    include_artifacts: Optional[bool] = Field(True, alias='includeArtifacts')


class TasksCancelParams(BaseModel):
    task_id: str = Field(..., alias='taskId')
    reason: Optional[str] = Field(None, description='Reason for cancellation')


class Event(Enum):
    status_change = 'STATUS_CHANGE'
    new_message = 'NEW_MESSAGE'
    new_artifact = 'NEW_ARTIFACT'
    completed = 'COMPLETED'
    failed = 'FAILED'


class TasksSubscribeParams(BaseModel):
    task_id: str = Field(..., alias='taskId')
    callback_url: AnyUrl = Field(
        ..., alias='callbackUrl', description='Webhook URL for task notifications'
    )
    events: Optional[List[Event]] = ['STATUS_CHANGE', 'COMPLETED', 'FAILED']


class Status1(Enum):
    active = 'ACTIVE'
    paused = 'PAUSED'
    closed = 'CLOSED'


class StreamObject(BaseModel):
    stream_id: str = Field(
        ..., alias='streamId', description='Unique identifier for the stream'
    )
    status: Status1
    participants: List[str] = Field(
        ..., description='Agent IDs participating in stream'
    )
    created_at: Optional[datetime] = Field(None, alias='createdAt')
    closed_at: Optional[datetime] = Field(None, alias='closedAt')
    metadata: Optional[Dict[str, Any]] = None


class StreamStartParams(BaseModel):
    participants: Optional[List[str]] = Field(
        None, description='Agent IDs to include in stream'
    )
    metadata: Optional[Dict[str, Any]] = None


class StreamEndParams(BaseModel):
    stream_id: str = Field(..., alias='streamId')
    reason: Optional[str] = Field(None, description='Reason for ending stream')


class Role(Enum):
    user = 'user'
    agent = 'agent'
    system = 'system'


class Type(Enum):
    text_part = 'TextPart'
    data_part = 'DataPart'
    file_part = 'FilePart'
    image_part = 'ImagePart'
    audio_part = 'AudioPart'


class Encoding(Enum):
    """
    Encoding for data parts
    """

    base64 = 'base64'
    utf8 = 'utf8'
    binary = 'binary'


class Part(BaseModel):
    model_config = ConfigDict(
        extra='allow',
    )
    type: Type
    content: Optional[Any] = Field(None, description='Text content or data payload')
    mime_type: Optional[str] = Field(
        None, alias='mimeType', description='MIME type for data/file parts'
    )
    filename: Optional[str] = Field(
        None, description='Original filename for file parts'
    )
    size: Optional[int] = Field(None, description='Size in bytes for data/file parts')
    encoding: Optional[Encoding] = Field(None, description='Encoding for data parts')


class Artifact(BaseModel):
    artifact_id: str = Field(
        ..., alias='artifactId', description='Unique identifier for artifact'
    )
    name: str = Field(..., description='Human-readable artifact name')
    description: Optional[str] = Field(
        None, description='Description of artifact contents/purpose'
    )
    parts: List[Part]
    created_at: Optional[datetime] = Field(None, alias='createdAt')
    created_by: Optional[str] = Field(
        None, alias='createdBy', description='Agent ID that created this artifact'
    )
    version: Optional[str] = Field(None, description='Artifact version number')
    metadata: Optional[Dict[str, Any]] = None


class Type1(Enum):
    task = 'task'
    stream = 'stream'
    subscription = 'subscription'
    notification = 'notification'
    success = 'success'
    task_1 = 'task'


class Type2(Enum):
    task = 'task'
    stream = 'stream'
    subscription = 'subscription'
    notification = 'notification'
    success = 'success'
    stream_1 = 'stream'


class Type3(Enum):
    task = 'task'
    stream = 'stream'
    subscription = 'subscription'
    notification = 'notification'
    success = 'success'
    subscription_1 = 'subscription'


class Type4(Enum):
    task = 'task'
    stream = 'stream'
    subscription = 'subscription'
    notification = 'notification'
    success = 'success'
    notification_1 = 'notification'
    success_1 = 'success'


class SubscriptionObject(BaseModel):
    subscription_id: str = Field(..., alias='subscriptionId')
    task_id: str = Field(..., alias='taskId')
    callback_url: AnyUrl = Field(..., alias='callbackUrl')
    events: List[str]
    created_at: Optional[datetime] = Field(None, alias='createdAt')
    active: Optional[bool] = True


class Message(BaseModel):
    role: Role
    parts: List[Part] = Field(..., min_length=1)
    timestamp: Optional[datetime] = None
    agent_id: Optional[str] = Field(
        None, alias='agentId', description='ID of agent that sent this message'
    )


class TaskObject(BaseModel):
    task_id: str = Field(
        ..., alias='taskId', description='Unique identifier for the task'
    )
    status: Status
    created_at: datetime = Field(..., alias='createdAt')
    updated_at: Optional[datetime] = Field(None, alias='updatedAt')
    assigned_agent: Optional[str] = Field(
        None, alias='assignedAgent', description='ID of agent processing this task'
    )
    messages: Optional[List[Message]] = Field(
        None, description='Conversation history for this task'
    )
    artifacts: Optional[List[Artifact]] = Field(
        None, description='Files, data, or outputs generated during task execution'
    )
    metadata: Optional[Dict[str, Any]] = Field(None, description='Custom task metadata')


class TasksCreateParams(BaseModel):
    initial_message: Message = Field(..., alias='initialMessage')
    assign_to: Optional[str] = Field(
        None, alias='assignTo', description='Specific agent ID to assign task to'
    )
    priority: Optional[Priority] = 'NORMAL'
    metadata: Optional[Dict[str, Any]] = None


class TasksSendParams(BaseModel):
    task_id: str = Field(..., alias='taskId')
    message: Message


class TaskNotificationParams(BaseModel):
    task_id: str = Field(..., alias='taskId')
    event: Event
    timestamp: datetime
    data: Optional[Union[TaskObject, Message, Artifact]] = None


class StreamMessageParams(BaseModel):
    stream_id: str = Field(..., alias='streamId')
    message: Message


class StreamChunkParams(BaseModel):
    stream_id: str = Field(..., alias='streamId')
    chunk: Message
    sequence: int = Field(..., description='Sequence number for ordering chunks')
    is_last: Optional[bool] = Field(
        False, alias='isLast', description='Indicates if this is the final chunk'
    )


class MethodResult1(BaseModel):
    type: Type1
    task: TaskObject
    stream: Optional[StreamObject] = None
    subscription: Optional[SubscriptionObject] = None
    message: Optional[str] = Field(
        None, description='Success message for simple operations'
    )


class MethodResult2(BaseModel):
    type: Type2
    task: Optional[TaskObject] = None
    stream: StreamObject
    subscription: Optional[SubscriptionObject] = None
    message: Optional[str] = Field(
        None, description='Success message for simple operations'
    )


class MethodResult3(BaseModel):
    type: Type3
    task: Optional[TaskObject] = None
    stream: Optional[StreamObject] = None
    subscription: SubscriptionObject
    message: Optional[str] = Field(
        None, description='Success message for simple operations'
    )


class MethodResult4(BaseModel):
    type: Type4
    task: Optional[TaskObject] = None
    stream: Optional[StreamObject] = None
    subscription: Optional[SubscriptionObject] = None
    message: str = Field(..., description='Success message for simple operations')


class MethodResult(
    RootModel[Union[MethodResult1, MethodResult2, MethodResult3, MethodResult4]]
):
    root: Union[MethodResult1, MethodResult2, MethodResult3, MethodResult4]


class JsonRpcRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    jsonrpc: Jsonrpc
    method: Method
    params: Optional[
        Union[
            TasksCreateParams,
            TasksSendParams,
            TasksGetParams,
            TasksCancelParams,
            TasksSubscribeParams,
            StreamStartParams,
            StreamMessageParams,
            StreamEndParams,
            TaskNotificationParams,
            StreamChunkParams,
        ]
    ] = None
    id: Optional[Union[str, int]] = None


class JsonRpcResponse1(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    jsonrpc: Jsonrpc
    id: Union[str, int]
    result: MethodResult
    error: Optional[RpcError] = None


class JsonRpcResponse2(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    jsonrpc: Jsonrpc
    id: Union[str, int]
    result: Optional[MethodResult] = None
    error: RpcError


class JsonRpcResponse(RootModel[Union[JsonRpcResponse1, JsonRpcResponse2]]):
    root: Union[JsonRpcResponse1, JsonRpcResponse2]
