"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SecureLogBucket = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_secure_bucket_1 = require("@gammarer/aws-secure-bucket");
const cdk = require("aws-cdk-lib");
const s3 = require("aws-cdk-lib/aws-s3");
class SecureLogBucket extends aws_secure_bucket_1.SecureBucket {
    constructor(scope, id, props) {
        super(scope, id, {
            bucketName: props?.bucketName,
            encryption: aws_secure_bucket_1.SecureBucketEncryption.KMS_MANAGED,
            versioned: true,
            objectOwnership: props?.objectOwnership,
            lifecycleRules: [{
                    id: 'archive-step-lifecycle-rule',
                    enabled: true,
                    transitions: [
                        {
                            storageClass: s3.StorageClass.INFREQUENT_ACCESS,
                            transitionAfter: cdk.Duration.days(props?.changeClassTransition?.infrequentAccessDays ?? 60),
                        },
                        {
                            storageClass: s3.StorageClass.INTELLIGENT_TIERING,
                            transitionAfter: cdk.Duration.days(props?.changeClassTransition?.intelligentTieringDays ?? 120),
                        },
                        {
                            storageClass: s3.StorageClass.GLACIER,
                            transitionAfter: cdk.Duration.days(props?.changeClassTransition?.glacierDays ?? 180),
                        },
                        {
                            storageClass: s3.StorageClass.DEEP_ARCHIVE,
                            transitionAfter: cdk.Duration.days(props?.changeClassTransition?.deepArchiveDays ?? 360),
                        },
                    ],
                }],
        });
    }
}
exports.SecureLogBucket = SecureLogBucket;
_a = JSII_RTTI_SYMBOL_1;
SecureLogBucket[_a] = { fqn: "@gammarer/aws-secure-log-bucket.SecureLogBucket", version: "0.11.12" };
//# sourceMappingURL=data:application/json;base64,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