# coding: utf-8

"""
    VRt.Account [AC]

    # Description  Veeroute Account Panel.  ## Entity relationship diagram  ![erd](../uml/account.svg) 

    The version of the OpenAPI document: 6.19.2236
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List
from pydantic import BaseModel
from vrt_lss_account.models.audit_action import AuditAction
from vrt_lss_account.models.audit_stats import AuditStats

class AccountAuditResult(BaseModel):
    """
    User actions request result.  # noqa: E501
    """
    actions: Annotated[List[AuditAction], Field(min_length=0, max_length=10000000)] = Field(description="User actions list.")
    statistics: AuditStats
    __properties = ["actions", "statistics"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AccountAuditResult:
        """Create an instance of AccountAuditResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in actions (list)
        _items = []
        if self.actions:
            for _item in self.actions:
                if _item:
                    _items.append(_item.to_dict())
            _dict['actions'] = _items
        # override the default output from pydantic by calling `to_dict()` of statistics
        if self.statistics:
            _dict['statistics'] = self.statistics.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AccountAuditResult:
        """Create an instance of AccountAuditResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AccountAuditResult.parse_obj(obj)

        _obj = AccountAuditResult.parse_obj({
            "actions": [AuditAction.from_dict(_item) for _item in obj.get("actions")] if obj.get("actions") is not None else None,
            "statistics": AuditStats.from_dict(obj.get("statistics")) if obj.get("statistics") is not None else None
        })
        return _obj


