# coding: utf-8

"""
    VRt.Account [AC]

    # Description  Veeroute Account Panel.  ## Entity relationship diagram  ![erd](../uml/account.svg) 

    The version of the OpenAPI document: 6.19.2236
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, field_validator

class AccountInfo(BaseModel):
    """
    User information.  # noqa: E501
    """
    username: Annotated[str, Field(min_length=2, strict=True, max_length=256)] = Field(description="Login, unique identifier.")
    name: Optional[Annotated[str, Field(min_length=2, strict=True, max_length=256)]] = Field(default=None, description="Full name of user.")
    email: Optional[Annotated[str, Field(min_length=5, strict=True, max_length=256)]] = Field(default=None, description="User mail address.")
    phone: Optional[Annotated[str, Field(min_length=5, strict=True, max_length=32)]] = Field(default=None, description="User phone.")
    company_key: Annotated[str, Field(min_length=3, strict=True, max_length=256)] = Field(description="Company key.")
    timezone: Optional[Annotated[int, Field(le=12, strict=True, ge=-12)]] = Field(default=0, description="Basic time zone used for statistics.")
    __properties = ["username", "name", "email", "phone", "company_key", "timezone"]

    @validator('username')
    def username_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"\w+", value):
            raise ValueError(r"must validate the regular expression /\w+/")
        return value

    @validator('company_key')
    def company_key_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"\w+", value):
            raise ValueError(r"must validate the regular expression /\w+/")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AccountInfo:
        """Create an instance of AccountInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if name (nullable) is None
        # and __fields_set__ contains the field
        if self.name is None and "name" in self.__fields_set__:
            _dict['name'] = None

        # set to None if email (nullable) is None
        # and __fields_set__ contains the field
        if self.email is None and "email" in self.__fields_set__:
            _dict['email'] = None

        # set to None if phone (nullable) is None
        # and __fields_set__ contains the field
        if self.phone is None and "phone" in self.__fields_set__:
            _dict['phone'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AccountInfo:
        """Create an instance of AccountInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AccountInfo.parse_obj(obj)

        _obj = AccountInfo.parse_obj({
            "username": obj.get("username"),
            "name": obj.get("name"),
            "email": obj.get("email"),
            "phone": obj.get("phone"),
            "company_key": obj.get("company_key"),
            "timezone": obj.get("timezone") if obj.get("timezone") is not None else 0
        })
        return _obj


