# coding: utf-8

"""
    VRt.Account [AC]

    # Description  Veeroute Account Panel.  ## Entity relationship diagram  ![erd](../uml/account.svg) 

    The version of the OpenAPI document: 6.19.2236
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List
from pydantic import BaseModel, field_validator
from vrt_lss_account.models.audit_action_statistics import AuditActionStatistics
from vrt_lss_account.models.method_group import MethodGroup
from vrt_lss_account.models.tracedata import Tracedata

class AuditAction(BaseModel):
    """
    User action.  # noqa: E501
    """
    username: Annotated[str, Field(min_length=2, strict=True, max_length=256)] = Field(description="Login, unique identifier.")
    company_key: Annotated[str, Field(min_length=3, strict=True, max_length=256)] = Field(description="Company key.")
    tracedata: Tracedata
    method_group: MethodGroup
    statistics: AuditActionStatistics
    __properties = ["username", "company_key", "tracedata", "method_group", "statistics"]

    @validator('username')
    def username_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"\w+", value):
            raise ValueError(r"must validate the regular expression /\w+/")
        return value

    @validator('company_key')
    def company_key_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"\w+", value):
            raise ValueError(r"must validate the regular expression /\w+/")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AuditAction:
        """Create an instance of AuditAction from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of tracedata
        if self.tracedata:
            _dict['tracedata'] = self.tracedata.to_dict()
        # override the default output from pydantic by calling `to_dict()` of statistics
        if self.statistics:
            _dict['statistics'] = self.statistics.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AuditAction:
        """Create an instance of AuditAction from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AuditAction.parse_obj(obj)

        _obj = AuditAction.parse_obj({
            "username": obj.get("username"),
            "company_key": obj.get("company_key"),
            "tracedata": Tracedata.from_dict(obj.get("tracedata")) if obj.get("tracedata") is not None else None,
            "method_group": obj.get("method_group"),
            "statistics": AuditActionStatistics.from_dict(obj.get("statistics")) if obj.get("statistics") is not None else None
        })
        return _obj


