# coding: utf-8

"""
    VRt.Account [AC]

    # Description  Veeroute Account Panel.  ## Entity relationship diagram  ![erd](../uml/account.svg) 

    The version of the OpenAPI document: 6.19.2236
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, field_validator

class AuditActionStatistics(BaseModel):
    """
    Detail user action statistics.   # noqa: E501
    """
    points_count: Optional[Annotated[int, Field(le=10000000, strict=True, ge=0)]] = Field(default=0, description="Non-unique points per request.")
    duration: Optional[Annotated[str, Field(min_length=3, strict=True, max_length=16)]] = Field(default='PT0S', description="Time duration according to [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). ")
    __properties = ["points_count", "duration"]

    @validator('duration')
    def duration_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$", value):
            raise ValueError(r"must validate the regular expression /^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$/")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AuditActionStatistics:
        """Create an instance of AuditActionStatistics from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AuditActionStatistics:
        """Create an instance of AuditActionStatistics from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AuditActionStatistics.parse_obj(obj)

        _obj = AuditActionStatistics.parse_obj({
            "points_count": obj.get("points_count") if obj.get("points_count") is not None else 0,
            "duration": obj.get("duration") if obj.get("duration") is not None else 'PT0S'
        })
        return _obj


