# coding: utf-8

"""
    VRt.Account [AC]

    # Description  Veeroute Account Panel.  ## Entity relationship diagram  ![erd](../uml/account.svg) 

    The version of the OpenAPI document: 6.19.2236
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import date
from typing import Any, ClassVar, Dict, List
from pydantic import BaseModel
from vrt_lss_account.models.service_statistics import ServiceStatistics

class DateStatistics(BaseModel):
    """
    Statistics for the specific date.  # noqa: E501
    """
    var_date: date = Field(description="Date in the YYYY-MM-DD format.", alias="date")
    services: Annotated[List[ServiceStatistics], Field(min_length=0)] = Field(description="Statistics list for each service on the specified date.")
    __properties = ["date", "services"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> DateStatistics:
        """Create an instance of DateStatistics from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in services (list)
        _items = []
        if self.services:
            for _item in self.services:
                if _item:
                    _items.append(_item.to_dict())
            _dict['services'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> DateStatistics:
        """Create an instance of DateStatistics from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return DateStatistics.parse_obj(obj)

        _obj = DateStatistics.parse_obj({
            "var_date": obj.get("date"),
            "services": [ServiceStatistics.from_dict(_item) for _item in obj.get("services")] if obj.get("services") is not None else None
        })
        return _obj


