# coding: utf-8

"""
    VRt.Account [AC]

    # Description  Veeroute Account Panel.  ## Entity relationship diagram  ![erd](../uml/account.svg) 

    The version of the OpenAPI document: 6.19.2236
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List
from pydantic import BaseModel
from vrt_lss_account.models.method_quota import MethodQuota
from vrt_lss_account.models.service_name import ServiceName

class ServiceQuota(BaseModel):
    """
    Service quota.  # noqa: E501
    """
    service: ServiceName
    methods: Annotated[List[MethodQuota], Field(min_length=1, max_length=100)] = Field(description="List of quotas for a group of methods.")
    __properties = ["service", "methods"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ServiceQuota:
        """Create an instance of ServiceQuota from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in methods (list)
        _items = []
        if self.methods:
            for _item in self.methods:
                if _item:
                    _items.append(_item.to_dict())
            _dict['methods'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ServiceQuota:
        """Create an instance of ServiceQuota from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ServiceQuota.parse_obj(obj)

        _obj = ServiceQuota.parse_obj({
            "service": obj.get("service"),
            "methods": [MethodQuota.from_dict(_item) for _item in obj.get("methods")] if obj.get("methods") is not None else None
        })
        return _obj


