# coding: utf-8

"""
    VRt.Account [AC]

    # Description  Veeroute Account Panel.  ## Entity relationship diagram  ![erd](../uml/account.svg) 

    The version of the OpenAPI document: 6.19.2236
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, field_validator

class TokenRequest(BaseModel):
    """
    Token obtaining data.  # noqa: E501
    """
    username: Annotated[str, Field(min_length=2, strict=True, max_length=256)] = Field(description="Login, unique identifier.")
    password: Annotated[str, Field(min_length=1, strict=True, max_length=1000)] = Field(description="Password.")
    ttl_seconds: Optional[Annotated[int, Field(le=31556926, strict=True, ge=60)]] = Field(default=86400, description="Token validity time, in seconds.")
    __properties = ["username", "password", "ttl_seconds"]

    @validator('username')
    def username_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"\w+", value):
            raise ValueError(r"must validate the regular expression /\w+/")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TokenRequest:
        """Create an instance of TokenRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TokenRequest:
        """Create an instance of TokenRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TokenRequest.parse_obj(obj)

        _obj = TokenRequest.parse_obj({
            "username": obj.get("username"),
            "password": obj.get("password"),
            "ttl_seconds": obj.get("ttl_seconds") if obj.get("ttl_seconds") is not None else 86400
        })
        return _obj


