# Adaptive Stratification

This package provides an implementation of the adaptive stratification sampling method to estimate quantities of interest of the form Q = E(f(Y)), where the random vector Y follows a d-dimensional uniform distribution on the unit-cube and f is a given function.

## Example: Using the Sampler

```python
# Import the module containing the sampling routines
from stratification import AdaptiveStratification

# Create a sampler for function func
sampler = AdaptiveStratification(func, d, N_max, N_new_per_stratum, alpha, type='hyperrect')

# Solve (return a tuple)
result = sampler.solve()
```
Input arguments:

* `func`: implementation of given function of interest that defines the quantity of interest. It needs to be callable, accepting one m-times-n-dimensional numpy array as input and returns a m-dimensional numpy array;
* `d`: dimension of the stochastic domain;
* `N_max`: number of total samples to be used;
* `N_new_per_stratum`: targeted average number of samples per stratum, controlling the adaptation;
* `alpha`: number between zero and one, defining the hybrid allocation rule;
* `type`: type of tessellation procedure, i.e., via hyper-rectangles (`type='hyperrect'`) or simplices (`type='simplex'`)

## More Information

See the [Github repository](https://github.com/SKrumscheid/ADSS) for more details.
