##Happenings

####Adding an event

1. Go to "Happenings > Events"
2. Click "Add event" in the upper right
3. The "General info" block defines "What". It is the basic information about your event. Required fields are marked in bold.
    - "Submitted by" should default to you.
    - "Overline" is an optional secondary title. It will appear above your event name on the event detail page. Note: In some contexts, only the event name will be shown, so be sure your event name makes sense without the overline.
    - "Event name" is required.
    - "Pre-event info" should be the pitch to get people to come to your event.
    Do not include date or time information, as it will be captured elsewhere.
    Use this to sell your event to potential attendees.
    - The "Featured" checkbox gives the event extra prominence.
    It should only be checked if the event will have additional coverage beyond the basic info.
4. The "Dates" block defines when the event will take place
    - "Start date" is required.
    - "End date" is only needed for multi-day events, and even then only if you care to say when it's over
5. "Related events" allows you to cross-link this event with other events.
    These events should be closely related.
6. The "Venue/Location" block defines "Where". It will also be used to map your venue.
    - "Region" simply breaks the map into wide ranges so people can theoretically find events in their general area. Pick whichever selection seems most appropriate
    - "Venue" is the name of your venue.
    - "Street address", "City", "State" and "Zipcode" provide additional information on the location of your event. They're not all required, but for best results, provide all of these.
    - "Event website" allows creating a link to another site for the event, if the event has one.
    - "Phone" allows for displaying a phone number if visitors should call for more info.
6. "Ticketing" is collapsed by default. If your event has tickets, you may wish to open this block and fill it in.
    - "Offsite tickets" is a URL to where visitors can buy tickets.
    - "Ticket sales end" allows you to note when sales end, so links and information will no longer be shown.
7. The "Staff Info" block should rarely need to be opened or touched.
    - "Admin notes" are private notes for staff about the event.
    - "Approved" simply marks the event for public viewing. If unchecked, the event will no longer be shown.
    - "Slug" is used to create a unique identifier for the event and in URLs. It should be populated for you.
8. The "Images" block shows the images attached directly to the event.
	- You can also attach images to children of the event such as updates, in most cases it is better to attach them directly.
	- Events can hold an infinite number of events, but to retain visitor interest and not crash the server, you should probably try to limit to no more than 100 or so. Edit yourself and pick your best images.
	- Images can be uploaded three at a time. This helps protect the server from being overloaded. If you have more than three images, just click "Save and continue" in the lower right and additional fields will appear.
	- Another rule of thumb is that if you have more than 50 images per day, you're probably loading too many images. Edit yourself.
	- Images can (optionally) have a byline, a caption, and credit a source.
	- Images can be dragged-and-dropped to change their order. You can also set order manually via the "Order" field, but it's far easier to drag them around.
9. "Bulk event image uploads" allows you to upload a ZIP file full of images and process them all at once. Note that while this can be convenient, there are limitations:
	- Bulk uploaded images cannot be uploaded with a caption, byline or source, because there is no way to know which information goes with which image. You will have to edit those fields later if you want them.
	- Bulk uploading can be slow. It takes time to process your mega-upload.
	- To be kind to the server (and keep things from being too slow) bulk-uploaded images should be resized before uploading so that each image is no more than 1200 pixels wide or tall.
10. "Videos" allows attaching site videos to an event. It may require additional permissions to do so.
11. "Supplemental info" allows you to easily include additional information about your event or information tangentially related to the event. You can have as many supplemental info blocks as you like. When you save, additional blocks will be created.
	- "Title" is required. It will be the headline of your supplemental information.
	- "Slug" is the slugified version of the title, used for URLs. It should be filled out for you, but if it is not, take your title, all lower case, and have hypens instead of spaces. That's your slug.
	- "Text" is the body of your supplemental info.
	- "Is sidebar" notes whether the supplemental information should be a sidebar or a sub-page. If the content is long or involved, it should not be a sidebar.
	- Supplemental info blocks can contain one image.
12. "Schedules" allows you to build out a schedule for your event. They can be useful if there are particular times and places at the event people need to be, or if you just want to highlight certain things happening at the event.
	- Note that the "show time" checkbox can be useful if the schedule event doesn't happen at a particular time, or you're just trying to highlight that it's going on sometime Saturday.
	- You must give a time, even if it's not the real time, but you do not have to show the time.
15. Videos allows you to connect video directly to a story. The application will handle sizing, placement, and serving the best possible format to the web site and mobile devices.
	- Videos from YouTube and Vimeo are supported.
	- Simply put the URL the video is at, <strong>not the embed code</strong>, into the relevant field. Note: Avoid mobile Youtube URLs. They are unreliable.
	- By default, the video title and description will show on site. If this is not what you want, check "&quot;"Hide title and description"

#### Updating an event
After an event is created, you will see additional fields allowing you to add additional information during and after the event.
- "Recap" can used after the event to tell what happened.
    It will replace your pre-event info on the publicly-viewable pages.
    You don't have to include a recap, but all featured events should.
    It is the historical record of your event.
- Updates are brief bits of information that can be posted to provide highlights or retain visitor interest during an event. They do not replace a proper recap after the event.

####Adding an update
1. Go to "Happenings > Updates"
2. Click "Add update" in the upper right
	- Be sure your event is the event selected for the "Event" field.
	- Give your update a title/headline.
	- Select your name in the "Author" field, if it wasn't selected already for you.
	- Provide your update body. Again, this should be a brief highlight -- A status update. So keep it to a paragraph or two. Long updates make navigating the event much more difficult. After the event, when you have more time, you can be as verbose as you want in the event recap.
3. Updates can have one or more images.
	- In general, one should be more than enough. Again, this should be a brief update. Additional images can (and should) be attached to the image itself.
	- These images will be included in the event slideshow, but they cannot be ordered with the other event images, so you can have some unpredictable ordering. Again, whenever possible, just upload the image directly to the event.
4. Events can have many updates, or they can have none. Updates can be very helpful, but remember the larger they get, the more difficult it can be to navigate around.
