# PySNMP SMI module. Autogenerated from smidump -f python RFC1213-MIB
# by libsmi2pysnmp-0.1.3 at Thu Jul 26 10:30:50 2012,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsIntersection, ConstraintsUnion, SingleValueConstraint, ValueRangeConstraint, ValueSizeConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsIntersection", "ConstraintsUnion", "SingleValueConstraint", "ValueRangeConstraint", "ValueSizeConstraint")
( NetworkAddress, ) = mibBuilder.importSymbols("RFC1155-SMI", "NetworkAddress")
( Bits, Counter32, Gauge32, Integer32, Integer32, IpAddress, MibIdentifier, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, TimeTicks, mgmt, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Gauge32", "Integer32", "Integer32", "IpAddress", "MibIdentifier", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "TimeTicks", "mgmt")

# Types

class DisplayString(OctetString):
    pass

class PhysAddress(OctetString):
    pass


# Objects

mib_2 = MibIdentifier((1, 3, 6, 1, 2, 1)).setLabel("mib-2")
system = MibIdentifier((1, 3, 6, 1, 2, 1, 1))
sysDescr = MibScalar((1, 3, 6, 1, 2, 1, 1, 1), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysDescr.setDescription("A textual description of the base_entity.  This value\nshould include the full name and version\nidentification of the system's hardware type,\nsoftware operating-system, and networking\nsoftware.  It is mandatory that this only contain\nprintable ASCII characters.")
sysObjectID = MibScalar((1, 3, 6, 1, 2, 1, 1, 2), ObjectIdentifier()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysObjectID.setDescription("The vendor's authoritative identification of the\nnetwork management subsystem contained in the\nbase_entity.  This value is allocated within the SMI\nenterprises subtree (1.3.6.1.4.1) and provides an\neasy and unambiguous means for determining `what\nkind of box' is being managed.  For example, if\nvendor `Flintstones, Inc.' was assigned the\nsubtree 1.3.6.1.4.1.4242, it could assign the\nidentifier 1.3.6.1.4.1.4242.1.1 to its `Fred\nRouter'.")
sysUpTime = MibScalar((1, 3, 6, 1, 2, 1, 1, 3), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysUpTime.setDescription("The time (in hundredths of a second) since the\nnetwork management portion of the system was last\nre-initialized.")
sysContact = MibScalar((1, 3, 6, 1, 2, 1, 1, 4), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 255))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sysContact.setDescription("The textual identification of the contact person\nfor this managed node, together with information\non how to contact this person.")
sysName = MibScalar((1, 3, 6, 1, 2, 1, 1, 5), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 255))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sysName.setDescription("An administratively-assigned name for this\nmanaged node.  By convention, this is the node's\nfully-qualified domain name.")
sysLocation = MibScalar((1, 3, 6, 1, 2, 1, 1, 6), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 255))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sysLocation.setDescription("The physical location of this node (e.g.,\n`telephone closet, 3rd floor').")
sysServices = MibScalar((1, 3, 6, 1, 2, 1, 1, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 127))).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysServices.setDescription("A value which indicates the set of services that\nthis base_entity primarily offers.\n\nThe value is a sum.  This sum initially takes the\nvalue zero, Then, for each layer, L, in the range\n1 through 7, that this node performs transactions\nfor, 2 raised to (L - 1) is added to the sum.  For\nexample, a node which performs primarily routing\nfunctions would have a value of 4 (2^(3-1)).  In\ncontrast, a node which is a host offering\napplication services would have a value of 72\n(2^(4-1) + 2^(7-1)).  Note that in the context of\nthe Internet suite of protocols, values should be\ncalculated accordingly:\n\n     layer  functionality\n         1  physical (e.g., repeaters)\n         2  datalink/subnetwork (e.g., bridges)\n         3  internet (e.g., IP gateways)\n         4  end-to-end  (e.g., IP hosts)\n         7  applications (e.g., mail relays)\n\nFor systems including OSI protocols, layers 5 and\n6 may also be counted.")
interfaces = MibIdentifier((1, 3, 6, 1, 2, 1, 2))
ifNumber = MibScalar((1, 3, 6, 1, 2, 1, 2, 1), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifNumber.setDescription("The number of network interfaces (regardless of\ntheir current state) present on this system.")
ifTable = MibTable((1, 3, 6, 1, 2, 1, 2, 2))
if mibBuilder.loadTexts: ifTable.setDescription("A list of interface entries.  The number of\nentries is given by the value of ifNumber.")
ifEntry = MibTableRow((1, 3, 6, 1, 2, 1, 2, 2, 1)).setIndexNames((0, "RFC1213-MIB", "ifIndex"))
if mibBuilder.loadTexts: ifEntry.setDescription("An interface entry containing objects at the\nsubnetwork layer and below for a particular\ninterface.")
ifIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 1), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifIndex.setDescription("A unique value for each interface.  Its value\nranges between 1 and the value of ifNumber.  The\nvalue for each interface must remain constant at\nleast from one re-initialization of the base_entity's\nnetwork management system to the next re-\ninitialization.")
ifDescr = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 2), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifDescr.setDescription("A textual string containing information about the\ninterface.  This string should include the name of\nthe manufacturer, the product name and the version\nof the hardware interface.")
ifType = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 3), Integer().subtype(subtypeSpec=SingleValueConstraint(30,22,10,32,14,24,5,20,6,23,4,28,12,18,19,15,17,26,21,29,13,11,25,9,7,3,27,1,2,8,31,16,)).subtype(namedValues=NamedValues(("other", 1), ("iso88026-man", 10), ("starLan", 11), ("proteon-10Mbit", 12), ("proteon-80Mbit", 13), ("hyperchannel", 14), ("fddi", 15), ("lapb", 16), ("sdlc", 17), ("ds1", 18), ("e1", 19), ("regular1822", 2), ("basicISDN", 20), ("primaryISDN", 21), ("propPointToPointSerial", 22), ("ppp", 23), ("softwareLoopback", 24), ("eon", 25), ("ethernet-3Mbit", 26), ("nsip", 27), ("slip", 28), ("ultra", 29), ("hdh1822", 3), ("ds3", 30), ("sip", 31), ("frame-relay", 32), ("ddn-x25", 4), ("rfc877-x25", 5), ("ethernet-csmacd", 6), ("iso88023-csmacd", 7), ("iso88024-tokenBus", 8), ("iso88025-tokenRing", 9), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifType.setDescription("The type of interface, distinguished according to\nthe physical/link protocol(s) immediately `below'\nthe network layer in the protocol stack.")
ifMtu = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 4), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifMtu.setDescription("The size of the largest datagram which can be\nsent/received on the interface, specified in\noctets.  For interfaces that are used for\ntransmitting network datagrams, this is the size\nof the largest network datagram that can be sent\non the interface.")
ifSpeed = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 5), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifSpeed.setDescription("An estimate of the interface's current bandwidth\nin bits per second.  For interfaces which do not\nvary in bandwidth or for those where no accurate\nestimation can be made, this object should contain\nthe nominal bandwidth.")
ifPhysAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 6), PhysAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifPhysAddress.setDescription("The interface's address at the protocol layer\nimmediately `below' the network layer in the\nprotocol stack.  For interfaces which do not have\n\nsuch an address (e.g., a serial line), this object\nshould contain an octet string of zero length.")
ifAdminStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 7), Integer().subtype(subtypeSpec=SingleValueConstraint(2,3,1,)).subtype(namedValues=NamedValues(("up", 1), ("down", 2), ("testing", 3), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ifAdminStatus.setDescription("The desired state of the interface.  The\ntesting(3) state indicates that no operational\npackets can be passed.")
ifOperStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 8), Integer().subtype(subtypeSpec=SingleValueConstraint(2,3,1,)).subtype(namedValues=NamedValues(("up", 1), ("down", 2), ("testing", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifOperStatus.setDescription("The current operational state of the interface.\nThe testing(3) state indicates that no operational\npackets can be passed.")
ifLastChange = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 9), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifLastChange.setDescription("The value of sysUpTime at the time the interface\nentered its current operational state.  If the\ncurrent state was entered prior to the last re-\ninitialization of the local network management\nsubsystem, then this object contains a zero\nvalue.")
ifInOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifInOctets.setDescription("The total number of octets received on the\ninterface, including framing characters.")
ifInUcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifInUcastPkts.setDescription("The number of subnetwork-unicast packets\ndelivered to a higher-layer protocol.")
ifInNUcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifInNUcastPkts.setDescription("The number of non-unicast (i.e., subnetwork-\nbroadcast or subnetwork-multicast) packets\ndelivered to a higher-layer protocol.")
ifInDiscards = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifInDiscards.setDescription("The number of inbound packets which were chosen\nto be discarded even though no errors had been\ndetected to prevent their being deliverable to a\nhigher-layer protocol.  One possible reason for\ndiscarding such a packet could be to free up\nbuffer space.")
ifInErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifInErrors.setDescription("The number of inbound packets that contained\nerrors preventing them from being deliverable to a\nhigher-layer protocol.")
ifInUnknownProtos = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifInUnknownProtos.setDescription("The number of packets received via the interface\nwhich were discarded because of an unknown or\nunsupported protocol.")
ifOutOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifOutOctets.setDescription("The total number of octets transmitted out of the\ninterface, including framing characters.")
ifOutUcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifOutUcastPkts.setDescription("The total number of packets that higher-level\nprotocols requested be transmitted to a\nsubnetwork-unicast address, including those that\nwere discarded or not sent.")
ifOutNUcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifOutNUcastPkts.setDescription("The total number of packets that higher-level\nprotocols requested be transmitted to a non-\nunicast (i.e., a subnetwork-broadcast or\nsubnetwork-multicast) address, including those\nthat were discarded or not sent.")
ifOutDiscards = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 19), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifOutDiscards.setDescription("The number of outbound packets which were chosen\n\nto be discarded even though no errors had been\ndetected to prevent their being transmitted.  One\npossible reason for discarding such a packet could\nbe to free up buffer space.")
ifOutErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 20), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifOutErrors.setDescription("The number of outbound packets that could not be\ntransmitted because of errors.")
ifOutQLen = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 21), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifOutQLen.setDescription("The length of the output packet queue (in\npackets).")
ifSpecific = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 22), ObjectIdentifier()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifSpecific.setDescription("A reference to MIB definitions specific to the\nparticular media being used to realize the\ninterface.  For example, if the interface is\nrealized by an ethernet, then the value of this\nobject refers to a document defining objects\nspecific to ethernet.  If this information is not\npresent, its value should be set to the OBJECT\nIDENTIFIER { 0 0 }, which is a syntatically valid\nobject identifier, and any conformant\nimplementation of ASN.1 and BER must be able to\ngenerate and recognize this value.")
at = MibIdentifier((1, 3, 6, 1, 2, 1, 3))
atTable = MibTable((1, 3, 6, 1, 2, 1, 3, 1))
if mibBuilder.loadTexts: atTable.setDescription("The Address Translation tables contain the\nNetworkAddress to `physical' address equivalences.\nSome interfaces do not use translation tables for\ndetermining address equivalences (e.g., DDN-X.25\nhas an algorithmic method); if all interfaces are\nof this type, then the Address Translation table\nis empty, i.e., has zero entries.")
atEntry = MibTableRow((1, 3, 6, 1, 2, 1, 3, 1, 1)).setIndexNames((0, "RFC1213-MIB", "atIfIndex"), (0, "RFC1213-MIB", "atNetAddressPlaceholder"), (0, "RFC1213-MIB", "atNetAddress"))
if mibBuilder.loadTexts: atEntry.setDescription("Each entry contains one NetworkAddress to\n`physical' address equivalence.")
atIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 3, 1, 1, 1), Integer32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: atIfIndex.setDescription("The interface on which this entry's equivalence\nis effective.  The interface identified by a\nparticular value of this index is the same\ninterface as identified by the same value of\nifIndex.")
atPhysAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 3, 1, 1, 2), PhysAddress()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: atPhysAddress.setDescription("The media-dependent `physical' address.\n\nSetting this object to a null string (one of zero\nlength) has the effect of invaliding the\ncorresponding entry in the atTable object.  That\nis, it effectively dissasociates the interface\nidentified with said entry from the mapping\nidentified with said entry.  It is an\nimplementation-specific matter as to whether the\nagent removes an invalidated entry from the table.\nAccordingly, management stations must be prepared\nto receive tabular information from agents that\ncorresponds to entries not currently in use.\nProper interpretation of such entries requires\nexamination of the relevant atPhysAddress object.")
atNetAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 3, 1, 1, 3), IpAddress()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: atNetAddress.setDescription("The NetworkAddress (e.g., the IP address)\ncorresponding to the media-dependent `physical'\naddress.")
# Pre-index placeholder.Should be done by smidump but it is not for some reason
# See RFC2576 2.1.1.10 for details
atNetAddressPlaceholder = MibTableColumn((1, 3, 6, 1, 2, 1, 3, 1, 1, 9993), Integer(1)).setMaxAccess("not-accessible")
ip = MibIdentifier((1, 3, 6, 1, 2, 1, 4))
ipForwarding = MibScalar((1, 3, 6, 1, 2, 1, 4, 1), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,)).subtype(namedValues=NamedValues(("forwarding", 1), ("not-forwarding", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipForwarding.setDescription("The indication of whether this base_entity is acting\nas an IP gateway in respect to the forwarding of\ndatagrams received by, but not addressed to, this\nbase_entity.  IP gateways forward datagrams.  IP hosts\ndo not (except those source-routed via the host).\n\nNote that for some managed nodes, this object may\ntake on only a subset of the values possible.\nAccordingly, it is appropriate for an agent to\nreturn a `badValue' response if a management\nstation attempts to change this object to an\ninappropriate value.")
ipDefaultTTL = MibScalar((1, 3, 6, 1, 2, 1, 4, 2), Integer32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipDefaultTTL.setDescription("The default value inserted into the Time-To-Live\nfield of the IP header of datagrams originated at\nthis base_entity, whenever a TTL value is not supplied\nby the transport layer protocol.")
ipInReceives = MibScalar((1, 3, 6, 1, 2, 1, 4, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipInReceives.setDescription("The total number of input datagrams received from\ninterfaces, including those received in error.")
ipInHdrErrors = MibScalar((1, 3, 6, 1, 2, 1, 4, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipInHdrErrors.setDescription("The number of input datagrams discarded due to\nerrors in their IP headers, including bad\nchecksums, version number mismatch, other format\nerrors, time-to-live exceeded, errors discovered\nin processing their IP options, etc.")
ipInAddrErrors = MibScalar((1, 3, 6, 1, 2, 1, 4, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipInAddrErrors.setDescription("The number of input datagrams discarded because\nthe IP address in their IP header's destination\nfield was not a valid address to be received at\nthis base_entity.  This count includes invalid\naddresses (e.g., 0.0.0.0) and addresses of\nunsupported Classes (e.g., Class E).  For entities\nwhich are not IP Gateways and therefore do not\nforward datagrams, this counter includes datagrams\ndiscarded because the destination address was not\na local address.")
ipForwDatagrams = MibScalar((1, 3, 6, 1, 2, 1, 4, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipForwDatagrams.setDescription("The number of input datagrams for which this\nbase_entity was not their final IP destination, as a\nresult of which an attempt was made to find a\nroute to forward them to that final destination.\nIn entities which do not act as IP Gateways, this\ncounter will include only those packets which were\nSource-Routed via this base_entity, and the Source-\nRoute option processing was successful.")
ipInUnknownProtos = MibScalar((1, 3, 6, 1, 2, 1, 4, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipInUnknownProtos.setDescription("The number of locally-addressed datagrams\nreceived successfully but discarded because of an\nunknown or unsupported protocol.")
ipInDiscards = MibScalar((1, 3, 6, 1, 2, 1, 4, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipInDiscards.setDescription("The number of input IP datagrams for which no\nproblems were encountered to prevent their\ncontinued processing, but which were discarded\n(e.g., for lack of buffer space).  Note that this\ncounter does not include any datagrams discarded\nwhile awaiting re-assembly.")
ipInDelivers = MibScalar((1, 3, 6, 1, 2, 1, 4, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipInDelivers.setDescription("The total number of input datagrams successfully\ndelivered to IP user-protocols (including ICMP).")
ipOutRequests = MibScalar((1, 3, 6, 1, 2, 1, 4, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipOutRequests.setDescription("The total number of IP datagrams which local IP\nuser-protocols (including ICMP) supplied to IP in\nrequests for transmission.  Note that this counter\ndoes not include any datagrams counted in\nipForwDatagrams.")
ipOutDiscards = MibScalar((1, 3, 6, 1, 2, 1, 4, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipOutDiscards.setDescription("The number of output IP datagrams for which no\n\nproblem was encountered to prevent their\ntransmission to their destination, but which were\ndiscarded (e.g., for lack of buffer space).  Note\nthat this counter would include datagrams counted\nin ipForwDatagrams if any such packets met this\n(discretionary) discard criterion.")
ipOutNoRoutes = MibScalar((1, 3, 6, 1, 2, 1, 4, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipOutNoRoutes.setDescription("The number of IP datagrams discarded because no\nroute could be found to transmit them to their\ndestination.  Note that this counter includes any\npackets counted in ipForwDatagrams which meet this\n`no-route' criterion.  Note that this includes any\ndatagarms which a host cannot route because all of\nits default gateways are down.")
ipReasmTimeout = MibScalar((1, 3, 6, 1, 2, 1, 4, 13), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipReasmTimeout.setDescription("The maximum number of seconds which received\nfragments are held while they are awaiting\nreassembly at this base_entity.")
ipReasmReqds = MibScalar((1, 3, 6, 1, 2, 1, 4, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipReasmReqds.setDescription("The number of IP fragments received which needed\nto be reassembled at this base_entity.")
ipReasmOKs = MibScalar((1, 3, 6, 1, 2, 1, 4, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipReasmOKs.setDescription("The number of IP datagrams successfully re-\nassembled.")
ipReasmFails = MibScalar((1, 3, 6, 1, 2, 1, 4, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipReasmFails.setDescription("The number of failures detected by the IP re-\nassembly algorithm (for whatever reason: timed\nout, errors, etc).  Note that this is not\nnecessarily a count of discarded IP fragments\nsince some algorithms (notably the algorithm in\nRFC 815) can lose track of the number of fragments\nby combining them as they are received.")
ipFragOKs = MibScalar((1, 3, 6, 1, 2, 1, 4, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipFragOKs.setDescription("The number of IP datagrams that have been\nsuccessfully fragmented at this base_entity.")
ipFragFails = MibScalar((1, 3, 6, 1, 2, 1, 4, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipFragFails.setDescription("The number of IP datagrams that have been\ndiscarded because they needed to be fragmented at\nthis base_entity but could not be, e.g., because their\nDon't Fragment flag was set.")
ipFragCreates = MibScalar((1, 3, 6, 1, 2, 1, 4, 19), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipFragCreates.setDescription("The number of IP datagram fragments that have\nbeen generated as a result of fragmentation at\nthis base_entity.")
ipAddrTable = MibTable((1, 3, 6, 1, 2, 1, 4, 20))
if mibBuilder.loadTexts: ipAddrTable.setDescription("The table of addressing information relevant to\nthis base_entity's IP addresses.")
ipAddrEntry = MibTableRow((1, 3, 6, 1, 2, 1, 4, 20, 1)).setIndexNames((0, "RFC1213-MIB", "ipAdEntAddr"))
if mibBuilder.loadTexts: ipAddrEntry.setDescription("The addressing information for one of this\nbase_entity's IP addresses.")
ipAdEntAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 20, 1, 1), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipAdEntAddr.setDescription("The IP address to which this entry's addressing\ninformation pertains.")
ipAdEntIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 20, 1, 2), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipAdEntIfIndex.setDescription("The index value which uniquely identifies the\ninterface to which this entry is applicable.  The\ninterface identified by a particular value of this\nindex is the same interface as identified by the\nsame value of ifIndex.")
ipAdEntNetMask = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 20, 1, 3), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipAdEntNetMask.setDescription("The subnet mask associated with the IP address of\nthis entry.  The value of the mask is an IP\naddress with all the network bits set to 1 and all\nthe hosts bits set to 0.")
ipAdEntBcastAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 20, 1, 4), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipAdEntBcastAddr.setDescription("The value of the least-significant bit in the IP\nbroadcast address used for sending datagrams on\nthe (logical) interface associated with the IP\naddress of this entry.  For example, when the\nInternet standard all-ones broadcast address is\nused, the value will be 1.  This value applies to\nboth the subnet and network broadcasts addresses\nused by the base_entity on this (logical) interface.")
ipAdEntReasmMaxSize = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 20, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipAdEntReasmMaxSize.setDescription("The size of the largest IP datagram which this\nbase_entity can re-assemble from incoming IP fragmented\ndatagrams received on this interface.")
ipRouteTable = MibTable((1, 3, 6, 1, 2, 1, 4, 21))
if mibBuilder.loadTexts: ipRouteTable.setDescription("This base_entity's IP Routing table.")
ipRouteEntry = MibTableRow((1, 3, 6, 1, 2, 1, 4, 21, 1)).setIndexNames((0, "RFC1213-MIB", "ipRouteDest"))
if mibBuilder.loadTexts: ipRouteEntry.setDescription("A route to a particular destination.")
ipRouteDest = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 21, 1, 1), IpAddress()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipRouteDest.setDescription("The destination IP address of this route.  An\nentry with a value of 0.0.0.0 is considered a\ndefault route.  Multiple routes to a single\ndestination can appear in the table, but access to\nsuch multiple entries is dependent on the table-\naccess mechanisms defined by the network\nmanagement protocol in use.")
ipRouteIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 21, 1, 2), Integer32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipRouteIfIndex.setDescription("The index value which uniquely identifies the\nlocal interface through which the next hop of this\nroute should be reached.  The interface identified\nby a particular value of this index is the same\ninterface as identified by the same value of\nifIndex.")
ipRouteMetric1 = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 21, 1, 3), Integer32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipRouteMetric1.setDescription("The primary routing metric for this route.  The\nsemantics of this metric are determined by the\nrouting-protocol specified in the route's\nipRouteProto value.  If this metric is not used,\nits value should be set to -1.")
ipRouteMetric2 = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 21, 1, 4), Integer32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipRouteMetric2.setDescription("An alternate routing metric for this route.  The\nsemantics of this metric are determined by the\nrouting-protocol specified in the route's\nipRouteProto value.  If this metric is not used,\nits value should be set to -1.")
ipRouteMetric3 = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 21, 1, 5), Integer32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipRouteMetric3.setDescription("An alternate routing metric for this route.  The\nsemantics of this metric are determined by the\nrouting-protocol specified in the route's\nipRouteProto value.  If this metric is not used,\nits value should be set to -1.")
ipRouteMetric4 = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 21, 1, 6), Integer32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipRouteMetric4.setDescription("An alternate routing metric for this route.  The\nsemantics of this metric are determined by the\nrouting-protocol specified in the route's\nipRouteProto value.  If this metric is not used,\nits value should be set to -1.")
ipRouteNextHop = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 21, 1, 7), IpAddress()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipRouteNextHop.setDescription("The IP address of the next hop of this route.\n(In the case of a route bound to an interface\nwhich is realized via a broadcast media, the value\nof this field is the agent's IP address on that\ninterface.)")
ipRouteType = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 21, 1, 8), Integer().subtype(subtypeSpec=SingleValueConstraint(4,1,3,2,)).subtype(namedValues=NamedValues(("other", 1), ("invalid", 2), ("direct", 3), ("indirect", 4), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipRouteType.setDescription("The type of route.  Note that the values\ndirect(3) and indirect(4) refer to the notion of\ndirect and indirect routing in the IP\narchitecture.\n\nSetting this object to the value invalid(2) has\nthe effect of invalidating the corresponding entry\nin the ipRouteTable object.  That is, it\neffectively dissasociates the destination\nidentified with said entry from the route\nidentified with said entry.  It is an\nimplementation-specific matter as to whether the\nagent removes an invalidated entry from the table.\nAccordingly, management stations must be prepared\nto receive tabular information from agents that\ncorresponds to entries not currently in use.\nProper interpretation of such entries requires\nexamination of the relevant ipRouteType object.")
ipRouteProto = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 21, 1, 9), Integer().subtype(subtypeSpec=SingleValueConstraint(12,6,8,9,4,14,3,13,5,10,11,1,2,7,)).subtype(namedValues=NamedValues(("other", 1), ("es-is", 10), ("ciscoIgrp", 11), ("bbnSpfIgp", 12), ("ospf", 13), ("bgp", 14), ("local", 2), ("netmgmt", 3), ("icmp", 4), ("egp", 5), ("ggp", 6), ("hello", 7), ("rip", 8), ("is-is", 9), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipRouteProto.setDescription("The routing mechanism via which this route was\nlearned.  Inclusion of values for gateway routing\nprotocols is not intended to imply that hosts\nshould support those protocols.")
ipRouteAge = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 21, 1, 10), Integer32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipRouteAge.setDescription("The number of seconds since this route was last\nupdated or otherwise determined to be correct.\nNote that no semantics of `too old' can be implied\nexcept through knowledge of the routing protocol\nby which the route was learned.")
ipRouteMask = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 21, 1, 11), IpAddress()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipRouteMask.setDescription("Indicate the mask to be logical-ANDed with the\ndestination address before being compared to the\nvalue in the ipRouteDest field.  For those systems\nthat do not support arbitrary subnet masks, an\nagent constructs the value of the ipRouteMask by\ndetermining whether the value of the correspondent\nipRouteDest field belong to a class-A, B, or C\nnetwork, and then using one of:\n\n     mask           network\n     255.0.0.0      class-A\n     255.255.0.0    class-B\n     255.255.255.0  class-C\n\nIf the value of the ipRouteDest is 0.0.0.0 (a\ndefault route), then the mask value is also\n0.0.0.0.  It should be noted that all IP routing\nsubsystems implicitly use this mechanism.")
ipRouteMetric5 = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 21, 1, 12), Integer32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipRouteMetric5.setDescription("An alternate routing metric for this route.  The\nsemantics of this metric are determined by the\nrouting-protocol specified in the route's\nipRouteProto value.  If this metric is not used,\nits value should be set to -1.")
ipRouteInfo = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 21, 1, 13), ObjectIdentifier()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipRouteInfo.setDescription("A reference to MIB definitions specific to the\nparticular routing protocol which is responsible\nfor this route, as determined by the value\nspecified in the route's ipRouteProto value.  If\nthis information is not present, its value should\nbe set to the OBJECT IDENTIFIER { 0 0 }, which is\na syntatically valid object identifier, and any\nconformant implementation of ASN.1 and BER must be\nable to generate and recognize this value.")
ipNetToMediaTable = MibTable((1, 3, 6, 1, 2, 1, 4, 22))
if mibBuilder.loadTexts: ipNetToMediaTable.setDescription("The IP Address Translation table used for mapping\nfrom IP addresses to physical addresses.")
ipNetToMediaEntry = MibTableRow((1, 3, 6, 1, 2, 1, 4, 22, 1)).setIndexNames((0, "RFC1213-MIB", "ipNetToMediaIfIndex"), (0, "RFC1213-MIB", "ipNetToMediaNetAddress"))
if mibBuilder.loadTexts: ipNetToMediaEntry.setDescription("Each entry contains one IpAddress to `physical'\naddress equivalence.")
ipNetToMediaIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 22, 1, 1), Integer32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipNetToMediaIfIndex.setDescription("The interface on which this entry's equivalence\nis effective.  The interface identified by a\nparticular value of this index is the same\ninterface as identified by the same value of\nifIndex.")
ipNetToMediaPhysAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 22, 1, 2), PhysAddress()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipNetToMediaPhysAddress.setDescription("The media-dependent `physical' address.")
ipNetToMediaNetAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 22, 1, 3), IpAddress()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipNetToMediaNetAddress.setDescription("The IpAddress corresponding to the media-\ndependent `physical' address.")
ipNetToMediaType = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 22, 1, 4), Integer().subtype(subtypeSpec=SingleValueConstraint(4,1,3,2,)).subtype(namedValues=NamedValues(("other", 1), ("invalid", 2), ("dynamic", 3), ("static", 4), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipNetToMediaType.setDescription("The type of mapping.\n\nSetting this object to the value invalid(2) has\nthe effect of invalidating the corresponding entry\nin the ipNetToMediaTable.  That is, it effectively\ndissasociates the interface identified with said\nentry from the mapping identified with said entry.\nIt is an implementation-specific matter as to\nwhether the agent removes an invalidated entry\nfrom the table.  Accordingly, management stations\nmust be prepared to receive tabular information\nfrom agents that corresponds to entries not\ncurrently in use.  Proper interpretation of such\nentries requires examination of the relevant\nipNetToMediaType object.")
ipRoutingDiscards = MibScalar((1, 3, 6, 1, 2, 1, 4, 23), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipRoutingDiscards.setDescription("The number of routing entries which were chosen\nto be discarded even though they are valid.  One\npossible reason for discarding such an entry could\nbe to free-up buffer space for other routing\n\nentries.")
icmp = MibIdentifier((1, 3, 6, 1, 2, 1, 5))
icmpInMsgs = MibScalar((1, 3, 6, 1, 2, 1, 5, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpInMsgs.setDescription("The total number of ICMP messages which the\nbase_entity received.  Note that this counter includes\nall those counted by icmpInErrors.")
icmpInErrors = MibScalar((1, 3, 6, 1, 2, 1, 5, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpInErrors.setDescription("The number of ICMP messages which the base_entity\nreceived but determined as having ICMP-specific\nerrors (bad ICMP checksums, bad length, etc.).")
icmpInDestUnreachs = MibScalar((1, 3, 6, 1, 2, 1, 5, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpInDestUnreachs.setDescription("The number of ICMP Destination Unreachable\nmessages received.")
icmpInTimeExcds = MibScalar((1, 3, 6, 1, 2, 1, 5, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpInTimeExcds.setDescription("The number of ICMP Time Exceeded messages\nreceived.")
icmpInParmProbs = MibScalar((1, 3, 6, 1, 2, 1, 5, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpInParmProbs.setDescription("The number of ICMP Parameter Problem messages\nreceived.")
icmpInSrcQuenchs = MibScalar((1, 3, 6, 1, 2, 1, 5, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpInSrcQuenchs.setDescription("The number of ICMP Source Quench messages\nreceived.")
icmpInRedirects = MibScalar((1, 3, 6, 1, 2, 1, 5, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpInRedirects.setDescription("The number of ICMP Redirect messages received.")
icmpInEchos = MibScalar((1, 3, 6, 1, 2, 1, 5, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpInEchos.setDescription("The number of ICMP Echo (request) messages\nreceived.")
icmpInEchoReps = MibScalar((1, 3, 6, 1, 2, 1, 5, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpInEchoReps.setDescription("The number of ICMP Echo Reply messages received.")
icmpInTimestamps = MibScalar((1, 3, 6, 1, 2, 1, 5, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpInTimestamps.setDescription("The number of ICMP Timestamp (request) messages\nreceived.")
icmpInTimestampReps = MibScalar((1, 3, 6, 1, 2, 1, 5, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpInTimestampReps.setDescription("The number of ICMP Timestamp Reply messages\nreceived.")
icmpInAddrMasks = MibScalar((1, 3, 6, 1, 2, 1, 5, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpInAddrMasks.setDescription("The number of ICMP Address Mask Request messages\nreceived.")
icmpInAddrMaskReps = MibScalar((1, 3, 6, 1, 2, 1, 5, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpInAddrMaskReps.setDescription("The number of ICMP Address Mask Reply messages\nreceived.")
icmpOutMsgs = MibScalar((1, 3, 6, 1, 2, 1, 5, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpOutMsgs.setDescription("The total number of ICMP messages which this\nbase_entity attempted to send.  Note that this counter\nincludes all those counted by icmpOutErrors.")
icmpOutErrors = MibScalar((1, 3, 6, 1, 2, 1, 5, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpOutErrors.setDescription("The number of ICMP messages which this base_entity did\nnot send due to problems discovered within ICMP\n\nsuch as a lack of buffers.  This value should not\ninclude errors discovered outside the ICMP layer\nsuch as the inability of IP to route the resultant\ndatagram.  In some implementations there may be no\ntypes of error which contribute to this counter's\nvalue.")
icmpOutDestUnreachs = MibScalar((1, 3, 6, 1, 2, 1, 5, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpOutDestUnreachs.setDescription("The number of ICMP Destination Unreachable\nmessages sent.")
icmpOutTimeExcds = MibScalar((1, 3, 6, 1, 2, 1, 5, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpOutTimeExcds.setDescription("The number of ICMP Time Exceeded messages sent.")
icmpOutParmProbs = MibScalar((1, 3, 6, 1, 2, 1, 5, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpOutParmProbs.setDescription("The number of ICMP Parameter Problem messages\nsent.")
icmpOutSrcQuenchs = MibScalar((1, 3, 6, 1, 2, 1, 5, 19), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpOutSrcQuenchs.setDescription("The number of ICMP Source Quench messages sent.")
icmpOutRedirects = MibScalar((1, 3, 6, 1, 2, 1, 5, 20), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpOutRedirects.setDescription("The number of ICMP Redirect messages sent.  For a\n\nhost, this object will always be zero, since hosts\ndo not send redirects.")
icmpOutEchos = MibScalar((1, 3, 6, 1, 2, 1, 5, 21), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpOutEchos.setDescription("The number of ICMP Echo (request) messages sent.")
icmpOutEchoReps = MibScalar((1, 3, 6, 1, 2, 1, 5, 22), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpOutEchoReps.setDescription("The number of ICMP Echo Reply messages sent.")
icmpOutTimestamps = MibScalar((1, 3, 6, 1, 2, 1, 5, 23), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpOutTimestamps.setDescription("The number of ICMP Timestamp (request) messages\nsent.")
icmpOutTimestampReps = MibScalar((1, 3, 6, 1, 2, 1, 5, 24), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpOutTimestampReps.setDescription("The number of ICMP Timestamp Reply messages\nsent.")
icmpOutAddrMasks = MibScalar((1, 3, 6, 1, 2, 1, 5, 25), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpOutAddrMasks.setDescription("The number of ICMP Address Mask Request messages\nsent.")
icmpOutAddrMaskReps = MibScalar((1, 3, 6, 1, 2, 1, 5, 26), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpOutAddrMaskReps.setDescription("The number of ICMP Address Mask Reply messages\nsent.")
tcp = MibIdentifier((1, 3, 6, 1, 2, 1, 6))
tcpRtoAlgorithm = MibScalar((1, 3, 6, 1, 2, 1, 6, 1), Integer().subtype(subtypeSpec=SingleValueConstraint(4,1,2,3,)).subtype(namedValues=NamedValues(("other", 1), ("constant", 2), ("rsre", 3), ("vanj", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpRtoAlgorithm.setDescription("The algorithm used to determine the timeout value\nused for retransmitting unacknowledged octets.")
tcpRtoMin = MibScalar((1, 3, 6, 1, 2, 1, 6, 2), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpRtoMin.setDescription("The minimum value permitted by a TCP\nimplementation for the retransmission timeout,\nmeasured in milliseconds.  More refined semantics\nfor objects of this type depend upon the algorithm\nused to determine the retransmission timeout.  In\nparticular, when the timeout algorithm is rsre(3),\nan object of this type has the semantics of the\nLBOUND quantity described in RFC 793.")
tcpRtoMax = MibScalar((1, 3, 6, 1, 2, 1, 6, 3), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpRtoMax.setDescription("The maximum value permitted by a TCP\nimplementation for the retransmission timeout,\nmeasured in milliseconds.  More refined semantics\nfor objects of this type depend upon the algorithm\nused to determine the retransmission timeout.  In\nparticular, when the timeout algorithm is rsre(3),\nan object of this type has the semantics of the\nUBOUND quantity described in RFC 793.")
tcpMaxConn = MibScalar((1, 3, 6, 1, 2, 1, 6, 4), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpMaxConn.setDescription("The limit on the total number of TCP connections\nthe base_entity can support.  In entities where the\nmaximum number of connections is dynamic, this\nobject should contain the value -1.")
tcpActiveOpens = MibScalar((1, 3, 6, 1, 2, 1, 6, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpActiveOpens.setDescription("The number of times TCP connections have made a\ndirect transition to the SYN-SENT state from the\nCLOSED state.")
tcpPassiveOpens = MibScalar((1, 3, 6, 1, 2, 1, 6, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpPassiveOpens.setDescription("The number of times TCP connections have made a\ndirect transition to the SYN-RCVD state from the\nLISTEN state.")
tcpAttemptFails = MibScalar((1, 3, 6, 1, 2, 1, 6, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpAttemptFails.setDescription("The number of times TCP connections have made a\ndirect transition to the CLOSED state from either\nthe SYN-SENT state or the SYN-RCVD state, plus the\nnumber of times TCP connections have made a direct\ntransition to the LISTEN state from the SYN-RCVD\nstate.")
tcpEstabResets = MibScalar((1, 3, 6, 1, 2, 1, 6, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEstabResets.setDescription("The number of times TCP connections have made a\ndirect transition to the CLOSED state from either\nthe ESTABLISHED state or the CLOSE-WAIT state.")
tcpCurrEstab = MibScalar((1, 3, 6, 1, 2, 1, 6, 9), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpCurrEstab.setDescription("The number of TCP connections for which the\ncurrent state is either ESTABLISHED or CLOSE-\nWAIT.")
tcpInSegs = MibScalar((1, 3, 6, 1, 2, 1, 6, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpInSegs.setDescription("The total number of segments received, including\nthose received in error.  This count includes\nsegments received on currently established\nconnections.")
tcpOutSegs = MibScalar((1, 3, 6, 1, 2, 1, 6, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpOutSegs.setDescription("The total number of segments sent, including\nthose on current connections but excluding those\ncontaining only retransmitted octets.")
tcpRetransSegs = MibScalar((1, 3, 6, 1, 2, 1, 6, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpRetransSegs.setDescription("The total number of segments retransmitted - that\nis, the number of TCP segments transmitted\ncontaining one or more previously transmitted\noctets.")
tcpConnTable = MibTable((1, 3, 6, 1, 2, 1, 6, 13))
if mibBuilder.loadTexts: tcpConnTable.setDescription("A table containing TCP connection-specific\ninformation.")
tcpConnEntry = MibTableRow((1, 3, 6, 1, 2, 1, 6, 13, 1)).setIndexNames((0, "RFC1213-MIB", "tcpConnLocalAddress"), (0, "RFC1213-MIB", "tcpConnLocalPort"), (0, "RFC1213-MIB", "tcpConnRemAddress"), (0, "RFC1213-MIB", "tcpConnRemPort"))
if mibBuilder.loadTexts: tcpConnEntry.setDescription("Information about a particular current TCP\nconnection.  An object of this type is transient,\nin that it ceases to exist when (or soon after)\nthe connection makes the transition to the CLOSED\nstate.")
tcpConnState = MibTableColumn((1, 3, 6, 1, 2, 1, 6, 13, 1, 1), Integer().subtype(subtypeSpec=SingleValueConstraint(4,6,7,8,5,11,9,12,1,10,2,3,)).subtype(namedValues=NamedValues(("closed", 1), ("closing", 10), ("timeWait", 11), ("deleteTCB", 12), ("listen", 2), ("synSent", 3), ("synReceived", 4), ("established", 5), ("finWait1", 6), ("finWait2", 7), ("closeWait", 8), ("lastAck", 9), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: tcpConnState.setDescription("The state of this TCP connection.\n\nThe only value which may be set by a management\nstation is deleteTCB(12).  Accordingly, it is\nappropriate for an agent to return a `badValue'\nresponse if a management station attempts to set\nthis object to any other value.\n\nIf a management station sets this object to the\nvalue deleteTCB(12), then this has the effect of\ndeleting the TCB (as defined in RFC 793) of the\ncorresponding connection on the managed node,\nresulting in immediate termination of the\nconnection.\n\nAs an implementation-specific option, a RST\n\nsegment may be sent from the managed node to the\nother TCP endpoint (note however that RST segments\nare not sent reliably).")
tcpConnLocalAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 6, 13, 1, 2), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpConnLocalAddress.setDescription("The local IP address for this TCP connection.  In\nthe case of a connection in the listen state which\nis willing to accept connections for any IP\ninterface associated with the node, the value\n0.0.0.0 is used.")
tcpConnLocalPort = MibTableColumn((1, 3, 6, 1, 2, 1, 6, 13, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpConnLocalPort.setDescription("The local port number for this TCP connection.")
tcpConnRemAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 6, 13, 1, 4), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpConnRemAddress.setDescription("The remote IP address for this TCP connection.")
tcpConnRemPort = MibTableColumn((1, 3, 6, 1, 2, 1, 6, 13, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpConnRemPort.setDescription("The remote port number for this TCP connection.")
tcpInErrs = MibScalar((1, 3, 6, 1, 2, 1, 6, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpInErrs.setDescription("The total number of segments received in error\n(e.g., bad TCP checksums).")
tcpOutRsts = MibScalar((1, 3, 6, 1, 2, 1, 6, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpOutRsts.setDescription("The number of TCP segments sent containing the\nRST flag.")
udp = MibIdentifier((1, 3, 6, 1, 2, 1, 7))
udpInDatagrams = MibScalar((1, 3, 6, 1, 2, 1, 7, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: udpInDatagrams.setDescription("The total number of UDP datagrams delivered to\nUDP users.")
udpNoPorts = MibScalar((1, 3, 6, 1, 2, 1, 7, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: udpNoPorts.setDescription("The total number of received UDP datagrams for\nwhich there was no application at the destination\nport.")
udpInErrors = MibScalar((1, 3, 6, 1, 2, 1, 7, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: udpInErrors.setDescription("The number of received UDP datagrams that could\nnot be delivered for reasons other than the lack\nof an application at the destination port.")
udpOutDatagrams = MibScalar((1, 3, 6, 1, 2, 1, 7, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: udpOutDatagrams.setDescription("The total number of UDP datagrams sent from this\nbase_entity.")
udpTable = MibTable((1, 3, 6, 1, 2, 1, 7, 5))
if mibBuilder.loadTexts: udpTable.setDescription("A table containing UDP listener information.")
udpEntry = MibTableRow((1, 3, 6, 1, 2, 1, 7, 5, 1)).setIndexNames((0, "RFC1213-MIB", "udpLocalAddress"), (0, "RFC1213-MIB", "udpLocalPort"))
if mibBuilder.loadTexts: udpEntry.setDescription("Information about a particular current UDP\nlistener.")
udpLocalAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 7, 5, 1, 1), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: udpLocalAddress.setDescription("The local IP address for this UDP listener.  In\n\nthe case of a UDP listener which is willing to\naccept datagrams for any IP interface associated\nwith the node, the value 0.0.0.0 is used.")
udpLocalPort = MibTableColumn((1, 3, 6, 1, 2, 1, 7, 5, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: udpLocalPort.setDescription("The local port number for this UDP listener.")
egp = MibIdentifier((1, 3, 6, 1, 2, 1, 8))
egpInMsgs = MibScalar((1, 3, 6, 1, 2, 1, 8, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: egpInMsgs.setDescription("The number of EGP messages received without\nerror.")
egpInErrors = MibScalar((1, 3, 6, 1, 2, 1, 8, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: egpInErrors.setDescription("The number of EGP messages received that proved\nto be in error.")
egpOutMsgs = MibScalar((1, 3, 6, 1, 2, 1, 8, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: egpOutMsgs.setDescription("The total number of locally generated EGP\nmessages.")
egpOutErrors = MibScalar((1, 3, 6, 1, 2, 1, 8, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: egpOutErrors.setDescription("The number of locally generated EGP messages not\nsent due to resource limitations within an EGP\nbase_entity.")
egpNeighTable = MibTable((1, 3, 6, 1, 2, 1, 8, 5))
if mibBuilder.loadTexts: egpNeighTable.setDescription("The EGP neighbor table.")
egpNeighEntry = MibTableRow((1, 3, 6, 1, 2, 1, 8, 5, 1)).setIndexNames((0, "RFC1213-MIB", "egpNeighAddr"))
if mibBuilder.loadTexts: egpNeighEntry.setDescription("Information about this base_entity's relationship with\na particular EGP neighbor.")
egpNeighState = MibTableColumn((1, 3, 6, 1, 2, 1, 8, 5, 1, 1), Integer().subtype(subtypeSpec=SingleValueConstraint(4,3,1,5,2,)).subtype(namedValues=NamedValues(("idle", 1), ("acquisition", 2), ("down", 3), ("up", 4), ("cease", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: egpNeighState.setDescription("The EGP state of the local system with respect to\nthis entry's EGP neighbor.  Each EGP state is\nrepresented by a value that is one greater than\nthe numerical value associated with said state in\nRFC 904.")
egpNeighAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 8, 5, 1, 2), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: egpNeighAddr.setDescription("The IP address of this entry's EGP neighbor.")
egpNeighAs = MibTableColumn((1, 3, 6, 1, 2, 1, 8, 5, 1, 3), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: egpNeighAs.setDescription("The autonomous system of this EGP peer.  Zero\nshould be specified if the autonomous system\nnumber of the neighbor is not yet known.")
egpNeighInMsgs = MibTableColumn((1, 3, 6, 1, 2, 1, 8, 5, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: egpNeighInMsgs.setDescription("The number of EGP messages received without error\nfrom this EGP peer.")
egpNeighInErrs = MibTableColumn((1, 3, 6, 1, 2, 1, 8, 5, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: egpNeighInErrs.setDescription("The number of EGP messages received from this EGP\npeer that proved to be in error (e.g., bad EGP\nchecksum).")
egpNeighOutMsgs = MibTableColumn((1, 3, 6, 1, 2, 1, 8, 5, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: egpNeighOutMsgs.setDescription("The number of locally generated EGP messages to\nthis EGP peer.")
egpNeighOutErrs = MibTableColumn((1, 3, 6, 1, 2, 1, 8, 5, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: egpNeighOutErrs.setDescription("The number of locally generated EGP messages not\nsent to this EGP peer due to resource limitations\nwithin an EGP base_entity.")
egpNeighInErrMsgs = MibTableColumn((1, 3, 6, 1, 2, 1, 8, 5, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: egpNeighInErrMsgs.setDescription("The number of EGP-defined error messages received\nfrom this EGP peer.")
egpNeighOutErrMsgs = MibTableColumn((1, 3, 6, 1, 2, 1, 8, 5, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: egpNeighOutErrMsgs.setDescription("The number of EGP-defined error messages sent to\nthis EGP peer.")
egpNeighStateUps = MibTableColumn((1, 3, 6, 1, 2, 1, 8, 5, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: egpNeighStateUps.setDescription("The number of EGP state transitions to the UP\nstate with this EGP peer.")
egpNeighStateDowns = MibTableColumn((1, 3, 6, 1, 2, 1, 8, 5, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: egpNeighStateDowns.setDescription("The number of EGP state transitions from the UP\nstate to any other state with this EGP peer.")
egpNeighIntervalHello = MibTableColumn((1, 3, 6, 1, 2, 1, 8, 5, 1, 12), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: egpNeighIntervalHello.setDescription("The interval between EGP Hello command\nretransmissions (in hundredths of a second).  This\nrepresents the t1 timer as defined in RFC 904.")
egpNeighIntervalPoll = MibTableColumn((1, 3, 6, 1, 2, 1, 8, 5, 1, 13), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: egpNeighIntervalPoll.setDescription("The interval between EGP poll command\n\nretransmissions (in hundredths of a second).  This\nrepresents the t3 timer as defined in RFC 904.")
egpNeighMode = MibTableColumn((1, 3, 6, 1, 2, 1, 8, 5, 1, 14), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,)).subtype(namedValues=NamedValues(("active", 1), ("passive", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: egpNeighMode.setDescription("The polling mode of this EGP base_entity, either\npassive or active.")
egpNeighEventTrigger = MibTableColumn((1, 3, 6, 1, 2, 1, 8, 5, 1, 15), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,)).subtype(namedValues=NamedValues(("start", 1), ("stop", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: egpNeighEventTrigger.setDescription("A control variable used to trigger operator-\ninitiated Start and Stop events.  When read, this\nvariable always returns the most recent value that\negpNeighEventTrigger was set to.  If it has not\nbeen set since the last initialization of the\nnetwork management subsystem on the node, it\nreturns a value of `stop'.\n\nWhen set, this variable causes a Start or Stop\nevent on the specified neighbor, as specified on\npages 8-10 of RFC 904.  Briefly, a Start event\ncauses an Idle peer to begin neighbor acquisition\nand a non-Idle peer to reinitiate neighbor\nacquisition.  A stop event causes a non-Idle peer\nto return to the Idle state until a Start event\noccurs, either via egpNeighEventTrigger or\notherwise.")
egpAs = MibScalar((1, 3, 6, 1, 2, 1, 8, 6), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: egpAs.setDescription("The autonomous system number of this EGP base_entity.")
transmission = MibIdentifier((1, 3, 6, 1, 2, 1, 10))
snmp = MibIdentifier((1, 3, 6, 1, 2, 1, 11))
snmpInPkts = MibScalar((1, 3, 6, 1, 2, 1, 11, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpInPkts.setDescription("The total number of Messages delivered to the\nSNMP base_entity from the transport service.")
snmpOutPkts = MibScalar((1, 3, 6, 1, 2, 1, 11, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpOutPkts.setDescription("The total number of SNMP Messages which were\npassed from the SNMP protocol base_entity to the\ntransport service.")
snmpInBadVersions = MibScalar((1, 3, 6, 1, 2, 1, 11, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpInBadVersions.setDescription("The total number of SNMP Messages which were\ndelivered to the SNMP protocol base_entity and were for\nan unsupported SNMP version.")
snmpInBadCommunityNames = MibScalar((1, 3, 6, 1, 2, 1, 11, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpInBadCommunityNames.setDescription("The total number of SNMP Messages delivered to\nthe SNMP protocol base_entity which used a SNMP\ncommunity name not known to said base_entity.")
snmpInBadCommunityUses = MibScalar((1, 3, 6, 1, 2, 1, 11, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpInBadCommunityUses.setDescription("The total number of SNMP Messages delivered to\nthe SNMP protocol base_entity which represented an SNMP\noperation which was not allowed by the SNMP\ncommunity named in the Message.")
snmpInASNParseErrs = MibScalar((1, 3, 6, 1, 2, 1, 11, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpInASNParseErrs.setDescription("The total number of ASN.1 or BER errors\nencountered by the SNMP protocol base_entity when\ndecoding received SNMP Messages.")
snmpInTooBigs = MibScalar((1, 3, 6, 1, 2, 1, 11, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpInTooBigs.setDescription("The total number of SNMP PDUs which were\ndelivered to the SNMP protocol base_entity and for\nwhich the value of the error-status field is\n`tooBig'.")
snmpInNoSuchNames = MibScalar((1, 3, 6, 1, 2, 1, 11, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpInNoSuchNames.setDescription("The total number of SNMP PDUs which were\ndelivered to the SNMP protocol base_entity and for\nwhich the value of the error-status field is\n`noSuchName'.")
snmpInBadValues = MibScalar((1, 3, 6, 1, 2, 1, 11, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpInBadValues.setDescription("The total number of SNMP PDUs which were\ndelivered to the SNMP protocol base_entity and for\nwhich the value of the error-status field is\n`badValue'.")
snmpInReadOnlys = MibScalar((1, 3, 6, 1, 2, 1, 11, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpInReadOnlys.setDescription("The total number valid SNMP PDUs which were\ndelivered to the SNMP protocol base_entity and for\nwhich the value of the error-status field is\n`readOnly'.  It should be noted that it is a\nprotocol error to generate an SNMP PDU which\ncontains the value `readOnly' in the error-status\nfield, as such this object is provided as a means\nof detecting incorrect implementations of the\n\nSNMP.")
snmpInGenErrs = MibScalar((1, 3, 6, 1, 2, 1, 11, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpInGenErrs.setDescription("The total number of SNMP PDUs which were\ndelivered to the SNMP protocol base_entity and for\nwhich the value of the error-status field is\n`genErr'.")
snmpInTotalReqVars = MibScalar((1, 3, 6, 1, 2, 1, 11, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpInTotalReqVars.setDescription("The total number of MIB objects which have been\nretrieved successfully by the SNMP protocol base_entity\nas the result of receiving valid SNMP Get-Request\nand Get-Next PDUs.")
snmpInTotalSetVars = MibScalar((1, 3, 6, 1, 2, 1, 11, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpInTotalSetVars.setDescription("The total number of MIB objects which have been\naltered successfully by the SNMP protocol base_entity\nas the result of receiving valid SNMP Set-Request\nPDUs.")
snmpInGetRequests = MibScalar((1, 3, 6, 1, 2, 1, 11, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpInGetRequests.setDescription("The total number of SNMP Get-Request PDUs which\nhave been accepted and processed by the SNMP\nprotocol base_entity.")
snmpInGetNexts = MibScalar((1, 3, 6, 1, 2, 1, 11, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpInGetNexts.setDescription("The total number of SNMP Get-Next PDUs which have\nbeen accepted and processed by the SNMP protocol\nbase_entity.")
snmpInSetRequests = MibScalar((1, 3, 6, 1, 2, 1, 11, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpInSetRequests.setDescription("The total number of SNMP Set-Request PDUs which\nhave been accepted and processed by the SNMP\nprotocol base_entity.")
snmpInGetResponses = MibScalar((1, 3, 6, 1, 2, 1, 11, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpInGetResponses.setDescription("The total number of SNMP Get-Response PDUs which\nhave been accepted and processed by the SNMP\nprotocol base_entity.")
snmpInTraps = MibScalar((1, 3, 6, 1, 2, 1, 11, 19), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpInTraps.setDescription("The total number of SNMP Trap PDUs which have\nbeen accepted and processed by the SNMP protocol\nbase_entity.")
snmpOutTooBigs = MibScalar((1, 3, 6, 1, 2, 1, 11, 20), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpOutTooBigs.setDescription("The total number of SNMP PDUs which were\ngenerated by the SNMP protocol base_entity and for\nwhich the value of the error-status field is\n`tooBig.'")
snmpOutNoSuchNames = MibScalar((1, 3, 6, 1, 2, 1, 11, 21), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpOutNoSuchNames.setDescription("The total number of SNMP PDUs which were\ngenerated by the SNMP protocol base_entity and for\nwhich the value of the error-status is\n`noSuchName'.")
snmpOutBadValues = MibScalar((1, 3, 6, 1, 2, 1, 11, 22), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpOutBadValues.setDescription("The total number of SNMP PDUs which were\ngenerated by the SNMP protocol base_entity and for\nwhich the value of the error-status field is\n`badValue'.")
snmpOutGenErrs = MibScalar((1, 3, 6, 1, 2, 1, 11, 24), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpOutGenErrs.setDescription("The total number of SNMP PDUs which were\ngenerated by the SNMP protocol base_entity and for\nwhich the value of the error-status field is\n`genErr'.")
snmpOutGetRequests = MibScalar((1, 3, 6, 1, 2, 1, 11, 25), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpOutGetRequests.setDescription("The total number of SNMP Get-Request PDUs which\nhave been generated by the SNMP protocol base_entity.")
snmpOutGetNexts = MibScalar((1, 3, 6, 1, 2, 1, 11, 26), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpOutGetNexts.setDescription("The total number of SNMP Get-Next PDUs which have\nbeen generated by the SNMP protocol base_entity.")
snmpOutSetRequests = MibScalar((1, 3, 6, 1, 2, 1, 11, 27), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpOutSetRequests.setDescription("The total number of SNMP Set-Request PDUs which\nhave been generated by the SNMP protocol base_entity.")
snmpOutGetResponses = MibScalar((1, 3, 6, 1, 2, 1, 11, 28), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpOutGetResponses.setDescription("The total number of SNMP Get-Response PDUs which\nhave been generated by the SNMP protocol base_entity.")
snmpOutTraps = MibScalar((1, 3, 6, 1, 2, 1, 11, 29), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpOutTraps.setDescription("The total number of SNMP Trap PDUs which have\nbeen generated by the SNMP protocol base_entity.")
snmpEnableAuthenTraps = MibScalar((1, 3, 6, 1, 2, 1, 11, 30), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("enabled", 1), ("disabled", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: snmpEnableAuthenTraps.setDescription("Indicates whether the SNMP agent process is\npermitted to generate authentication-failure\ntraps.  The value of this object overrides any\nconfiguration information; as such, it provides a\nmeans whereby all authentication-failure traps may\nbe disabled.\n\nNote that it is strongly recommended that this\nobject be stored in non-volatile memory so that it\nremains constant between re-initializations of the\nnetwork management system.")

# Augmentions

# Exports

# Types
mibBuilder.exportSymbols("RFC1213-MIB", DisplayString=DisplayString, PhysAddress=PhysAddress)

# Objects
mibBuilder.exportSymbols("RFC1213-MIB", mib_2=mib_2, system=system, sysDescr=sysDescr, sysObjectID=sysObjectID, sysUpTime=sysUpTime, sysContact=sysContact, sysName=sysName, sysLocation=sysLocation, sysServices=sysServices, interfaces=interfaces, ifNumber=ifNumber, ifTable=ifTable, ifEntry=ifEntry, ifIndex=ifIndex, ifDescr=ifDescr, ifType=ifType, ifMtu=ifMtu, ifSpeed=ifSpeed, ifPhysAddress=ifPhysAddress, ifAdminStatus=ifAdminStatus, ifOperStatus=ifOperStatus, ifLastChange=ifLastChange, ifInOctets=ifInOctets, ifInUcastPkts=ifInUcastPkts, ifInNUcastPkts=ifInNUcastPkts, ifInDiscards=ifInDiscards, ifInErrors=ifInErrors, ifInUnknownProtos=ifInUnknownProtos, ifOutOctets=ifOutOctets, ifOutUcastPkts=ifOutUcastPkts, ifOutNUcastPkts=ifOutNUcastPkts, ifOutDiscards=ifOutDiscards, ifOutErrors=ifOutErrors, ifOutQLen=ifOutQLen, ifSpecific=ifSpecific, at=at, atTable=atTable, atEntry=atEntry, atIfIndex=atIfIndex, atPhysAddress=atPhysAddress, atNetAddress=atNetAddress, atNetAddressPlaceholder=atNetAddressPlaceholder, ip=ip, ipForwarding=ipForwarding, ipDefaultTTL=ipDefaultTTL, ipInReceives=ipInReceives, ipInHdrErrors=ipInHdrErrors, ipInAddrErrors=ipInAddrErrors, ipForwDatagrams=ipForwDatagrams, ipInUnknownProtos=ipInUnknownProtos, ipInDiscards=ipInDiscards, ipInDelivers=ipInDelivers, ipOutRequests=ipOutRequests, ipOutDiscards=ipOutDiscards, ipOutNoRoutes=ipOutNoRoutes, ipReasmTimeout=ipReasmTimeout, ipReasmReqds=ipReasmReqds, ipReasmOKs=ipReasmOKs, ipReasmFails=ipReasmFails, ipFragOKs=ipFragOKs, ipFragFails=ipFragFails, ipFragCreates=ipFragCreates, ipAddrTable=ipAddrTable, ipAddrEntry=ipAddrEntry, ipAdEntAddr=ipAdEntAddr, ipAdEntIfIndex=ipAdEntIfIndex, ipAdEntNetMask=ipAdEntNetMask, ipAdEntBcastAddr=ipAdEntBcastAddr, ipAdEntReasmMaxSize=ipAdEntReasmMaxSize, ipRouteTable=ipRouteTable, ipRouteEntry=ipRouteEntry, ipRouteDest=ipRouteDest, ipRouteIfIndex=ipRouteIfIndex, ipRouteMetric1=ipRouteMetric1, ipRouteMetric2=ipRouteMetric2, ipRouteMetric3=ipRouteMetric3, ipRouteMetric4=ipRouteMetric4, ipRouteNextHop=ipRouteNextHop, ipRouteType=ipRouteType, ipRouteProto=ipRouteProto, ipRouteAge=ipRouteAge, ipRouteMask=ipRouteMask, ipRouteMetric5=ipRouteMetric5, ipRouteInfo=ipRouteInfo, ipNetToMediaTable=ipNetToMediaTable, ipNetToMediaEntry=ipNetToMediaEntry, ipNetToMediaIfIndex=ipNetToMediaIfIndex, ipNetToMediaPhysAddress=ipNetToMediaPhysAddress, ipNetToMediaNetAddress=ipNetToMediaNetAddress, ipNetToMediaType=ipNetToMediaType, ipRoutingDiscards=ipRoutingDiscards, icmp=icmp, icmpInMsgs=icmpInMsgs, icmpInErrors=icmpInErrors, icmpInDestUnreachs=icmpInDestUnreachs, icmpInTimeExcds=icmpInTimeExcds, icmpInParmProbs=icmpInParmProbs, icmpInSrcQuenchs=icmpInSrcQuenchs, icmpInRedirects=icmpInRedirects, icmpInEchos=icmpInEchos, icmpInEchoReps=icmpInEchoReps, icmpInTimestamps=icmpInTimestamps, icmpInTimestampReps=icmpInTimestampReps, icmpInAddrMasks=icmpInAddrMasks, icmpInAddrMaskReps=icmpInAddrMaskReps, icmpOutMsgs=icmpOutMsgs, icmpOutErrors=icmpOutErrors, icmpOutDestUnreachs=icmpOutDestUnreachs, icmpOutTimeExcds=icmpOutTimeExcds, icmpOutParmProbs=icmpOutParmProbs, icmpOutSrcQuenchs=icmpOutSrcQuenchs, icmpOutRedirects=icmpOutRedirects, icmpOutEchos=icmpOutEchos, icmpOutEchoReps=icmpOutEchoReps, icmpOutTimestamps=icmpOutTimestamps, icmpOutTimestampReps=icmpOutTimestampReps, icmpOutAddrMasks=icmpOutAddrMasks, icmpOutAddrMaskReps=icmpOutAddrMaskReps, tcp=tcp, tcpRtoAlgorithm=tcpRtoAlgorithm, tcpRtoMin=tcpRtoMin, tcpRtoMax=tcpRtoMax, tcpMaxConn=tcpMaxConn, tcpActiveOpens=tcpActiveOpens, tcpPassiveOpens=tcpPassiveOpens, tcpAttemptFails=tcpAttemptFails, tcpEstabResets=tcpEstabResets)
mibBuilder.exportSymbols("RFC1213-MIB", tcpCurrEstab=tcpCurrEstab, tcpInSegs=tcpInSegs, tcpOutSegs=tcpOutSegs, tcpRetransSegs=tcpRetransSegs, tcpConnTable=tcpConnTable, tcpConnEntry=tcpConnEntry, tcpConnState=tcpConnState, tcpConnLocalAddress=tcpConnLocalAddress, tcpConnLocalPort=tcpConnLocalPort, tcpConnRemAddress=tcpConnRemAddress, tcpConnRemPort=tcpConnRemPort, tcpInErrs=tcpInErrs, tcpOutRsts=tcpOutRsts, udp=udp, udpInDatagrams=udpInDatagrams, udpNoPorts=udpNoPorts, udpInErrors=udpInErrors, udpOutDatagrams=udpOutDatagrams, udpTable=udpTable, udpEntry=udpEntry, udpLocalAddress=udpLocalAddress, udpLocalPort=udpLocalPort, egp=egp, egpInMsgs=egpInMsgs, egpInErrors=egpInErrors, egpOutMsgs=egpOutMsgs, egpOutErrors=egpOutErrors, egpNeighTable=egpNeighTable, egpNeighEntry=egpNeighEntry, egpNeighState=egpNeighState, egpNeighAddr=egpNeighAddr, egpNeighAs=egpNeighAs, egpNeighInMsgs=egpNeighInMsgs, egpNeighInErrs=egpNeighInErrs, egpNeighOutMsgs=egpNeighOutMsgs, egpNeighOutErrs=egpNeighOutErrs, egpNeighInErrMsgs=egpNeighInErrMsgs, egpNeighOutErrMsgs=egpNeighOutErrMsgs, egpNeighStateUps=egpNeighStateUps, egpNeighStateDowns=egpNeighStateDowns, egpNeighIntervalHello=egpNeighIntervalHello, egpNeighIntervalPoll=egpNeighIntervalPoll, egpNeighMode=egpNeighMode, egpNeighEventTrigger=egpNeighEventTrigger, egpAs=egpAs, transmission=transmission, snmp=snmp, snmpInPkts=snmpInPkts, snmpOutPkts=snmpOutPkts, snmpInBadVersions=snmpInBadVersions, snmpInBadCommunityNames=snmpInBadCommunityNames, snmpInBadCommunityUses=snmpInBadCommunityUses, snmpInASNParseErrs=snmpInASNParseErrs, snmpInTooBigs=snmpInTooBigs, snmpInNoSuchNames=snmpInNoSuchNames, snmpInBadValues=snmpInBadValues, snmpInReadOnlys=snmpInReadOnlys, snmpInGenErrs=snmpInGenErrs, snmpInTotalReqVars=snmpInTotalReqVars, snmpInTotalSetVars=snmpInTotalSetVars, snmpInGetRequests=snmpInGetRequests, snmpInGetNexts=snmpInGetNexts, snmpInSetRequests=snmpInSetRequests, snmpInGetResponses=snmpInGetResponses, snmpInTraps=snmpInTraps, snmpOutTooBigs=snmpOutTooBigs, snmpOutNoSuchNames=snmpOutNoSuchNames, snmpOutBadValues=snmpOutBadValues, snmpOutGenErrs=snmpOutGenErrs, snmpOutGetRequests=snmpOutGetRequests, snmpOutGetNexts=snmpOutGetNexts, snmpOutSetRequests=snmpOutSetRequests, snmpOutGetResponses=snmpOutGetResponses, snmpOutTraps=snmpOutTraps, snmpEnableAuthenTraps=snmpEnableAuthenTraps)
