import { ExceptionOptionType as __ExceptionOptionType } from "@aws-sdk/smithy-client";
import { CodeDeployServiceException as __BaseException } from "./CodeDeployServiceException";
export interface Tag {
  Key?: string;
  Value?: string;
}
export interface AddTagsToOnPremisesInstancesInput {
  tags: Tag[] | undefined;
  instanceNames: string[] | undefined;
}
export declare class InstanceLimitExceededException extends __BaseException {
  readonly name: "InstanceLimitExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InstanceLimitExceededException, __BaseException>
  );
}
export declare class InstanceNameRequiredException extends __BaseException {
  readonly name: "InstanceNameRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InstanceNameRequiredException, __BaseException>
  );
}
export declare class InstanceNotRegisteredException extends __BaseException {
  readonly name: "InstanceNotRegisteredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InstanceNotRegisteredException, __BaseException>
  );
}
export declare class InvalidInstanceNameException extends __BaseException {
  readonly name: "InvalidInstanceNameException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidInstanceNameException, __BaseException>
  );
}
export declare class InvalidTagException extends __BaseException {
  readonly name: "InvalidTagException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidTagException, __BaseException>
  );
}
export declare class TagLimitExceededException extends __BaseException {
  readonly name: "TagLimitExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<TagLimitExceededException, __BaseException>
  );
}
export declare class TagRequiredException extends __BaseException {
  readonly name: "TagRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<TagRequiredException, __BaseException>
  );
}
export interface Alarm {
  name?: string;
}
export interface AlarmConfiguration {
  enabled?: boolean;
  ignorePollAlarmFailure?: boolean;
  alarms?: Alarm[];
}
export declare class AlarmsLimitExceededException extends __BaseException {
  readonly name: "AlarmsLimitExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<AlarmsLimitExceededException, __BaseException>
  );
}
export declare class ApplicationAlreadyExistsException extends __BaseException {
  readonly name: "ApplicationAlreadyExistsException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      ApplicationAlreadyExistsException,
      __BaseException
    >
  );
}
export declare class ApplicationDoesNotExistException extends __BaseException {
  readonly name: "ApplicationDoesNotExistException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      ApplicationDoesNotExistException,
      __BaseException
    >
  );
}
export declare enum ComputePlatform {
  ECS = "ECS",
  LAMBDA = "Lambda",
  SERVER = "Server",
}
export interface ApplicationInfo {
  applicationId?: string;
  applicationName?: string;
  createTime?: Date;
  linkedToGitHub?: boolean;
  gitHubAccountName?: string;
  computePlatform?: ComputePlatform | string;
}
export declare class ApplicationLimitExceededException extends __BaseException {
  readonly name: "ApplicationLimitExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      ApplicationLimitExceededException,
      __BaseException
    >
  );
}
export declare class ApplicationNameRequiredException extends __BaseException {
  readonly name: "ApplicationNameRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      ApplicationNameRequiredException,
      __BaseException
    >
  );
}
export declare enum ApplicationRevisionSortBy {
  FirstUsedTime = "firstUsedTime",
  LastUsedTime = "lastUsedTime",
  RegisterTime = "registerTime",
}
export interface AppSpecContent {
  content?: string;
  sha256?: string;
}
export declare class ArnNotSupportedException extends __BaseException {
  readonly name: "ArnNotSupportedException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ArnNotSupportedException, __BaseException>
  );
}
export declare enum AutoRollbackEvent {
  DEPLOYMENT_FAILURE = "DEPLOYMENT_FAILURE",
  DEPLOYMENT_STOP_ON_ALARM = "DEPLOYMENT_STOP_ON_ALARM",
  DEPLOYMENT_STOP_ON_REQUEST = "DEPLOYMENT_STOP_ON_REQUEST",
}
export interface AutoRollbackConfiguration {
  enabled?: boolean;
  events?: (AutoRollbackEvent | string)[];
}
export interface AutoScalingGroup {
  name?: string;
  hook?: string;
}
export interface GitHubLocation {
  repository?: string;
  commitId?: string;
}
export declare enum RevisionLocationType {
  AppSpecContent = "AppSpecContent",
  GitHub = "GitHub",
  S3 = "S3",
  String = "String",
}
export declare enum BundleType {
  JSON = "JSON",
  Tar = "tar",
  TarGZip = "tgz",
  YAML = "YAML",
  Zip = "zip",
}
export interface S3Location {
  bucket?: string;
  key?: string;
  bundleType?: BundleType | string;
  version?: string;
  eTag?: string;
}
export interface RawString {
  content?: string;
  sha256?: string;
}
export interface RevisionLocation {
  revisionType?: RevisionLocationType | string;
  s3Location?: S3Location;
  gitHubLocation?: GitHubLocation;
  string?: RawString;
  appSpecContent?: AppSpecContent;
}
export interface BatchGetApplicationRevisionsInput {
  applicationName: string | undefined;
  revisions: RevisionLocation[] | undefined;
}
export interface GenericRevisionInfo {
  description?: string;
  deploymentGroups?: string[];
  firstUsedTime?: Date;
  lastUsedTime?: Date;
  registerTime?: Date;
}
export interface RevisionInfo {
  revisionLocation?: RevisionLocation;
  genericRevisionInfo?: GenericRevisionInfo;
}
export interface BatchGetApplicationRevisionsOutput {
  applicationName?: string;
  errorMessage?: string;
  revisions?: RevisionInfo[];
}
export declare class BatchLimitExceededException extends __BaseException {
  readonly name: "BatchLimitExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<BatchLimitExceededException, __BaseException>
  );
}
export declare class InvalidApplicationNameException extends __BaseException {
  readonly name: "InvalidApplicationNameException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidApplicationNameException,
      __BaseException
    >
  );
}
export declare class InvalidRevisionException extends __BaseException {
  readonly name: "InvalidRevisionException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidRevisionException, __BaseException>
  );
}
export declare class RevisionRequiredException extends __BaseException {
  readonly name: "RevisionRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<RevisionRequiredException, __BaseException>
  );
}
export interface BatchGetApplicationsInput {
  applicationNames: string[] | undefined;
}
export interface BatchGetApplicationsOutput {
  applicationsInfo?: ApplicationInfo[];
}
export interface BatchGetDeploymentGroupsInput {
  applicationName: string | undefined;
  deploymentGroupNames: string[] | undefined;
}
export declare enum DeploymentReadyAction {
  CONTINUE_DEPLOYMENT = "CONTINUE_DEPLOYMENT",
  STOP_DEPLOYMENT = "STOP_DEPLOYMENT",
}
export interface DeploymentReadyOption {
  actionOnTimeout?: DeploymentReadyAction | string;
  waitTimeInMinutes?: number;
}
export declare enum GreenFleetProvisioningAction {
  COPY_AUTO_SCALING_GROUP = "COPY_AUTO_SCALING_GROUP",
  DISCOVER_EXISTING = "DISCOVER_EXISTING",
}
export interface GreenFleetProvisioningOption {
  action?: GreenFleetProvisioningAction | string;
}
export declare enum InstanceAction {
  KEEP_ALIVE = "KEEP_ALIVE",
  TERMINATE = "TERMINATE",
}
export interface BlueInstanceTerminationOption {
  action?: InstanceAction | string;
  terminationWaitTimeInMinutes?: number;
}
export interface BlueGreenDeploymentConfiguration {
  terminateBlueInstancesOnDeploymentSuccess?: BlueInstanceTerminationOption;
  deploymentReadyOption?: DeploymentReadyOption;
  greenFleetProvisioningOption?: GreenFleetProvisioningOption;
}
export declare enum DeploymentOption {
  WITHOUT_TRAFFIC_CONTROL = "WITHOUT_TRAFFIC_CONTROL",
  WITH_TRAFFIC_CONTROL = "WITH_TRAFFIC_CONTROL",
}
export declare enum DeploymentType {
  BLUE_GREEN = "BLUE_GREEN",
  IN_PLACE = "IN_PLACE",
}
export interface DeploymentStyle {
  deploymentType?: DeploymentType | string;
  deploymentOption?: DeploymentOption | string;
}
export declare enum EC2TagFilterType {
  KEY_AND_VALUE = "KEY_AND_VALUE",
  KEY_ONLY = "KEY_ONLY",
  VALUE_ONLY = "VALUE_ONLY",
}
export interface EC2TagFilter {
  Key?: string;
  Value?: string;
  Type?: EC2TagFilterType | string;
}
export interface EC2TagSet {
  ec2TagSetList?: EC2TagFilter[][];
}
export interface ECSService {
  serviceName?: string;
  clusterName?: string;
}
export declare enum DeploymentStatus {
  BAKING = "Baking",
  CREATED = "Created",
  FAILED = "Failed",
  IN_PROGRESS = "InProgress",
  QUEUED = "Queued",
  READY = "Ready",
  STOPPED = "Stopped",
  SUCCEEDED = "Succeeded",
}
export interface LastDeploymentInfo {
  deploymentId?: string;
  status?: DeploymentStatus | string;
  endTime?: Date;
  createTime?: Date;
}
export interface ELBInfo {
  name?: string;
}
export interface TargetGroupInfo {
  name?: string;
}
export interface TrafficRoute {
  listenerArns?: string[];
}
export interface TargetGroupPairInfo {
  targetGroups?: TargetGroupInfo[];
  prodTrafficRoute?: TrafficRoute;
  testTrafficRoute?: TrafficRoute;
}
export interface LoadBalancerInfo {
  elbInfoList?: ELBInfo[];
  targetGroupInfoList?: TargetGroupInfo[];
  targetGroupPairInfoList?: TargetGroupPairInfo[];
}
export declare enum TagFilterType {
  KEY_AND_VALUE = "KEY_AND_VALUE",
  KEY_ONLY = "KEY_ONLY",
  VALUE_ONLY = "VALUE_ONLY",
}
export interface TagFilter {
  Key?: string;
  Value?: string;
  Type?: TagFilterType | string;
}
export interface OnPremisesTagSet {
  onPremisesTagSetList?: TagFilter[][];
}
export declare enum OutdatedInstancesStrategy {
  Ignore = "IGNORE",
  Update = "UPDATE",
}
export declare enum TriggerEventType {
  DEPLOYMENT_FAILURE = "DeploymentFailure",
  DEPLOYMENT_READY = "DeploymentReady",
  DEPLOYMENT_ROLLBACK = "DeploymentRollback",
  DEPLOYMENT_START = "DeploymentStart",
  DEPLOYMENT_STOP = "DeploymentStop",
  DEPLOYMENT_SUCCESS = "DeploymentSuccess",
  INSTANCE_FAILURE = "InstanceFailure",
  INSTANCE_READY = "InstanceReady",
  INSTANCE_START = "InstanceStart",
  INSTANCE_SUCCESS = "InstanceSuccess",
}
export interface TriggerConfig {
  triggerName?: string;
  triggerTargetArn?: string;
  triggerEvents?: (TriggerEventType | string)[];
}
export interface DeploymentGroupInfo {
  applicationName?: string;
  deploymentGroupId?: string;
  deploymentGroupName?: string;
  deploymentConfigName?: string;
  ec2TagFilters?: EC2TagFilter[];
  onPremisesInstanceTagFilters?: TagFilter[];
  autoScalingGroups?: AutoScalingGroup[];
  serviceRoleArn?: string;
  targetRevision?: RevisionLocation;
  triggerConfigurations?: TriggerConfig[];
  alarmConfiguration?: AlarmConfiguration;
  autoRollbackConfiguration?: AutoRollbackConfiguration;
  deploymentStyle?: DeploymentStyle;
  outdatedInstancesStrategy?: OutdatedInstancesStrategy | string;
  blueGreenDeploymentConfiguration?: BlueGreenDeploymentConfiguration;
  loadBalancerInfo?: LoadBalancerInfo;
  lastSuccessfulDeployment?: LastDeploymentInfo;
  lastAttemptedDeployment?: LastDeploymentInfo;
  ec2TagSet?: EC2TagSet;
  onPremisesTagSet?: OnPremisesTagSet;
  computePlatform?: ComputePlatform | string;
  ecsServices?: ECSService[];
}
export interface BatchGetDeploymentGroupsOutput {
  deploymentGroupsInfo?: DeploymentGroupInfo[];
  errorMessage?: string;
}
export declare class DeploymentConfigDoesNotExistException extends __BaseException {
  readonly name: "DeploymentConfigDoesNotExistException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DeploymentConfigDoesNotExistException,
      __BaseException
    >
  );
}
export declare class DeploymentGroupNameRequiredException extends __BaseException {
  readonly name: "DeploymentGroupNameRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DeploymentGroupNameRequiredException,
      __BaseException
    >
  );
}
export declare class InvalidDeploymentGroupNameException extends __BaseException {
  readonly name: "InvalidDeploymentGroupNameException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidDeploymentGroupNameException,
      __BaseException
    >
  );
}
export interface BatchGetDeploymentInstancesInput {
  deploymentId: string | undefined;
  instanceIds: string[] | undefined;
}
export declare enum _InstanceType {
  BLUE = "Blue",
  GREEN = "Green",
}
export declare enum LifecycleErrorCode {
  SCRIPT_FAILED = "ScriptFailed",
  SCRIPT_MISSING = "ScriptMissing",
  SCRIPT_NOT_EXECUTABLE = "ScriptNotExecutable",
  SCRIPT_TIMED_OUT = "ScriptTimedOut",
  SUCCESS = "Success",
  UNKNOWN_ERROR = "UnknownError",
}
export interface Diagnostics {
  errorCode?: LifecycleErrorCode | string;
  scriptName?: string;
  message?: string;
  logTail?: string;
}
export declare enum LifecycleEventStatus {
  FAILED = "Failed",
  IN_PROGRESS = "InProgress",
  PENDING = "Pending",
  SKIPPED = "Skipped",
  SUCCEEDED = "Succeeded",
  UNKNOWN = "Unknown",
}
export interface LifecycleEvent {
  lifecycleEventName?: string;
  diagnostics?: Diagnostics;
  startTime?: Date;
  endTime?: Date;
  status?: LifecycleEventStatus | string;
}
export declare enum InstanceStatus {
  FAILED = "Failed",
  IN_PROGRESS = "InProgress",
  PENDING = "Pending",
  READY = "Ready",
  SKIPPED = "Skipped",
  SUCCEEDED = "Succeeded",
  UNKNOWN = "Unknown",
}
export interface InstanceSummary {
  deploymentId?: string;
  instanceId?: string;
  status?: InstanceStatus | string;
  lastUpdatedAt?: Date;
  lifecycleEvents?: LifecycleEvent[];
  instanceType?: _InstanceType | string;
}
export interface BatchGetDeploymentInstancesOutput {
  instancesSummary?: InstanceSummary[];
  errorMessage?: string;
}
export declare class DeploymentDoesNotExistException extends __BaseException {
  readonly name: "DeploymentDoesNotExistException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DeploymentDoesNotExistException,
      __BaseException
    >
  );
}
export declare class DeploymentIdRequiredException extends __BaseException {
  readonly name: "DeploymentIdRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<DeploymentIdRequiredException, __BaseException>
  );
}
export declare class InstanceIdRequiredException extends __BaseException {
  readonly name: "InstanceIdRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InstanceIdRequiredException, __BaseException>
  );
}
export declare class InvalidComputePlatformException extends __BaseException {
  readonly name: "InvalidComputePlatformException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidComputePlatformException,
      __BaseException
    >
  );
}
export declare class InvalidDeploymentIdException extends __BaseException {
  readonly name: "InvalidDeploymentIdException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidDeploymentIdException, __BaseException>
  );
}
export interface BatchGetDeploymentsInput {
  deploymentIds: string[] | undefined;
}
export declare enum DeploymentCreator {
  Autoscaling = "autoscaling",
  CloudFormation = "CloudFormation",
  CloudFormationRollback = "CloudFormationRollback",
  CodeDeploy = "CodeDeploy",
  CodeDeployAutoUpdate = "CodeDeployAutoUpdate",
  CodeDeployRollback = "codeDeployRollback",
  User = "user",
}
export interface DeploymentOverview {
  Pending?: number;
  InProgress?: number;
  Succeeded?: number;
  Failed?: number;
  Skipped?: number;
  Ready?: number;
}
export declare enum ErrorCode {
  AGENT_ISSUE = "AGENT_ISSUE",
  ALARM_ACTIVE = "ALARM_ACTIVE",
  APPLICATION_MISSING = "APPLICATION_MISSING",
  AUTOSCALING_VALIDATION_ERROR = "AUTOSCALING_VALIDATION_ERROR",
  AUTO_SCALING_CONFIGURATION = "AUTO_SCALING_CONFIGURATION",
  AUTO_SCALING_IAM_ROLE_PERMISSIONS = "AUTO_SCALING_IAM_ROLE_PERMISSIONS",
  CLOUDFORMATION_STACK_FAILURE = "CLOUDFORMATION_STACK_FAILURE",
  CODEDEPLOY_RESOURCE_CANNOT_BE_FOUND = "CODEDEPLOY_RESOURCE_CANNOT_BE_FOUND",
  CUSTOMER_APPLICATION_UNHEALTHY = "CUSTOMER_APPLICATION_UNHEALTHY",
  DEPLOYMENT_GROUP_MISSING = "DEPLOYMENT_GROUP_MISSING",
  ECS_UPDATE_ERROR = "ECS_UPDATE_ERROR",
  ELASTIC_LOAD_BALANCING_INVALID = "ELASTIC_LOAD_BALANCING_INVALID",
  ELB_INVALID_INSTANCE = "ELB_INVALID_INSTANCE",
  HEALTH_CONSTRAINTS = "HEALTH_CONSTRAINTS",
  HEALTH_CONSTRAINTS_INVALID = "HEALTH_CONSTRAINTS_INVALID",
  HOOK_EXECUTION_FAILURE = "HOOK_EXECUTION_FAILURE",
  IAM_ROLE_MISSING = "IAM_ROLE_MISSING",
  IAM_ROLE_PERMISSIONS = "IAM_ROLE_PERMISSIONS",
  INTERNAL_ERROR = "INTERNAL_ERROR",
  INVALID_ECS_SERVICE = "INVALID_ECS_SERVICE",
  INVALID_LAMBDA_CONFIGURATION = "INVALID_LAMBDA_CONFIGURATION",
  INVALID_LAMBDA_FUNCTION = "INVALID_LAMBDA_FUNCTION",
  INVALID_REVISION = "INVALID_REVISION",
  MANUAL_STOP = "MANUAL_STOP",
  MISSING_BLUE_GREEN_DEPLOYMENT_CONFIGURATION = "MISSING_BLUE_GREEN_DEPLOYMENT_CONFIGURATION",
  MISSING_ELB_INFORMATION = "MISSING_ELB_INFORMATION",
  MISSING_GITHUB_TOKEN = "MISSING_GITHUB_TOKEN",
  NO_EC2_SUBSCRIPTION = "NO_EC2_SUBSCRIPTION",
  NO_INSTANCES = "NO_INSTANCES",
  OVER_MAX_INSTANCES = "OVER_MAX_INSTANCES",
  RESOURCE_LIMIT_EXCEEDED = "RESOURCE_LIMIT_EXCEEDED",
  REVISION_MISSING = "REVISION_MISSING",
  THROTTLED = "THROTTLED",
  TIMEOUT = "TIMEOUT",
}
export interface ErrorInformation {
  code?: ErrorCode | string;
  message?: string;
}
export declare enum FileExistsBehavior {
  DISALLOW = "DISALLOW",
  OVERWRITE = "OVERWRITE",
  RETAIN = "RETAIN",
}
export interface RelatedDeployments {
  autoUpdateOutdatedInstancesRootDeploymentId?: string;
  autoUpdateOutdatedInstancesDeploymentIds?: string[];
}
export interface RollbackInfo {
  rollbackDeploymentId?: string;
  rollbackTriggeringDeploymentId?: string;
  rollbackMessage?: string;
}
export interface TargetInstances {
  tagFilters?: EC2TagFilter[];
  autoScalingGroups?: string[];
  ec2TagSet?: EC2TagSet;
}
export interface DeploymentInfo {
  applicationName?: string;
  deploymentGroupName?: string;
  deploymentConfigName?: string;
  deploymentId?: string;
  previousRevision?: RevisionLocation;
  revision?: RevisionLocation;
  status?: DeploymentStatus | string;
  errorInformation?: ErrorInformation;
  createTime?: Date;
  startTime?: Date;
  completeTime?: Date;
  deploymentOverview?: DeploymentOverview;
  description?: string;
  creator?: DeploymentCreator | string;
  ignoreApplicationStopFailures?: boolean;
  autoRollbackConfiguration?: AutoRollbackConfiguration;
  updateOutdatedInstancesOnly?: boolean;
  rollbackInfo?: RollbackInfo;
  deploymentStyle?: DeploymentStyle;
  targetInstances?: TargetInstances;
  instanceTerminationWaitTimeStarted?: boolean;
  blueGreenDeploymentConfiguration?: BlueGreenDeploymentConfiguration;
  loadBalancerInfo?: LoadBalancerInfo;
  additionalDeploymentStatusInfo?: string;
  fileExistsBehavior?: FileExistsBehavior | string;
  deploymentStatusMessages?: string[];
  computePlatform?: ComputePlatform | string;
  externalId?: string;
  relatedDeployments?: RelatedDeployments;
  overrideAlarmConfiguration?: AlarmConfiguration;
}
export interface BatchGetDeploymentsOutput {
  deploymentsInfo?: DeploymentInfo[];
}
export interface BatchGetDeploymentTargetsInput {
  deploymentId?: string;
  targetIds?: string[];
}
export declare enum TargetStatus {
  FAILED = "Failed",
  IN_PROGRESS = "InProgress",
  PENDING = "Pending",
  READY = "Ready",
  SKIPPED = "Skipped",
  SUCCEEDED = "Succeeded",
  UNKNOWN = "Unknown",
}
export interface CloudFormationTarget {
  deploymentId?: string;
  targetId?: string;
  lastUpdatedAt?: Date;
  lifecycleEvents?: LifecycleEvent[];
  status?: TargetStatus | string;
  resourceType?: string;
  targetVersionWeight?: number;
}
export declare enum DeploymentTargetType {
  CLOUDFORMATION_TARGET = "CloudFormationTarget",
  ECS_TARGET = "ECSTarget",
  INSTANCE_TARGET = "InstanceTarget",
  LAMBDA_TARGET = "LambdaTarget",
}
export declare enum TargetLabel {
  BLUE = "Blue",
  GREEN = "Green",
}
export interface ECSTaskSet {
  identifer?: string;
  desiredCount?: number;
  pendingCount?: number;
  runningCount?: number;
  status?: string;
  trafficWeight?: number;
  targetGroup?: TargetGroupInfo;
  taskSetLabel?: TargetLabel | string;
}
export interface ECSTarget {
  deploymentId?: string;
  targetId?: string;
  targetArn?: string;
  lastUpdatedAt?: Date;
  lifecycleEvents?: LifecycleEvent[];
  status?: TargetStatus | string;
  taskSetsInfo?: ECSTaskSet[];
}
export interface InstanceTarget {
  deploymentId?: string;
  targetId?: string;
  targetArn?: string;
  status?: TargetStatus | string;
  lastUpdatedAt?: Date;
  lifecycleEvents?: LifecycleEvent[];
  instanceLabel?: TargetLabel | string;
}
export interface LambdaFunctionInfo {
  functionName?: string;
  functionAlias?: string;
  currentVersion?: string;
  targetVersion?: string;
  targetVersionWeight?: number;
}
export interface LambdaTarget {
  deploymentId?: string;
  targetId?: string;
  targetArn?: string;
  status?: TargetStatus | string;
  lastUpdatedAt?: Date;
  lifecycleEvents?: LifecycleEvent[];
  lambdaFunctionInfo?: LambdaFunctionInfo;
}
export interface DeploymentTarget {
  deploymentTargetType?: DeploymentTargetType | string;
  instanceTarget?: InstanceTarget;
  lambdaTarget?: LambdaTarget;
  ecsTarget?: ECSTarget;
  cloudFormationTarget?: CloudFormationTarget;
}
export interface BatchGetDeploymentTargetsOutput {
  deploymentTargets?: DeploymentTarget[];
}
export declare class DeploymentNotStartedException extends __BaseException {
  readonly name: "DeploymentNotStartedException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<DeploymentNotStartedException, __BaseException>
  );
}
export declare class DeploymentTargetDoesNotExistException extends __BaseException {
  readonly name: "DeploymentTargetDoesNotExistException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DeploymentTargetDoesNotExistException,
      __BaseException
    >
  );
}
export declare class DeploymentTargetIdRequiredException extends __BaseException {
  readonly name: "DeploymentTargetIdRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DeploymentTargetIdRequiredException,
      __BaseException
    >
  );
}
export declare class DeploymentTargetListSizeExceededException extends __BaseException {
  readonly name: "DeploymentTargetListSizeExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DeploymentTargetListSizeExceededException,
      __BaseException
    >
  );
}
export declare class InstanceDoesNotExistException extends __BaseException {
  readonly name: "InstanceDoesNotExistException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InstanceDoesNotExistException, __BaseException>
  );
}
export declare class InvalidDeploymentTargetIdException extends __BaseException {
  readonly name: "InvalidDeploymentTargetIdException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidDeploymentTargetIdException,
      __BaseException
    >
  );
}
export interface BatchGetOnPremisesInstancesInput {
  instanceNames: string[] | undefined;
}
export interface InstanceInfo {
  instanceName?: string;
  iamSessionArn?: string;
  iamUserArn?: string;
  instanceArn?: string;
  registerTime?: Date;
  deregisterTime?: Date;
  tags?: Tag[];
}
export interface BatchGetOnPremisesInstancesOutput {
  instanceInfos?: InstanceInfo[];
}
export declare class BucketNameFilterRequiredException extends __BaseException {
  readonly name: "BucketNameFilterRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      BucketNameFilterRequiredException,
      __BaseException
    >
  );
}
export declare enum DeploymentWaitType {
  READY_WAIT = "READY_WAIT",
  TERMINATION_WAIT = "TERMINATION_WAIT",
}
export interface ContinueDeploymentInput {
  deploymentId?: string;
  deploymentWaitType?: DeploymentWaitType | string;
}
export declare class DeploymentAlreadyCompletedException extends __BaseException {
  readonly name: "DeploymentAlreadyCompletedException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DeploymentAlreadyCompletedException,
      __BaseException
    >
  );
}
export declare class DeploymentIsNotInReadyStateException extends __BaseException {
  readonly name: "DeploymentIsNotInReadyStateException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DeploymentIsNotInReadyStateException,
      __BaseException
    >
  );
}
export declare class InvalidDeploymentStatusException extends __BaseException {
  readonly name: "InvalidDeploymentStatusException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidDeploymentStatusException,
      __BaseException
    >
  );
}
export declare class InvalidDeploymentWaitTypeException extends __BaseException {
  readonly name: "InvalidDeploymentWaitTypeException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidDeploymentWaitTypeException,
      __BaseException
    >
  );
}
export declare class UnsupportedActionForDeploymentTypeException extends __BaseException {
  readonly name: "UnsupportedActionForDeploymentTypeException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      UnsupportedActionForDeploymentTypeException,
      __BaseException
    >
  );
}
export interface CreateApplicationInput {
  applicationName: string | undefined;
  computePlatform?: ComputePlatform | string;
  tags?: Tag[];
}
export interface CreateApplicationOutput {
  applicationId?: string;
}
export declare class InvalidTagsToAddException extends __BaseException {
  readonly name: "InvalidTagsToAddException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidTagsToAddException, __BaseException>
  );
}
export interface CreateDeploymentInput {
  applicationName: string | undefined;
  deploymentGroupName?: string;
  revision?: RevisionLocation;
  deploymentConfigName?: string;
  description?: string;
  ignoreApplicationStopFailures?: boolean;
  targetInstances?: TargetInstances;
  autoRollbackConfiguration?: AutoRollbackConfiguration;
  updateOutdatedInstancesOnly?: boolean;
  fileExistsBehavior?: FileExistsBehavior | string;
  overrideAlarmConfiguration?: AlarmConfiguration;
}
export interface CreateDeploymentOutput {
  deploymentId?: string;
}
export declare class DeploymentGroupDoesNotExistException extends __BaseException {
  readonly name: "DeploymentGroupDoesNotExistException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DeploymentGroupDoesNotExistException,
      __BaseException
    >
  );
}
export declare class DeploymentLimitExceededException extends __BaseException {
  readonly name: "DeploymentLimitExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DeploymentLimitExceededException,
      __BaseException
    >
  );
}
export declare class DescriptionTooLongException extends __BaseException {
  readonly name: "DescriptionTooLongException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<DescriptionTooLongException, __BaseException>
  );
}
export declare class InvalidAlarmConfigException extends __BaseException {
  readonly name: "InvalidAlarmConfigException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidAlarmConfigException, __BaseException>
  );
}
export declare class InvalidAutoRollbackConfigException extends __BaseException {
  readonly name: "InvalidAutoRollbackConfigException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidAutoRollbackConfigException,
      __BaseException
    >
  );
}
export declare class InvalidAutoScalingGroupException extends __BaseException {
  readonly name: "InvalidAutoScalingGroupException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidAutoScalingGroupException,
      __BaseException
    >
  );
}
export declare class InvalidDeploymentConfigNameException extends __BaseException {
  readonly name: "InvalidDeploymentConfigNameException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidDeploymentConfigNameException,
      __BaseException
    >
  );
}
export declare class InvalidFileExistsBehaviorException extends __BaseException {
  readonly name: "InvalidFileExistsBehaviorException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidFileExistsBehaviorException,
      __BaseException
    >
  );
}
export declare class InvalidGitHubAccountTokenException extends __BaseException {
  readonly name: "InvalidGitHubAccountTokenException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidGitHubAccountTokenException,
      __BaseException
    >
  );
}
export declare class InvalidIgnoreApplicationStopFailuresValueException extends __BaseException {
  readonly name: "InvalidIgnoreApplicationStopFailuresValueException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidIgnoreApplicationStopFailuresValueException,
      __BaseException
    >
  );
}
export declare class InvalidLoadBalancerInfoException extends __BaseException {
  readonly name: "InvalidLoadBalancerInfoException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidLoadBalancerInfoException,
      __BaseException
    >
  );
}
export declare class InvalidRoleException extends __BaseException {
  readonly name: "InvalidRoleException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidRoleException, __BaseException>
  );
}
export declare class InvalidTargetInstancesException extends __BaseException {
  readonly name: "InvalidTargetInstancesException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidTargetInstancesException,
      __BaseException
    >
  );
}
export declare class InvalidTrafficRoutingConfigurationException extends __BaseException {
  readonly name: "InvalidTrafficRoutingConfigurationException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidTrafficRoutingConfigurationException,
      __BaseException
    >
  );
}
export declare class InvalidUpdateOutdatedInstancesOnlyValueException extends __BaseException {
  readonly name: "InvalidUpdateOutdatedInstancesOnlyValueException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidUpdateOutdatedInstancesOnlyValueException,
      __BaseException
    >
  );
}
export declare class RevisionDoesNotExistException extends __BaseException {
  readonly name: "RevisionDoesNotExistException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<RevisionDoesNotExistException, __BaseException>
  );
}
export declare class ThrottlingException extends __BaseException {
  readonly name: "ThrottlingException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ThrottlingException, __BaseException>
  );
}
export declare enum MinimumHealthyHostsType {
  FLEET_PERCENT = "FLEET_PERCENT",
  HOST_COUNT = "HOST_COUNT",
}
export interface MinimumHealthyHosts {
  type?: MinimumHealthyHostsType | string;
  value?: number;
}
export interface TimeBasedCanary {
  canaryPercentage?: number;
  canaryInterval?: number;
}
export interface TimeBasedLinear {
  linearPercentage?: number;
  linearInterval?: number;
}
export declare enum TrafficRoutingType {
  AllAtOnce = "AllAtOnce",
  TimeBasedCanary = "TimeBasedCanary",
  TimeBasedLinear = "TimeBasedLinear",
}
export interface TrafficRoutingConfig {
  type?: TrafficRoutingType | string;
  timeBasedCanary?: TimeBasedCanary;
  timeBasedLinear?: TimeBasedLinear;
}
export interface CreateDeploymentConfigInput {
  deploymentConfigName: string | undefined;
  minimumHealthyHosts?: MinimumHealthyHosts;
  trafficRoutingConfig?: TrafficRoutingConfig;
  computePlatform?: ComputePlatform | string;
}
export interface CreateDeploymentConfigOutput {
  deploymentConfigId?: string;
}
export declare class DeploymentConfigAlreadyExistsException extends __BaseException {
  readonly name: "DeploymentConfigAlreadyExistsException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DeploymentConfigAlreadyExistsException,
      __BaseException
    >
  );
}
export declare class DeploymentConfigLimitExceededException extends __BaseException {
  readonly name: "DeploymentConfigLimitExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DeploymentConfigLimitExceededException,
      __BaseException
    >
  );
}
export declare class DeploymentConfigNameRequiredException extends __BaseException {
  readonly name: "DeploymentConfigNameRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DeploymentConfigNameRequiredException,
      __BaseException
    >
  );
}
export declare class InvalidMinimumHealthyHostValueException extends __BaseException {
  readonly name: "InvalidMinimumHealthyHostValueException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidMinimumHealthyHostValueException,
      __BaseException
    >
  );
}
export interface CreateDeploymentGroupInput {
  applicationName: string | undefined;
  deploymentGroupName: string | undefined;
  deploymentConfigName?: string;
  ec2TagFilters?: EC2TagFilter[];
  onPremisesInstanceTagFilters?: TagFilter[];
  autoScalingGroups?: string[];
  serviceRoleArn: string | undefined;
  triggerConfigurations?: TriggerConfig[];
  alarmConfiguration?: AlarmConfiguration;
  autoRollbackConfiguration?: AutoRollbackConfiguration;
  outdatedInstancesStrategy?: OutdatedInstancesStrategy | string;
  deploymentStyle?: DeploymentStyle;
  blueGreenDeploymentConfiguration?: BlueGreenDeploymentConfiguration;
  loadBalancerInfo?: LoadBalancerInfo;
  ec2TagSet?: EC2TagSet;
  ecsServices?: ECSService[];
  onPremisesTagSet?: OnPremisesTagSet;
  tags?: Tag[];
}
export interface CreateDeploymentGroupOutput {
  deploymentGroupId?: string;
}
export declare class DeploymentGroupAlreadyExistsException extends __BaseException {
  readonly name: "DeploymentGroupAlreadyExistsException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DeploymentGroupAlreadyExistsException,
      __BaseException
    >
  );
}
export declare class DeploymentGroupLimitExceededException extends __BaseException {
  readonly name: "DeploymentGroupLimitExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DeploymentGroupLimitExceededException,
      __BaseException
    >
  );
}
export declare class ECSServiceMappingLimitExceededException extends __BaseException {
  readonly name: "ECSServiceMappingLimitExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      ECSServiceMappingLimitExceededException,
      __BaseException
    >
  );
}
export declare class InvalidBlueGreenDeploymentConfigurationException extends __BaseException {
  readonly name: "InvalidBlueGreenDeploymentConfigurationException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidBlueGreenDeploymentConfigurationException,
      __BaseException
    >
  );
}
export declare class InvalidDeploymentStyleException extends __BaseException {
  readonly name: "InvalidDeploymentStyleException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidDeploymentStyleException,
      __BaseException
    >
  );
}
export declare class InvalidEC2TagCombinationException extends __BaseException {
  readonly name: "InvalidEC2TagCombinationException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidEC2TagCombinationException,
      __BaseException
    >
  );
}
export declare class InvalidEC2TagException extends __BaseException {
  readonly name: "InvalidEC2TagException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidEC2TagException, __BaseException>
  );
}
export declare class InvalidECSServiceException extends __BaseException {
  readonly name: "InvalidECSServiceException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidECSServiceException, __BaseException>
  );
}
export declare class InvalidInputException extends __BaseException {
  readonly name: "InvalidInputException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidInputException, __BaseException>
  );
}
export declare class InvalidOnPremisesTagCombinationException extends __BaseException {
  readonly name: "InvalidOnPremisesTagCombinationException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidOnPremisesTagCombinationException,
      __BaseException
    >
  );
}
export declare class InvalidTargetGroupPairException extends __BaseException {
  readonly name: "InvalidTargetGroupPairException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidTargetGroupPairException,
      __BaseException
    >
  );
}
export declare class InvalidTriggerConfigException extends __BaseException {
  readonly name: "InvalidTriggerConfigException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidTriggerConfigException, __BaseException>
  );
}
export declare class LifecycleHookLimitExceededException extends __BaseException {
  readonly name: "LifecycleHookLimitExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      LifecycleHookLimitExceededException,
      __BaseException
    >
  );
}
export declare class RoleRequiredException extends __BaseException {
  readonly name: "RoleRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<RoleRequiredException, __BaseException>
  );
}
export declare class TagSetListLimitExceededException extends __BaseException {
  readonly name: "TagSetListLimitExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      TagSetListLimitExceededException,
      __BaseException
    >
  );
}
export declare class TriggerTargetsLimitExceededException extends __BaseException {
  readonly name: "TriggerTargetsLimitExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      TriggerTargetsLimitExceededException,
      __BaseException
    >
  );
}
export interface DeleteApplicationInput {
  applicationName: string | undefined;
}
export interface DeleteDeploymentConfigInput {
  deploymentConfigName: string | undefined;
}
export declare class DeploymentConfigInUseException extends __BaseException {
  readonly name: "DeploymentConfigInUseException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<DeploymentConfigInUseException, __BaseException>
  );
}
export declare class InvalidOperationException extends __BaseException {
  readonly name: "InvalidOperationException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidOperationException, __BaseException>
  );
}
export interface DeleteDeploymentGroupInput {
  applicationName: string | undefined;
  deploymentGroupName: string | undefined;
}
export interface DeleteDeploymentGroupOutput {
  hooksNotCleanedUp?: AutoScalingGroup[];
}
export interface DeleteGitHubAccountTokenInput {
  tokenName?: string;
}
export interface DeleteGitHubAccountTokenOutput {
  tokenName?: string;
}
export declare class GitHubAccountTokenDoesNotExistException extends __BaseException {
  readonly name: "GitHubAccountTokenDoesNotExistException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      GitHubAccountTokenDoesNotExistException,
      __BaseException
    >
  );
}
export declare class GitHubAccountTokenNameRequiredException extends __BaseException {
  readonly name: "GitHubAccountTokenNameRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      GitHubAccountTokenNameRequiredException,
      __BaseException
    >
  );
}
export declare class InvalidGitHubAccountTokenNameException extends __BaseException {
  readonly name: "InvalidGitHubAccountTokenNameException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidGitHubAccountTokenNameException,
      __BaseException
    >
  );
}
export declare class OperationNotSupportedException extends __BaseException {
  readonly name: "OperationNotSupportedException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<OperationNotSupportedException, __BaseException>
  );
}
export declare class ResourceValidationException extends __BaseException {
  readonly name: "ResourceValidationException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ResourceValidationException, __BaseException>
  );
}
export interface DeleteResourcesByExternalIdInput {
  externalId?: string;
}
export interface DeleteResourcesByExternalIdOutput {}
export interface DeregisterOnPremisesInstanceInput {
  instanceName: string | undefined;
}
export interface GetApplicationInput {
  applicationName: string | undefined;
}
export interface GetApplicationOutput {
  application?: ApplicationInfo;
}
export interface GetApplicationRevisionInput {
  applicationName: string | undefined;
  revision: RevisionLocation | undefined;
}
export interface GetApplicationRevisionOutput {
  applicationName?: string;
  revision?: RevisionLocation;
  revisionInfo?: GenericRevisionInfo;
}
export interface GetDeploymentInput {
  deploymentId: string | undefined;
}
export interface GetDeploymentOutput {
  deploymentInfo?: DeploymentInfo;
}
export interface GetDeploymentConfigInput {
  deploymentConfigName: string | undefined;
}
export interface DeploymentConfigInfo {
  deploymentConfigId?: string;
  deploymentConfigName?: string;
  minimumHealthyHosts?: MinimumHealthyHosts;
  createTime?: Date;
  computePlatform?: ComputePlatform | string;
  trafficRoutingConfig?: TrafficRoutingConfig;
}
export interface GetDeploymentConfigOutput {
  deploymentConfigInfo?: DeploymentConfigInfo;
}
export interface GetDeploymentGroupInput {
  applicationName: string | undefined;
  deploymentGroupName: string | undefined;
}
export interface GetDeploymentGroupOutput {
  deploymentGroupInfo?: DeploymentGroupInfo;
}
export interface GetDeploymentInstanceInput {
  deploymentId: string | undefined;
  instanceId: string | undefined;
}
export interface GetDeploymentInstanceOutput {
  instanceSummary?: InstanceSummary;
}
export interface GetDeploymentTargetInput {
  deploymentId?: string;
  targetId?: string;
}
export interface GetDeploymentTargetOutput {
  deploymentTarget?: DeploymentTarget;
}
export interface GetOnPremisesInstanceInput {
  instanceName: string | undefined;
}
export interface GetOnPremisesInstanceOutput {
  instanceInfo?: InstanceInfo;
}
export declare class InvalidBucketNameFilterException extends __BaseException {
  readonly name: "InvalidBucketNameFilterException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidBucketNameFilterException,
      __BaseException
    >
  );
}
export declare class InvalidDeployedStateFilterException extends __BaseException {
  readonly name: "InvalidDeployedStateFilterException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidDeployedStateFilterException,
      __BaseException
    >
  );
}
export declare class InvalidKeyPrefixFilterException extends __BaseException {
  readonly name: "InvalidKeyPrefixFilterException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidKeyPrefixFilterException,
      __BaseException
    >
  );
}
export declare class InvalidNextTokenException extends __BaseException {
  readonly name: "InvalidNextTokenException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidNextTokenException, __BaseException>
  );
}
export declare class InvalidSortByException extends __BaseException {
  readonly name: "InvalidSortByException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidSortByException, __BaseException>
  );
}
export declare class InvalidSortOrderException extends __BaseException {
  readonly name: "InvalidSortOrderException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidSortOrderException, __BaseException>
  );
}
export declare enum ListStateFilterAction {
  Exclude = "exclude",
  Ignore = "ignore",
  Include = "include",
}
export declare enum SortOrder {
  Ascending = "ascending",
  Descending = "descending",
}
export interface ListApplicationRevisionsInput {
  applicationName: string | undefined;
  sortBy?: ApplicationRevisionSortBy | string;
  sortOrder?: SortOrder | string;
  s3Bucket?: string;
  s3KeyPrefix?: string;
  deployed?: ListStateFilterAction | string;
  nextToken?: string;
}
export interface ListApplicationRevisionsOutput {
  revisions?: RevisionLocation[];
  nextToken?: string;
}
export interface ListApplicationsInput {
  nextToken?: string;
}
export interface ListApplicationsOutput {
  applications?: string[];
  nextToken?: string;
}
export interface ListDeploymentConfigsInput {
  nextToken?: string;
}
export interface ListDeploymentConfigsOutput {
  deploymentConfigsList?: string[];
  nextToken?: string;
}
export interface ListDeploymentGroupsInput {
  applicationName: string | undefined;
  nextToken?: string;
}
export interface ListDeploymentGroupsOutput {
  applicationName?: string;
  deploymentGroups?: string[];
  nextToken?: string;
}
export declare class InvalidDeploymentInstanceTypeException extends __BaseException {
  readonly name: "InvalidDeploymentInstanceTypeException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidDeploymentInstanceTypeException,
      __BaseException
    >
  );
}
export declare class InvalidInstanceStatusException extends __BaseException {
  readonly name: "InvalidInstanceStatusException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidInstanceStatusException, __BaseException>
  );
}
export declare class InvalidInstanceTypeException extends __BaseException {
  readonly name: "InvalidInstanceTypeException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidInstanceTypeException, __BaseException>
  );
}
export declare class InvalidTargetFilterNameException extends __BaseException {
  readonly name: "InvalidTargetFilterNameException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidTargetFilterNameException,
      __BaseException
    >
  );
}
export interface ListDeploymentInstancesInput {
  deploymentId: string | undefined;
  nextToken?: string;
  instanceStatusFilter?: (InstanceStatus | string)[];
  instanceTypeFilter?: (_InstanceType | string)[];
}
export interface ListDeploymentInstancesOutput {
  instancesList?: string[];
  nextToken?: string;
}
export declare class InvalidExternalIdException extends __BaseException {
  readonly name: "InvalidExternalIdException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidExternalIdException, __BaseException>
  );
}
export declare class InvalidTimeRangeException extends __BaseException {
  readonly name: "InvalidTimeRangeException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidTimeRangeException, __BaseException>
  );
}
export interface TimeRange {
  start?: Date;
  end?: Date;
}
export interface ListDeploymentsInput {
  applicationName?: string;
  deploymentGroupName?: string;
  externalId?: string;
  includeOnlyStatuses?: (DeploymentStatus | string)[];
  createTimeRange?: TimeRange;
  nextToken?: string;
}
export interface ListDeploymentsOutput {
  deployments?: string[];
  nextToken?: string;
}
export declare enum TargetFilterName {
  SERVER_INSTANCE_LABEL = "ServerInstanceLabel",
  TARGET_STATUS = "TargetStatus",
}
export interface ListDeploymentTargetsInput {
  deploymentId?: string;
  nextToken?: string;
  targetFilters?: Record<string, string[]>;
}
export interface ListDeploymentTargetsOutput {
  targetIds?: string[];
  nextToken?: string;
}
export interface ListGitHubAccountTokenNamesInput {
  nextToken?: string;
}
export interface ListGitHubAccountTokenNamesOutput {
  tokenNameList?: string[];
  nextToken?: string;
}
export declare class InvalidRegistrationStatusException extends __BaseException {
  readonly name: "InvalidRegistrationStatusException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidRegistrationStatusException,
      __BaseException
    >
  );
}
export declare class InvalidTagFilterException extends __BaseException {
  readonly name: "InvalidTagFilterException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidTagFilterException, __BaseException>
  );
}
export declare enum RegistrationStatus {
  Deregistered = "Deregistered",
  Registered = "Registered",
}
export interface ListOnPremisesInstancesInput {
  registrationStatus?: RegistrationStatus | string;
  tagFilters?: TagFilter[];
  nextToken?: string;
}
export interface ListOnPremisesInstancesOutput {
  instanceNames?: string[];
  nextToken?: string;
}
export declare class InvalidArnException extends __BaseException {
  readonly name: "InvalidArnException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidArnException, __BaseException>
  );
}
export interface ListTagsForResourceInput {
  ResourceArn: string | undefined;
  NextToken?: string;
}
export interface ListTagsForResourceOutput {
  Tags?: Tag[];
  NextToken?: string;
}
export declare class ResourceArnRequiredException extends __BaseException {
  readonly name: "ResourceArnRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ResourceArnRequiredException, __BaseException>
  );
}
export declare class InvalidLifecycleEventHookExecutionIdException extends __BaseException {
  readonly name: "InvalidLifecycleEventHookExecutionIdException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidLifecycleEventHookExecutionIdException,
      __BaseException
    >
  );
}
export declare class InvalidLifecycleEventHookExecutionStatusException extends __BaseException {
  readonly name: "InvalidLifecycleEventHookExecutionStatusException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidLifecycleEventHookExecutionStatusException,
      __BaseException
    >
  );
}
export declare class LifecycleEventAlreadyCompletedException extends __BaseException {
  readonly name: "LifecycleEventAlreadyCompletedException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      LifecycleEventAlreadyCompletedException,
      __BaseException
    >
  );
}
export interface PutLifecycleEventHookExecutionStatusInput {
  deploymentId?: string;
  lifecycleEventHookExecutionId?: string;
  status?: LifecycleEventStatus | string;
}
export interface PutLifecycleEventHookExecutionStatusOutput {
  lifecycleEventHookExecutionId?: string;
}
export interface RegisterApplicationRevisionInput {
  applicationName: string | undefined;
  description?: string;
  revision: RevisionLocation | undefined;
}
export declare class IamArnRequiredException extends __BaseException {
  readonly name: "IamArnRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<IamArnRequiredException, __BaseException>
  );
}
export declare class IamSessionArnAlreadyRegisteredException extends __BaseException {
  readonly name: "IamSessionArnAlreadyRegisteredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      IamSessionArnAlreadyRegisteredException,
      __BaseException
    >
  );
}
export declare class IamUserArnAlreadyRegisteredException extends __BaseException {
  readonly name: "IamUserArnAlreadyRegisteredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      IamUserArnAlreadyRegisteredException,
      __BaseException
    >
  );
}
export declare class IamUserArnRequiredException extends __BaseException {
  readonly name: "IamUserArnRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<IamUserArnRequiredException, __BaseException>
  );
}
export declare class InstanceNameAlreadyRegisteredException extends __BaseException {
  readonly name: "InstanceNameAlreadyRegisteredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InstanceNameAlreadyRegisteredException,
      __BaseException
    >
  );
}
export declare class InvalidIamSessionArnException extends __BaseException {
  readonly name: "InvalidIamSessionArnException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidIamSessionArnException, __BaseException>
  );
}
export declare class InvalidIamUserArnException extends __BaseException {
  readonly name: "InvalidIamUserArnException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidIamUserArnException, __BaseException>
  );
}
export declare class MultipleIamArnsProvidedException extends __BaseException {
  readonly name: "MultipleIamArnsProvidedException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      MultipleIamArnsProvidedException,
      __BaseException
    >
  );
}
export interface RegisterOnPremisesInstanceInput {
  instanceName: string | undefined;
  iamSessionArn?: string;
  iamUserArn?: string;
}
export interface RemoveTagsFromOnPremisesInstancesInput {
  tags: Tag[] | undefined;
  instanceNames: string[] | undefined;
}
export interface SkipWaitTimeForInstanceTerminationInput {
  deploymentId?: string;
}
export interface StopDeploymentInput {
  deploymentId: string | undefined;
  autoRollbackEnabled?: boolean;
}
export declare enum StopStatus {
  PENDING = "Pending",
  SUCCEEDED = "Succeeded",
}
export interface StopDeploymentOutput {
  status?: StopStatus | string;
  statusMessage?: string;
}
export interface TagResourceInput {
  ResourceArn: string | undefined;
  Tags: Tag[] | undefined;
}
export interface TagResourceOutput {}
export interface UntagResourceInput {
  ResourceArn: string | undefined;
  TagKeys: string[] | undefined;
}
export interface UntagResourceOutput {}
export interface UpdateApplicationInput {
  applicationName?: string;
  newApplicationName?: string;
}
export interface UpdateDeploymentGroupInput {
  applicationName: string | undefined;
  currentDeploymentGroupName: string | undefined;
  newDeploymentGroupName?: string;
  deploymentConfigName?: string;
  ec2TagFilters?: EC2TagFilter[];
  onPremisesInstanceTagFilters?: TagFilter[];
  autoScalingGroups?: string[];
  serviceRoleArn?: string;
  triggerConfigurations?: TriggerConfig[];
  alarmConfiguration?: AlarmConfiguration;
  autoRollbackConfiguration?: AutoRollbackConfiguration;
  outdatedInstancesStrategy?: OutdatedInstancesStrategy | string;
  deploymentStyle?: DeploymentStyle;
  blueGreenDeploymentConfiguration?: BlueGreenDeploymentConfiguration;
  loadBalancerInfo?: LoadBalancerInfo;
  ec2TagSet?: EC2TagSet;
  ecsServices?: ECSService[];
  onPremisesTagSet?: OnPremisesTagSet;
}
export interface UpdateDeploymentGroupOutput {
  hooksNotCleanedUp?: AutoScalingGroup[];
}
export declare const TagFilterSensitiveLog: (obj: Tag) => any;
export declare const AddTagsToOnPremisesInstancesInputFilterSensitiveLog: (
  obj: AddTagsToOnPremisesInstancesInput
) => any;
export declare const AlarmFilterSensitiveLog: (obj: Alarm) => any;
export declare const AlarmConfigurationFilterSensitiveLog: (
  obj: AlarmConfiguration
) => any;
export declare const ApplicationInfoFilterSensitiveLog: (
  obj: ApplicationInfo
) => any;
export declare const AppSpecContentFilterSensitiveLog: (
  obj: AppSpecContent
) => any;
export declare const AutoRollbackConfigurationFilterSensitiveLog: (
  obj: AutoRollbackConfiguration
) => any;
export declare const AutoScalingGroupFilterSensitiveLog: (
  obj: AutoScalingGroup
) => any;
export declare const GitHubLocationFilterSensitiveLog: (
  obj: GitHubLocation
) => any;
export declare const S3LocationFilterSensitiveLog: (obj: S3Location) => any;
export declare const RawStringFilterSensitiveLog: (obj: RawString) => any;
export declare const RevisionLocationFilterSensitiveLog: (
  obj: RevisionLocation
) => any;
export declare const BatchGetApplicationRevisionsInputFilterSensitiveLog: (
  obj: BatchGetApplicationRevisionsInput
) => any;
export declare const GenericRevisionInfoFilterSensitiveLog: (
  obj: GenericRevisionInfo
) => any;
export declare const RevisionInfoFilterSensitiveLog: (obj: RevisionInfo) => any;
export declare const BatchGetApplicationRevisionsOutputFilterSensitiveLog: (
  obj: BatchGetApplicationRevisionsOutput
) => any;
export declare const BatchGetApplicationsInputFilterSensitiveLog: (
  obj: BatchGetApplicationsInput
) => any;
export declare const BatchGetApplicationsOutputFilterSensitiveLog: (
  obj: BatchGetApplicationsOutput
) => any;
export declare const BatchGetDeploymentGroupsInputFilterSensitiveLog: (
  obj: BatchGetDeploymentGroupsInput
) => any;
export declare const DeploymentReadyOptionFilterSensitiveLog: (
  obj: DeploymentReadyOption
) => any;
export declare const GreenFleetProvisioningOptionFilterSensitiveLog: (
  obj: GreenFleetProvisioningOption
) => any;
export declare const BlueInstanceTerminationOptionFilterSensitiveLog: (
  obj: BlueInstanceTerminationOption
) => any;
export declare const BlueGreenDeploymentConfigurationFilterSensitiveLog: (
  obj: BlueGreenDeploymentConfiguration
) => any;
export declare const DeploymentStyleFilterSensitiveLog: (
  obj: DeploymentStyle
) => any;
export declare const EC2TagFilterFilterSensitiveLog: (obj: EC2TagFilter) => any;
export declare const EC2TagSetFilterSensitiveLog: (obj: EC2TagSet) => any;
export declare const ECSServiceFilterSensitiveLog: (obj: ECSService) => any;
export declare const LastDeploymentInfoFilterSensitiveLog: (
  obj: LastDeploymentInfo
) => any;
export declare const ELBInfoFilterSensitiveLog: (obj: ELBInfo) => any;
export declare const TargetGroupInfoFilterSensitiveLog: (
  obj: TargetGroupInfo
) => any;
export declare const TrafficRouteFilterSensitiveLog: (obj: TrafficRoute) => any;
export declare const TargetGroupPairInfoFilterSensitiveLog: (
  obj: TargetGroupPairInfo
) => any;
export declare const LoadBalancerInfoFilterSensitiveLog: (
  obj: LoadBalancerInfo
) => any;
export declare const TagFilterFilterSensitiveLog: (obj: TagFilter) => any;
export declare const OnPremisesTagSetFilterSensitiveLog: (
  obj: OnPremisesTagSet
) => any;
export declare const TriggerConfigFilterSensitiveLog: (
  obj: TriggerConfig
) => any;
export declare const DeploymentGroupInfoFilterSensitiveLog: (
  obj: DeploymentGroupInfo
) => any;
export declare const BatchGetDeploymentGroupsOutputFilterSensitiveLog: (
  obj: BatchGetDeploymentGroupsOutput
) => any;
export declare const BatchGetDeploymentInstancesInputFilterSensitiveLog: (
  obj: BatchGetDeploymentInstancesInput
) => any;
export declare const DiagnosticsFilterSensitiveLog: (obj: Diagnostics) => any;
export declare const LifecycleEventFilterSensitiveLog: (
  obj: LifecycleEvent
) => any;
export declare const InstanceSummaryFilterSensitiveLog: (
  obj: InstanceSummary
) => any;
export declare const BatchGetDeploymentInstancesOutputFilterSensitiveLog: (
  obj: BatchGetDeploymentInstancesOutput
) => any;
export declare const BatchGetDeploymentsInputFilterSensitiveLog: (
  obj: BatchGetDeploymentsInput
) => any;
export declare const DeploymentOverviewFilterSensitiveLog: (
  obj: DeploymentOverview
) => any;
export declare const ErrorInformationFilterSensitiveLog: (
  obj: ErrorInformation
) => any;
export declare const RelatedDeploymentsFilterSensitiveLog: (
  obj: RelatedDeployments
) => any;
export declare const RollbackInfoFilterSensitiveLog: (obj: RollbackInfo) => any;
export declare const TargetInstancesFilterSensitiveLog: (
  obj: TargetInstances
) => any;
export declare const DeploymentInfoFilterSensitiveLog: (
  obj: DeploymentInfo
) => any;
export declare const BatchGetDeploymentsOutputFilterSensitiveLog: (
  obj: BatchGetDeploymentsOutput
) => any;
export declare const BatchGetDeploymentTargetsInputFilterSensitiveLog: (
  obj: BatchGetDeploymentTargetsInput
) => any;
export declare const CloudFormationTargetFilterSensitiveLog: (
  obj: CloudFormationTarget
) => any;
export declare const ECSTaskSetFilterSensitiveLog: (obj: ECSTaskSet) => any;
export declare const ECSTargetFilterSensitiveLog: (obj: ECSTarget) => any;
export declare const InstanceTargetFilterSensitiveLog: (
  obj: InstanceTarget
) => any;
export declare const LambdaFunctionInfoFilterSensitiveLog: (
  obj: LambdaFunctionInfo
) => any;
export declare const LambdaTargetFilterSensitiveLog: (obj: LambdaTarget) => any;
export declare const DeploymentTargetFilterSensitiveLog: (
  obj: DeploymentTarget
) => any;
export declare const BatchGetDeploymentTargetsOutputFilterSensitiveLog: (
  obj: BatchGetDeploymentTargetsOutput
) => any;
export declare const BatchGetOnPremisesInstancesInputFilterSensitiveLog: (
  obj: BatchGetOnPremisesInstancesInput
) => any;
export declare const InstanceInfoFilterSensitiveLog: (obj: InstanceInfo) => any;
export declare const BatchGetOnPremisesInstancesOutputFilterSensitiveLog: (
  obj: BatchGetOnPremisesInstancesOutput
) => any;
export declare const ContinueDeploymentInputFilterSensitiveLog: (
  obj: ContinueDeploymentInput
) => any;
export declare const CreateApplicationInputFilterSensitiveLog: (
  obj: CreateApplicationInput
) => any;
export declare const CreateApplicationOutputFilterSensitiveLog: (
  obj: CreateApplicationOutput
) => any;
export declare const CreateDeploymentInputFilterSensitiveLog: (
  obj: CreateDeploymentInput
) => any;
export declare const CreateDeploymentOutputFilterSensitiveLog: (
  obj: CreateDeploymentOutput
) => any;
export declare const MinimumHealthyHostsFilterSensitiveLog: (
  obj: MinimumHealthyHosts
) => any;
export declare const TimeBasedCanaryFilterSensitiveLog: (
  obj: TimeBasedCanary
) => any;
export declare const TimeBasedLinearFilterSensitiveLog: (
  obj: TimeBasedLinear
) => any;
export declare const TrafficRoutingConfigFilterSensitiveLog: (
  obj: TrafficRoutingConfig
) => any;
export declare const CreateDeploymentConfigInputFilterSensitiveLog: (
  obj: CreateDeploymentConfigInput
) => any;
export declare const CreateDeploymentConfigOutputFilterSensitiveLog: (
  obj: CreateDeploymentConfigOutput
) => any;
export declare const CreateDeploymentGroupInputFilterSensitiveLog: (
  obj: CreateDeploymentGroupInput
) => any;
export declare const CreateDeploymentGroupOutputFilterSensitiveLog: (
  obj: CreateDeploymentGroupOutput
) => any;
export declare const DeleteApplicationInputFilterSensitiveLog: (
  obj: DeleteApplicationInput
) => any;
export declare const DeleteDeploymentConfigInputFilterSensitiveLog: (
  obj: DeleteDeploymentConfigInput
) => any;
export declare const DeleteDeploymentGroupInputFilterSensitiveLog: (
  obj: DeleteDeploymentGroupInput
) => any;
export declare const DeleteDeploymentGroupOutputFilterSensitiveLog: (
  obj: DeleteDeploymentGroupOutput
) => any;
export declare const DeleteGitHubAccountTokenInputFilterSensitiveLog: (
  obj: DeleteGitHubAccountTokenInput
) => any;
export declare const DeleteGitHubAccountTokenOutputFilterSensitiveLog: (
  obj: DeleteGitHubAccountTokenOutput
) => any;
export declare const DeleteResourcesByExternalIdInputFilterSensitiveLog: (
  obj: DeleteResourcesByExternalIdInput
) => any;
export declare const DeleteResourcesByExternalIdOutputFilterSensitiveLog: (
  obj: DeleteResourcesByExternalIdOutput
) => any;
export declare const DeregisterOnPremisesInstanceInputFilterSensitiveLog: (
  obj: DeregisterOnPremisesInstanceInput
) => any;
export declare const GetApplicationInputFilterSensitiveLog: (
  obj: GetApplicationInput
) => any;
export declare const GetApplicationOutputFilterSensitiveLog: (
  obj: GetApplicationOutput
) => any;
export declare const GetApplicationRevisionInputFilterSensitiveLog: (
  obj: GetApplicationRevisionInput
) => any;
export declare const GetApplicationRevisionOutputFilterSensitiveLog: (
  obj: GetApplicationRevisionOutput
) => any;
export declare const GetDeploymentInputFilterSensitiveLog: (
  obj: GetDeploymentInput
) => any;
export declare const GetDeploymentOutputFilterSensitiveLog: (
  obj: GetDeploymentOutput
) => any;
export declare const GetDeploymentConfigInputFilterSensitiveLog: (
  obj: GetDeploymentConfigInput
) => any;
export declare const DeploymentConfigInfoFilterSensitiveLog: (
  obj: DeploymentConfigInfo
) => any;
export declare const GetDeploymentConfigOutputFilterSensitiveLog: (
  obj: GetDeploymentConfigOutput
) => any;
export declare const GetDeploymentGroupInputFilterSensitiveLog: (
  obj: GetDeploymentGroupInput
) => any;
export declare const GetDeploymentGroupOutputFilterSensitiveLog: (
  obj: GetDeploymentGroupOutput
) => any;
export declare const GetDeploymentInstanceInputFilterSensitiveLog: (
  obj: GetDeploymentInstanceInput
) => any;
export declare const GetDeploymentInstanceOutputFilterSensitiveLog: (
  obj: GetDeploymentInstanceOutput
) => any;
export declare const GetDeploymentTargetInputFilterSensitiveLog: (
  obj: GetDeploymentTargetInput
) => any;
export declare const GetDeploymentTargetOutputFilterSensitiveLog: (
  obj: GetDeploymentTargetOutput
) => any;
export declare const GetOnPremisesInstanceInputFilterSensitiveLog: (
  obj: GetOnPremisesInstanceInput
) => any;
export declare const GetOnPremisesInstanceOutputFilterSensitiveLog: (
  obj: GetOnPremisesInstanceOutput
) => any;
export declare const ListApplicationRevisionsInputFilterSensitiveLog: (
  obj: ListApplicationRevisionsInput
) => any;
export declare const ListApplicationRevisionsOutputFilterSensitiveLog: (
  obj: ListApplicationRevisionsOutput
) => any;
export declare const ListApplicationsInputFilterSensitiveLog: (
  obj: ListApplicationsInput
) => any;
export declare const ListApplicationsOutputFilterSensitiveLog: (
  obj: ListApplicationsOutput
) => any;
export declare const ListDeploymentConfigsInputFilterSensitiveLog: (
  obj: ListDeploymentConfigsInput
) => any;
export declare const ListDeploymentConfigsOutputFilterSensitiveLog: (
  obj: ListDeploymentConfigsOutput
) => any;
export declare const ListDeploymentGroupsInputFilterSensitiveLog: (
  obj: ListDeploymentGroupsInput
) => any;
export declare const ListDeploymentGroupsOutputFilterSensitiveLog: (
  obj: ListDeploymentGroupsOutput
) => any;
export declare const ListDeploymentInstancesInputFilterSensitiveLog: (
  obj: ListDeploymentInstancesInput
) => any;
export declare const ListDeploymentInstancesOutputFilterSensitiveLog: (
  obj: ListDeploymentInstancesOutput
) => any;
export declare const TimeRangeFilterSensitiveLog: (obj: TimeRange) => any;
export declare const ListDeploymentsInputFilterSensitiveLog: (
  obj: ListDeploymentsInput
) => any;
export declare const ListDeploymentsOutputFilterSensitiveLog: (
  obj: ListDeploymentsOutput
) => any;
export declare const ListDeploymentTargetsInputFilterSensitiveLog: (
  obj: ListDeploymentTargetsInput
) => any;
export declare const ListDeploymentTargetsOutputFilterSensitiveLog: (
  obj: ListDeploymentTargetsOutput
) => any;
export declare const ListGitHubAccountTokenNamesInputFilterSensitiveLog: (
  obj: ListGitHubAccountTokenNamesInput
) => any;
export declare const ListGitHubAccountTokenNamesOutputFilterSensitiveLog: (
  obj: ListGitHubAccountTokenNamesOutput
) => any;
export declare const ListOnPremisesInstancesInputFilterSensitiveLog: (
  obj: ListOnPremisesInstancesInput
) => any;
export declare const ListOnPremisesInstancesOutputFilterSensitiveLog: (
  obj: ListOnPremisesInstancesOutput
) => any;
export declare const ListTagsForResourceInputFilterSensitiveLog: (
  obj: ListTagsForResourceInput
) => any;
export declare const ListTagsForResourceOutputFilterSensitiveLog: (
  obj: ListTagsForResourceOutput
) => any;
export declare const PutLifecycleEventHookExecutionStatusInputFilterSensitiveLog: (
  obj: PutLifecycleEventHookExecutionStatusInput
) => any;
export declare const PutLifecycleEventHookExecutionStatusOutputFilterSensitiveLog: (
  obj: PutLifecycleEventHookExecutionStatusOutput
) => any;
export declare const RegisterApplicationRevisionInputFilterSensitiveLog: (
  obj: RegisterApplicationRevisionInput
) => any;
export declare const RegisterOnPremisesInstanceInputFilterSensitiveLog: (
  obj: RegisterOnPremisesInstanceInput
) => any;
export declare const RemoveTagsFromOnPremisesInstancesInputFilterSensitiveLog: (
  obj: RemoveTagsFromOnPremisesInstancesInput
) => any;
export declare const SkipWaitTimeForInstanceTerminationInputFilterSensitiveLog: (
  obj: SkipWaitTimeForInstanceTerminationInput
) => any;
export declare const StopDeploymentInputFilterSensitiveLog: (
  obj: StopDeploymentInput
) => any;
export declare const StopDeploymentOutputFilterSensitiveLog: (
  obj: StopDeploymentOutput
) => any;
export declare const TagResourceInputFilterSensitiveLog: (
  obj: TagResourceInput
) => any;
export declare const TagResourceOutputFilterSensitiveLog: (
  obj: TagResourceOutput
) => any;
export declare const UntagResourceInputFilterSensitiveLog: (
  obj: UntagResourceInput
) => any;
export declare const UntagResourceOutputFilterSensitiveLog: (
  obj: UntagResourceOutput
) => any;
export declare const UpdateApplicationInputFilterSensitiveLog: (
  obj: UpdateApplicationInput
) => any;
export declare const UpdateDeploymentGroupInputFilterSensitiveLog: (
  obj: UpdateDeploymentGroupInput
) => any;
export declare const UpdateDeploymentGroupOutputFilterSensitiveLog: (
  obj: UpdateDeploymentGroupOutput
) => any;
