/*
 * Decompiled with CFR 0.152.
 */
package org.mowl.WRO;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class WROEval
implements Runnable {
    ArrayList<String> pair;
    int k;
    ArrayList<ArrayList<String>> groundTruth;
    ArrayList<ArrayList<String>> predictions;
    ArrayList<String> subjects;
    HashMap<String, Integer> dict_subj_hits;
    HashMap<String, HashMap<Float, Integer>> dict_subj_ranks;
    private static Object lock = new Object();

    public static void main(String[] args) {
    }

    public WROEval(ArrayList<String> pair, int k, ArrayList<ArrayList<String>> groundTruth, ArrayList<ArrayList<String>> predictions, ArrayList<String> subjects, HashMap<String, Integer> dict_subj_hits, HashMap<String, HashMap<Float, Integer>> dict_subj_ranks) {
        this.pair = pair;
        this.k = k;
        this.groundTruth = groundTruth;
        this.predictions = predictions;
        this.subjects = subjects;
        this.dict_subj_hits = dict_subj_hits;
        this.dict_subj_ranks = dict_subj_ranks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String subj = this.pair.get(0);
        if (this.dict_subj_hits.containsKey(subj)) {
            return;
        }
        Set grouped_pairs_gt = this.groundTruth.stream().filter(x -> ((String)x.get(0)).equals(subj)).map(x -> new Pair((ArrayList<String>)x)).collect(Collectors.toSet());
        Set grouped_pairs_pred = this.predictions.stream().filter(x -> ((String)x.get(0)).equals(subj)).map(x -> new Pair((String)x.get(0), (String)x.get(1), (String)x.get(2))).collect(Collectors.toSet());
        Set grouped_pairs_pred_aux = grouped_pairs_pred.stream().map(x -> new Pair(x.subj, x.obj, 0.0f)).collect(Collectors.toSet());
        HashSet<Pair> all_pairs = new HashSet<Pair>();
        for (int i = 0; i < this.subjects.size(); ++i) {
            all_pairs.add(new Pair(subj, this.subjects.get(i), 0.0f));
        }
        all_pairs.removeAll(grouped_pairs_pred_aux);
        all_pairs.addAll(grouped_pairs_pred);
        ArrayList grouped_pairs_gt_list = new ArrayList(grouped_pairs_gt);
        ArrayList all_pairs_list = new ArrayList(all_pairs);
        List<Float> scores = all_pairs.stream().map(x -> Float.valueOf(-x.score)).collect(Collectors.toList());
        float[] ranking = this.rankify(scores, scores.size());
        int hits = 0;
        HashMap<Float, Integer> ranks = new HashMap<Float, Integer>();
        for (int i = 0; i < grouped_pairs_gt.size(); ++i) {
            Pair grouped_pair = (Pair)grouped_pairs_gt_list.get(i);
            int idx = all_pairs_list.indexOf(grouped_pair);
            float rank = ranking[idx];
            if (rank <= (float)this.k) {
                ++hits;
            }
            if (!ranks.containsKey(Float.valueOf(rank))) {
                ranks.put(Float.valueOf(rank), 0);
            }
            ranks.put(Float.valueOf(rank), (Integer)ranks.get(Float.valueOf(rank)) + 1);
        }
        Object object = lock;
        synchronized (object) {
            this.dict_subj_hits.put(subj, hits);
            this.dict_subj_ranks.put(subj, ranks);
        }
    }

    public List<Integer> rank_simple(List<Float> vector, int n) {
        ArrayList<Integer> toOrder = new ArrayList<Integer>();
        for (int i = 0; i < n; ++i) {
            toOrder.add(i);
        }
        toOrder.sort(Comparator.comparingInt(vector::indexOf));
        return toOrder;
    }

    public float[] rankify(List<Float> A, int n) {
        List<Integer> ivec = this.rank_simple(A, n);
        List svec = ivec.stream().map(rank -> (Float)A.get((int)rank)).collect(Collectors.toList());
        int sumranks = 0;
        int dupcount = 0;
        float[] newarray = new float[n];
        for (int i = 0; i < n; ++i) {
            sumranks += i;
            ++dupcount;
            if (i != n - 1 && svec.get(i) == svec.get(i + 1)) continue;
            float averank = (float)sumranks / (float)dupcount + 1.0f;
            for (int j = i - dupcount + 1; j < i + 1; ++j) {
                newarray[ivec.get((int)j).intValue()] = averank;
            }
            sumranks = 0;
            dupcount = 0;
        }
        return newarray;
    }

    private class Pair
    implements Comparable<Pair> {
        String subj;
        String obj;
        float score;

        public Pair(String subj, String obj, float score) {
            this.subj = subj;
            this.obj = obj;
            this.score = score;
        }

        public Pair(String subj, String obj, String score) {
            this.subj = subj;
            this.obj = obj;
            this.score = Float.parseFloat(score);
        }

        public Pair(ArrayList<String> data) {
            this.subj = data.get(0);
            this.obj = data.get(1);
            this.score = Float.parseFloat(data.get(2));
        }

        public String toString() {
            return "(" + this.subj + ", " + this.obj + ", " + String.valueOf(this.score) + ")";
        }

        @Override
        public int compareTo(Pair other) {
            int subjects = this.subj.compareTo(other.subj);
            int objects = this.obj.compareTo(other.obj);
            return subjects * objects;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Pair other = (Pair)o;
            return this.subj.equals(other.subj) && this.obj.equals(other.obj);
        }

        public int hashCode() {
            return this.subj.hashCode() * this.obj.hashCode();
        }
    }
}

