/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import java.io.InputStream;
import java.io.Reader;
import java.util.Iterator;
import org.apache.jena.atlas.io.PeekReader;
import org.apache.jena.atlas.json.io.parser.TokenizerJSON;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.lang.LangNQuads;
import org.apache.jena.riot.lang.LangNTriples;
import org.apache.jena.riot.lang.LangRDFJSON;
import org.apache.jena.riot.lang.LangRIOT;
import org.apache.jena.riot.lang.LangTriG;
import org.apache.jena.riot.lang.LangTurtle;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.tokens.Tokenizer;
import org.apache.jena.riot.tokens.TokenizerText;
import org.apache.jena.sparql.core.Quad;

public class RiotParsers {
    private RiotParsers() {
    }

    public static LangRIOT createParser(InputStream input, Lang lang, StreamRDF dest, ParserProfile profile) {
        if (RDFLanguages.sameLang(RDFLanguages.RDFJSON, lang)) {
            TokenizerJSON tokenizer = new TokenizerJSON(PeekReader.makeUTF8((InputStream)input));
            return RiotParsers.createParserRdfJson(tokenizer, dest, profile);
        }
        Tokenizer tokenizer = TokenizerText.create().source(input).errorHandler(profile.getErrorHandler()).build();
        if (RDFLanguages.sameLang(RDFLanguages.TURTLE, lang) || RDFLanguages.sameLang(RDFLanguages.N3, lang)) {
            return RiotParsers.createParserTurtle(tokenizer, dest, profile);
        }
        if (RDFLanguages.sameLang(RDFLanguages.NTRIPLES, lang)) {
            return RiotParsers.createParserNTriples(tokenizer, dest, profile);
        }
        if (RDFLanguages.sameLang(RDFLanguages.NQUADS, lang)) {
            return RiotParsers.createParserNQuads(tokenizer, dest, profile);
        }
        if (RDFLanguages.sameLang(RDFLanguages.TRIG, lang)) {
            return RiotParsers.createParserTriG(tokenizer, dest, profile);
        }
        return null;
    }

    public static LangRIOT createParser(Reader input, Lang lang, StreamRDF dest, ParserProfile profile) {
        if (RDFLanguages.sameLang(RDFLanguages.RDFJSON, lang)) {
            TokenizerJSON tokenizer = new TokenizerJSON(PeekReader.make((Reader)input));
            return RiotParsers.createParserRdfJson(tokenizer, dest, profile);
        }
        Tokenizer tokenizer = TokenizerText.create().source(input).errorHandler(profile.getErrorHandler()).build();
        if (RDFLanguages.sameLang(RDFLanguages.TURTLE, lang) || RDFLanguages.sameLang(RDFLanguages.N3, lang)) {
            return RiotParsers.createParserTurtle(tokenizer, dest, profile);
        }
        if (RDFLanguages.sameLang(RDFLanguages.NTRIPLES, lang)) {
            return RiotParsers.createParserNTriples(tokenizer, dest, profile);
        }
        if (RDFLanguages.sameLang(RDFLanguages.NQUADS, lang)) {
            return RiotParsers.createParserNQuads(tokenizer, dest, profile);
        }
        if (RDFLanguages.sameLang(RDFLanguages.TRIG, lang)) {
            return RiotParsers.createParserTriG(tokenizer, dest, profile);
        }
        return null;
    }

    public static LangNTriples createParserNTriples(Tokenizer tokenizer, StreamRDF dest, ParserProfile profile) {
        LangNTriples parser = new LangNTriples(tokenizer, profile, dest);
        return parser;
    }

    public static LangNQuads createParserNQuads(Tokenizer tokenizer, StreamRDF dest, ParserProfile profile) {
        LangNQuads parser = new LangNQuads(tokenizer, profile, dest);
        return parser;
    }

    static LangTurtle createParserTurtle(Tokenizer tokenizer, StreamRDF dest, ParserProfile profile) {
        LangTurtle parser = new LangTurtle(tokenizer, profile, dest);
        return parser;
    }

    static LangTriG createParserTriG(Tokenizer tokenizer, StreamRDF dest, ParserProfile profile) {
        LangTriG parser = new LangTriG(tokenizer, profile, dest);
        return parser;
    }

    static LangRDFJSON createParserRdfJson(Tokenizer tokenizer, StreamRDF dest, ParserProfile profile) {
        LangRDFJSON parser = new LangRDFJSON(tokenizer, profile, dest);
        return parser;
    }

    public static Iterator<Triple> createIteratorNTriples(InputStream input, StreamRDF dest) {
        return RiotParsers.createIteratorNTriples(input, dest, RiotLib.dftProfile());
    }

    public static Iterator<Triple> createIteratorNTriples(InputStream input, StreamRDF dest, ParserProfile profile) {
        Tokenizer tokenizer = TokenizerText.create().source(input).errorHandler(profile.getErrorHandler()).build();
        return RiotParsers.createParserNTriples(tokenizer, null, profile);
    }

    public static Iterator<Quad> createIteratorNQuads(InputStream input, StreamRDF dest) {
        return RiotParsers.createIteratorNQuads(input, dest, RiotLib.dftProfile());
    }

    public static Iterator<Quad> createIteratorNQuads(InputStream input, StreamRDF dest, ParserProfile profile) {
        Tokenizer tokenizer = TokenizerText.create().source(input).errorHandler(profile.getErrorHandler()).build();
        return RiotParsers.createParserNQuads(tokenizer, null, profile);
    }
}

