/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

public class RiotChars {
    public static boolean isAlpha(int codepoint) {
        return Character.isLetter(codepoint);
    }

    public static boolean isAlphaNumeric(int codepoint) {
        return Character.isLetterOrDigit(codepoint);
    }

    public static boolean isA2Z(int ch) {
        return RiotChars.range(ch, 97, 122) || RiotChars.range(ch, 65, 90);
    }

    public static boolean isA2ZN(int ch) {
        return RiotChars.range(ch, 97, 122) || RiotChars.range(ch, 65, 90) || RiotChars.range(ch, 48, 57);
    }

    public static boolean isDigit(int ch) {
        return RiotChars.range(ch, 48, 57);
    }

    public static boolean isWhitespace(int ch) {
        return RiotChars.isHorizontalWhitespace(ch) || RiotChars.isNewlineChar(ch) || ch == 12;
    }

    public static boolean isHorizontalWhitespace(int ch) {
        return ch == 32 || ch == 9;
    }

    public static boolean isNewlineChar(int ch) {
        return ch == 13 || ch == 10;
    }

    public static boolean isPNCharsBase(int ch) {
        return RiotChars.r(ch, 97, 122) || RiotChars.r(ch, 65, 90) || RiotChars.r(ch, 192, 214) || RiotChars.r(ch, 216, 246) || RiotChars.r(ch, 248, 767) || RiotChars.r(ch, 880, 893) || RiotChars.r(ch, 895, 8191) || RiotChars.r(ch, 8204, 8205) || RiotChars.r(ch, 8304, 8591) || RiotChars.r(ch, 11264, 12271) || RiotChars.r(ch, 12289, 55295) || RiotChars.r(ch, 55296, 57343) || RiotChars.r(ch, 63744, 64975) || RiotChars.r(ch, 65008, 65533) || RiotChars.r(ch, 65536, 983039);
    }

    public static boolean isPNChars_U(int ch) {
        return RiotChars.isPNCharsBase(ch) || ch == 95;
    }

    public static boolean isPNChars_U_N(int ch) {
        return RiotChars.isPNCharsBase(ch) || ch == 95 || RiotChars.isDigit(ch);
    }

    public static boolean isPNChars(int ch) {
        return RiotChars.isPNChars_U(ch) || RiotChars.isDigit(ch) || ch == 45 || ch == 183 || RiotChars.r(ch, 768, 879) || RiotChars.r(ch, 8255, 8256);
    }

    public static boolean isPN_LOCAL_ESC(char ch) {
        switch (ch) {
            case '!': 
            case '#': 
            case '$': 
            case '%': 
            case '&': 
            case '\'': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case ',': 
            case '-': 
            case '.': 
            case '/': 
            case ';': 
            case '=': 
            case '?': 
            case '@': 
            case '_': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    public static boolean isHexChar(int ch) {
        return RiotChars.range(ch, 48, 57) || RiotChars.range(ch, 97, 102) || RiotChars.range(ch, 65, 70);
    }

    public static boolean isHexCharLC(int ch) {
        return RiotChars.range(ch, 48, 57) || RiotChars.range(ch, 97, 102);
    }

    public static boolean isHexCharUC(int ch) {
        return RiotChars.range(ch, 48, 57) || RiotChars.range(ch, 65, 70);
    }

    public static int valHexChar(int ch) {
        if (RiotChars.range(ch, 48, 57)) {
            return ch - 48;
        }
        if (RiotChars.range(ch, 97, 102)) {
            return ch - 97 + 10;
        }
        if (RiotChars.range(ch, 65, 70)) {
            return ch - 65 + 10;
        }
        return -1;
    }

    private static boolean r(int ch, int a, int b) {
        return ch >= a && ch <= b;
    }

    public static boolean range(int ch, int a, int b) {
        return ch >= a && ch <= b;
    }
}

