/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.context;

import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class ContextStatistics {
    public int countCreatedContexts;
    public int countProcessedContexts;
    public int countModifiedContexts;
    public long timeContextProcess;
    private int addCounter_ = 0;

    public void reset() {
        this.addCounter_ = 0;
        this.countCreatedContexts = 0;
        this.countProcessedContexts = 0;
        this.countModifiedContexts = 0;
        this.timeContextProcess = 0L;
    }

    public synchronized void add(ContextStatistics stats) {
        ++this.addCounter_;
        this.countCreatedContexts += stats.countCreatedContexts;
        this.countProcessedContexts += stats.countProcessedContexts;
        this.countModifiedContexts += stats.countModifiedContexts;
        this.timeContextProcess += stats.timeContextProcess;
    }

    public void print(Logger logger, Priority level) {
        if (!logger.isDebugEnabled() || this.addCounter_ <= 0) {
            return;
        }
        if (this.countCreatedContexts > 0) {
            logger.log(level, (Object)("Contexts created: " + this.countCreatedContexts));
        }
        if (this.countProcessedContexts > 0) {
            logger.log(level, (Object)("Contexts processed: " + this.countProcessedContexts + " (" + this.timeContextProcess / (long)this.addCounter_ + " ms)"));
        }
        if (this.countModifiedContexts > 0) {
            logger.log(level, (Object)("Contexts modified: " + this.countModifiedContexts));
        }
    }

    public void check(Logger logger) {
        if (this.countCreatedContexts > this.countProcessedContexts) {
            logger.error((Object)"More contexts than context activations!");
        }
    }
}

