/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.properties;

import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import org.apache.log4j.Logger;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedBinaryPropertyChain;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectProperty;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedPropertyChain;
import org.semanticweb.elk.reasoner.indexing.visitors.IndexedPropertyChainVisitor;
import org.semanticweb.elk.reasoner.saturation.properties.SaturatedPropertyChain;
import org.semanticweb.elk.util.collections.ArrayHashSet;

class SubPropertyExplorer
implements IndexedPropertyChainVisitor<Void> {
    private static final Logger LOGGER_ = Logger.getLogger(SubPropertyExplorer.class);
    private final Set<IndexedPropertyChain> allSubProperties_ = new ArrayHashSet();
    private final Queue<IndexedPropertyChain> toDoSubProperties_ = new LinkedList<IndexedPropertyChain>();
    private final Set<IndexedPropertyChain> relevantSubProperties_ = new ArrayHashSet();
    private static final IndexedPropertyChainVisitor<Set<IndexedPropertyChain>> SUB_PROPERTY_FINDER_ = new IndexedPropertyChainVisitor<Set<IndexedPropertyChain>>(){

        @Override
        public Set<IndexedPropertyChain> visit(IndexedObjectProperty element) {
            return SubPropertyExplorer.getSetRelevantSubProperties(element);
        }

        @Override
        public Set<IndexedPropertyChain> visit(IndexedBinaryPropertyChain element) {
            return SubPropertyExplorer.getRelevantSubProperties(element);
        }
    };

    SubPropertyExplorer(IndexedPropertyChain element) {
        this.toDo(element);
    }

    @Override
    public Void visit(IndexedObjectProperty element) {
        for (IndexedPropertyChain sub : element.getToldSubProperties()) {
            this.toDo(sub);
        }
        return null;
    }

    @Override
    public Void visit(IndexedBinaryPropertyChain element) {
        IndexedObjectProperty left = element.getLeftProperty();
        IndexedPropertyChain right = element.getRightProperty();
        SaturatedPropertyChain leftSaturation = left.getSaturated();
        SaturatedPropertyChain rightSaturation = right.getSaturated();
        if (leftSaturation != null && leftSaturation.isDerivedReflexive()) {
            this.toDo(right);
        }
        if (rightSaturation != null && rightSaturation.isDerivedReflexive()) {
            this.toDo(left);
        }
        return null;
    }

    private void toDo(IndexedPropertyChain element) {
        if (this.allSubProperties_.add(element)) {
            this.toDoSubProperties_.add(element);
            if (SaturatedPropertyChain.isRelevant(element)) {
                this.relevantSubProperties_.add(element);
            }
        }
    }

    private void doAll() {
        IndexedPropertyChain next;
        while ((next = this.toDoSubProperties_.poll()) != null) {
            next.accept(this);
        }
    }

    private Set<IndexedPropertyChain> getRelevantSubProperties() {
        this.doAll();
        return this.relevantSubProperties_;
    }

    static Set<IndexedPropertyChain> getSetRelevantSubProperties(IndexedPropertyChain element) {
        return element.accept(SUB_PROPERTY_FINDER_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Set<IndexedPropertyChain> getSetRelevantSubProperties(IndexedObjectProperty element) {
        SaturatedPropertyChain saturation;
        SaturatedPropertyChain saturatedPropertyChain = saturation = SaturatedPropertyChain.getCreate(element);
        synchronized (saturatedPropertyChain) {
            if (saturation.derivedSubProperties == null) {
                saturation.derivedSubProperties = SubPropertyExplorer.getRelevantSubProperties(element);
            }
        }
        return saturation.derivedSubProperties;
    }

    static Set<IndexedPropertyChain> getRelevantSubProperties(IndexedPropertyChain property) {
        Set<IndexedPropertyChain> result = new SubPropertyExplorer(property).getRelevantSubProperties();
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)(property + " relevant subproperties: " + result));
        }
        return result;
    }
}

