/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import java.util.Iterator;
import org.apache.log4j.Logger;
import org.semanticweb.elk.reasoner.saturation.conclusions.ConclusionVisitor;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerStage;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerState;
import org.semanticweb.elk.reasoner.stages.ElkInterruptedException;

class ContextInitializationStage
extends AbstractReasonerStage {
    private static final Logger LOGGER_ = Logger.getLogger(ContextInitializationStage.class);
    private int deletedContexts_;
    private int maxContexts_;
    private Iterator<Context> todo_ = null;

    public ContextInitializationStage(AbstractReasonerState reasoner, AbstractReasonerStage ... preStages) {
        super(reasoner, preStages);
    }

    @Override
    public String getName() {
        return "Context Initialization";
    }

    @Override
    public boolean preExecute() {
        if (!super.preExecute()) {
            return false;
        }
        this.todo_ = this.reasoner.saturationState.getContexts().iterator();
        this.maxContexts_ = this.reasoner.ontologyIndex.getIndexedClassExpressions().size();
        this.deletedContexts_ = 0;
        return true;
    }

    @Override
    public void executeStage() throws ElkInterruptedException {
        while (true) {
            this.checkInterrupt();
            if (!this.todo_.hasNext()) {
                return;
            }
            Context context = this.todo_.next();
            context.getRoot().resetContext();
            ++this.deletedContexts_;
            this.progressMonitor.report(this.deletedContexts_, this.maxContexts_);
        }
    }

    @Override
    public boolean postExecute() {
        if (!super.postExecute()) {
            return false;
        }
        this.reasoner.saturationState.getWriter(ConclusionVisitor.DUMMY).resetContexts();
        return true;
    }

    @Override
    public boolean dispose() {
        if (!super.dispose()) {
            return false;
        }
        this.todo_ = null;
        return true;
    }

    @Override
    public void printInfo() {
        if (this.deletedContexts_ > 0 && LOGGER_.isDebugEnabled()) {
            LOGGER_.debug((Object)("Contexts deleted:" + this.deletedContexts_));
        }
    }
}

