/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.semanticweb.elk.owl.exceptions.ElkException;
import org.semanticweb.elk.reasoner.incremental.IncrementalStages;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClassEntity;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClassExpression;
import org.semanticweb.elk.reasoner.saturation.conclusions.ConclusionVisitor;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerStage;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerState;
import org.semanticweb.elk.reasoner.taxonomy.TaxonomyCleaning;
import org.semanticweb.elk.util.collections.Operations;
import org.semanticweb.elk.util.concurrent.computation.Interrupter;

public class IncrementalTaxonomyCleaningStage
extends AbstractReasonerStage {
    private static final Logger LOGGER_ = Logger.getLogger(IncrementalTaxonomyCleaningStage.class);
    private TaxonomyCleaning cleaning_ = null;

    public IncrementalTaxonomyCleaningStage(AbstractReasonerState reasoner, AbstractReasonerStage ... preStages) {
        super(reasoner, preStages);
    }

    @Override
    public String getName() {
        return IncrementalStages.TAXONOMY_CLEANING.toString();
    }

    @Override
    public boolean preExecute() {
        if (!super.preExecute()) {
            return false;
        }
        ContextRootCollection modified = new ContextRootCollection(this.reasoner.saturationState.getNotSaturatedContexts());
        ContextRootCollection removedClasses = new ContextRootCollection(this.reasoner.classTaxonomyState.removedClasses);
        ContextRootCollection removedIndividuals = new ContextRootCollection(this.reasoner.instanceTaxonomyState.getRemovedIndividuals());
        Collection inputs = Operations.getCollection((Iterable)Operations.concat((Iterable)Operations.concat((Iterable)removedClasses, (Iterable)modified), (Iterable)removedIndividuals), (int)(removedClasses.size() + modified.size() + removedIndividuals.size()));
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)("Taxonomy nodes to be cleaned for modified contexts: " + modified));
            LOGGER_.trace((Object)("Class taxonomy nodes to be cleaned for removed classes: " + removedClasses));
            LOGGER_.trace((Object)("Instance taxonomy nodes to be cleaned for removed individuals: " + removedIndividuals));
        }
        this.cleaning_ = new TaxonomyCleaning(inputs, this.reasoner.classTaxonomyState, this.reasoner.instanceTaxonomyState, this.reasoner.getProcessExecutor(), this.workerNo, this.progressMonitor);
        return true;
    }

    @Override
    public void executeStage() throws ElkException {
        if (this.reasoner.classTaxonomyState.getTaxonomy() == null) {
            return;
        }
        this.cleaning_.process();
    }

    @Override
    public boolean postExecute() {
        if (!super.postExecute()) {
            return false;
        }
        this.reasoner.saturationState.getWriter(ConclusionVisitor.DUMMY).clearNotSaturatedContexts();
        this.reasoner.classTaxonomyState.getWriter().clearRemovedClasses();
        this.reasoner.instanceTaxonomyState.getWriter().clearRemovedIndividuals();
        return true;
    }

    @Override
    public boolean dispose() {
        if (!super.dispose()) {
            return false;
        }
        this.cleaning_ = null;
        return true;
    }

    @Override
    public void printInfo() {
    }

    public void setInterrupt(boolean flag) {
        super.setInterrupt(flag);
        this.setInterrupt((Interrupter)this.cleaning_, flag);
    }

    private static class ContextRootCollection
    extends AbstractCollection<IndexedClassEntity> {
        private final Collection<? extends IndexedClassExpression> ices_;

        ContextRootCollection(Collection<? extends IndexedClassExpression> ices) {
            this.ices_ = ices;
        }

        @Override
        public Iterator<IndexedClassEntity> iterator() {
            return new Iterator<IndexedClassEntity>(){
                private IndexedClassEntity curr_ = null;
                private final Iterator<? extends IndexedClassExpression> iter_ = ContextRootCollection.access$000(ContextRootCollection.this).iterator();

                @Override
                public boolean hasNext() {
                    if (this.curr_ != null) {
                        return true;
                    }
                    while (this.curr_ == null && this.iter_.hasNext()) {
                        IndexedClassExpression expr = this.iter_.next();
                        if (!(expr instanceof IndexedClassEntity)) continue;
                        this.curr_ = (IndexedClassEntity)expr;
                    }
                    return this.curr_ != null;
                }

                @Override
                public IndexedClassEntity next() {
                    IndexedClassEntity tmp = this.curr_;
                    this.curr_ = null;
                    return tmp;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            return this.ices_.size();
        }

        static /* synthetic */ Collection access$000(ContextRootCollection x0) {
            return x0.ices_;
        }
    }
}

