/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.core.algorithm.cel;

import de.tudresden.inf.lat.jcel.core.algorithm.cel.CelExtendedOntology;
import de.tudresden.inf.lat.jcel.core.algorithm.cel.ExistentialEntry;
import de.tudresden.inf.lat.jcel.core.algorithm.cel.ExtensionEntry;
import de.tudresden.inf.lat.jcel.core.algorithm.cel.ImplicationEntry;
import de.tudresden.inf.lat.jcel.core.algorithm.common.Processor;
import de.tudresden.inf.lat.jcel.core.algorithm.common.UnclassifiedOntologyException;
import de.tudresden.inf.lat.jcel.core.graph.IntegerBinaryRelation;
import de.tudresden.inf.lat.jcel.core.graph.IntegerHierarchicalGraph;
import de.tudresden.inf.lat.jcel.core.graph.IntegerHierarchicalGraphImpl;
import de.tudresden.inf.lat.jcel.core.graph.IntegerRelationMapImpl;
import de.tudresden.inf.lat.jcel.core.graph.IntegerSubsumerGraph;
import de.tudresden.inf.lat.jcel.core.graph.IntegerSubsumerGraphImpl;
import de.tudresden.inf.lat.jcel.coreontology.axiom.NormalizedIntegerAxiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.NormalizedIntegerAxiomFactory;
import de.tudresden.inf.lat.jcel.coreontology.axiom.RI2Axiom;
import de.tudresden.inf.lat.jcel.coreontology.datatype.IntegerEntityManager;
import de.tudresden.inf.lat.jcel.coreontology.datatype.IntegerEntityType;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;

public class CelProcessor
implements Processor {
    private static final Integer bottomClassId = IntegerEntityManager.bottomClassId;
    private static final Integer bottomObjectPropertyId = IntegerEntityManager.bottomObjectPropertyId;
    private static final Logger logger = Logger.getLogger(CelProcessor.class.getName());
    private static final Integer topClassId = IntegerEntityManager.topClassId;
    private static final Integer topObjectPropertyId = IntegerEntityManager.topObjectPropertyId;
    private final NormalizedIntegerAxiomFactory axiomFactory;
    private IntegerSubsumerGraphImpl classGraph = null;
    private IntegerHierarchicalGraph classHierarchy = null;
    private IntegerHierarchicalGraph dataPropertyHierarchy = null;
    private Map<Integer, Set<Integer>> directTypes = null;
    private final IntegerEntityManager entityManager;
    private CelExtendedOntology extendedOntology = null;
    private boolean isReady = false;
    private IntegerSubsumerGraphImpl objectPropertyGraph = null;
    private IntegerHierarchicalGraph objectPropertyHierarchy = null;
    private Map<Integer, Set<Integer>> propertyUsedByClass = null;
    private final Deque<ExtensionEntry> queueEntries = new ArrayDeque<ExtensionEntry>();
    private final Deque<Integer> queueKeys = new ArrayDeque<Integer>();
    private IntegerRelationMapImpl relationSet = null;
    private Map<Integer, Set<Integer>> sameIndividualMap = null;
    private Map<Integer, Set<Integer>> transitiveSubsumed = null;

    public CelProcessor(Set<Integer> originalObjectProperties, Set<Integer> originalClasses, Set<NormalizedIntegerAxiom> normalizedAxiomSet, NormalizedIntegerAxiomFactory factory, IntegerEntityManager entityManager) {
        Objects.requireNonNull(originalObjectProperties);
        Objects.requireNonNull(originalClasses);
        Objects.requireNonNull(normalizedAxiomSet);
        Objects.requireNonNull(factory);
        Objects.requireNonNull(entityManager);
        this.axiomFactory = factory;
        this.entityManager = entityManager;
        this.preProcess(originalObjectProperties, originalClasses, normalizedAxiomSet);
    }

    private void addToQueue(Integer className, Collection<ExtensionEntry> entrySet) {
        entrySet.forEach(entry -> {
            this.queueKeys.push(className);
            this.queueEntries.push((ExtensionEntry)entry);
        });
    }

    private Map<Integer, Set<Integer>> computeDirectTypes(IntegerHierarchicalGraph hierarchicalGraph) {
        HashMap<Integer, Set<Integer>> ret = new HashMap<Integer, Set<Integer>>();
        Set<Integer> individuals = this.getEntityManager().getEntities(IntegerEntityType.INDIVIDUAL, false);
        individuals.forEach(indiv -> {
            Set<Integer> subsumers = hierarchicalGraph.getParents(this.getEntityManager().getAuxiliaryNominal((Integer)indiv).get());
            subsumers.forEach(elem -> {
                if (this.getEntityManager().getAuxiliaryNominals().contains(elem)) {
                    throw new IllegalStateException("An individual has another individual as direct subsumer.");
                }
            });
            ret.put((Integer)indiv, Collections.unmodifiableSet(subsumers));
        });
        return ret;
    }

    private Map<Integer, Set<Integer>> computeSameIndividualMap(IntegerHierarchicalGraph hierarchicalGraph) {
        HashMap<Integer, Set<Integer>> ret = new HashMap<Integer, Set<Integer>>();
        Set<Integer> individuals = this.getEntityManager().getEntities(IntegerEntityType.INDIVIDUAL, false);
        individuals.forEach(indiv -> {
            Set<Integer> equivalentClasses = hierarchicalGraph.getEquivalents(this.getEntityManager().getAuxiliaryNominal((Integer)indiv).get());
            HashSet equivalents = new HashSet();
            equivalentClasses.forEach(elem -> {
                if (this.getEntityManager().getAuxiliaryNominals().contains(elem)) {
                    equivalents.add(this.getEntityManager().getIndividual((Integer)elem).get());
                }
            });
            ret.put((Integer)indiv, Collections.unmodifiableSet(equivalents));
        });
        return ret;
    }

    private IntegerSubsumerGraphImpl createClassGraph(Set<Integer> originalClassSet, Set<NormalizedIntegerAxiom> axiomSet) {
        HashSet<Integer> classIdSet = new HashSet<Integer>();
        classIdSet.addAll(originalClassSet);
        axiomSet.forEach(axiom -> classIdSet.addAll(axiom.getClassesInSignature()));
        IntegerSubsumerGraphImpl ret = new IntegerSubsumerGraphImpl(bottomClassId, topClassId);
        classIdSet.forEach(index -> ret.addAncestor((int)index, topClassId));
        ret.addAncestor(topClassId, topClassId);
        return ret;
    }

    private IntegerSubsumerGraphImpl createObjectPropertyGraph(Set<Integer> originalPropertySet, Set<NormalizedIntegerAxiom> axiomSet) {
        IntegerSubsumerGraphImpl ret = new IntegerSubsumerGraphImpl(bottomObjectPropertyId, topObjectPropertyId);
        HashSet<Integer> propertyIdSet = new HashSet<Integer>();
        propertyIdSet.addAll(originalPropertySet);
        axiomSet.forEach(axiom -> propertyIdSet.addAll(axiom.getObjectPropertiesInSignature()));
        propertyIdSet.forEach(index -> ret.addAncestor((int)index, topObjectPropertyId));
        axiomSet.forEach(axiom -> {
            if (axiom instanceof RI2Axiom) {
                RI2Axiom current = (RI2Axiom)axiom;
                ret.addAncestor(current.getSubProperty(), current.getSuperProperty());
            }
        });
        this.makeTransitiveClosure(ret);
        return ret;
    }

    private Map<Integer, Set<Integer>> createPropertyUseMap() {
        HashMap<Integer, Set<Integer>> ret = new HashMap<Integer, Set<Integer>>();
        this.getClassGraph().getElements().forEach(cA -> {
            HashSet propertySet = new HashSet();
            this.getObjectPropertyGraph().getElements().forEach(r -> {
                if (!this.relationSet.getBySecond((int)r, (int)cA).isEmpty()) {
                    propertySet.add(r);
                }
            });
            ret.put((Integer)cA, propertySet);
        });
        return ret;
    }

    private IntegerRelationMapImpl createRelationSet(Collection<Integer> collection) {
        IntegerRelationMapImpl ret = new IntegerRelationMapImpl();
        collection.forEach(index -> ret.add((int)index));
        return ret;
    }

    private Map<Integer, Set<Integer>> createTransitiveSubsumed() {
        HashMap<Integer, Set<Integer>> ret = new HashMap<Integer, Set<Integer>>();
        this.getObjectPropertyGraph().getElements().forEach(r -> {
            HashSet related = new HashSet();
            this.getObjectPropertyGraph().getElements().forEach(s -> {
                if (this.isReflexiveTransitiveSubsumed((Integer)r, (Integer)s)) {
                    related.add(s);
                }
            });
            ret.put((Integer)r, related);
        });
        return ret;
    }

    protected IntegerSubsumerGraph getClassGraph() {
        return this.classGraph;
    }

    @Override
    public IntegerHierarchicalGraph getClassHierarchy() {
        if (!this.isReady()) {
            throw new UnclassifiedOntologyException();
        }
        return this.classHierarchy;
    }

    @Override
    public IntegerHierarchicalGraph getDataPropertyHierarchy() throws UnclassifiedOntologyException {
        if (!this.isReady()) {
            throw new UnclassifiedOntologyException();
        }
        return this.dataPropertyHierarchy;
    }

    private Set<Integer> getDescendants(IntegerHierarchicalGraph hierarchicalGraph, Integer vertex) {
        HashSet<Integer> visited = new HashSet<Integer>();
        HashSet<Integer> queue = new HashSet<Integer>();
        queue.add(vertex);
        while (!queue.isEmpty()) {
            Integer elem = (Integer)queue.iterator().next();
            queue.remove(elem);
            visited.add(elem);
            HashSet<Integer> children = new HashSet<Integer>();
            children.addAll(hierarchicalGraph.getChildren(elem));
            children.removeAll(visited);
            queue.addAll(children);
        }
        return visited;
    }

    @Override
    public Map<Integer, Set<Integer>> getDirectTypes() {
        if (!this.isReady()) {
            throw new UnclassifiedOntologyException();
        }
        return Collections.unmodifiableMap(this.directTypes);
    }

    protected IntegerEntityManager getEntityManager() {
        return this.entityManager;
    }

    protected CelExtendedOntology getExtendedOntology() {
        return this.extendedOntology;
    }

    protected IntegerSubsumerGraph getObjectPropertyGraph() {
        return this.objectPropertyGraph;
    }

    @Override
    public IntegerHierarchicalGraph getObjectPropertyHierarchy() {
        if (!this.isReady()) {
            throw new UnclassifiedOntologyException();
        }
        return this.objectPropertyHierarchy;
    }

    public NormalizedIntegerAxiomFactory getOntologyObjectFactory() {
        return this.axiomFactory;
    }

    private Set<Integer> getPropertyUsedByClass(Integer cA) {
        return this.propertyUsedByClass.get(cA);
    }

    protected IntegerBinaryRelation getRelation(Integer relationId) {
        Objects.requireNonNull(relationId);
        return this.relationSet.get(relationId);
    }

    protected Set<Integer> getRelationIdSet() {
        return Collections.unmodifiableSet(this.relationSet.getElements());
    }

    @Override
    public Map<Integer, Set<Integer>> getSameIndividualMap() {
        if (!this.isReady()) {
            throw new UnclassifiedOntologyException();
        }
        return Collections.unmodifiableMap(this.sameIndividualMap);
    }

    private boolean isConnectedTo(Integer c, Integer d) {
        HashSet<Integer> visited = new HashSet<Integer>();
        HashSet<Integer> toVisit = new HashSet<Integer>();
        toVisit.add(c);
        while (!toVisit.isEmpty()) {
            Integer elem = (Integer)toVisit.iterator().next();
            toVisit.remove(elem);
            visited.add(elem);
            HashSet newToVisit = new HashSet();
            this.getPropertyUsedByClass(elem).forEach(r -> {
                IntegerBinaryRelation relation = this.relationSet.get((int)r);
                newToVisit.addAll(relation.getByFirst(elem));
            });
            newToVisit.removeAll(visited);
            toVisit.addAll(newToVisit);
        }
        return visited.contains(d);
    }

    @Override
    public boolean isReady() {
        return this.isReady;
    }

    private boolean isReflexiveTransitiveSubsumed(Integer leftPropertyName, Integer rightPropertyName) {
        return Objects.nonNull(this.objectPropertyGraph) && this.objectPropertyGraph.containsPair(leftPropertyName, rightPropertyName);
    }

    private void makeTransitiveClosure(IntegerSubsumerGraphImpl graph) {
        boolean hasChanged = true;
        while (hasChanged) {
            hasChanged = false;
            for (Integer elem : graph.getElements()) {
                Collection<Integer> subsumerSet = graph.getSubsumers(elem);
                HashSet<Integer> allSubsumers = new HashSet<Integer>();
                allSubsumers.add(elem);
                for (Integer otherElem : subsumerSet) {
                    allSubsumers.addAll(graph.getSubsumers(otherElem));
                }
                allSubsumers.removeAll(subsumerSet);
                if (allSubsumers.isEmpty()) continue;
                hasChanged = true;
                for (Integer subsumer : allSubsumers) {
                    graph.addAncestor(elem, subsumer);
                }
            }
        }
    }

    protected void postProcess() {
        this.removeAuxiliaryObjectProperties();
        this.objectPropertyHierarchy = new IntegerHierarchicalGraphImpl(this.objectPropertyGraph);
        this.objectPropertyGraph = null;
        this.removeAuxiliaryClassesExceptNominals();
        IntegerHierarchicalGraphImpl hierarchicalGraph = new IntegerHierarchicalGraphImpl(this.classGraph);
        this.processNominals(hierarchicalGraph);
        this.directTypes = this.computeDirectTypes(hierarchicalGraph);
        this.sameIndividualMap = this.computeSameIndividualMap(hierarchicalGraph);
        this.removeAuxiliaryNominals();
        this.classHierarchy = new IntegerHierarchicalGraphImpl(this.classGraph);
        this.classGraph = null;
    }

    private void prepareQueue(CelExtendedOntology ontology) {
        HashSet<Integer> classNameSet = new HashSet<Integer>();
        classNameSet.addAll(ontology.getClassSet());
        classNameSet.forEach(className -> {
            this.addToQueue((Integer)className, (Collection<ExtensionEntry>)ontology.getClassEntries((Integer)className));
            this.addToQueue((Integer)className, (Collection<ExtensionEntry>)ontology.getClassEntries(topClassId));
        });
    }

    protected void preProcess(Set<Integer> originalObjectProperties, Set<Integer> originalClasses, Set<NormalizedIntegerAxiom> normalizedAxiomSet) {
        Objects.requireNonNull(originalObjectProperties);
        Objects.requireNonNull(originalClasses);
        Objects.requireNonNull(normalizedAxiomSet);
        this.isReady = false;
        logger.fine("using " + this.getClass().getSimpleName() + " ...");
        logger.fine("configuring processor ...");
        this.dataPropertyHierarchy = new IntegerHierarchicalGraphImpl(new IntegerSubsumerGraphImpl(IntegerEntityManager.bottomDataPropertyId, IntegerEntityManager.topDataPropertyId));
        HashSet<Integer> originalClassSet = new HashSet<Integer>();
        originalClassSet.addAll(originalClasses);
        originalClassSet.add(bottomClassId);
        originalClassSet.add(topClassId);
        HashSet<Integer> originalObjectPropertySet = new HashSet<Integer>();
        originalObjectPropertySet.addAll(originalObjectProperties);
        originalObjectPropertySet.add(bottomObjectPropertyId);
        originalObjectPropertySet.add(topObjectPropertyId);
        logger.finer("normalizing ontology ...");
        HashSet<NormalizedIntegerAxiom> ontology = new HashSet<NormalizedIntegerAxiom>();
        ontology.addAll(normalizedAxiomSet);
        logger.finer("auxiliary classes created (including nominals) : " + this.getEntityManager().getEntities(IntegerEntityType.CLASS, true).size());
        logger.finer("auxiliary classes created for nominals : " + this.getEntityManager().getIndividuals().size());
        logger.finer("auxiliary object properties created : " + this.getEntityManager().getEntities(IntegerEntityType.OBJECT_PROPERTY, true).size());
        logger.finer("creating extended ontology ...");
        this.extendedOntology = new CelExtendedOntology();
        this.extendedOntology.load(ontology);
        logger.finer("creating class graph ...");
        this.classGraph = this.createClassGraph(originalClassSet, ontology);
        logger.finer("creating property graph ...");
        this.objectPropertyGraph = this.createObjectPropertyGraph(originalObjectPropertySet, ontology);
        this.relationSet = this.createRelationSet(this.objectPropertyGraph.getElements());
        this.propertyUsedByClass = this.createPropertyUseMap();
        this.transitiveSubsumed = this.createTransitiveSubsumed();
        logger.finer("preparing queue ...");
        this.queueKeys.clear();
        this.queueEntries.clear();
        this.prepareQueue(this.extendedOntology);
        logger.fine("processor configured.");
    }

    @Override
    public boolean process() {
        if (!this.isReady) {
            if (!this.queueKeys.isEmpty()) {
                this.process(this.queueKeys.pop(), this.queueEntries.pop());
            } else if (!this.isReady) {
                this.postProcess();
                this.isReady = true;
            }
        }
        return !this.isReady;
    }

    private void process(Integer cA, ExtensionEntry eX) {
        if (eX.isImplication()) {
            this.processImplication(cA, eX.asImplication().get());
        } else if (eX.isExistential()) {
            this.processExistential(cA, eX.asExistential().get());
        } else {
            throw new RuntimeException("Internal error: entry was not recognized " + eX);
        }
    }

    private void processBottom(Integer className) {
        this.classGraph.addAncestor(className, bottomClassId);
        this.relationSet.getElements().forEach(relation -> this.relationSet.getBySecond((int)relation, className).forEach(firstComponent -> {
            if (!this.classGraph.containsPair((int)firstComponent, bottomClassId)) {
                this.processBottom((Integer)firstComponent);
            }
        }));
    }

    private void processExistential(Integer cA, ExistentialEntry eX) {
        Integer r = eX.getPropertyId();
        Integer cB = eX.getClassId();
        Integer bottom = bottomClassId;
        if (!this.relationSet.contains(r, cA, cB)) {
            if (this.classGraph.containsPair(cB, bottom) && !this.classGraph.containsPair(cA, bottom)) {
                this.processBottom(cA);
            }
            this.processNewEdge(cA, r, cB);
        }
    }

    private void processImplication(Integer cA, ImplicationEntry eX) {
        Set<Integer> vecB = eX.getOperands();
        Integer cB = eX.getSuperClass();
        Collection<Integer> sSofA = this.classGraph.getSubsumers(cA);
        Integer bottom = bottomClassId;
        if (sSofA.containsAll(vecB) && !sSofA.contains(cB)) {
            if (cB.equals(bottom)) {
                this.processBottom(cA);
            } else {
                this.classGraph.addAncestor(cA, cB);
                this.addToQueue(cA, this.getExtendedOntology().getClassEntries(cB));
                Set<Integer> propertySet = this.getPropertyUsedByClass(cA);
                propertySet.forEach(r -> {
                    Set<ExtensionEntry> existentialEntries = this.getExtendedOntology().getExistentialEntries((Integer)r, cB);
                    Collection<Integer> classSet = this.relationSet.getBySecond((int)r, cA);
                    classSet.forEach(cAprime -> this.addToQueue((Integer)cAprime, (Collection<ExtensionEntry>)existentialEntries));
                });
            }
        }
    }

    private void processNewEdge(Integer cA, Integer r, Integer cB) {
        this.transitiveSubsumed.get(r).forEach(s -> {
            this.relationSet.add((int)s, cA, cB);
            this.getPropertyUsedByClass(cB).add((Integer)s);
            this.classGraph.getSubsumers(cB).forEach(cBprime -> this.addToQueue(cA, this.getExtendedOntology().getExistentialEntries((Integer)s, (Integer)cBprime)));
            this.getExtendedOntology().getSubPropertyAxiomSetByRight((Integer)s).forEach(axiom -> {
                Integer t = axiom.getLeftSubProperty();
                Integer u = axiom.getSuperProperty();
                Collection<Integer> classSet = this.relationSet.getBySecond(t, cA);
                classSet.forEach(cAprime -> {
                    if (!this.relationSet.contains(u, (int)cAprime, cB)) {
                        this.processNewEdge((Integer)cAprime, u, cB);
                    }
                });
            });
            this.getExtendedOntology().getSubPropertyAxiomSetByLeft((Integer)s).forEach(axiom -> {
                Integer t = axiom.getRightSubProperty();
                Integer u = axiom.getSuperProperty();
                Collection<Integer> classSet = this.relationSet.getByFirst(t, cB);
                classSet.forEach(cBprime -> {
                    if (!this.relationSet.contains(u, cA, (int)cBprime)) {
                        this.processNewEdge(cA, u, (Integer)cBprime);
                    }
                });
            });
        });
    }

    private void processNominals(IntegerHierarchicalGraph hierarchicalGraph) {
        Set<Integer> nominals = this.getEntityManager().getAuxiliaryNominals();
        nominals.forEach(indiv -> {
            Set<Integer> descendants = this.getDescendants(hierarchicalGraph, (Integer)indiv);
            descendants.forEach(c -> descendants.forEach(d -> {
                Collection<Integer> sC = this.getClassGraph().getSubsumers((int)c);
                Collection<Integer> sD = this.getClassGraph().getSubsumers((int)d);
                if (!sD.containsAll(sC)) {
                    if (this.isConnectedTo((Integer)c, (Integer)d)) {
                        sD.forEach(elem -> this.classGraph.addAncestor((int)c, (int)elem));
                    }
                    nominals.forEach(nominal -> {
                        if (this.isConnectedTo((Integer)nominal, (Integer)d)) {
                            sD.forEach(elem -> this.classGraph.addAncestor((int)c, (int)elem));
                        }
                    });
                }
            }));
        });
    }

    private void removeAuxiliaryClassesExceptNominals() {
        HashSet<Integer> reqClasses = new HashSet<Integer>();
        this.getClassGraph().getElements().forEach(elem -> {
            if (!this.getEntityManager().isAuxiliary((Integer)elem)) {
                reqClasses.add((Integer)elem);
            }
        });
        reqClasses.addAll(this.getEntityManager().getAuxiliaryNominals());
        this.classGraph.retainAll(reqClasses);
    }

    private void removeAuxiliaryNominals() {
        HashSet<Integer> reqClasses = new HashSet<Integer>();
        reqClasses.addAll(this.getClassGraph().getElements());
        reqClasses.removeAll(this.getEntityManager().getAuxiliaryNominals());
        this.classGraph.retainAll(reqClasses);
    }

    private void removeAuxiliaryObjectProperties() {
        HashSet<Integer> reqObjectProperties = new HashSet<Integer>();
        this.getObjectPropertyGraph().getElements().forEach(elem -> {
            if (!this.getEntityManager().isAuxiliary((Integer)elem)) {
                reqObjectProperties.add((Integer)elem);
            }
        });
        this.objectPropertyGraph.retainAll(reqObjectProperties);
    }
}

