/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.core.algorithm.cel;

import de.tudresden.inf.lat.jcel.core.algorithm.cel.ExtensionEntry;
import de.tudresden.inf.lat.jcel.core.algorithm.cel.ImplicationEntry;
import java.util.Objects;
import java.util.Optional;

class ExistentialEntry
implements ExtensionEntry {
    private final Integer classId;
    private final int hashcode;
    private final Integer propertyId;

    public ExistentialEntry(Integer property, Integer cls) {
        Objects.requireNonNull(property);
        Objects.requireNonNull(cls);
        this.propertyId = property;
        this.classId = cls;
        this.hashcode = 31 * this.classId.hashCode() + this.propertyId.hashCode();
    }

    @Override
    public Optional<ExistentialEntry> asExistential() {
        return Optional.of(this);
    }

    @Override
    public Optional<ImplicationEntry> asImplication() {
        return Optional.empty();
    }

    public boolean equals(Object o) {
        boolean ret = false;
        if (o instanceof ExistentialEntry) {
            ExistentialEntry other = (ExistentialEntry)o;
            ret = this.getClassId().equals(other.getClassId()) && this.getPropertyId().equals(other.getPropertyId());
        }
        return ret;
    }

    public Integer getClassId() {
        return this.classId;
    }

    public Integer getPropertyId() {
        return this.propertyId;
    }

    public int hashCode() {
        return this.hashcode;
    }

    @Override
    public boolean isExistential() {
        return true;
    }

    @Override
    public boolean isImplication() {
        return false;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("(E ");
        sbuf.append(this.getPropertyId());
        sbuf.append(".");
        sbuf.append(this.getClassId());
        sbuf.append(")");
        return sbuf.toString();
    }
}

