/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.core.algorithm.cel;

import de.tudresden.inf.lat.jcel.core.algorithm.cel.ExistentialEntry;
import de.tudresden.inf.lat.jcel.core.algorithm.cel.ExtensionEntry;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

class ImplicationEntry
implements ExtensionEntry {
    private final int hashcode;
    private final Set<Integer> leftPart;
    private final Integer superClass;

    public ImplicationEntry(Set<Integer> left, Integer right) {
        Objects.requireNonNull(left);
        Objects.requireNonNull(right);
        this.leftPart = left;
        this.superClass = right;
        this.hashcode = 31 * this.leftPart.hashCode() + this.superClass.hashCode();
    }

    @Override
    public Optional<ExistentialEntry> asExistential() {
        return Optional.empty();
    }

    @Override
    public Optional<ImplicationEntry> asImplication() {
        return Optional.of(this);
    }

    public boolean equals(Object o) {
        boolean ret = false;
        if (o instanceof ImplicationEntry) {
            ImplicationEntry other = (ImplicationEntry)o;
            ret = this.getOperands().equals(other.getOperands()) && this.getSuperClass().equals(other.getSuperClass());
        }
        return ret;
    }

    public Set<Integer> getOperands() {
        return Collections.unmodifiableSet(this.leftPart);
    }

    public Integer getSuperClass() {
        return this.superClass;
    }

    public int hashCode() {
        return this.hashcode;
    }

    @Override
    public boolean isExistential() {
        return false;
    }

    @Override
    public boolean isImplication() {
        return true;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("(");
        sbuf.append(this.getOperands());
        sbuf.append(" --> ");
        sbuf.append(this.getSuperClass());
        sbuf.append(")");
        return sbuf.toString();
    }
}

