/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.core.algorithm.module;

import de.tudresden.inf.lat.jcel.coreontology.axiom.FunctObjectPropAxiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.GCI0Axiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.GCI1Axiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.GCI2Axiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.GCI3Axiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.NominalAxiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.NormalizedIntegerAxiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.NormalizedIntegerAxiomVisitor;
import de.tudresden.inf.lat.jcel.coreontology.axiom.RI1Axiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.RI2Axiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.RI3Axiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.RangeAxiom;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public class DefaultIdentifierCollector {
    private final Set<Integer> classesOnTheLeft = new TreeSet<Integer>();
    private final Set<Integer> classesOnTheRight = new TreeSet<Integer>();
    private final Set<Integer> objectPropertiesOnTheLeft = new TreeSet<Integer>();
    private final Set<Integer> objectPropertiesOnTheRight = new TreeSet<Integer>();
    private final NormalizedIntegerAxiom axiom;

    public DefaultIdentifierCollector(NormalizedIntegerAxiom axiom) {
        Objects.requireNonNull(axiom);
        this.axiom = axiom;
        axiom.accept(new AuxBornIdentifierCollector());
    }

    public NormalizedIntegerAxiom getAxiom() {
        return this.axiom;
    }

    public Set<Integer> getClassesOnTheLeft() {
        return Collections.unmodifiableSet(this.classesOnTheLeft);
    }

    public Set<Integer> getClassesOnTheRight() {
        return Collections.unmodifiableSet(this.classesOnTheRight);
    }

    public Set<Integer> getObjectPropertiesOnTheLeft() {
        return Collections.unmodifiableSet(this.objectPropertiesOnTheLeft);
    }

    public Set<Integer> getObjectPropertiesOnTheRight() {
        return Collections.unmodifiableSet(this.objectPropertiesOnTheRight);
    }

    public int hashCode() {
        return this.axiom.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DefaultIdentifierCollector)) {
            return false;
        }
        DefaultIdentifierCollector other = (DefaultIdentifierCollector)obj;
        return this.getAxiom().equals(other.getAxiom());
    }

    public String toString() {
        return this.axiom.toString();
    }

    private class AuxBornIdentifierCollector
    implements NormalizedIntegerAxiomVisitor<Boolean> {
        AuxBornIdentifierCollector() {
        }

        @Override
        public Boolean visit(FunctObjectPropAxiom axiom) {
            DefaultIdentifierCollector.this.objectPropertiesOnTheLeft.add(axiom.getProperty());
            return true;
        }

        @Override
        public Boolean visit(GCI0Axiom axiom) {
            DefaultIdentifierCollector.this.classesOnTheLeft.add(axiom.getSubClass());
            DefaultIdentifierCollector.this.classesOnTheRight.add(axiom.getSuperClass());
            return true;
        }

        @Override
        public Boolean visit(GCI1Axiom axiom) {
            DefaultIdentifierCollector.this.classesOnTheLeft.add(axiom.getLeftSubClass());
            DefaultIdentifierCollector.this.classesOnTheLeft.add(axiom.getRightSubClass());
            DefaultIdentifierCollector.this.classesOnTheRight.add(axiom.getSuperClass());
            return true;
        }

        @Override
        public Boolean visit(GCI2Axiom axiom) {
            DefaultIdentifierCollector.this.classesOnTheLeft.add(axiom.getSubClass());
            DefaultIdentifierCollector.this.objectPropertiesOnTheRight.add(axiom.getPropertyInSuperClass());
            DefaultIdentifierCollector.this.classesOnTheRight.add(axiom.getClassInSuperClass());
            return true;
        }

        @Override
        public Boolean visit(GCI3Axiom axiom) {
            DefaultIdentifierCollector.this.objectPropertiesOnTheLeft.add(axiom.getPropertyInSubClass());
            DefaultIdentifierCollector.this.classesOnTheLeft.add(axiom.getClassInSubClass());
            DefaultIdentifierCollector.this.classesOnTheRight.add(axiom.getSuperClass());
            return true;
        }

        @Override
        public Boolean visit(NominalAxiom axiom) {
            DefaultIdentifierCollector.this.classesOnTheLeft.add(axiom.getClassExpression());
            DefaultIdentifierCollector.this.classesOnTheRight.add(axiom.getClassExpression());
            return true;
        }

        @Override
        public Boolean visit(RangeAxiom axiom) {
            DefaultIdentifierCollector.this.objectPropertiesOnTheLeft.add(axiom.getProperty());
            DefaultIdentifierCollector.this.classesOnTheRight.add(axiom.getRange());
            return true;
        }

        @Override
        public Boolean visit(RI1Axiom axiom) {
            DefaultIdentifierCollector.this.objectPropertiesOnTheRight.add(axiom.getSuperProperty());
            return true;
        }

        @Override
        public Boolean visit(RI2Axiom axiom) {
            DefaultIdentifierCollector.this.objectPropertiesOnTheLeft.add(axiom.getSubProperty());
            DefaultIdentifierCollector.this.objectPropertiesOnTheRight.add(axiom.getSuperProperty());
            return true;
        }

        @Override
        public Boolean visit(RI3Axiom axiom) {
            DefaultIdentifierCollector.this.objectPropertiesOnTheLeft.add(axiom.getLeftSubProperty());
            DefaultIdentifierCollector.this.objectPropertiesOnTheLeft.add(axiom.getRightSubProperty());
            DefaultIdentifierCollector.this.objectPropertiesOnTheRight.add(axiom.getSuperProperty());
            return true;
        }
    }
}

