/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.core.algorithm.module;

import de.tudresden.inf.lat.jcel.core.algorithm.module.DefaultIdentifierCollector;
import de.tudresden.inf.lat.jcel.core.algorithm.module.Module;
import de.tudresden.inf.lat.jcel.coreontology.axiom.NormalizedIntegerAxiom;
import de.tudresden.inf.lat.jcel.coreontology.datatype.IntegerAxiom;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public class DefaultModuleExtractor {
    Map<Integer, Set<DefaultIdentifierCollector>> buildMapOfAxioms(Set<DefaultIdentifierCollector> normalizedAxioms) {
        HashMap<Integer, Set<DefaultIdentifierCollector>> map = new HashMap<Integer, Set<DefaultIdentifierCollector>>();
        normalizedAxioms.forEach(axiom -> {
            Set<Integer> classesOnTheLeft = axiom.getClassesOnTheLeft();
            classesOnTheLeft.forEach(classId -> {
                HashSet<DefaultIdentifierCollector> value = (HashSet<DefaultIdentifierCollector>)map.get(classId);
                if (Objects.isNull(value)) {
                    value = new HashSet<DefaultIdentifierCollector>();
                    map.put((Integer)classId, (Set<DefaultIdentifierCollector>)value);
                }
                value.add((DefaultIdentifierCollector)axiom);
            });
        });
        return map;
    }

    Set<NormalizedIntegerAxiom> getAxiomsWithoutEntitiesOnTheLeft(Set<DefaultIdentifierCollector> axioms) {
        HashSet<NormalizedIntegerAxiom> ret = new HashSet<NormalizedIntegerAxiom>();
        axioms.forEach(axiom -> {
            if (axiom.getClassesOnTheLeft().isEmpty() && axiom.getObjectPropertiesOnTheLeft().isEmpty()) {
                ret.add(axiom.getAxiom());
            }
        });
        return ret;
    }

    Set<DefaultIdentifierCollector> getAxiomsWithClassesOnTheLeft(Set<Integer> classesToVisit, Map<Integer, Set<DefaultIdentifierCollector>> map) {
        HashSet<DefaultIdentifierCollector> ret = new HashSet<DefaultIdentifierCollector>();
        classesToVisit.forEach(classId -> {
            Set newAxioms = (Set)map.get(classId);
            if (Objects.nonNull(newAxioms)) {
                ret.addAll(newAxioms);
            }
        });
        return ret;
    }

    Set<Integer> getEntities(IntegerAxiom axiom) {
        TreeSet<Integer> ret = new TreeSet<Integer>();
        ret.addAll(axiom.getClassesInSignature());
        ret.addAll(axiom.getObjectPropertiesInSignature());
        ret.addAll(axiom.getIndividualsInSignature());
        ret.addAll(axiom.getDataPropertiesInSignature());
        ret.addAll(axiom.getDatatypesInSignature());
        return ret;
    }

    public Module extractModule(Collection<NormalizedIntegerAxiom> setOfAxioms, Set<Integer> setOfClasses) {
        HashSet<NormalizedIntegerAxiom> newAxioms = new HashSet<NormalizedIntegerAxiom>();
        HashSet<DefaultIdentifierCollector> axioms = new HashSet<DefaultIdentifierCollector>();
        setOfAxioms.forEach(axiom -> axioms.add(new DefaultIdentifierCollector((NormalizedIntegerAxiom)axiom)));
        newAxioms.addAll(this.getAxiomsWithoutEntitiesOnTheLeft(axioms));
        Map<Integer, Set<DefaultIdentifierCollector>> map = this.buildMapOfAxioms(axioms);
        TreeSet<Integer> visitedClasses = new TreeSet<Integer>();
        TreeSet<Integer> classesToVisit = new TreeSet<Integer>();
        classesToVisit.addAll(setOfClasses);
        int resultSize = -1;
        while (newAxioms.size() > resultSize) {
            resultSize = newAxioms.size();
            Set<DefaultIdentifierCollector> axiomsToVisit = this.getAxiomsWithClassesOnTheLeft(classesToVisit, map);
            visitedClasses.addAll(classesToVisit);
            classesToVisit.clear();
            axiomsToVisit.forEach(axiom -> {
                classesToVisit.addAll(axiom.getClassesOnTheRight());
                newAxioms.add(axiom.getAxiom());
            });
            classesToVisit.removeAll(visitedClasses);
        }
        TreeSet<Integer> entities = new TreeSet<Integer>();
        entities.addAll(visitedClasses);
        newAxioms.forEach(axiom -> entities.addAll(this.getEntities((IntegerAxiom)axiom)));
        return new Module(entities, newAxioms);
    }
}

