/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.core.algorithm.module;

import de.tudresden.inf.lat.jcel.core.algorithm.module.ExtendedNormalizedAxiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.FunctObjectPropAxiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.GCI0Axiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.GCI1Axiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.GCI2Axiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.GCI3Axiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.NominalAxiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.NormalizedIntegerAxiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.NormalizedIntegerAxiomVisitor;
import de.tudresden.inf.lat.jcel.coreontology.axiom.RI1Axiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.RI2Axiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.RI3Axiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.RangeAxiom;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public class ExtendedNormalizedAxiomImpl
implements ExtendedNormalizedAxiom {
    private final NormalizedIntegerAxiom axiom;
    private final Set<Integer> classesOnTheLeft = new TreeSet<Integer>();
    private final Set<Integer> classesOnTheRight = new TreeSet<Integer>();
    private final Set<Integer> objectPropertiesOnTheLeft = new TreeSet<Integer>();
    private final Set<Integer> objectPropertiesOnTheRight = new TreeSet<Integer>();

    public ExtendedNormalizedAxiomImpl(NormalizedIntegerAxiom axiom) {
        Objects.requireNonNull(axiom);
        this.axiom = axiom;
        axiom.accept(new AuxIdentifierCollector());
    }

    @Override
    public NormalizedIntegerAxiom getAxiom() {
        return this.axiom;
    }

    @Override
    public Set<Integer> getClassesOnTheLeft() {
        return Collections.unmodifiableSet(this.classesOnTheLeft);
    }

    @Override
    public Set<Integer> getClassesOnTheRight() {
        return Collections.unmodifiableSet(this.classesOnTheRight);
    }

    @Override
    public Set<Integer> getObjectPropertiesOnTheLeft() {
        return Collections.unmodifiableSet(this.objectPropertiesOnTheLeft);
    }

    @Override
    public Set<Integer> getObjectPropertiesOnTheRight() {
        return Collections.unmodifiableSet(this.objectPropertiesOnTheRight);
    }

    public int hashCode() {
        return this.axiom.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ExtendedNormalizedAxiomImpl)) {
            return false;
        }
        ExtendedNormalizedAxiom other = (ExtendedNormalizedAxiom)obj;
        return this.getAxiom().equals(other.getAxiom());
    }

    public String toString() {
        return this.axiom.toString();
    }

    class AuxIdentifierCollector
    implements NormalizedIntegerAxiomVisitor<Boolean> {
        AuxIdentifierCollector() {
        }

        @Override
        public Boolean visit(FunctObjectPropAxiom axiom) {
            ExtendedNormalizedAxiomImpl.this.objectPropertiesOnTheLeft.add(axiom.getProperty());
            return true;
        }

        @Override
        public Boolean visit(GCI0Axiom axiom) {
            ExtendedNormalizedAxiomImpl.this.classesOnTheLeft.add(axiom.getSubClass());
            ExtendedNormalizedAxiomImpl.this.classesOnTheRight.add(axiom.getSuperClass());
            return true;
        }

        @Override
        public Boolean visit(GCI1Axiom axiom) {
            ExtendedNormalizedAxiomImpl.this.classesOnTheLeft.add(axiom.getLeftSubClass());
            ExtendedNormalizedAxiomImpl.this.classesOnTheLeft.add(axiom.getRightSubClass());
            ExtendedNormalizedAxiomImpl.this.classesOnTheRight.add(axiom.getSuperClass());
            return true;
        }

        @Override
        public Boolean visit(GCI2Axiom axiom) {
            ExtendedNormalizedAxiomImpl.this.classesOnTheLeft.add(axiom.getSubClass());
            ExtendedNormalizedAxiomImpl.this.objectPropertiesOnTheRight.add(axiom.getPropertyInSuperClass());
            ExtendedNormalizedAxiomImpl.this.classesOnTheRight.add(axiom.getClassInSuperClass());
            return true;
        }

        @Override
        public Boolean visit(GCI3Axiom axiom) {
            ExtendedNormalizedAxiomImpl.this.objectPropertiesOnTheLeft.add(axiom.getPropertyInSubClass());
            ExtendedNormalizedAxiomImpl.this.classesOnTheLeft.add(axiom.getClassInSubClass());
            ExtendedNormalizedAxiomImpl.this.classesOnTheRight.add(axiom.getSuperClass());
            return true;
        }

        @Override
        public Boolean visit(NominalAxiom axiom) {
            ExtendedNormalizedAxiomImpl.this.classesOnTheLeft.add(axiom.getClassExpression());
            ExtendedNormalizedAxiomImpl.this.classesOnTheRight.add(axiom.getClassExpression());
            return true;
        }

        @Override
        public Boolean visit(RangeAxiom axiom) {
            ExtendedNormalizedAxiomImpl.this.objectPropertiesOnTheLeft.add(axiom.getProperty());
            ExtendedNormalizedAxiomImpl.this.classesOnTheRight.add(axiom.getRange());
            return true;
        }

        @Override
        public Boolean visit(RI1Axiom axiom) {
            ExtendedNormalizedAxiomImpl.this.objectPropertiesOnTheRight.add(axiom.getSuperProperty());
            return true;
        }

        @Override
        public Boolean visit(RI2Axiom axiom) {
            ExtendedNormalizedAxiomImpl.this.objectPropertiesOnTheLeft.add(axiom.getSubProperty());
            ExtendedNormalizedAxiomImpl.this.objectPropertiesOnTheRight.add(axiom.getSuperProperty());
            return true;
        }

        @Override
        public Boolean visit(RI3Axiom axiom) {
            ExtendedNormalizedAxiomImpl.this.objectPropertiesOnTheLeft.add(axiom.getLeftSubProperty());
            ExtendedNormalizedAxiomImpl.this.objectPropertiesOnTheLeft.add(axiom.getRightSubProperty());
            ExtendedNormalizedAxiomImpl.this.objectPropertiesOnTheRight.add(axiom.getSuperProperty());
            return true;
        }
    }
}

