/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.core.algorithm.rulebased;

import de.tudresden.inf.lat.jcel.core.completion.common.REntry;
import java.util.Objects;

public class REntryImpl
implements REntry,
Comparable<REntry> {
    private final int hashCode;
    private final int leftClass;
    private final int property;
    private final int rightClass;

    public REntryImpl(int prop, int leftCl, int rightCl) {
        this.property = prop;
        this.leftClass = leftCl;
        this.rightClass = rightCl;
        this.hashCode = this.property + 31 * (this.leftClass + 31 * this.rightClass);
    }

    @Override
    public int compareTo(REntry other) {
        Objects.requireNonNull(other);
        int ret = this.property - other.getProperty();
        if (ret == 0) {
            ret = this.leftClass - other.getLeftClass();
        }
        if (ret == 0) {
            ret = this.rightClass - other.getRightClass();
        }
        return ret;
    }

    public boolean equals(Object o) {
        boolean ret;
        boolean bl = ret = this == o;
        if (!ret && o instanceof REntry) {
            REntry other = (REntry)o;
            ret = this.property == other.getProperty() && this.leftClass == other.getLeftClass() && this.rightClass == other.getRightClass();
        }
        return ret;
    }

    @Override
    public int getLeftClass() {
        return this.leftClass;
    }

    @Override
    public int getProperty() {
        return this.property;
    }

    @Override
    public int getRightClass() {
        return this.rightClass;
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean isREntry() {
        return true;
    }

    @Override
    public boolean isSEntry() {
        return false;
    }

    public String toString() {
        return "(" + this.getProperty() + " " + this.getLeftClass() + " " + this.getRightClass() + ")";
    }
}

