/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.core.algorithm.rulebased;

import de.tudresden.inf.lat.jcel.core.algorithm.rulebased.TurtleRenderer;
import de.tudresden.inf.lat.jcel.core.graph.IntegerBinaryRelation;
import de.tudresden.inf.lat.jcel.core.graph.IntegerRelationMap;
import de.tudresden.inf.lat.jcel.core.graph.IntegerSubsumerGraph;
import de.tudresden.inf.lat.jcel.coreontology.datatype.IntegerEntityManager;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public class Renderer {
    public static final String subClassOf = "isA";

    private Set<String> getNames(Collection<Integer> identifiers, IntegerEntityManager entityManager) {
        TreeSet<String> ret = new TreeSet<String>();
        identifiers.forEach(id -> ret.add(entityManager.getName((Integer)id)));
        return ret;
    }

    public boolean renderWithNames(Writer output, IntegerEntityManager entityManager, IntegerRelationMap setR) throws IOException {
        Objects.requireNonNull(output);
        Objects.requireNonNull(entityManager);
        Objects.requireNonNull(setR);
        boolean ret = false;
        TurtleRenderer renderer = new TurtleRenderer(output);
        renderer.loadPrefixes(this.getNames(setR.getElements(), entityManager));
        renderer.renderPrefixes();
        List<Integer> listOfPropertyIds = this.sortByName(setR.getElements(), entityManager);
        for (int propertyId : listOfPropertyIds) {
            IntegerBinaryRelation relation = setR.get(propertyId);
            String propertyName = entityManager.getName(propertyId);
            List<Integer> listOfLeftClassIds = this.sortByName(relation.getElements(), entityManager);
            for (int leftClassId : listOfLeftClassIds) {
                String leftClassName = entityManager.getName(leftClassId);
                List<Integer> listOfRightClassIds = this.sortByName(relation.getByFirst(leftClassId), entityManager);
                for (int rightClassId : listOfRightClassIds) {
                    String rightClassName = entityManager.getName(rightClassId);
                    renderer.renderTriple(propertyName, leftClassName, rightClassName);
                    ret = true;
                }
            }
        }
        return ret;
    }

    public boolean renderWithNames(Writer output, IntegerEntityManager entityManager, IntegerSubsumerGraph setS) throws IOException {
        Objects.requireNonNull(output);
        Objects.requireNonNull(entityManager);
        Objects.requireNonNull(setS);
        boolean ret = false;
        TurtleRenderer renderer = new TurtleRenderer(output);
        renderer.loadPrefixes(this.getNames(setS.getElements(), entityManager));
        renderer.renderPrefixes();
        List<Integer> listOfSubClassIds = this.sortByName(setS.getElements(), entityManager);
        for (int subClassId : listOfSubClassIds) {
            String subClassName = entityManager.getName(subClassId);
            List<Integer> listOfSuperClassIds = this.sortByName(setS.getSubsumers(subClassId), entityManager);
            for (int superClassId : listOfSuperClassIds) {
                String superClassName = entityManager.getName(superClassId);
                renderer.renderTriple(subClassOf, subClassName, superClassName);
                ret = true;
            }
        }
        return ret;
    }

    private List<Integer> sortByName(Collection<Integer> identifiers, IntegerEntityManager entityManager) {
        ArrayList list = new ArrayList();
        identifiers.forEach(id -> list.add(new PairIdName((int)id, entityManager.getName((Integer)id))));
        Collections.sort(list);
        ArrayList<Integer> ret = new ArrayList<Integer>();
        list.forEach(pair -> ret.add(pair.getId()));
        return ret;
    }

    private class PairIdName
    implements Comparable<PairIdName> {
        private final int id;
        private final String name;

        public PairIdName(int id, String name) {
            Objects.requireNonNull(name);
            this.id = id;
            this.name = name;
        }

        @Override
        public int compareTo(PairIdName other) {
            Objects.requireNonNull(other);
            int ret = this.getName().compareTo(other.getName());
            if (ret == 0) {
                ret = this.getId() - other.getId();
            }
            return ret;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }
    }
}

