/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.core.algorithm.rulebased;

import de.tudresden.inf.lat.jcel.core.algorithm.common.Processor;
import de.tudresden.inf.lat.jcel.core.algorithm.common.UnclassifiedOntologyException;
import de.tudresden.inf.lat.jcel.core.algorithm.rulebased.ClassifierStatusImpl;
import de.tudresden.inf.lat.jcel.core.algorithm.rulebased.CompletionRuleChainSelector;
import de.tudresden.inf.lat.jcel.core.algorithm.rulebased.RChain;
import de.tudresden.inf.lat.jcel.core.algorithm.rulebased.SChain;
import de.tudresden.inf.lat.jcel.core.completion.common.REntry;
import de.tudresden.inf.lat.jcel.core.completion.common.SEntry;
import de.tudresden.inf.lat.jcel.core.graph.IntegerBinaryRelation;
import de.tudresden.inf.lat.jcel.core.graph.IntegerHierarchicalGraph;
import de.tudresden.inf.lat.jcel.core.graph.IntegerHierarchicalGraphImpl;
import de.tudresden.inf.lat.jcel.core.graph.IntegerSubsumerGraph;
import de.tudresden.inf.lat.jcel.core.graph.IntegerSubsumerGraphImpl;
import de.tudresden.inf.lat.jcel.core.saturation.SubPropertyNormalizer;
import de.tudresden.inf.lat.jcel.coreontology.axiom.ExtendedOntology;
import de.tudresden.inf.lat.jcel.coreontology.axiom.ExtendedOntologyImpl;
import de.tudresden.inf.lat.jcel.coreontology.axiom.NormalizedIntegerAxiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.NormalizedIntegerAxiomFactory;
import de.tudresden.inf.lat.jcel.coreontology.datatype.IntegerEntityManager;
import de.tudresden.inf.lat.jcel.coreontology.datatype.IntegerEntityType;
import de.tudresden.inf.lat.jcel.coreontology.datatype.OntologyExpressivity;
import java.io.IOException;
import java.io.Writer;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;

public class RuleBasedProcessor
implements Processor {
    private static final Logger logger = Logger.getLogger(RuleBasedProcessor.class.getName());
    private static final long loggingFrequency = 0x1000000L;
    private static final long threadWaitingTime = 32L;
    private static final Integer topClassId = IntegerEntityManager.topClassId;
    private RChain chainR = null;
    private SChain chainS = null;
    private IntegerHierarchicalGraph classHierarchy = null;
    private IntegerHierarchicalGraph dataPropertyHierarchy = null;
    private Map<Integer, Set<Integer>> directTypes = null;
    private final IntegerEntityManager entityManager;
    private final NormalizedIntegerAxiomFactory factory;
    private boolean isReady = false;
    private long iteration = 0L;
    private long loggingCount = 0x1000000L;
    private final boolean multiThreadedMode = false;
    private IntegerHierarchicalGraph objectPropertyHierarchy = null;
    private Map<Integer, Set<Integer>> sameIndividualMap = null;
    private ClassifierStatusImpl status = null;
    private WorkerThreadR threadR1 = null;
    private WorkerThreadR threadR2 = null;
    private WorkerThreadS threadS1 = null;
    private WorkerThreadS threadS2 = null;

    public RuleBasedProcessor(Set<Integer> originalObjectProperties, Set<Integer> originalClasses, Set<NormalizedIntegerAxiom> normalizedAxiomSet, OntologyExpressivity expressivity, NormalizedIntegerAxiomFactory factory, IntegerEntityManager entityManager) {
        Objects.requireNonNull(originalObjectProperties);
        Objects.requireNonNull(originalClasses);
        Objects.requireNonNull(normalizedAxiomSet);
        Objects.requireNonNull(expressivity);
        Objects.requireNonNull(factory);
        Objects.requireNonNull(entityManager);
        this.factory = factory;
        this.entityManager = entityManager;
        CompletionRuleChainSelector selector = new CompletionRuleChainSelector(expressivity);
        selector.activateProfiler();
        this.chainR = selector.getRChain();
        this.chainS = selector.getSChain();
        this.preProcess(this.createExtendedOntology(originalObjectProperties, originalClasses, normalizedAxiomSet));
    }

    public void addAxioms(Set<NormalizedIntegerAxiom> normalizedAxiomSet) {
        Objects.requireNonNull(normalizedAxiomSet);
        logger.fine("adding axioms ...");
        this.status.getExtendedOntology().load(normalizedAxiomSet);
        this.preProcess(this.status.getExtendedOntology());
        logger.fine("processor reset.");
    }

    private Map<Integer, Set<Integer>> computeDirectTypes(IntegerHierarchicalGraph hierarchicalGraph) {
        HashMap<Integer, Set<Integer>> ret = new HashMap<Integer, Set<Integer>>();
        Set<Integer> individuals = this.getEntityManager().getIndividuals();
        individuals.forEach(indiv -> {
            Set<Integer> subsumers = hierarchicalGraph.getParents(this.getEntityManager().getAuxiliaryNominal((Integer)indiv).get());
            subsumers.forEach(elem -> {
                if (this.getEntityManager().getAuxiliaryNominals().contains(elem)) {
                    throw new IllegalStateException("An individual has another individual as direct subsumer.");
                }
            });
            ret.put((Integer)indiv, Collections.unmodifiableSet(subsumers));
        });
        return ret;
    }

    private Set<Integer> computeReachability(Integer c) {
        HashSet<Integer> ret = new HashSet<Integer>();
        HashSet<Integer> toVisit = new HashSet<Integer>();
        toVisit.add(c);
        while (!toVisit.isEmpty()) {
            Integer elem = (Integer)toVisit.iterator().next();
            toVisit.remove(elem);
            ret.add(elem);
            HashSet newToVisit = new HashSet();
            this.status.getObjectPropertiesByFirst(elem).forEach(r -> {
                IntegerBinaryRelation relation = this.status.getRelationSet().get((int)r);
                newToVisit.addAll(relation.getByFirst(elem));
            });
            newToVisit.removeAll(ret);
            toVisit.addAll(newToVisit);
        }
        return ret;
    }

    private Set<Integer> computeReachability(Integer c, Map<Integer, Set<Integer>> reachableNodeCache) {
        Set<Integer> reachableNodes = reachableNodeCache.get(c);
        if (Objects.isNull(reachableNodes)) {
            reachableNodes = this.computeReachability(c);
            reachableNodeCache.put(c, reachableNodes);
        }
        return reachableNodes;
    }

    private Map<Integer, Set<Integer>> computeSameIndividualMap(IntegerHierarchicalGraph hierarchicalGraph) {
        HashMap<Integer, Set<Integer>> ret = new HashMap<Integer, Set<Integer>>();
        Set<Integer> individuals = this.getEntityManager().getIndividuals();
        individuals.forEach(indiv -> {
            Set<Integer> equivalentClasses = hierarchicalGraph.getEquivalents(this.getEntityManager().getAuxiliaryNominal((Integer)indiv).get());
            HashSet equivalents = new HashSet();
            equivalentClasses.forEach(elem -> {
                if (this.getEntityManager().getAuxiliaryNominals().contains(elem)) {
                    equivalents.add(this.getEntityManager().getIndividual((Integer)elem).get());
                }
            });
            ret.put((Integer)indiv, Collections.unmodifiableSet(equivalents));
        });
        return ret;
    }

    private Map.Entry<String, String> createEntry(String key, String value) {
        return new AbstractMap.SimpleEntry<String, String>(key, value);
    }

    private ExtendedOntology createExtendedOntology(Set<Integer> originalObjectPropertySet, Set<Integer> originalClassSet, Set<NormalizedIntegerAxiom> axioms) {
        SubPropertyNormalizer subPropNormalizer = new SubPropertyNormalizer(this.getOntologyObjectFactory(), this.getEntityManager());
        Set<NormalizedIntegerAxiom> saturatedNormalizedAxiomSet = subPropNormalizer.apply(axioms);
        ExtendedOntologyImpl extendedOntology = new ExtendedOntologyImpl();
        extendedOntology.load(saturatedNormalizedAxiomSet);
        originalObjectPropertySet.forEach(elem -> extendedOntology.addObjectProperty((int)elem));
        originalClassSet.forEach(elem -> extendedOntology.addClass((int)elem));
        return extendedOntology;
    }

    protected IntegerSubsumerGraph getClassGraph() {
        return this.status.getClassGraph();
    }

    @Override
    public IntegerHierarchicalGraph getClassHierarchy() {
        if (!this.isReady()) {
            throw new UnclassifiedOntologyException();
        }
        return this.classHierarchy;
    }

    public List<Map.Entry<String, String>> getConfigurationInfo() {
        ArrayList<Map.Entry<String, String>> ret = new ArrayList<Map.Entry<String, String>>();
        ret.add(this.createEntry("processor", this.getClass().getSimpleName()));
        ret.add(this.createEntry("iterations per log entry", "16777216"));
        ret.add(this.createEntry("classes read (including TOP and BOTTOM classes)", "" + this.getEntityManager().getEntities(IntegerEntityType.CLASS, false).size()));
        ret.add(this.createEntry("object properties read (including TOP and BOTTOM object properties)", "" + this.getEntityManager().getEntities(IntegerEntityType.OBJECT_PROPERTY, false).size()));
        ret.add(this.createEntry("auxiliary classes created (including nominals)", "" + this.getEntityManager().getEntities(IntegerEntityType.CLASS, true).size()));
        ret.add(this.createEntry("auxiliary classes created for nominals", "" + this.getEntityManager().getIndividuals().size()));
        ret.add(this.createEntry("auxiliary object properties created", "" + this.getEntityManager().getEntities(IntegerEntityType.OBJECT_PROPERTY, true).size()));
        ret.add(this.createEntry("chain S", this.chainS.toString()));
        ret.add(this.createEntry("chain R", this.chainR.toString()));
        return ret;
    }

    @Override
    public IntegerHierarchicalGraph getDataPropertyHierarchy() throws UnclassifiedOntologyException {
        if (!this.isReady()) {
            throw new UnclassifiedOntologyException();
        }
        return this.dataPropertyHierarchy;
    }

    private Set<Integer> getDescendants(IntegerHierarchicalGraph hierarchicalGraph, Integer vertex) {
        HashSet<Integer> visited = new HashSet<Integer>();
        HashSet<Integer> queue = new HashSet<Integer>();
        queue.add(vertex);
        while (!queue.isEmpty()) {
            Integer elem = (Integer)queue.iterator().next();
            queue.remove(elem);
            visited.add(elem);
            HashSet<Integer> children = new HashSet<Integer>();
            children.addAll(hierarchicalGraph.getChildren(elem));
            children.removeAll(visited);
            queue.addAll(children);
        }
        return visited;
    }

    @Override
    public Map<Integer, Set<Integer>> getDirectTypes() {
        if (!this.isReady()) {
            throw new UnclassifiedOntologyException();
        }
        return Collections.unmodifiableMap(this.directTypes);
    }

    protected IntegerEntityManager getEntityManager() {
        return this.entityManager;
    }

    protected IntegerSubsumerGraph getObjectPropertyGraph() {
        return this.status.getObjectPropertyGraph();
    }

    @Override
    public IntegerHierarchicalGraph getObjectPropertyHierarchy() {
        if (!this.isReady()) {
            throw new UnclassifiedOntologyException();
        }
        return this.objectPropertyHierarchy;
    }

    public NormalizedIntegerAxiomFactory getOntologyObjectFactory() {
        return this.factory;
    }

    protected IntegerBinaryRelation getRelation(Integer relationId) {
        Objects.requireNonNull(relationId);
        return this.status.getRelationSet().get(relationId);
    }

    protected Set<Integer> getRelationIdSet() {
        return Collections.unmodifiableSet(this.status.getRelationSet().getElements());
    }

    @Override
    public Map<Integer, Set<Integer>> getSameIndividualMap() {
        if (!this.isReady()) {
            throw new UnclassifiedOntologyException();
        }
        return Collections.unmodifiableMap(this.sameIndividualMap);
    }

    public List<Map.Entry<String, String>> getStatusInfo() {
        ArrayList<Map.Entry<String, String>> ret = new ArrayList<Map.Entry<String, String>>();
        ret.add(this.createEntry("iteration", "" + this.iteration));
        ret.add(this.createEntry("Q_S", "" + this.status.getNumberOfSEntries()));
        ret.add(this.createEntry("Q_R", "" + this.status.getNumberOfREntries()));
        ret.add(this.createEntry("S", "" + this.status.getDeepSizeOfS()));
        ret.add(this.createEntry("R", "" + this.status.getDeepSizeOfR()));
        ret.add(this.createEntry("V", "" + this.status.getSizeOfV()));
        ret.add(this.createEntry("subV", "" + this.status.getDeepSizeOfV()));
        return ret;
    }

    @Override
    public boolean isReady() {
        return this.isReady;
    }

    protected void postProcess() {
        this.removeAuxiliaryObjectProperties();
        this.objectPropertyHierarchy = new IntegerHierarchicalGraphImpl(this.getObjectPropertyGraph());
        this.removeAuxiliaryClassesExceptNominals();
        IntegerHierarchicalGraphImpl hierarchicalGraph = new IntegerHierarchicalGraphImpl(this.status.getClassGraph());
        this.processNominals(hierarchicalGraph);
        this.directTypes = this.computeDirectTypes(hierarchicalGraph);
        this.sameIndividualMap = this.computeSameIndividualMap(hierarchicalGraph);
        this.removeAuxiliaryNominals();
        this.classHierarchy = new IntegerHierarchicalGraphImpl(this.status.getClassGraph());
    }

    protected void preProcess(ExtendedOntology ontology) {
        logger.fine("configuring processor ...");
        this.isReady = false;
        this.status = new ClassifierStatusImpl(this.getEntityManager(), ontology);
        this.dataPropertyHierarchy = new IntegerHierarchicalGraphImpl(new IntegerSubsumerGraphImpl(IntegerEntityManager.bottomDataPropertyId, IntegerEntityManager.topDataPropertyId));
        HashSet<Integer> classNameSet = new HashSet<Integer>();
        classNameSet.addAll(this.status.getExtendedOntology().getClassSet());
        classNameSet.forEach(className -> {
            this.status.addNewSEntry((int)className, (int)className);
            this.status.addNewSEntry((int)className, topClassId);
        });
        logger.fine("processor configured.");
        logger.fine(this.showConfigurationInfo());
        int numberOfCores = Runtime.getRuntime().availableProcessors();
        logger.fine("number of cores : " + numberOfCores);
        this.getClass();
        logger.fine("running processor on a single thread.");
    }

    @Override
    public boolean process() {
        boolean ret = false;
        this.getClass();
        ret = this.processSingleThreaded();
        if (ret && this.loggingCount < 1L) {
            this.loggingCount = 0x1000000L;
            logger.fine(this.showStatusInfo());
        }
        return ret;
    }

    private boolean processMultiThreaded() {
        if (!this.isReady) {
            if (Objects.nonNull(this.threadS1) && Objects.nonNull(this.threadS2) && Objects.nonNull(this.threadR1) && Objects.nonNull(this.threadR2) && this.threadS1.getState().equals((Object)Thread.State.TERMINATED) && this.threadS2.getState().equals((Object)Thread.State.TERMINATED) && this.threadR1.getState().equals((Object)Thread.State.TERMINATED) && this.threadR2.getState().equals((Object)Thread.State.TERMINATED) && this.status.getNumberOfSEntries() == 0 && this.status.getNumberOfREntries() == 0) {
                logger.fine(this.showStatusInfo());
                this.postProcess();
                logger.fine(this.showConfigurationInfo());
                this.isReady = true;
            } else {
                if (Objects.isNull(this.threadS1) || Objects.nonNull(this.threadS1) && this.threadS1.getState().equals((Object)Thread.State.TERMINATED)) {
                    this.threadS1 = new WorkerThreadS();
                    this.threadS1.start();
                    logger.finest("starting new thread S-1 ...");
                }
                if (Objects.isNull(this.threadS2) || Objects.nonNull(this.threadS2) && this.threadS2.getState().equals((Object)Thread.State.TERMINATED)) {
                    this.threadS2 = new WorkerThreadS();
                    this.threadS2.start();
                    logger.finest("starting new thread S-2 ...");
                }
                if (Objects.isNull(this.threadR1) || Objects.nonNull(this.threadR1) && this.threadR1.getState().equals((Object)Thread.State.TERMINATED)) {
                    this.threadR1 = new WorkerThreadR();
                    this.threadR1.start();
                    logger.finest("starting new thread R-1 ...");
                }
                if (Objects.isNull(this.threadR2) || Objects.nonNull(this.threadR2) && this.threadR2.getState().equals((Object)Thread.State.TERMINATED)) {
                    this.threadR2 = new WorkerThreadR();
                    this.threadR2.start();
                    logger.finest("starting new thread R-2 ...");
                }
                try {
                    if (this.status.getNumberOfREntries() < this.status.getNumberOfSEntries()) {
                        if (this.iteration % 2L == 0L) {
                            this.threadR1.join();
                        } else {
                            this.threadR2.join();
                        }
                    } else if (this.iteration % 2L == 0L) {
                        this.threadS1.join();
                    } else {
                        this.threadS2.join();
                    }
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
        return !this.isReady;
    }

    private void processNominals(IntegerHierarchicalGraph hierarchicalGraph) {
        HashMap reachabilityCache = new HashMap();
        Set<Integer> nominals = this.getEntityManager().getAuxiliaryNominals();
        nominals.forEach(indiv -> {
            Set<Integer> descendants = this.getDescendants(hierarchicalGraph, (Integer)indiv);
            descendants.forEach(c -> descendants.forEach(d -> {
                Collection<Integer> sC = this.getClassGraph().getSubsumers((int)c);
                Collection<Integer> sD = this.getClassGraph().getSubsumers((int)d);
                if (!sD.containsAll(sC)) {
                    if (this.computeReachability((Integer)c, reachabilityCache).contains(d)) {
                        sD.forEach(elem -> this.status.getClassGraph().addAncestor((int)c, (int)elem));
                    }
                    nominals.forEach(nominal -> {
                        if (this.computeReachability((Integer)nominal, reachabilityCache).contains(d)) {
                            sD.forEach(elem -> this.status.getClassGraph().addAncestor((int)c, (int)elem));
                        }
                    });
                }
            }));
        });
    }

    private boolean processREntries() {
        boolean ret = false;
        REntry entry = null;
        try {
            entry = this.status.removeNextREntry();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        if (Objects.nonNull(entry)) {
            int rightClass;
            int leftClass;
            ret = true;
            int property = entry.getProperty();
            boolean applied = this.status.addToR(property, leftClass = entry.getLeftClass(), rightClass = entry.getRightClass());
            if (applied) {
                this.chainR.apply(this.status, property, leftClass, rightClass);
                --this.loggingCount;
                ++this.iteration;
            }
        }
        return ret;
    }

    private boolean processSEntries() {
        boolean ret = false;
        SEntry entry = null;
        try {
            entry = this.status.removeNextSEntry();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        if (Objects.nonNull(entry)) {
            int superClass;
            ret = true;
            int subClass = entry.getSubClass();
            boolean applied = this.status.addToS(subClass, superClass = entry.getSuperClass());
            if (applied) {
                this.chainS.apply(this.status, subClass, superClass);
                --this.loggingCount;
                ++this.iteration;
            }
        }
        return ret;
    }

    private boolean processSingleThreaded() {
        if (!this.isReady) {
            if (this.status.getNumberOfSEntries() == 0 && this.status.getNumberOfREntries() == 0) {
                logger.fine(this.showStatusInfo());
                this.postProcess();
                logger.fine(this.showConfigurationInfo());
                this.isReady = true;
            } else if (this.status.getNumberOfSEntries() > this.status.getNumberOfREntries()) {
                this.processSEntries();
            } else {
                this.processREntries();
            }
        }
        return !this.isReady;
    }

    private void removeAuxiliaryClassesExceptNominals() {
        HashSet<Integer> reqClasses = new HashSet<Integer>();
        this.getClassGraph().getElements().forEach(elem -> {
            if (!this.getEntityManager().isAuxiliary((Integer)elem)) {
                reqClasses.add((Integer)elem);
            }
        });
        reqClasses.addAll(this.getEntityManager().getAuxiliaryNominals());
        this.status.getClassGraph().retainAll(reqClasses);
    }

    private void removeAuxiliaryNominals() {
        HashSet<Integer> reqClasses = new HashSet<Integer>();
        reqClasses.addAll(this.getClassGraph().getElements());
        reqClasses.removeAll(this.getEntityManager().getAuxiliaryNominals());
        this.status.getClassGraph().retainAll(reqClasses);
    }

    private void removeAuxiliaryObjectProperties() {
        HashSet<Integer> reqObjectProperties = new HashSet<Integer>();
        this.getObjectPropertyGraph().getElements().forEach(elem -> {
            if (!this.getEntityManager().isAuxiliary((Integer)elem)) {
                reqObjectProperties.add((Integer)elem);
            }
        });
        this.status.getObjectPropertyGraph().retainAll(reqObjectProperties);
    }

    public String showConfigurationInfo() {
        StringBuffer sbuf = new StringBuffer();
        this.getConfigurationInfo().forEach(entry -> {
            sbuf.append((String)entry.getKey());
            sbuf.append(" = ");
            sbuf.append((String)entry.getValue());
            sbuf.append("\n");
        });
        return sbuf.toString();
    }

    public String showStatusInfo() {
        StringBuffer sbuf = new StringBuffer();
        this.getStatusInfo().forEach(entry -> {
            sbuf.append((String)entry.getKey());
            sbuf.append("=");
            sbuf.append((String)entry.getValue());
            sbuf.append(" ");
        });
        return sbuf.toString();
    }

    public void outputSetS(Writer writer) throws IOException {
        this.status.outputSetS(writer);
    }

    public void outputSetR(Writer writer) throws IOException {
        this.status.outputSetR(writer);
    }

    private class WorkerThreadS
    extends Thread {
        private WorkerThreadS() {
        }

        @Override
        public void run() {
            while (RuleBasedProcessor.this.status.getNumberOfSEntries() > 0) {
                while (RuleBasedProcessor.this.status.getNumberOfSEntries() > 0) {
                    RuleBasedProcessor.this.processSEntries();
                }
                try {
                    Thread.sleep(32L);
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
    }

    private class WorkerThreadR
    extends Thread {
        private WorkerThreadR() {
        }

        @Override
        public void run() {
            while (RuleBasedProcessor.this.status.getNumberOfREntries() > 0) {
                while (RuleBasedProcessor.this.status.getNumberOfREntries() > 0) {
                    RuleBasedProcessor.this.processREntries();
                }
                try {
                    Thread.sleep(32L);
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
    }
}

