/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.core.graph;

import de.tudresden.inf.lat.jcel.core.graph.IntegerHierarchicalGraph;
import de.tudresden.inf.lat.jcel.core.graph.IntegerSubsumerGraph;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class IntegerHierarchicalGraphImpl
implements IntegerHierarchicalGraph {
    private final Integer bottomElement;
    private final Map<Integer, Set<Integer>> children = new TreeMap<Integer, Set<Integer>>();
    private final Map<Integer, Set<Integer>> equivalents = new TreeMap<Integer, Set<Integer>>();
    private final Map<Integer, Set<Integer>> parents = new TreeMap<Integer, Set<Integer>>();
    private final Map<Integer, Integer> representative = new TreeMap<Integer, Integer>();
    private final Integer topElement;

    public IntegerHierarchicalGraphImpl(Integer bottom, Integer top) {
        Objects.requireNonNull(bottom);
        Objects.requireNonNull(top);
        this.bottomElement = bottom;
        this.topElement = top;
    }

    public IntegerHierarchicalGraphImpl(IntegerSubsumerGraph origGraph) {
        Objects.requireNonNull(origGraph);
        this.bottomElement = origGraph.getBottomElement();
        this.topElement = origGraph.getTopElement();
        if (origGraph.containsPair(this.getTopElement(), this.getBottomElement())) {
            this.computeInconsistentDag(origGraph);
        } else {
            this.computeDag(origGraph);
            this.updateParents();
            this.updateChildren();
            this.updateBottom();
        }
    }

    private void computeDag(IntegerSubsumerGraph setS) {
        this.reset(setS.getElements());
        TreeSet<Integer> sCN = new TreeSet<Integer>();
        sCN.addAll(setS.getElements());
        sCN.remove(this.getBottomElement());
        sCN.remove(this.getTopElement());
        TreeSet<Integer> equivToTop = new TreeSet<Integer>();
        equivToTop.addAll(setS.getSubsumers(this.getTopElement()));
        equivToTop.forEach(elem -> this.makeEquivalent(this.getTopElement(), (Integer)elem));
        TreeSet<Integer> classified = new TreeSet<Integer>();
        classified.addAll(equivToTop);
        sCN.forEach(cA -> {
            if (!classified.contains(cA)) {
                this.dagClassify((Integer)cA, (Set<Integer>)classified, setS);
            }
        });
    }

    private void computeInconsistentDag(IntegerSubsumerGraph setS) {
        Collection<Integer> elements = setS.getElements();
        this.reset(elements);
        elements.forEach(elem -> this.makeEquivalent(this.getBottomElement(), (Integer)elem));
    }

    private void dagClassify(Integer cA, Set<Integer> classified, IntegerSubsumerGraph setS) {
        TreeSet<Integer> candidates = new TreeSet<Integer>();
        candidates.add(this.getTopElement());
        TreeSet<Integer> subsumersA = new TreeSet<Integer>();
        subsumersA.addAll(setS.getSubsumers(cA));
        subsumersA.remove(cA);
        subsumersA.remove(this.getTopElement());
        subsumersA.forEach(cB -> {
            TreeSet<Integer> subsumersB = new TreeSet<Integer>();
            subsumersB.addAll(setS.getSubsumers((int)cB));
            if (subsumersB.contains(cA)) {
                classified.add((Integer)cB);
                this.makeEquivalent(cA, (Integer)cB);
            } else {
                if (!classified.contains(cB)) {
                    this.dagClassify((Integer)cB, classified, setS);
                }
                candidates.add((Integer)cB);
            }
        });
        this.dagInsert(cA, candidates);
        classified.add(cA);
    }

    private void dagInsert(Integer cA, Set<Integer> candidates) {
        TreeSet marked = new TreeSet();
        candidates.forEach(cB -> {
            Set<Integer> parentSet = this.parents.get(cB);
            parentSet.forEach(cX -> marked.add(cX));
        });
        TreeSet<Integer> notMarkedCandidates = new TreeSet<Integer>();
        notMarkedCandidates.addAll(candidates);
        notMarkedCandidates.removeAll(marked);
        this.parents.put(cA, notMarkedCandidates);
        notMarkedCandidates.forEach(cB -> this.children.get(cB).add(cA));
    }

    public void disjointUnion(IntegerHierarchicalGraph otherGraph) {
        Objects.requireNonNull(otherGraph);
        if (this.getBottomElement().equals(otherGraph.getBottomElement()) && this.getTopElement().equals(otherGraph.getTopElement())) {
            HashSet<Integer> set = new HashSet<Integer>();
            set.addAll(this.getElements());
            set.remove(this.getBottomElement());
            set.remove(this.getTopElement());
            set.retainAll(otherGraph.getElements());
            if (!set.isEmpty()) {
                throw new IllegalArgumentException("Graphs are not disjoint.");
            }
        } else {
            throw new IllegalArgumentException("Both graphs have different bottom element or different top element.");
        }
        HashSet<Integer> otherSet = new HashSet<Integer>();
        otherSet.addAll(otherGraph.getElements());
        otherSet.forEach(elem -> {
            if (Objects.isNull(this.children.get(elem))) {
                this.children.put((Integer)elem, new HashSet());
            }
            this.children.get(elem).addAll(otherGraph.getChildren((Integer)elem));
            if (Objects.isNull(this.parents.get(elem))) {
                this.parents.put((Integer)elem, new HashSet());
            }
            this.parents.get(elem).addAll(otherGraph.getParents((Integer)elem));
            if (Objects.isNull(this.equivalents.get(elem))) {
                this.equivalents.put((Integer)elem, new HashSet());
            }
            if (Objects.isNull(this.representative.get(elem))) {
                this.representative.put((Integer)elem, (Integer)elem);
            }
            otherGraph.getEquivalents((Integer)elem).forEach(otherElem -> this.makeEquivalent((Integer)elem, (Integer)otherElem));
        });
    }

    public boolean equals(Object o) {
        boolean ret;
        boolean bl = ret = this == o;
        if (!ret && o instanceof IntegerHierarchicalGraph) {
            IntegerHierarchicalGraph other = (IntegerHierarchicalGraph)o;
            ret = this.getBottomElement().equals(other.getBottomElement()) && this.getTopElement().equals(other.getTopElement()) && this.getElements().equals(other.getElements());
            ret = ret && this.getElements().stream().allMatch(elem -> this.getChildren((Integer)elem).equals(other.getChildren((Integer)elem)) && this.getParents((Integer)elem).equals(other.getParents((Integer)elem)) && this.getEquivalents((Integer)elem).equals(other.getEquivalents((Integer)elem)));
        }
        return ret;
    }

    @Override
    public Set<Integer> getAncestors(Integer orig) {
        Objects.requireNonNull(orig);
        HashSet<Integer> ret = new HashSet<Integer>();
        HashSet toVisit = new HashSet();
        toVisit.addAll(this.parents.get(orig));
        while (!toVisit.isEmpty()) {
            Integer elem = (Integer)toVisit.iterator().next();
            toVisit.remove(elem);
            ret.add(elem);
            HashSet related = new HashSet();
            related.addAll(this.parents.get(elem));
            related.removeAll(ret);
            toVisit.addAll(related);
        }
        return ret;
    }

    @Override
    public Integer getBottomElement() {
        return this.bottomElement;
    }

    @Override
    public Set<Integer> getChildren(Integer elem) {
        Objects.requireNonNull(elem);
        return Collections.unmodifiableSet(this.children.get(elem));
    }

    @Override
    public Set<Integer> getDescendants(Integer orig) {
        Objects.requireNonNull(orig);
        HashSet<Integer> ret = new HashSet<Integer>();
        HashSet toVisit = new HashSet();
        toVisit.addAll(this.children.get(orig));
        while (!toVisit.isEmpty()) {
            Integer elem = (Integer)toVisit.iterator().next();
            toVisit.remove(elem);
            ret.add(elem);
            HashSet related = new HashSet();
            related.addAll(this.children.get(elem));
            related.removeAll(ret);
            toVisit.addAll(related);
        }
        return ret;
    }

    @Override
    public Set<Integer> getElements() {
        return Collections.unmodifiableSet(this.representative.keySet());
    }

    @Override
    public Set<Integer> getEquivalents(Integer elem) {
        Objects.requireNonNull(elem);
        return Collections.unmodifiableSet(this.equivalents.get(this.representative.get(elem)));
    }

    public Set<Integer> getNonEquivalentElements() {
        return Collections.unmodifiableSet(this.equivalents.keySet());
    }

    @Override
    public Set<Integer> getParents(Integer elem) {
        Objects.requireNonNull(elem);
        return Collections.unmodifiableSet(this.parents.get(elem));
    }

    @Override
    public Integer getTopElement() {
        return this.topElement;
    }

    public int hashCode() {
        return this.parents.hashCode();
    }

    private void makeEquivalent(Integer cA, Integer cB) {
        Integer repB;
        Integer repA = this.representative.get(cA);
        if (!repA.equals(repB = this.representative.get(cB))) {
            Integer rep = Math.min(repA, repB);
            Integer exRep = Math.max(repA, repB);
            this.equivalents.get(rep).addAll((Collection<Integer>)this.equivalents.get(exRep));
            this.equivalents.get(exRep).forEach(elem -> this.representative.put((Integer)elem, rep));
            this.equivalents.remove(exRep);
        }
    }

    private void reset(Collection<Integer> elements) {
        this.children.clear();
        this.parents.clear();
        this.equivalents.clear();
        this.representative.clear();
        elements.forEach(elem -> {
            this.children.put((Integer)elem, new TreeSet());
            this.parents.put((Integer)elem, new TreeSet());
            TreeSet<Integer> equiv = new TreeSet<Integer>();
            equiv.add((Integer)elem);
            this.equivalents.put((Integer)elem, (Set<Integer>)equiv);
            this.representative.put((Integer)elem, (Integer)elem);
        });
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("\n* children : ");
        ret.append(this.children);
        ret.append("\n* parents : ");
        ret.append(this.parents);
        ret.append("\n* equivalents : ");
        ret.append(this.equivalents);
        ret.append("\n* representative : ");
        ret.append(this.representative);
        ret.append("\n");
        return ret.toString();
    }

    private void updateBottom() {
        HashSet<Integer> parentsOfBottom = new HashSet<Integer>();
        this.getElements().forEach(elem -> {
            if (this.children.get(elem).isEmpty()) {
                parentsOfBottom.add((Integer)elem);
            }
        });
        Set<Integer> equivToBottom = this.equivalents.get(this.bottomElement);
        parentsOfBottom.removeAll(equivToBottom);
        if (!equivToBottom.contains(this.topElement) && parentsOfBottom.isEmpty()) {
            parentsOfBottom.add(this.topElement);
        }
        parentsOfBottom.forEach(elem -> this.children.get(elem).add(this.bottomElement));
        equivToBottom.forEach(elem -> this.parents.put((Integer)elem, (Set<Integer>)parentsOfBottom));
    }

    private void updateChildren() {
        this.getElements().forEach(elem -> {
            HashSet elemChildren = new HashSet();
            this.getEquivalents((Integer)elem).forEach(index -> this.children.get(index).forEach(child -> elemChildren.addAll(this.getEquivalents((Integer)child))));
            this.getEquivalents((Integer)elem).forEach(index -> this.children.put((Integer)index, elemChildren));
        });
    }

    private void updateParents() {
        this.getElements().forEach(elem -> {
            HashSet elemParents = new HashSet();
            this.getEquivalents((Integer)elem).forEach(index -> this.parents.get(index).forEach(parent -> elemParents.addAll(this.getEquivalents((Integer)parent))));
            this.getEquivalents((Integer)elem).forEach(index -> this.parents.put((Integer)index, elemParents));
        });
    }
}

