/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.core.graph;

import de.tudresden.inf.lat.jcel.core.graph.ArraySet;
import de.tudresden.inf.lat.jcel.core.graph.IntegerBinaryRelation;
import de.tudresden.inf.lat.jcel.core.graph.IntegerBinaryRelationImpl;
import de.tudresden.inf.lat.jcel.core.graph.IntegerRelationMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class IntegerRelationMapImpl
implements IntegerRelationMap {
    private final Map<Integer, IntegerBinaryRelationImpl> relationMap = new ConcurrentHashMap<Integer, IntegerBinaryRelationImpl>();
    private final Map<Integer, Collection<Integer>> relationSetByFirst = new ConcurrentHashMap<Integer, Collection<Integer>>();
    private final Map<Integer, Collection<Integer>> relationSetBySecond = new ConcurrentHashMap<Integer, Collection<Integer>>();

    public boolean add(int relationId) {
        boolean ret = false;
        if (!this.relationMap.containsKey(relationId)) {
            this.relationMap.put(relationId, new IntegerBinaryRelationImpl());
            ret = true;
        }
        return ret;
    }

    public boolean add(int relationId, int first, int second) {
        boolean ret = false;
        IntegerBinaryRelationImpl relation = this.relationMap.get(relationId);
        if (Objects.isNull(relation)) {
            relation = new IntegerBinaryRelationImpl();
            this.relationMap.put(relationId, relation);
            ret = true;
        }
        ret |= relation.add(first, second);
        ArraySet byFirst = this.relationSetByFirst.get(first);
        if (Objects.isNull(byFirst)) {
            byFirst = new ArraySet();
            this.relationSetByFirst.put(first, byFirst);
            ret = true;
        }
        ret |= byFirst.add(relationId);
        ArraySet bySecond = this.relationSetBySecond.get(second);
        if (Objects.isNull(bySecond)) {
            bySecond = new ArraySet();
            this.relationSetBySecond.put(second, bySecond);
            ret = true;
        }
        return ret |= bySecond.add(relationId);
    }

    @Override
    public boolean contains(int relationId) {
        return this.relationMap.containsKey(relationId);
    }

    @Override
    public boolean contains(int relationId, int first, int second) {
        boolean ret = false;
        IntegerBinaryRelation relation = this.relationMap.get(relationId);
        if (Objects.nonNull(relation)) {
            ret = relation.contains(first, second);
        }
        return ret;
    }

    public boolean equals(Object o) {
        boolean ret;
        boolean bl = ret = this == o;
        if (!ret && o instanceof IntegerRelationMap) {
            IntegerRelationMap other = (IntegerRelationMap)o;
            ret = this.getElements().equals(other.getElements());
            ret = ret && this.getElements().stream().allMatch(elem -> this.get((int)elem).equals(other.get((int)elem)));
        }
        return ret;
    }

    @Override
    public IntegerBinaryRelation get(int relationId) {
        return this.relationMap.get(relationId);
    }

    @Override
    public Collection<Integer> getByFirst(int relationId, int first) {
        Collection<Integer> ret = Collections.emptySet();
        IntegerBinaryRelation relation = this.relationMap.get(relationId);
        if (Objects.nonNull(relation)) {
            ret = relation.getByFirst(first);
        }
        return ret;
    }

    @Override
    public Collection<Integer> getBySecond(int relationId, int second) {
        Collection<Integer> ret = Collections.emptySet();
        IntegerBinaryRelation relation = this.relationMap.get(relationId);
        if (Objects.nonNull(relation)) {
            ret = relation.getBySecond(second);
        }
        return ret;
    }

    public long getDeepSize() {
        long ret = 0L;
        ret += this.relationMap.keySet().stream().map(key -> this.relationMap.get(key).getDeepSize()).reduce(0L, (accum, elem) -> accum + elem).longValue();
        ret += (long)this.relationSetByFirst.keySet().stream().map(key -> this.relationSetByFirst.get(key).size()).reduce(0, (accum, elem) -> accum + elem).intValue();
        return ret += (long)this.relationSetBySecond.keySet().stream().map(key -> this.relationSetBySecond.get(key).size()).reduce(0, (accum, elem) -> accum + elem).intValue();
    }

    @Override
    public Set<Integer> getElements() {
        return this.relationMap.keySet();
    }

    @Override
    public Collection<Integer> getRelationsByFirst(int first) {
        Collection<Integer> ret = this.relationSetByFirst.get(first);
        if (Objects.isNull(ret)) {
            ret = Collections.emptySet();
        }
        return Collections.unmodifiableCollection(ret);
    }

    @Override
    public Collection<Integer> getRelationsBySecond(int second) {
        Collection<Integer> ret = this.relationSetBySecond.get(second);
        if (Objects.isNull(ret)) {
            ret = Collections.emptySet();
        }
        return Collections.unmodifiableCollection(ret);
    }

    public int hashCode() {
        return this.relationMap.hashCode();
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        this.getElements().forEach(relationId -> {
            sbuf.append(relationId);
            sbuf.append(" ");
            sbuf.append(this.relationMap.get(relationId).toString());
            sbuf.append("\n");
        });
        return sbuf.toString();
    }
}

