/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.core.graph;

import de.tudresden.inf.lat.jcel.core.graph.ArraySet;
import de.tudresden.inf.lat.jcel.core.graph.IntegerSubsumerGraph;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class IntegerSubsumerGraphImpl
implements IntegerSubsumerGraph {
    private final int bottomElement;
    private final Collection<Integer> emptyCollection = Collections.unmodifiableCollection(new ArraySet());
    private final Set<Integer> equivToBottom = new HashSet<Integer>();
    private final Map<Integer, Collection<Integer>> setS = new ConcurrentHashMap<Integer, Collection<Integer>>();
    private final int topElement;

    public IntegerSubsumerGraphImpl(int bottom, int top) {
        this.bottomElement = bottom;
        this.topElement = top;
        this.setS.put(this.bottomElement, this.emptyCollection);
        this.setS.put(this.topElement, Collections.synchronizedCollection(new ArraySet()));
        this.equivToBottom.add(this.bottomElement);
    }

    public boolean add(int vertex) {
        boolean ret = false;
        if (!this.setS.containsKey(vertex)) {
            this.setS.put(vertex, Collections.synchronizedCollection(new ArraySet()));
            ret = true;
        }
        return ret;
    }

    public boolean addAncestor(int subId, int superId) {
        boolean ret = false;
        if (!this.equivToBottom.contains(subId)) {
            if (this.bottomElement == superId) {
                ret |= this.equivToBottom.add(subId);
                this.setS.put(subId, this.emptyCollection);
            } else {
                ret |= this.add(subId);
                ret |= this.add(superId);
                Collection<Integer> set = this.setS.get(subId);
                if (!set.contains(superId)) {
                    ret |= set.add(superId);
                }
            }
        }
        return ret;
    }

    @Override
    public boolean containsPair(int subsumee, int subsumer) {
        return Objects.nonNull(this.getSubsumers(subsumee)) && this.getSubsumers(subsumee).contains(subsumer);
    }

    public boolean equals(Object o) {
        boolean ret;
        boolean bl = ret = this == o;
        if (!ret && o instanceof IntegerSubsumerGraph) {
            IntegerSubsumerGraph other = (IntegerSubsumerGraph)o;
            ret = this.getBottomElement() == other.getBottomElement() && this.getTopElement() == other.getTopElement() && this.getElements().equals(other.getElements());
            ret = ret && this.getElements().stream().allMatch(elem -> this.getSubsumers((int)elem).equals(other.getSubsumers((int)elem)));
        }
        return ret;
    }

    @Override
    public int getBottomElement() {
        return this.bottomElement;
    }

    public long getDeepSize() {
        return this.setS.keySet().stream().map(key -> this.setS.get(key).size()).reduce(0, (accum, elem) -> accum + elem).intValue();
    }

    @Override
    public Collection<Integer> getElements() {
        return Collections.unmodifiableSet(this.setS.keySet());
    }

    @Override
    public Collection<Integer> getSubsumers(int vertex) {
        Collection<Object> ret;
        ret = this.equivToBottom.contains(vertex) ? this.getElements() : (Objects.isNull(ret = this.setS.get(vertex)) ? Collections.emptySet() : Collections.unmodifiableCollection(ret));
        return ret;
    }

    @Override
    public int getTopElement() {
        return this.topElement;
    }

    public int hashCode() {
        return this.setS.hashCode();
    }

    public void retainAll(Collection<Integer> collection) {
        Objects.requireNonNull(collection);
        HashSet<Integer> keySet = new HashSet<Integer>();
        keySet.addAll(this.setS.keySet());
        keySet.forEach(key -> {
            if (collection.contains(key)) {
                Collection<Integer> value = Collections.synchronizedCollection(new ArraySet());
                this.getSubsumers((int)key).forEach(elem -> {
                    if (collection.contains(elem)) {
                        value.add((Integer)elem);
                    }
                });
                this.setS.put((Integer)key, value);
            }
        });
        keySet.forEach(key -> {
            if (!collection.contains(key)) {
                this.setS.remove(key);
                if (this.equivToBottom.contains(key)) {
                    this.equivToBottom.remove(key);
                }
            }
        });
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("equivalent to bottom: ");
        this.equivToBottom.forEach(elem -> ret.append(" " + elem));
        ret.append("\n");
        this.setS.keySet().forEach(id -> {
            Collection<Integer> related = this.getSubsumers((int)id);
            if (this.equivToBottom.contains(id)) {
                ret.append("* ");
            }
            ret.append(id);
            ret.append(" (");
            ret.append(related.size());
            ret.append(") : ");
            related.forEach(elem -> ret.append(elem + " "));
            ret.append("\n");
        });
        return ret.toString();
    }
}

