/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.core.saturation;

import de.tudresden.inf.lat.jcel.core.saturation.SaturationRule;
import de.tudresden.inf.lat.jcel.core.saturation.SaturationRuleHelper;
import de.tudresden.inf.lat.jcel.coreontology.axiom.IntegerAnnotation;
import de.tudresden.inf.lat.jcel.coreontology.axiom.NormalizedIntegerAxiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.NormalizedIntegerAxiomFactory;
import de.tudresden.inf.lat.jcel.coreontology.axiom.RI2Axiom;
import de.tudresden.inf.lat.jcel.coreontology.datatype.IntegerEntityManager;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public class SR1AndSR2Rules
implements SaturationRule {
    private final NormalizedIntegerAxiomFactory factory;
    private final SaturationRuleHelper helper = new SaturationRuleHelper();
    private final IntegerEntityManager idGenerator;

    public SR1AndSR2Rules(NormalizedIntegerAxiomFactory factory, IntegerEntityManager entityManager) {
        Objects.requireNonNull(factory);
        Objects.requireNonNull(entityManager);
        this.factory = factory;
        this.idGenerator = entityManager;
    }

    @Override
    public Set<NormalizedIntegerAxiom> apply(Set<NormalizedIntegerAxiom> originalSet) {
        Objects.requireNonNull(originalSet);
        HashSet<NormalizedIntegerAxiom> ret = new HashSet<NormalizedIntegerAxiom>();
        ret.addAll(originalSet);
        HashSet<RI2Axiom> accumulatedSet = new HashSet<RI2Axiom>();
        HashSet<RI2Axiom> currentSet = new HashSet<RI2Axiom>();
        currentSet.addAll(this.helper.getRI2Axioms(originalSet));
        while (!currentSet.isEmpty()) {
            accumulatedSet.addAll(currentSet);
            currentSet = new HashSet();
            currentSet.addAll(this.applyRule1(accumulatedSet));
            currentSet.addAll(this.applyRule2(accumulatedSet));
            currentSet.removeAll(accumulatedSet);
        }
        ret.addAll(accumulatedSet);
        return Collections.unmodifiableSet(ret);
    }

    private Set<RI2Axiom> applyRule1(Set<RI2Axiom> axiomSet) {
        HashSet<RI2Axiom> ret = new HashSet<RI2Axiom>();
        axiomSet.forEach(axiom -> {
            Integer invSubProperty = this.idGenerator.createOrGetInverseObjectPropertyOf(axiom.getSubProperty());
            Integer invSuperProperty = this.idGenerator.createOrGetInverseObjectPropertyOf(axiom.getSuperProperty());
            ret.add(this.factory.createRI2Axiom(invSubProperty, invSuperProperty, axiom.getAnnotations()));
        });
        return ret;
    }

    private Set<RI2Axiom> applyRule2(Set<RI2Axiom> axiomSet) {
        HashSet<RI2Axiom> ret = new HashSet<RI2Axiom>();
        axiomSet.forEach(axiom0 -> axiomSet.forEach(axiom1 -> {
            if (axiom0.getSuperProperty() == axiom1.getSubProperty()) {
                TreeSet<IntegerAnnotation> annotations = new TreeSet<IntegerAnnotation>();
                annotations.addAll(axiom0.getAnnotations());
                annotations.addAll(axiom1.getAnnotations());
                ret.add(this.factory.createRI2Axiom(axiom0.getSubProperty(), axiom1.getSuperProperty(), annotations));
            }
        }));
        return ret;
    }
}

