/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.core.saturation;

import de.tudresden.inf.lat.jcel.core.saturation.SaturationRule;
import de.tudresden.inf.lat.jcel.core.saturation.SaturationRuleHelper;
import de.tudresden.inf.lat.jcel.coreontology.axiom.FunctObjectPropAxiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.NormalizedIntegerAxiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.NormalizedIntegerAxiomFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class SR4Rule
implements SaturationRule {
    private final NormalizedIntegerAxiomFactory factory;
    private final SaturationRuleHelper helper = new SaturationRuleHelper();

    public SR4Rule(NormalizedIntegerAxiomFactory factory) {
        Objects.requireNonNull(factory);
        this.factory = factory;
    }

    @Override
    public Set<NormalizedIntegerAxiom> apply(Set<NormalizedIntegerAxiom> originalSet) {
        Objects.requireNonNull(originalSet);
        Map<Integer, Set<Integer>> mapBySuperProp = this.helper.getMapBySuperObjectProperty(this.helper.getRI2Axioms(originalSet));
        HashSet<NormalizedIntegerAxiom> ret = new HashSet<NormalizedIntegerAxiom>();
        ret.addAll(originalSet);
        originalSet.forEach(normalizedAxiom -> {
            if (normalizedAxiom instanceof FunctObjectPropAxiom) {
                FunctObjectPropAxiom axiom = (FunctObjectPropAxiom)normalizedAxiom;
                Integer functionalProperty = axiom.getProperty();
                Set<Integer> newFunctionalPropertySet = this.helper.getReachable(functionalProperty, mapBySuperProp);
                newFunctionalPropertySet.forEach(newFunctionalProperty -> ret.add(this.factory.createFunctObjectPropAxiom((int)newFunctionalProperty, axiom.getAnnotations())));
            }
        });
        return Collections.unmodifiableSet(ret);
    }
}

