/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.indexing.hierarchy;

import java.util.Map;
import org.apache.log4j.Logger;
import org.semanticweb.elk.owl.exceptions.ElkRuntimeException;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.hierarchy.ModifiableOntologyIndex;
import org.semanticweb.elk.reasoner.indexing.visitors.IndexedClassExpressionVisitor;
import org.semanticweb.elk.reasoner.indexing.visitors.IndexedObjectIntersectionOfVisitor;
import org.semanticweb.elk.reasoner.saturation.BasicSaturationStateWriter;
import org.semanticweb.elk.reasoner.saturation.conclusions.NegativeSubsumer;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.semanticweb.elk.reasoner.saturation.rules.ChainableRule;
import org.semanticweb.elk.reasoner.saturation.rules.DecompositionRuleApplicationVisitor;
import org.semanticweb.elk.reasoner.saturation.rules.RuleApplicationVisitor;
import org.semanticweb.elk.util.collections.ArrayHashMap;
import org.semanticweb.elk.util.collections.LazySetIntersection;
import org.semanticweb.elk.util.collections.chains.Chain;
import org.semanticweb.elk.util.collections.chains.Matcher;
import org.semanticweb.elk.util.collections.chains.ModifiableLinkImpl;
import org.semanticweb.elk.util.collections.chains.ReferenceFactory;
import org.semanticweb.elk.util.collections.chains.SimpleTypeBasedMatcher;

public class IndexedObjectIntersectionOf
extends IndexedClassExpression {
    protected static final Logger LOGGER_ = Logger.getLogger(IndexedObjectIntersectionOf.class);
    private final IndexedClassExpression firstConjunct_;
    private final IndexedClassExpression secondConjunct_;

    protected IndexedObjectIntersectionOf(IndexedClassExpression conjunctA, IndexedClassExpression conjunctB) {
        if (conjunctA.compareTo(conjunctB) < 0) {
            this.firstConjunct_ = conjunctA;
            this.secondConjunct_ = conjunctB;
        } else {
            this.firstConjunct_ = conjunctB;
            this.secondConjunct_ = conjunctA;
        }
    }

    public IndexedClassExpression getFirstConjunct() {
        return this.firstConjunct_;
    }

    public IndexedClassExpression getSecondConjunct() {
        return this.secondConjunct_;
    }

    public <O> O accept(IndexedObjectIntersectionOfVisitor<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public <O> O accept(IndexedClassExpressionVisitor<O> visitor) {
        return this.accept((IndexedObjectIntersectionOfVisitor<O>)visitor);
    }

    @Override
    protected void updateOccurrenceNumbers(ModifiableOntologyIndex index, int increment, int positiveIncrement, int negativeIncrement) {
        if (this.negativeOccurrenceNo == 0 && negativeIncrement > 0) {
            index.add(this.firstConjunct_, new ThisCompositionRule(this.secondConjunct_, this));
            if (!this.secondConjunct_.equals(this.firstConjunct_)) {
                index.add(this.secondConjunct_, new ThisCompositionRule(this.firstConjunct_, this));
            }
        }
        this.positiveOccurrenceNo += positiveIncrement;
        this.negativeOccurrenceNo += negativeIncrement;
        this.checkOccurrenceNumbers();
        if (this.negativeOccurrenceNo == 0 && negativeIncrement < 0) {
            index.remove(this.firstConjunct_, new ThisCompositionRule(this.secondConjunct_, this));
            if (!this.secondConjunct_.equals(this.firstConjunct_)) {
                index.remove(this.secondConjunct_, new ThisCompositionRule(this.firstConjunct_, this));
            }
        }
    }

    @Override
    public String toStringStructural() {
        return "ObjectIntersectionOf(" + this.firstConjunct_ + ' ' + this.secondConjunct_ + ')';
    }

    @Override
    public void accept(DecompositionRuleApplicationVisitor visitor, Context context) {
        visitor.visit(this, context);
    }

    public static class ThisCompositionRule
    extends ModifiableLinkImpl<ChainableRule<Context>>
    implements ChainableRule<Context> {
        private static final String NAME = "ObjectIntersectionOf Introduction";
        private final Map<IndexedClassExpression, IndexedObjectIntersectionOf> conjunctionsByConjunct_ = new ArrayHashMap<IndexedClassExpression, IndexedObjectIntersectionOf>(4);
        private static final Matcher<ChainableRule<Context>, ThisCompositionRule> MATCHER_ = new SimpleTypeBasedMatcher<ChainableRule<Context>, ThisCompositionRule>(ThisCompositionRule.class);
        private static final ReferenceFactory<ChainableRule<Context>, ThisCompositionRule> FACTORY_ = new ReferenceFactory<ChainableRule<Context>, ThisCompositionRule>(){

            @Override
            public ThisCompositionRule create(ChainableRule<Context> tail) {
                return new ThisCompositionRule(tail);
            }
        };

        private ThisCompositionRule(ChainableRule<Context> tail) {
            super(tail);
        }

        ThisCompositionRule(IndexedClassExpression conjunct, IndexedObjectIntersectionOf conjunction) {
            this(null);
            this.conjunctionsByConjunct_.put(conjunct, conjunction);
        }

        @Override
        public String getName() {
            return NAME;
        }

        public Map<IndexedClassExpression, IndexedObjectIntersectionOf> getConjunctionsByConjunct() {
            return this.conjunctionsByConjunct_;
        }

        @Override
        public void apply(BasicSaturationStateWriter writer, Context context) {
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace((Object)("Applying ObjectIntersectionOf Introduction to " + context));
            }
            for (IndexedClassExpression common : new LazySetIntersection<IndexedClassExpression>(this.conjunctionsByConjunct_.keySet(), context.getSubsumers())) {
                writer.produce(context, new NegativeSubsumer(this.conjunctionsByConjunct_.get(common)));
            }
        }

        @Override
        public boolean addTo(Chain<ChainableRule<Context>> ruleChain) {
            ThisCompositionRule rule = ruleChain.getCreate(MATCHER_, FACTORY_);
            boolean changed = false;
            for (Map.Entry<IndexedClassExpression, IndexedObjectIntersectionOf> entry : this.conjunctionsByConjunct_.entrySet()) {
                changed |= rule.addConjunctionByConjunct(entry.getValue(), entry.getKey());
            }
            return changed;
        }

        @Override
        public boolean removeFrom(Chain<ChainableRule<Context>> ruleChain) {
            ThisCompositionRule rule = ruleChain.find(MATCHER_);
            boolean changed = false;
            if (rule != null) {
                for (IndexedClassExpression conjunct : this.conjunctionsByConjunct_.keySet()) {
                    changed |= rule.removeConjunctionByConjunct(conjunct);
                }
                if (rule.isEmpty()) {
                    ruleChain.remove(MATCHER_);
                }
            }
            return changed;
        }

        @Override
        public void accept(RuleApplicationVisitor visitor, BasicSaturationStateWriter writer, Context context) {
            visitor.visit(this, writer, context);
        }

        private boolean addConjunctionByConjunct(IndexedObjectIntersectionOf conjunction, IndexedClassExpression conjunct) {
            IndexedObjectIntersectionOf previous = this.conjunctionsByConjunct_.put(conjunct, conjunction);
            if (previous == null) {
                return true;
            }
            throw new ElkRuntimeException("Conjunction " + conjunction + "is already indexed: " + previous);
        }

        private boolean removeConjunctionByConjunct(IndexedClassExpression conjunct) {
            return this.conjunctionsByConjunct_.remove(conjunct) != null;
        }

        private boolean isEmpty() {
            return this.conjunctionsByConjunct_.isEmpty();
        }
    }
}

