/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import org.apache.log4j.Logger;
import org.semanticweb.elk.loading.AxiomLoader;
import org.semanticweb.elk.owl.exceptions.ElkException;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.printers.OwlFunctionalStylePrinter;
import org.semanticweb.elk.owl.visitors.ElkAxiomProcessor;
import org.semanticweb.elk.reasoner.incremental.NonIncrementalChangeListener;
import org.semanticweb.elk.reasoner.indexing.hierarchy.ChangeIndexingProcessor;
import org.semanticweb.elk.reasoner.indexing.hierarchy.ElkAxiomIndexingVisitor;
import org.semanticweb.elk.reasoner.indexing.hierarchy.MainAxiomIndexerVisitor;
import org.semanticweb.elk.reasoner.indexing.hierarchy.ModifiableOntologyIndex;
import org.semanticweb.elk.reasoner.indexing.hierarchy.NonIncrementalChangeCheckingVisitor;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerStage;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerState;

public class AxiomLoadingStage
extends AbstractReasonerStage {
    private static final Logger LOGGER_ = Logger.getLogger(AxiomLoadingStage.class);
    private volatile AxiomLoader loader_;
    private ElkAxiomProcessor axiomInsertionProcessor_;
    private ElkAxiomProcessor axiomDeletionProcessor_;

    public AxiomLoadingStage(AbstractReasonerState reasoner, AbstractReasonerStage ... preStages) {
        super(reasoner, preStages);
    }

    @Override
    public String getName() {
        return "Loading of Axioms";
    }

    @Override
    public boolean preExecute() {
        if (!super.preExecute()) {
            return false;
        }
        this.loader_ = this.reasoner.getAxiomLoader();
        if (this.loader_ == null || this.loader_.isLoadingFinished()) {
            return true;
        }
        ModifiableOntologyIndex ontologyIndex = this.reasoner.getModifiableOntologyIndex();
        ElkAxiomIndexingVisitor axiomInserter = new MainAxiomIndexerVisitor(ontologyIndex, true);
        ElkAxiomIndexingVisitor axiomDeleter = new MainAxiomIndexerVisitor(ontologyIndex, false);
        NonIncrementalChangeListener<ElkAxiom> listener = new NonIncrementalChangeListener<ElkAxiom>(){
            boolean resetDone = false;

            @Override
            public void notify(ElkAxiom axiom) {
                if (this.resetDone) {
                    return;
                }
                if (LOGGER_.isDebugEnabled()) {
                    LOGGER_.debug((Object)("Disallowing incremental mode due to " + OwlFunctionalStylePrinter.toString(axiom)));
                }
                AxiomLoadingStage.this.reasoner.resetPropertySaturation();
                AxiomLoadingStage.this.reasoner.setNonIncrementalMode();
                this.resetDone = true;
            }
        };
        axiomInserter = new NonIncrementalChangeCheckingVisitor(axiomInserter, listener);
        axiomDeleter = new NonIncrementalChangeCheckingVisitor(axiomDeleter, listener);
        this.axiomInsertionProcessor_ = new ChangeIndexingProcessor(axiomInserter);
        this.axiomDeletionProcessor_ = new ChangeIndexingProcessor(axiomDeleter);
        return true;
    }

    @Override
    public void executeStage() throws ElkException {
        this.loader_.load(this.axiomInsertionProcessor_, this.axiomDeletionProcessor_);
    }

    @Override
    public boolean dispose() {
        if (!super.dispose()) {
            return false;
        }
        this.loader_.dispose();
        this.loader_ = null;
        return true;
    }

    @Override
    public void printInfo() {
    }

    @Override
    public void setInterrupt(boolean flag) {
        super.setInterrupt(flag);
        this.setInterrupt(this.loader_, flag);
    }
}

