/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.protege.ui;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import java.awt.Dimension;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.semanticweb.elk.protege.ui.WrappingLabel;
import org.semanticweb.elk.util.logging.ElkMessage;

public class MessageDialogAppender
extends AppenderBase<ILoggingEvent>
implements Runnable {
    protected final ConcurrentLinkedQueue<ILoggingEvent> eventBuffer = new ConcurrentLinkedQueue();
    protected final AtomicReference<String> messengerThreadName = new AtomicReference<String>("");
    protected final Set<String> ignoredMessageTypes = new HashSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        super.stop();
        ConcurrentLinkedQueue<ILoggingEvent> concurrentLinkedQueue = this.eventBuffer;
        synchronized (concurrentLinkedQueue) {
            this.eventBuffer.clear();
        }
    }

    protected void append(ILoggingEvent event) {
        if (!Thread.currentThread().getName().equals(this.messengerThreadName.get())) {
            this.eventBuffer.add(event);
        }
        this.ensureMessengerRuns();
    }

    protected void ensureMessengerRuns() {
        if (this.messengerThreadName.compareAndSet("", "Initialising thread ...")) {
            Thread messengerThread = new Thread(this);
            this.messengerThreadName.set(messengerThread.getName());
            messengerThread.start();
        }
    }

    protected String getCheckboxMessage(ILoggingEvent event) {
        return "Do not show further messages of this kind";
    }

    protected boolean showMessage(ILoggingEvent event) {
        int messageLevel;
        String messageTitle;
        if (event.getLevel().isGreaterOrEqual(Level.ERROR)) {
            messageTitle = "ELK Error";
            messageLevel = 0;
        } else if (event.getLevel().isGreaterOrEqual(Level.WARN)) {
            messageTitle = "ELK Warning";
            messageLevel = 2;
        } else {
            messageTitle = "ELK Information";
            messageLevel = 1;
        }
        ElkMessage elkMessage = ElkMessage.deserialize((String)event.getFormattedMessage());
        String messageText = event.getFormattedMessage();
        String messageType = null;
        if (elkMessage != null) {
            messageType = elkMessage.getMessageType();
            messageText = elkMessage.getMessage();
            if (this.ignoredMessageTypes.contains(messageType)) {
                return false;
            }
        }
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        if (messageText.length() > 520) {
            messageText = messageText.substring(0, 500) + "...";
        }
        WrappingLabel label = new WrappingLabel(messageText, 600);
        label.setAlignmentX(0.0f);
        panel.add(label);
        JCheckBox ignoreMessageButton = new JCheckBox(String.format(this.getCheckboxMessage(event), 450));
        if (messageType != null) {
            ignoreMessageButton.setAlignmentX(0.0f);
            panel.add(Box.createRigidArea(new Dimension(0, 10)));
            panel.add(ignoreMessageButton);
        }
        JOptionPane.showMessageDialog(null, panel, messageTitle, messageLevel);
        if (ignoreMessageButton.isSelected()) {
            this.ignoredMessageTypes.add(messageType);
        }
        return true;
    }

    @Override
    public void run() {
        while (!this.eventBuffer.isEmpty()) {
            this.showMessage(this.eventBuffer.poll());
        }
        this.messengerThreadName.set("");
        if (!this.eventBuffer.isEmpty()) {
            this.ensureMessengerRuns();
        }
    }
}

