/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb;

import java.io.File;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.assembler.AssemblerUtils;
import org.apache.jena.sys.JenaSystem;
import org.apache.jena.tdb.StoreConnection;
import org.apache.jena.tdb.assembler.VocabTDB;
import org.apache.jena.tdb.base.file.Location;
import org.apache.jena.tdb.setup.StoreParams;
import org.apache.jena.tdb.store.DatasetGraphTDB;
import org.apache.jena.tdb.sys.TDBInternal;
import org.apache.jena.tdb.sys.TDBMaker;
import org.apache.jena.tdb.transaction.DatasetGraphTransaction;

public class TDBFactory {
    private TDBFactory() {
    }

    public static Dataset assembleDataset(String assemblerFile) {
        return (Dataset)AssemblerUtils.build((String)assemblerFile, (Resource)VocabTDB.tDatasetTDB);
    }

    public static Dataset createDataset(String dir) {
        return TDBFactory.createDataset(Location.create(dir));
    }

    public static Dataset createDataset(Location location) {
        return TDBFactory.createDataset(TDBFactory.createDatasetGraph(location));
    }

    public static Dataset createDataset() {
        return TDBFactory.createDataset(TDBFactory.createDatasetGraph());
    }

    private static Dataset createDataset(DatasetGraph datasetGraph) {
        return DatasetFactory.wrap((DatasetGraph)datasetGraph);
    }

    public static DatasetGraph createDatasetGraph(String directory) {
        return TDBFactory.createDatasetGraph(Location.create(directory));
    }

    public static DatasetGraph createDatasetGraph(Location location) {
        return TDBFactory._createDatasetGraph(location);
    }

    public static DatasetGraph createDatasetGraph() {
        return TDBFactory._createDatasetGraph();
    }

    public static void release(Dataset dataset) {
        TDBFactory.release(dataset.asDatasetGraph());
    }

    public static void release(DatasetGraph dataset) {
        TDBFactory._release(dataset);
    }

    private static void _release(DatasetGraph dataset) {
        TDBInternal.expel(dataset);
    }

    private static DatasetGraph _createDatasetGraph(Location location) {
        return TDBMaker.createDatasetGraphTransaction(location);
    }

    private static DatasetGraph _createDatasetGraph() {
        return TDBMaker.createDatasetGraphTransaction();
    }

    @Deprecated
    public static boolean isBackedByTDB(Dataset dataset) {
        DatasetGraph dsg = dataset.asDatasetGraph();
        return TDBFactory.isBackedByTDB(dsg);
    }

    @Deprecated
    public static boolean isBackedByTDB(DatasetGraph datasetGraph) {
        if (datasetGraph instanceof DatasetGraphTransaction) {
            return true;
        }
        return datasetGraph instanceof DatasetGraphTDB;
    }

    public static boolean isTDB1(Dataset dataset) {
        DatasetGraph dsg = dataset.asDatasetGraph();
        return TDBFactory.isTDB1(dsg);
    }

    public static boolean isTDB1(DatasetGraph datasetGraph) {
        return TDBInternal.isTDB1(datasetGraph);
    }

    public static Location location(Dataset dataset) {
        DatasetGraph dsg = dataset.asDatasetGraph();
        return TDBFactory.location(dsg);
    }

    public static Location location(DatasetGraph datasetGraph) {
        if (datasetGraph instanceof DatasetGraphTDB) {
            return ((DatasetGraphTDB)datasetGraph).getLocation();
        }
        if (datasetGraph instanceof DatasetGraphTransaction) {
            return ((DatasetGraphTransaction)datasetGraph).getLocation();
        }
        return null;
    }

    public static boolean inUseLocation(String directory) {
        return TDBFactory.inUseLocation(Location.create(directory));
    }

    public static boolean inUseLocation(Location location) {
        if (location.isMemUnique()) {
            return false;
        }
        if (location.isMem()) {
            return StoreConnection.getExisting(location) != null;
        }
        String dirname = location.getDirectoryPath();
        File d = new File(dirname);
        if (!d.exists()) {
            return !FileOps.exists((String)d.getParent());
        }
        return !TDBInternal.isNewDatabaseArea(location);
    }

    public static void setup(Location location, StoreParams params) {
        StoreConnection sConn = StoreConnection.getExisting(location);
        if (sConn != null) {
            throw new IllegalStateException("Location is already active");
        }
        StoreConnection.make(location, params);
    }

    static {
        JenaSystem.init();
    }
}

