/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.ontology.axiom.complex;

import de.tudresden.inf.lat.jcel.coreontology.axiom.IntegerAnnotation;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.ComplexIntegerAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.ComplexIntegerAxiomVisitor;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerObjectPropertyExpression;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class IntegerSubObjectPropertyOfAxiom
implements ComplexIntegerAxiom {
    private final Set<Integer> objectPropertiesInSignature;
    private final IntegerObjectPropertyExpression subObjectProperty;
    private final IntegerObjectPropertyExpression superObjectProperty;
    private final Set<IntegerAnnotation> annotations;
    private final int hashCode;

    IntegerSubObjectPropertyOfAxiom(IntegerObjectPropertyExpression subPropExpr, IntegerObjectPropertyExpression superPropExpr, Set<IntegerAnnotation> annotations) {
        Objects.requireNonNull(subPropExpr);
        Objects.requireNonNull(superPropExpr);
        Objects.requireNonNull(annotations);
        this.subObjectProperty = subPropExpr;
        this.superObjectProperty = superPropExpr;
        HashSet<Integer> objectPropertiesInSignature = new HashSet<Integer>();
        objectPropertiesInSignature.addAll(this.subObjectProperty.getObjectPropertiesInSignature());
        objectPropertiesInSignature.addAll(this.superObjectProperty.getObjectPropertiesInSignature());
        this.objectPropertiesInSignature = Collections.unmodifiableSet(objectPropertiesInSignature);
        this.annotations = annotations;
        this.hashCode = this.subObjectProperty.hashCode() + 31 * (this.superObjectProperty.hashCode() + 31 * this.annotations.hashCode());
    }

    @Override
    public <T> T accept(ComplexIntegerAxiomVisitor<T> visitor) {
        Objects.requireNonNull(visitor);
        return visitor.visit(this);
    }

    public boolean equals(Object obj) {
        boolean ret;
        boolean bl = ret = this == obj;
        if (!ret && obj instanceof IntegerSubObjectPropertyOfAxiom) {
            IntegerSubObjectPropertyOfAxiom other = (IntegerSubObjectPropertyOfAxiom)obj;
            ret = this.getSubProperty().equals(other.getSubProperty()) && this.getSuperProperty().equals(other.getSuperProperty()) && this.getAnnotations().equals(other.getAnnotations());
        }
        return ret;
    }

    @Override
    public Set<Integer> getClassesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getDataPropertiesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getDatatypesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getIndividualsInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getObjectPropertiesInSignature() {
        return Collections.unmodifiableSet(this.objectPropertiesInSignature);
    }

    public IntegerObjectPropertyExpression getSubProperty() {
        return this.subObjectProperty;
    }

    public IntegerObjectPropertyExpression getSuperProperty() {
        return this.superObjectProperty;
    }

    @Override
    public Set<IntegerAnnotation> getAnnotations() {
        return Collections.unmodifiableSet(this.annotations);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("SubObjectPropertyOf");
        sbuf.append("(");
        sbuf.append(this.getSubProperty().toString());
        sbuf.append(" ");
        sbuf.append(this.getSuperProperty().toString());
        sbuf.append(")");
        return sbuf.toString();
    }
}

