/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.ontology.normalization;

import de.tudresden.inf.lat.jcel.coreontology.datatype.IntegerAxiom;
import de.tudresden.inf.lat.jcel.coreontology.datatype.IntegerEntityType;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerSubClassOfAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.extension.IntegerOntologyObjectFactory;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerClass;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerClassExpression;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerObjectSomeValuesFrom;
import de.tudresden.inf.lat.jcel.ontology.normalization.NormalizationRule;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class NormalizerNR3_1
implements NormalizationRule {
    private final IntegerOntologyObjectFactory ontologyObjectFactory;

    public NormalizerNR3_1(IntegerOntologyObjectFactory factory) {
        Objects.requireNonNull(factory);
        this.ontologyObjectFactory = factory;
    }

    @Override
    public Set<IntegerAxiom> apply(IntegerAxiom axiom) {
        Objects.requireNonNull(axiom);
        Set<IntegerAxiom> ret = Collections.emptySet();
        if (axiom instanceof IntegerSubClassOfAxiom) {
            ret = this.applyRule((IntegerSubClassOfAxiom)axiom);
        }
        return ret;
    }

    private Set<IntegerAxiom> applyRule(IntegerSubClassOfAxiom classAxiom) {
        Set<IntegerAxiom> ret = Collections.emptySet();
        IntegerClassExpression subClass = classAxiom.getSubClass();
        IntegerClassExpression superClass = classAxiom.getSuperClass();
        if (!subClass.isLiteral() && superClass instanceof IntegerObjectSomeValuesFrom) {
            ret = new HashSet<IntegerAxiom>();
            IntegerClass newClass = this.getOntologyObjectFactory().getDataTypeFactory().createClass(this.getOntologyObjectFactory().getEntityManager().createAnonymousEntity(IntegerEntityType.CLASS, true));
            ret.add(this.getOntologyObjectFactory().getComplexAxiomFactory().createSubClassOfAxiom(subClass, newClass, classAxiom.getAnnotations()));
            ret.add(this.getOntologyObjectFactory().getComplexAxiomFactory().createSubClassOfAxiom(newClass, superClass, classAxiom.getAnnotations()));
        }
        return ret;
    }

    private IntegerOntologyObjectFactory getOntologyObjectFactory() {
        return this.ontologyObjectFactory;
    }
}

