/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.ontology.normalization;

import de.tudresden.inf.lat.jcel.coreontology.axiom.FunctObjectPropAxiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.IntegerAnnotation;
import de.tudresden.inf.lat.jcel.coreontology.axiom.NormalizedIntegerAxiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.NormalizedIntegerAxiomFactory;
import de.tudresden.inf.lat.jcel.coreontology.axiom.RI1Axiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.RI2Axiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.RI3Axiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.RangeAxiom;
import de.tudresden.inf.lat.jcel.coreontology.datatype.IntegerAxiom;
import de.tudresden.inf.lat.jcel.coreontology.datatype.IntegerEntityManager;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.ComplexIntegerAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.ComplexIntegerAxiomFactory;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.ComplexIntegerAxiomVisitor;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerClassAssertionAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerClassDeclarationAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerDataPropertyAssertionAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerDataPropertyDeclarationAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerDifferentIndividualsAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerDisjointClassesAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerEquivalentClassesAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerEquivalentObjectPropertiesAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerFunctionalObjectPropertyAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerInverseFunctionalObjectPropertyAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerInverseObjectPropertiesAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerNamedIndividualDeclarationAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerNegativeObjectPropertyAssertionAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerObjectPropertyAssertionAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerObjectPropertyDeclarationAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerPropertyRangeAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerReflexiveObjectPropertyAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerSameIndividualAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerSubClassOfAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerSubObjectPropertyOfAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerSubPropertyChainOfAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerTransitiveObjectPropertyAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.extension.IntegerOntologyObjectFactory;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerClass;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerClassExpression;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerObjectIntersectionOf;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerObjectPropertyExpression;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerObjectSomeValuesFrom;
import de.tudresden.inf.lat.jcel.ontology.normalization.NormalizationRule;
import de.tudresden.inf.lat.jcel.ontology.normalization.NormalizerDisjoint;
import de.tudresden.inf.lat.jcel.ontology.normalization.NormalizerEquivProperties;
import de.tudresden.inf.lat.jcel.ontology.normalization.NormalizerNR1_2;
import de.tudresden.inf.lat.jcel.ontology.normalization.NormalizerNR1_5;
import de.tudresden.inf.lat.jcel.ontology.normalization.NormalizerNR1_6;
import de.tudresden.inf.lat.jcel.ontology.normalization.NormalizerNR1_7;
import de.tudresden.inf.lat.jcel.ontology.normalization.NormalizerNR2_1;
import de.tudresden.inf.lat.jcel.ontology.normalization.NormalizerNR2_2;
import de.tudresden.inf.lat.jcel.ontology.normalization.NormalizerNR2_3;
import de.tudresden.inf.lat.jcel.ontology.normalization.NormalizerNR2_4;
import de.tudresden.inf.lat.jcel.ontology.normalization.NormalizerNR3_1;
import de.tudresden.inf.lat.jcel.ontology.normalization.NormalizerNR3_2;
import de.tudresden.inf.lat.jcel.ontology.normalization.NormalizerNR3_3;
import de.tudresden.inf.lat.jcel.ontology.normalization.NormalizerNR4_1;
import de.tudresden.inf.lat.jcel.ontology.normalization.NormalizerNR4_2;
import de.tudresden.inf.lat.jcel.ontology.normalization.NormalizerSubClassOf;
import de.tudresden.inf.lat.jcel.ontology.normalization.NormalizerSubPropertyChainOf;
import de.tudresden.inf.lat.jcel.ontology.normalization.ObjectPropertyIdFinder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class SimpleNormalizer
implements ComplexIntegerAxiomVisitor<Set<IntegerAxiom>> {
    private final List<NormalizationRule> norChainOfSubClass;
    private final NormalizationRule norDisjoint;
    private final NormalizationRule norEquivProperties;
    private final NormalizationRule norNR1_2;
    private final NormalizationRule norNR1_5;
    private final NormalizerNR1_6 norNR1_6;
    private final NormalizationRule norNR2_1;
    private final NormalizationRule norSubPropertyChainOf;
    private final IntegerOntologyObjectFactory ontologyObjectFactory;

    public SimpleNormalizer(IntegerOntologyObjectFactory factory) {
        Objects.requireNonNull(factory);
        this.ontologyObjectFactory = factory;
        this.norChainOfSubClass = new ArrayList<NormalizationRule>();
        this.norChainOfSubClass.add(new NormalizerNR1_7(this.getOntologyObjectFactory()));
        this.norChainOfSubClass.add(new NormalizerNR2_2(this.getOntologyObjectFactory()));
        this.norChainOfSubClass.add(new NormalizerNR2_3(this.getOntologyObjectFactory()));
        this.norChainOfSubClass.add(new NormalizerNR2_4(this.getOntologyObjectFactory()));
        this.norChainOfSubClass.add(new NormalizerNR3_1(this.getOntologyObjectFactory()));
        this.norChainOfSubClass.add(new NormalizerNR3_2(this.getOntologyObjectFactory()));
        this.norChainOfSubClass.add(new NormalizerNR3_3(this.getOntologyObjectFactory()));
        this.norChainOfSubClass.add(new NormalizerNR4_1(this.getOntologyObjectFactory()));
        this.norChainOfSubClass.add(new NormalizerNR4_2(this.getOntologyObjectFactory()));
        this.norChainOfSubClass.add(new NormalizerSubClassOf(this.getOntologyObjectFactory()));
        this.norDisjoint = new NormalizerDisjoint(this.getOntologyObjectFactory());
        this.norEquivProperties = new NormalizerEquivProperties(this.getOntologyObjectFactory());
        this.norSubPropertyChainOf = new NormalizerSubPropertyChainOf(this.getOntologyObjectFactory());
        this.norNR1_5 = new NormalizerNR1_5(this.getOntologyObjectFactory());
        this.norNR1_2 = new NormalizerNR1_2(this.getOntologyObjectFactory());
        this.norNR2_1 = new NormalizerNR2_1(this.getOntologyObjectFactory());
        this.norNR1_6 = new NormalizerNR1_6();
    }

    public Set<NormalizedIntegerAxiom> getAxiomsForInverseObjectProperties(Integer firstProperty, Integer secondProperty) {
        Integer inverseFirstProperty;
        Objects.requireNonNull(firstProperty);
        Objects.requireNonNull(secondProperty);
        Set<IntegerAnnotation> annotations = Collections.emptySet();
        HashSet<RI2Axiom> ret = new HashSet<RI2Axiom>();
        Integer inverseSecondProperty = this.getIdGenerator().createOrGetInverseObjectPropertyOf(secondProperty);
        if (!inverseSecondProperty.equals(firstProperty)) {
            ret.add(this.getNormalizedAxiomFactory().createRI2Axiom(firstProperty, inverseSecondProperty, annotations));
            ret.add(this.getNormalizedAxiomFactory().createRI2Axiom(inverseSecondProperty, firstProperty, annotations));
        }
        if (!(inverseFirstProperty = this.getIdGenerator().createOrGetInverseObjectPropertyOf(firstProperty)).equals(secondProperty)) {
            ret.add(this.getNormalizedAxiomFactory().createRI2Axiom(secondProperty, inverseFirstProperty, annotations));
            ret.add(this.getNormalizedAxiomFactory().createRI2Axiom(inverseFirstProperty, secondProperty, annotations));
        }
        return Collections.unmodifiableSet(ret);
    }

    private ComplexIntegerAxiomFactory getComplexAxiomFactory() {
        return this.getOntologyObjectFactory().getComplexAxiomFactory();
    }

    private IntegerEntityManager getIdGenerator() {
        return this.getOntologyObjectFactory().getEntityManager();
    }

    private NormalizedIntegerAxiomFactory getNormalizedAxiomFactory() {
        return this.getOntologyObjectFactory().getNormalizedAxiomFactory();
    }

    private Integer getObjectPropertyId(IntegerObjectPropertyExpression propExpr) {
        return propExpr.accept(new ObjectPropertyIdFinder(this.getIdGenerator()));
    }

    public IntegerOntologyObjectFactory getOntologyObjectFactory() {
        return this.ontologyObjectFactory;
    }

    public Set<IntegerAxiom> normalize(IntegerAxiom axiom) {
        Objects.requireNonNull(axiom);
        Set<Object> ret = null;
        if (axiom instanceof ComplexIntegerAxiom) {
            ComplexIntegerAxiom complexAxiom = (ComplexIntegerAxiom)axiom;
            ret = complexAxiom.accept(this);
        } else if (axiom instanceof NormalizedIntegerAxiom) {
            ret = new HashSet();
            ret.add(axiom);
        } else {
            throw new IllegalArgumentException("Axiom type is not recognized: '" + axiom + "'.");
        }
        return ret;
    }

    @Override
    public Set<IntegerAxiom> visit(IntegerClassAssertionAxiom axiom) {
        Objects.requireNonNull(axiom);
        Integer individual = axiom.getIndividual();
        IntegerClassExpression classExpression = axiom.getClassExpression();
        HashSet<IntegerAxiom> ret = new HashSet<IntegerAxiom>();
        Integer classId = this.getIdGenerator().createOrGetClassIdForIndividual(individual);
        ret.add(this.getNormalizedAxiomFactory().createNominalAxiom(classId, individual, axiom.getAnnotations()));
        ret.add(this.getComplexAxiomFactory().createSubClassOfAxiom(this.getOntologyObjectFactory().getDataTypeFactory().createClass(classId), classExpression, axiom.getAnnotations()));
        return Collections.unmodifiableSet(ret);
    }

    @Override
    public Set<IntegerAxiom> visit(IntegerClassDeclarationAxiom axiom) {
        Objects.requireNonNull(axiom);
        return Collections.emptySet();
    }

    @Override
    public Set<IntegerAxiom> visit(IntegerDataPropertyAssertionAxiom axiom) {
        Objects.requireNonNull(axiom);
        return Collections.emptySet();
    }

    @Override
    public Set<IntegerAxiom> visit(IntegerDataPropertyDeclarationAxiom axiom) {
        Objects.requireNonNull(axiom);
        return Collections.emptySet();
    }

    @Override
    public Set<IntegerAxiom> visit(IntegerDifferentIndividualsAxiom axiom) {
        Objects.requireNonNull(axiom);
        HashSet<IntegerDisjointClassesAxiom> ret = new HashSet<IntegerDisjointClassesAxiom>();
        Set<Integer> individualSet = axiom.getIndividuals();
        HashSet<IntegerClassExpression> classExprSet = new HashSet<IntegerClassExpression>();
        individualSet.forEach(individual -> {
            Integer classForIndiv = this.getIdGenerator().createOrGetClassIdForIndividual((Integer)individual);
            ret.add((IntegerDisjointClassesAxiom)((Object)this.getNormalizedAxiomFactory().createNominalAxiom(classForIndiv, (int)individual, axiom.getAnnotations())));
            classExprSet.add(this.getOntologyObjectFactory().getDataTypeFactory().createClass(classForIndiv));
        });
        ret.add(this.getComplexAxiomFactory().createDisjointClassesAxiom(classExprSet, axiom.getAnnotations()));
        return Collections.unmodifiableSet(ret);
    }

    @Override
    public Set<IntegerAxiom> visit(IntegerDisjointClassesAxiom axiom) {
        Objects.requireNonNull(axiom);
        return this.norDisjoint.apply(axiom);
    }

    @Override
    public Set<IntegerAxiom> visit(IntegerEquivalentClassesAxiom axiom) {
        Objects.requireNonNull(axiom);
        return this.norNR1_5.apply(axiom);
    }

    @Override
    public Set<IntegerAxiom> visit(IntegerEquivalentObjectPropertiesAxiom axiom) {
        Objects.requireNonNull(axiom);
        return this.norEquivProperties.apply(axiom);
    }

    @Override
    public Set<IntegerAxiom> visit(IntegerFunctionalObjectPropertyAxiom axiom) {
        Objects.requireNonNull(axiom);
        HashSet<FunctObjectPropAxiom> ret = new HashSet<FunctObjectPropAxiom>();
        FunctObjectPropAxiom newAxiom = this.getNormalizedAxiomFactory().createFunctObjectPropAxiom(this.getObjectPropertyId(axiom.getProperty()), axiom.getAnnotations());
        ret.add(newAxiom);
        return Collections.unmodifiableSet(ret);
    }

    @Override
    public Set<IntegerAxiom> visit(IntegerInverseFunctionalObjectPropertyAxiom axiom) {
        Objects.requireNonNull(axiom);
        FunctObjectPropAxiom newAxiom = this.getNormalizedAxiomFactory().createFunctObjectPropAxiom(this.getIdGenerator().createOrGetInverseObjectPropertyOf(this.getObjectPropertyId(axiom.getProperty())), axiom.getAnnotations());
        return Collections.singleton(newAxiom);
    }

    @Override
    public Set<IntegerAxiom> visit(IntegerInverseObjectPropertiesAxiom axiom) {
        Objects.requireNonNull(axiom);
        Integer firstProperty = this.getObjectPropertyId(axiom.getFirstProperty());
        Integer secondProperty = this.getObjectPropertyId(axiom.getSecondProperty());
        this.getIdGenerator().proposeInverseObjectPropertyOf(firstProperty, secondProperty);
        HashSet<NormalizedIntegerAxiom> ret = new HashSet<NormalizedIntegerAxiom>();
        ret.addAll(this.getAxiomsForInverseObjectProperties(firstProperty, secondProperty));
        return Collections.unmodifiableSet(ret);
    }

    @Override
    public Set<IntegerAxiom> visit(IntegerNamedIndividualDeclarationAxiom axiom) {
        Objects.requireNonNull(axiom);
        return Collections.emptySet();
    }

    @Override
    public Set<IntegerAxiom> visit(IntegerNegativeObjectPropertyAssertionAxiom axiom) {
        Objects.requireNonNull(axiom);
        Integer subject = axiom.getSubject();
        Integer object = axiom.getObject();
        IntegerObjectPropertyExpression property = axiom.getProperty();
        HashSet<IntegerAxiom> ret = new HashSet<IntegerAxiom>();
        Integer classIdForSubject = this.getIdGenerator().createOrGetClassIdForIndividual(subject);
        ret.add(this.getNormalizedAxiomFactory().createNominalAxiom(classIdForSubject, subject, axiom.getAnnotations()));
        Integer classIdForObject = this.getIdGenerator().createOrGetClassIdForIndividual(object);
        ret.add(this.getNormalizedAxiomFactory().createNominalAxiom(classIdForObject, object, axiom.getAnnotations()));
        IntegerObjectSomeValuesFrom restriction = this.getOntologyObjectFactory().getDataTypeFactory().createObjectSomeValuesFrom(property, this.getOntologyObjectFactory().getDataTypeFactory().createClass(classIdForObject));
        HashSet<IntegerClassExpression> classExpressionSet = new HashSet<IntegerClassExpression>();
        classExpressionSet.add(this.getOntologyObjectFactory().getDataTypeFactory().createClass(classIdForSubject));
        classExpressionSet.add(restriction);
        IntegerObjectIntersectionOf intersection = this.getOntologyObjectFactory().getDataTypeFactory().createObjectIntersectionOf(classExpressionSet);
        ret.add(this.getComplexAxiomFactory().createSubClassOfAxiom(intersection, this.getOntologyObjectFactory().getDataTypeFactory().createClass(IntegerEntityManager.bottomClassId), axiom.getAnnotations()));
        return Collections.unmodifiableSet(ret);
    }

    @Override
    public Set<IntegerAxiom> visit(IntegerObjectPropertyAssertionAxiom axiom) {
        Objects.requireNonNull(axiom);
        Integer subject = axiom.getSubject();
        Integer object = axiom.getObject();
        IntegerObjectPropertyExpression property = axiom.getProperty();
        HashSet<IntegerAxiom> ret = new HashSet<IntegerAxiom>();
        Integer classIdForSubject = this.getIdGenerator().createOrGetClassIdForIndividual(subject);
        ret.add(this.getNormalizedAxiomFactory().createNominalAxiom(classIdForSubject, subject, axiom.getAnnotations()));
        Integer classIdForObject = this.getIdGenerator().createOrGetClassIdForIndividual(object);
        ret.add(this.getNormalizedAxiomFactory().createNominalAxiom(classIdForObject, object, axiom.getAnnotations()));
        IntegerObjectSomeValuesFrom restriction = this.getOntologyObjectFactory().getDataTypeFactory().createObjectSomeValuesFrom(property, this.getOntologyObjectFactory().getDataTypeFactory().createClass(classIdForObject));
        ret.add(this.getComplexAxiomFactory().createSubClassOfAxiom(this.getOntologyObjectFactory().getDataTypeFactory().createClass(classIdForSubject), restriction, axiom.getAnnotations()));
        return Collections.unmodifiableSet(ret);
    }

    @Override
    public Set<IntegerAxiom> visit(IntegerObjectPropertyDeclarationAxiom axiom) {
        Objects.requireNonNull(axiom);
        return Collections.emptySet();
    }

    @Override
    public Set<IntegerAxiom> visit(IntegerPropertyRangeAxiom axiom) {
        Objects.requireNonNull(axiom);
        Set<Object> ret = Collections.emptySet();
        IntegerClassExpression range = axiom.getRange();
        if (range.isLiteral()) {
            Integer property = this.getObjectPropertyId(axiom.getProperty());
            RangeAxiom normAxiom = this.getNormalizedAxiomFactory().createRangeAxiom(property, ((IntegerClass)range).getId(), axiom.getAnnotations());
            ret = new HashSet();
            ret.add(normAxiom);
        } else {
            ret = this.norNR1_2.apply(axiom);
        }
        return Collections.unmodifiableSet(ret);
    }

    @Override
    public Set<IntegerAxiom> visit(IntegerReflexiveObjectPropertyAxiom axiom) {
        Objects.requireNonNull(axiom);
        HashSet<RI1Axiom> ret = new HashSet<RI1Axiom>();
        RI1Axiom newAxiom = this.getNormalizedAxiomFactory().createRI1Axiom(this.getObjectPropertyId(axiom.getProperty()), axiom.getAnnotations());
        ret.add(newAxiom);
        return Collections.unmodifiableSet(ret);
    }

    @Override
    public Set<IntegerAxiom> visit(IntegerSameIndividualAxiom axiom) {
        Objects.requireNonNull(axiom);
        HashSet<IntegerEquivalentClassesAxiom> ret = new HashSet<IntegerEquivalentClassesAxiom>();
        Set<Integer> individualSet = axiom.getIndividuals();
        HashSet<IntegerClassExpression> classExprSet = new HashSet<IntegerClassExpression>();
        individualSet.forEach(individual -> {
            Integer classForIndiv = this.getIdGenerator().createOrGetClassIdForIndividual((Integer)individual);
            ret.add((IntegerEquivalentClassesAxiom)((Object)this.getNormalizedAxiomFactory().createNominalAxiom(classForIndiv, (int)individual, axiom.getAnnotations())));
            classExprSet.add(this.getOntologyObjectFactory().getDataTypeFactory().createClass(classForIndiv));
        });
        ret.add(this.getComplexAxiomFactory().createEquivalentClassesAxiom(classExprSet, axiom.getAnnotations()));
        return Collections.unmodifiableSet(ret);
    }

    @Override
    public Set<IntegerAxiom> visit(IntegerSubClassOfAxiom axiom) {
        Objects.requireNonNull(axiom);
        Set<Object> ret = new HashSet();
        if (!this.norNR1_6.canBeApplied(axiom)) {
            Iterator<NormalizationRule> it = this.norChainOfSubClass.iterator();
            while (it.hasNext() && ret.isEmpty()) {
                ret = it.next().apply(axiom);
            }
        }
        return Collections.unmodifiableSet(ret);
    }

    @Override
    public Set<IntegerAxiom> visit(IntegerSubObjectPropertyOfAxiom axiom) {
        Objects.requireNonNull(axiom);
        HashSet<RI2Axiom> ret = new HashSet<RI2Axiom>();
        Integer subProperty = this.getObjectPropertyId(axiom.getSubProperty());
        Integer superProperty = this.getObjectPropertyId(axiom.getSuperProperty());
        Integer inverseSubProperty = this.getIdGenerator().createOrGetInverseObjectPropertyOf(subProperty);
        Integer inverseSuperProperty = this.getIdGenerator().createOrGetInverseObjectPropertyOf(superProperty);
        ret.add(this.getNormalizedAxiomFactory().createRI2Axiom(subProperty, superProperty, axiom.getAnnotations()));
        ret.add(this.getNormalizedAxiomFactory().createRI2Axiom(inverseSubProperty, inverseSuperProperty, axiom.getAnnotations()));
        return Collections.unmodifiableSet(ret);
    }

    @Override
    public Set<IntegerAxiom> visit(IntegerSubPropertyChainOfAxiom axiom) {
        Objects.requireNonNull(axiom);
        Set<Object> ret = new HashSet();
        if (ret.isEmpty()) {
            ret = this.norNR2_1.apply(axiom);
        }
        if (ret.isEmpty()) {
            ret = this.norSubPropertyChainOf.apply(axiom);
        }
        return Collections.unmodifiableSet(ret);
    }

    @Override
    public Set<IntegerAxiom> visit(IntegerTransitiveObjectPropertyAxiom axiom) {
        Objects.requireNonNull(axiom);
        HashSet<RI3Axiom> ret = new HashSet<RI3Axiom>();
        Integer property = this.getObjectPropertyId(axiom.getProperty());
        RI3Axiom normAxiom = this.getNormalizedAxiomFactory().createRI3Axiom(property, property, property, axiom.getAnnotations());
        ret.add(normAxiom);
        return Collections.unmodifiableSet(ret);
    }
}

