/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.owlapi.console;

import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.OWLReasoner;

public class OWLInferredOntologyWrapper {
    private final OWLOntology ontology;
    private final OWLReasoner reasoner;

    public OWLInferredOntologyWrapper(OWLReasoner reasoner) throws OWLOntologyCreationException {
        Objects.requireNonNull(reasoner);
        this.reasoner = reasoner;
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        this.ontology = manager.createOntology(reasoner.getRootOntology().getOntologyID());
        this.process();
    }

    private void addAxiom(OWLAxiom axiom) {
        this.ontology.getOWLOntologyManager().addAxiom(this.ontology, axiom);
    }

    public OWLOntology getOWLOntology() {
        return this.ontology;
    }

    private OWLReasoner getReasoner() {
        return this.reasoner;
    }

    private void process() {
        Set equivProperties;
        OWLObjectProperty property2;
        TreeSet<OWLClass> classSet = new TreeSet<OWLClass>();
        classSet.addAll(this.getReasoner().getRootOntology().getClassesInSignature());
        TreeSet<OWLObjectProperty> objectPropertySet = new TreeSet<OWLObjectProperty>();
        objectPropertySet.addAll(this.getReasoner().getRootOntology().getObjectPropertiesInSignature());
        TreeSet<OWLDataProperty> dataPropertySet = new TreeSet<OWLDataProperty>();
        dataPropertySet.addAll(this.getReasoner().getRootOntology().getDataPropertiesInSignature());
        TreeSet<OWLNamedIndividual> individualSet = new TreeSet<OWLNamedIndividual>();
        individualSet.addAll(this.getReasoner().getRootOntology().getIndividualsInSignature());
        this.processDeclarationC(classSet);
        this.processDeclarationOP(objectPropertySet);
        this.processDeclarationDP(dataPropertySet);
        this.processDeclarationI(individualSet);
        TreeSet<OWLClass> classesToVisit = new TreeSet<OWLClass>();
        classesToVisit.addAll(classSet);
        while (!classesToVisit.isEmpty()) {
            OWLClass cls2 = (OWLClass)classesToVisit.iterator().next();
            classesToVisit.remove(cls2);
            Set equivClasses = this.getReasoner().getEquivalentClasses((OWLClassExpression)cls2).getEntities();
            if (equivClasses.size() > 1) {
                this.processEquivalentClasses(equivClasses);
            }
            classesToVisit.removeAll(equivClasses);
        }
        TreeSet<OWLObjectProperty> objectPropertiesToVisit = new TreeSet<OWLObjectProperty>();
        objectPropertiesToVisit.addAll(objectPropertySet);
        while (!objectPropertiesToVisit.isEmpty()) {
            property2 = (OWLObjectProperty)objectPropertiesToVisit.iterator().next();
            objectPropertiesToVisit.remove(property2);
            equivProperties = this.getReasoner().getEquivalentObjectProperties((OWLObjectPropertyExpression)property2).getEntities();
            if (equivProperties.size() > 1) {
                this.processEquivalentObjectProperties(equivProperties);
            }
            objectPropertiesToVisit.removeAll(equivProperties);
        }
        TreeSet<OWLDataProperty> dataPropertiesToVisit = new TreeSet<OWLDataProperty>();
        dataPropertiesToVisit.addAll(dataPropertySet);
        while (!dataPropertiesToVisit.isEmpty()) {
            property2 = (OWLDataProperty)dataPropertiesToVisit.iterator().next();
            dataPropertiesToVisit.remove(property2);
            equivProperties = this.getReasoner().getEquivalentDataProperties((OWLDataProperty)property2).getEntities();
            if (equivProperties.size() > 1) {
                this.processEquivalentDataProperties(equivProperties);
            }
            dataPropertiesToVisit.removeAll(equivProperties);
        }
        classSet.forEach(subClass -> {
            TreeSet superClasses = new TreeSet();
            superClasses.addAll(this.getReasoner().getSuperClasses((OWLClassExpression)subClass, true).getFlattened());
            superClasses.forEach(superClass -> this.processSubClassOf((OWLClass)subClass, (OWLClass)superClass));
        });
        objectPropertySet.forEach(subProperty -> {
            TreeSet superProperties = new TreeSet();
            superProperties.addAll(this.getReasoner().getSuperObjectProperties((OWLObjectPropertyExpression)subProperty, true).getFlattened());
            superProperties.forEach(superProperty -> this.processSubObjectPropertyOf(subProperty.asOWLObjectProperty(), superProperty.asOWLObjectProperty()));
        });
        dataPropertySet.forEach(subProperty -> {
            TreeSet superProperties = new TreeSet();
            superProperties.addAll(this.getReasoner().getSuperDataProperties(subProperty, true).getFlattened());
            superProperties.forEach(superProperty -> this.processSubDataPropertyOf(subProperty.asOWLDataProperty(), superProperty.asOWLDataProperty()));
        });
        classSet.forEach(cls -> {
            TreeSet instances = new TreeSet();
            instances.addAll(this.getReasoner().getInstances((OWLClassExpression)cls, true).getFlattened());
            instances.forEach(individual -> this.processClassAssertion((OWLClass)cls, (OWLNamedIndividual)individual));
        });
        objectPropertySet.forEach(property -> individualSet.forEach(individual -> {
            TreeSet propertyValues = new TreeSet();
            propertyValues.addAll(this.getReasoner().getObjectPropertyValues(individual, (OWLObjectPropertyExpression)property.asOWLObjectProperty()).getFlattened());
            propertyValues.forEach(otherIndividual -> this.processObjectPropertyAssertion((OWLObjectProperty)property, (OWLNamedIndividual)individual, (OWLNamedIndividual)otherIndividual));
        }));
        dataPropertySet.forEach(property -> individualSet.forEach(individual -> {
            TreeSet propertyValues = new TreeSet();
            propertyValues.addAll(this.getReasoner().getDataPropertyValues(individual, property.asOWLDataProperty()));
            propertyValues.forEach(otherIndividual -> this.processDataPropertyAssertion((OWLDataProperty)property, (OWLNamedIndividual)individual, (OWLLiteral)otherIndividual));
        }));
    }

    private void processClassAssertion(OWLClass cls, OWLNamedIndividual individual) {
        this.processEntity(cls);
        this.processEntity(individual);
    }

    private void processDataPropertyAssertion(OWLDataProperty property, OWLNamedIndividual subject, OWLLiteral object) {
        this.processEntity(property);
        this.processEntity(subject);
    }

    private void processDeclarationC(Set<OWLClass> entities) {
        entities.forEach(elem -> this.processEntity((OWLClass)elem));
    }

    private void processDeclarationDP(Set<OWLDataProperty> entities) {
        entities.forEach(elem -> this.processEntity((OWLDataProperty)elem));
    }

    private void processDeclarationI(Set<OWLNamedIndividual> entities) {
        entities.forEach(elem -> this.processEntity((OWLNamedIndividual)elem));
    }

    private void processDeclarationOP(Set<OWLObjectProperty> entities) {
        entities.forEach(elem -> this.processEntity((OWLObjectProperty)elem));
    }

    private void processEntity(OWLClass entity) {
        this.addAxiom((OWLAxiom)this.ontology.getOWLOntologyManager().getOWLDataFactory().getOWLDeclarationAxiom((OWLEntity)entity));
    }

    private void processEntity(OWLDataProperty entity) {
        this.addAxiom((OWLAxiom)this.ontology.getOWLOntologyManager().getOWLDataFactory().getOWLDeclarationAxiom((OWLEntity)entity));
    }

    private void processEntity(OWLNamedIndividual entity) {
        this.addAxiom((OWLAxiom)this.ontology.getOWLOntologyManager().getOWLDataFactory().getOWLDeclarationAxiom((OWLEntity)entity));
    }

    private void processEntity(OWLObjectProperty entity) {
        this.addAxiom((OWLAxiom)this.ontology.getOWLOntologyManager().getOWLDataFactory().getOWLDeclarationAxiom((OWLEntity)entity));
    }

    private void processEquivalentClasses(Set<OWLClass> classSet) {
        this.addAxiom((OWLAxiom)this.ontology.getOWLOntologyManager().getOWLDataFactory().getOWLEquivalentClassesAxiom(classSet));
    }

    private void processEquivalentDataProperties(Set<OWLDataProperty> propertySet) {
        this.addAxiom((OWLAxiom)this.ontology.getOWLOntologyManager().getOWLDataFactory().getOWLEquivalentDataPropertiesAxiom(propertySet));
    }

    private void processEquivalentObjectProperties(Set<OWLObjectPropertyExpression> propertySet) {
        this.addAxiom((OWLAxiom)this.ontology.getOWLOntologyManager().getOWLDataFactory().getOWLEquivalentObjectPropertiesAxiom(propertySet));
    }

    private void processObjectPropertyAssertion(OWLObjectProperty property, OWLNamedIndividual subject, OWLNamedIndividual object) {
        this.addAxiom((OWLAxiom)this.ontology.getOWLOntologyManager().getOWLDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)property, (OWLIndividual)subject, (OWLIndividual)object));
    }

    private void processSubClassOf(OWLClass subClass, OWLClass superClass) {
        this.addAxiom((OWLAxiom)this.ontology.getOWLOntologyManager().getOWLDataFactory().getOWLSubClassOfAxiom((OWLClassExpression)subClass, (OWLClassExpression)superClass));
    }

    private void processSubDataPropertyOf(OWLDataProperty subProperty, OWLDataProperty superProperty) {
        this.addAxiom((OWLAxiom)this.ontology.getOWLOntologyManager().getOWLDataFactory().getOWLSubDataPropertyOfAxiom((OWLDataPropertyExpression)subProperty, (OWLDataPropertyExpression)superProperty));
    }

    private void processSubObjectPropertyOf(OWLObjectProperty subProperty, OWLObjectProperty superProperty) {
        this.addAxiom((OWLAxiom)this.ontology.getOWLOntologyManager().getOWLDataFactory().getOWLSubObjectPropertyOfAxiom((OWLObjectPropertyExpression)subProperty, (OWLObjectPropertyExpression)superProperty));
    }
}

