/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.owlapi.translator;

import de.tudresden.inf.lat.jcel.coreontology.axiom.FunctObjectPropAxiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.GCI0Axiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.GCI1Axiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.GCI2Axiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.GCI3Axiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.IntegerAnnotation;
import de.tudresden.inf.lat.jcel.coreontology.axiom.NominalAxiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.NormalizedIntegerAxiomVisitor;
import de.tudresden.inf.lat.jcel.coreontology.axiom.RI1Axiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.RI2Axiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.RI3Axiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.RangeAxiom;
import de.tudresden.inf.lat.jcel.owlapi.translator.Translator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLOntology;

public class ReverseAxiomTranslator
implements NormalizedIntegerAxiomVisitor<OWLAxiom> {
    private final Translator translator;
    private final OWLOntology ontology;

    public ReverseAxiomTranslator(Translator translator, OWLOntology ontology) {
        Objects.requireNonNull(translator);
        Objects.requireNonNull(ontology);
        this.translator = translator;
        this.ontology = ontology;
    }

    @Override
    public OWLAxiom visit(FunctObjectPropAxiom axiom) {
        Objects.requireNonNull(axiom);
        OWLObjectProperty owlProperty = this.translator.getTranslationRepository().getOWLObjectProperty(axiom.getProperty());
        Set<OWLAnnotation> owlAnnotations = this.translateAnnotations(axiom.getAnnotations());
        OWLDataFactory dataFactory = this.ontology.getOWLOntologyManager().getOWLDataFactory();
        return dataFactory.getOWLFunctionalObjectPropertyAxiom((OWLObjectPropertyExpression)owlProperty, owlAnnotations);
    }

    @Override
    public OWLAxiom visit(GCI0Axiom axiom) {
        Objects.requireNonNull(axiom);
        OWLClass owlSubClass = this.translator.getTranslationRepository().getOWLClass(axiom.getSubClass());
        OWLClass owlSuperClass = this.translator.getTranslationRepository().getOWLClass(axiom.getSuperClass());
        Set<OWLAnnotation> owlAnnotations = this.translateAnnotations(axiom.getAnnotations());
        OWLDataFactory dataFactory = this.ontology.getOWLOntologyManager().getOWLDataFactory();
        return dataFactory.getOWLSubClassOfAxiom((OWLClassExpression)owlSubClass, (OWLClassExpression)owlSuperClass, owlAnnotations);
    }

    @Override
    public OWLAxiom visit(GCI1Axiom axiom) {
        Objects.requireNonNull(axiom);
        OWLClass owlLeftSubClass = this.translator.getTranslationRepository().getOWLClass(axiom.getLeftSubClass());
        OWLClass owlRightSubClass = this.translator.getTranslationRepository().getOWLClass(axiom.getRightSubClass());
        OWLClass owlSuperClass = this.translator.getTranslationRepository().getOWLClass(axiom.getSuperClass());
        Set<OWLAnnotation> owlAnnotations = this.translateAnnotations(axiom.getAnnotations());
        OWLDataFactory dataFactory = this.ontology.getOWLOntologyManager().getOWLDataFactory();
        HashSet<OWLClass> set = new HashSet<OWLClass>();
        set.add(owlLeftSubClass);
        set.add(owlRightSubClass);
        OWLObjectIntersectionOf owlObjectIntersectionOf = dataFactory.getOWLObjectIntersectionOf(set);
        return dataFactory.getOWLSubClassOfAxiom((OWLClassExpression)owlObjectIntersectionOf, (OWLClassExpression)owlSuperClass, owlAnnotations);
    }

    @Override
    public OWLAxiom visit(GCI2Axiom axiom) {
        Objects.requireNonNull(axiom);
        OWLClass owlSubClass = this.translator.getTranslationRepository().getOWLClass(axiom.getSubClass());
        OWLClass owlClassInSuperClass = this.translator.getTranslationRepository().getOWLClass(axiom.getClassInSuperClass());
        OWLObjectProperty owlObjectProperty = this.translator.getTranslationRepository().getOWLObjectProperty(axiom.getPropertyInSuperClass());
        Set<OWLAnnotation> owlAnnotations = this.translateAnnotations(axiom.getAnnotations());
        OWLDataFactory dataFactory = this.ontology.getOWLOntologyManager().getOWLDataFactory();
        OWLObjectSomeValuesFrom owlObjectSomeValuesFrom = dataFactory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)owlObjectProperty, (OWLClassExpression)owlClassInSuperClass);
        return dataFactory.getOWLSubClassOfAxiom((OWLClassExpression)owlSubClass, (OWLClassExpression)owlObjectSomeValuesFrom, owlAnnotations);
    }

    @Override
    public OWLAxiom visit(GCI3Axiom axiom) {
        Objects.requireNonNull(axiom);
        OWLClass owlSuperClass = this.translator.getTranslationRepository().getOWLClass(axiom.getSuperClass());
        OWLClass owlClassInSubClass = this.translator.getTranslationRepository().getOWLClass(axiom.getClassInSubClass());
        OWLObjectProperty owlObjectProperty = this.translator.getTranslationRepository().getOWLObjectProperty(axiom.getPropertyInSubClass());
        Set<OWLAnnotation> owlAnnotations = this.translateAnnotations(axiom.getAnnotations());
        OWLDataFactory dataFactory = this.ontology.getOWLOntologyManager().getOWLDataFactory();
        OWLObjectSomeValuesFrom owlObjectSomeValuesFrom = dataFactory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)owlObjectProperty, (OWLClassExpression)owlClassInSubClass);
        return dataFactory.getOWLSubClassOfAxiom((OWLClassExpression)owlObjectSomeValuesFrom, (OWLClassExpression)owlSuperClass, owlAnnotations);
    }

    @Override
    public OWLAxiom visit(NominalAxiom axiom) {
        Objects.requireNonNull(axiom);
        OWLNamedIndividual owlIndividual = this.translator.getTranslationRepository().getOWLNamedIndividual(axiom.getIndividual());
        OWLClass owlClass = this.translator.getTranslationRepository().getOWLClass(axiom.getClassExpression());
        Set<OWLAnnotation> owlAnnotations = this.translateAnnotations(axiom.getAnnotations());
        OWLDataFactory dataFactory = this.ontology.getOWLOntologyManager().getOWLDataFactory();
        OWLObjectOneOf owlObjectOneOf = dataFactory.getOWLObjectOneOf(new OWLIndividual[]{owlIndividual});
        HashSet<Object> owlClassExpressions = new HashSet<Object>();
        owlClassExpressions.add(owlObjectOneOf);
        owlClassExpressions.add(owlClass);
        return dataFactory.getOWLEquivalentClassesAxiom(owlClassExpressions, owlAnnotations);
    }

    @Override
    public OWLAxiom visit(RangeAxiom axiom) {
        Objects.requireNonNull(axiom);
        OWLObjectProperty owlObjectProperty = this.translator.getTranslationRepository().getOWLObjectProperty(axiom.getProperty());
        OWLClass owlClass = this.translator.getTranslationRepository().getOWLClass(axiom.getRange());
        Set<OWLAnnotation> owlAnnotations = this.translateAnnotations(axiom.getAnnotations());
        OWLDataFactory dataFactory = this.ontology.getOWLOntologyManager().getOWLDataFactory();
        return dataFactory.getOWLObjectPropertyRangeAxiom((OWLObjectPropertyExpression)owlObjectProperty, (OWLClassExpression)owlClass, owlAnnotations);
    }

    @Override
    public OWLAxiom visit(RI1Axiom axiom) {
        Objects.requireNonNull(axiom);
        OWLObjectProperty owlSuperProperty = this.translator.getTranslationRepository().getOWLObjectProperty(axiom.getSuperProperty());
        Set<OWLAnnotation> owlAnnotations = this.translateAnnotations(axiom.getAnnotations());
        OWLDataFactory dataFactory = this.ontology.getOWLOntologyManager().getOWLDataFactory();
        ArrayList owlPropertyList = new ArrayList();
        return dataFactory.getOWLSubPropertyChainOfAxiom(owlPropertyList, (OWLObjectPropertyExpression)owlSuperProperty, owlAnnotations);
    }

    @Override
    public OWLAxiom visit(RI2Axiom axiom) {
        Objects.requireNonNull(axiom);
        OWLObjectProperty owlSubProperty = this.translator.getTranslationRepository().getOWLObjectProperty(axiom.getSubProperty());
        OWLObjectProperty owlSuperProperty = this.translator.getTranslationRepository().getOWLObjectProperty(axiom.getSuperProperty());
        Set<OWLAnnotation> owlAnnotations = this.translateAnnotations(axiom.getAnnotations());
        OWLDataFactory dataFactory = this.ontology.getOWLOntologyManager().getOWLDataFactory();
        return dataFactory.getOWLSubObjectPropertyOfAxiom((OWLObjectPropertyExpression)owlSubProperty, (OWLObjectPropertyExpression)owlSuperProperty, owlAnnotations);
    }

    @Override
    public OWLAxiom visit(RI3Axiom axiom) {
        Objects.requireNonNull(axiom);
        OWLObjectProperty owlLeftSubProperty = this.translator.getTranslationRepository().getOWLObjectProperty(axiom.getLeftSubProperty());
        OWLObjectProperty owlRightSubProperty = this.translator.getTranslationRepository().getOWLObjectProperty(axiom.getRightSubProperty());
        OWLObjectProperty owlSuperProperty = this.translator.getTranslationRepository().getOWLObjectProperty(axiom.getSuperProperty());
        Set<OWLAnnotation> owlAnnotations = this.translateAnnotations(axiom.getAnnotations());
        OWLDataFactory dataFactory = this.ontology.getOWLOntologyManager().getOWLDataFactory();
        ArrayList<OWLObjectProperty> owlPropertyList = new ArrayList<OWLObjectProperty>();
        owlPropertyList.add(owlLeftSubProperty);
        owlPropertyList.add(owlRightSubProperty);
        return dataFactory.getOWLSubPropertyChainOfAxiom(owlPropertyList, (OWLObjectPropertyExpression)owlSuperProperty, owlAnnotations);
    }

    OWLAnnotation translateAnnotation(IntegerAnnotation annotation) {
        Objects.requireNonNull(annotation);
        OWLDataFactory factory = this.ontology.getOWLOntologyManager().getOWLDataFactory();
        OWLAnnotationProperty owlAnnotationProperty = this.translator.getTranslationRepository().getOWLAnnotationProperty(annotation.getAnnotationProperty());
        OWLAnnotationValue owlAnnotationValue = this.translator.getTranslationRepository().getOWLAnnotationValue(annotation.getAnnotationProperty());
        OWLAnnotation owlAnnotation = factory.getOWLAnnotation(owlAnnotationProperty, owlAnnotationValue);
        return owlAnnotation;
    }

    Set<OWLAnnotation> translateAnnotations(Set<IntegerAnnotation> annotations) {
        Objects.requireNonNull(annotations);
        HashSet<OWLAnnotation> owlAnnotations = new HashSet<OWLAnnotation>();
        annotations.forEach(annotation -> owlAnnotations.add(this.translateAnnotation((IntegerAnnotation)annotation)));
        return owlAnnotations;
    }
}

