/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.owlapi.translator;

import java.util.Objects;
import org.semanticweb.owlapi.model.OWLAxiom;

public class TranslationException
extends UnsupportedOperationException {
    private static final long serialVersionUID = 6883202061243751672L;

    public static TranslationException newIncompleteMapException(String item) {
        Objects.requireNonNull(item);
        return new TranslationException("The translation map is incomplete. Item id was not found: '" + item + "'.");
    }

    public static TranslationException newUnsupportedAxiomException(OWLAxiom axiom) {
        Objects.requireNonNull(axiom);
        return new TranslationException("This axiom is not supported: '" + axiom + "'.");
    }

    public static TranslationException newUnsupportedTranslationException(Object o) {
        Objects.requireNonNull(o);
        return new TranslationException("Object cannot be translated: '" + o.toString() + "'.");
    }

    public TranslationException(String message) {
        super(message);
    }

    public TranslationException(String message, Throwable cause) {
        super(message, cause);
    }

    public TranslationException(Throwable cause) {
        super(cause);
    }
}

