/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.reasoner.module;

import de.tudresden.inf.lat.jcel.core.algorithm.common.Processor;
import de.tudresden.inf.lat.jcel.core.algorithm.common.UnclassifiedOntologyException;
import de.tudresden.inf.lat.jcel.core.graph.IntegerHierarchicalGraph;
import de.tudresden.inf.lat.jcel.core.graph.IntegerHierarchicalGraphImpl;
import de.tudresden.inf.lat.jcel.core.graph.IntegerSubsumerGraphImpl;
import de.tudresden.inf.lat.jcel.coreontology.datatype.IntegerEntityManager;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.ComplexIntegerAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.ComplexIntegerAxiomFactory;
import de.tudresden.inf.lat.jcel.ontology.axiom.extension.IntegerOntologyObjectFactory;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerClassExpression;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerDataTypeFactory;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerObjectPropertyExpression;
import de.tudresden.inf.lat.jcel.reasoner.module.ModuleProcessorFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.stream.IntStream;

public class ClassModuleProcessor
implements Processor {
    private static final Integer bottomClassId = IntegerEntityManager.bottomClassId;
    private static final Logger logger = Logger.getLogger(ClassModuleProcessor.class.getName());
    private static final Integer topClassId = IntegerEntityManager.topClassId;
    private Set<ComplexIntegerAxiom> accumulatedAxiomSet = null;
    private final IntegerOntologyObjectFactory axiomFactory;
    private IntegerHierarchicalGraph classHierarchy = null;
    private final Map<Integer, Set<ComplexIntegerAxiom>> classToAxiom = new HashMap<Integer, Set<ComplexIntegerAxiom>>();
    private final Map<Integer, Set<Integer>> classToClass = new HashMap<Integer, Set<Integer>>();
    private IntegerHierarchicalGraphImpl dataPropertyHierarchy = null;
    private Map<Integer, Set<Integer>> directTypes = null;
    private boolean finalClassification = false;
    private boolean isReady = false;
    private Integer moduleIndex = 0;
    private List<Set<ComplexIntegerAxiom>> moduleList = null;
    private IntegerHierarchicalGraph objectPropertyHierarchy = null;
    private Processor processor = null;
    private final ModuleProcessorFactory processorFactory;
    private Map<Integer, Set<Integer>> sameIndividualMap = null;
    private final Set<ComplexIntegerAxiom> sharedAxioms = new HashSet<ComplexIntegerAxiom>();

    public ClassModuleProcessor(Set<ComplexIntegerAxiom> axiomSet, IntegerOntologyObjectFactory axFactory, ModuleProcessorFactory procFactory) {
        Objects.requireNonNull(axiomSet);
        Objects.requireNonNull(axFactory);
        Objects.requireNonNull(procFactory);
        this.axiomFactory = axFactory;
        this.processorFactory = procFactory;
        this.preProcess(axiomSet);
    }

    private Set<ComplexIntegerAxiom> convertClassHierarchyToAxioms(IntegerHierarchicalGraph classGraph) {
        HashSet<ComplexIntegerAxiom> ret = new HashSet<ComplexIntegerAxiom>();
        Set annotations = Collections.emptySet();
        classGraph.getElements().forEach(subClass -> {
            Set<Integer> superSet = classGraph.getParents((Integer)subClass);
            superSet.forEach(superClass -> ret.add((ComplexIntegerAxiom)this.getAxiomFactory().createSubClassOfAxiom((IntegerClassExpression)this.getDataTypeFactory().createClass(subClass.intValue()), (IntegerClassExpression)this.getDataTypeFactory().createClass(superClass.intValue()), annotations)));
            Set<Integer> equivSet = classGraph.getEquivalents((Integer)subClass);
            HashSet equivalentClassSet = new HashSet();
            equivSet.forEach(equivalentClass -> equivalentClassSet.add(this.getDataTypeFactory().createClass(equivalentClass.intValue())));
            ret.add((ComplexIntegerAxiom)this.getAxiomFactory().createEquivalentClassesAxiom(equivalentClassSet, annotations));
        });
        return ret;
    }

    private Set<ComplexIntegerAxiom> convertObjectPropertyHierarchyToAxioms(IntegerHierarchicalGraph objectPropertyGraph) {
        HashSet<ComplexIntegerAxiom> ret = new HashSet<ComplexIntegerAxiom>();
        Set annotations = Collections.emptySet();
        objectPropertyGraph.getElements().forEach(subObjectProperty -> {
            Set<Integer> set = objectPropertyGraph.getParents((Integer)subObjectProperty);
            set.forEach(superObjectProperty -> ret.add((ComplexIntegerAxiom)this.getAxiomFactory().createSubObjectPropertyOfAxiom((IntegerObjectPropertyExpression)this.getDataTypeFactory().createObjectProperty(subObjectProperty.intValue()), (IntegerObjectPropertyExpression)this.getDataTypeFactory().createObjectProperty(superObjectProperty.intValue()), annotations)));
            Set<Integer> equivSet = objectPropertyGraph.getEquivalents((Integer)subObjectProperty);
            HashSet propExprSet = new HashSet();
            equivSet.forEach(elem -> propExprSet.add(this.getDataTypeFactory().createObjectProperty(elem.intValue())));
            ret.add((ComplexIntegerAxiom)this.getAxiomFactory().createEquivalentObjectPropertiesAxiom(propExprSet, annotations));
        });
        return ret;
    }

    private void createMaps(Set<ComplexIntegerAxiom> axiomSet) {
        this.classToAxiom.clear();
        this.classToClass.clear();
        this.sharedAxioms.clear();
        axiomSet.forEach(axiom -> {
            Set classSet = axiom.getClassesInSignature();
            if (classSet.isEmpty()) {
                this.sharedAxioms.add((ComplexIntegerAxiom)axiom);
            } else {
                classSet.forEach(classId -> {
                    Set<ComplexIntegerAxiom> complexAxioms = this.classToAxiom.get(classId);
                    if (Objects.isNull(complexAxioms)) {
                        complexAxioms = new HashSet<ComplexIntegerAxiom>();
                        this.classToAxiom.put((Integer)classId, complexAxioms);
                    }
                    complexAxioms.add((ComplexIntegerAxiom)axiom);
                    Set<Integer> otherClasses = this.classToClass.get(classId);
                    if (Objects.isNull(otherClasses)) {
                        otherClasses = new HashSet<Integer>();
                        this.classToClass.put((Integer)classId, otherClasses);
                    }
                    otherClasses.addAll(classSet);
                });
            }
        });
    }

    private List<Set<ComplexIntegerAxiom>> findModules(Set<ComplexIntegerAxiom> axiomSet) {
        this.createMaps(axiomSet);
        ArrayList<Set<ComplexIntegerAxiom>> ret = new ArrayList<Set<ComplexIntegerAxiom>>();
        List<Set<Integer>> clustersOfClasses = this.getClustersOfClasses(axiomSet);
        clustersOfClasses.forEach(classSet -> {
            HashSet<ComplexIntegerAxiom> currentModule = new HashSet<ComplexIntegerAxiom>();
            classSet.forEach(classId -> {
                Set<ComplexIntegerAxiom> reachable = this.classToAxiom.get(classId);
                if (Objects.nonNull(reachable)) {
                    currentModule.addAll(reachable);
                }
            });
            currentModule.addAll(this.sharedAxioms);
            ret.add(currentModule);
        });
        return ret;
    }

    private ComplexIntegerAxiomFactory getAxiomFactory() {
        return this.axiomFactory.getComplexAxiomFactory();
    }

    @Override
    public IntegerHierarchicalGraph getClassHierarchy() {
        if (!this.isReady()) {
            throw new UnclassifiedOntologyException();
        }
        return this.classHierarchy;
    }

    private List<Set<Integer>> getClustersOfClasses(Set<ComplexIntegerAxiom> axiomSet) {
        ArrayList<Set<Integer>> ret = new ArrayList<Set<Integer>>();
        TreeSet allClasses = new TreeSet();
        axiomSet.forEach(axiom -> allClasses.addAll(axiom.getClassesInSignature()));
        allClasses.remove(bottomClassId);
        allClasses.remove(topClassId);
        while (!allClasses.isEmpty()) {
            Integer representativeId = (Integer)allClasses.iterator().next();
            allClasses.remove(representativeId);
            Set<Integer> classSet = this.getReachableClasses(representativeId, axiomSet);
            allClasses.removeAll(classSet);
            ret.add(classSet);
        }
        return ret;
    }

    @Override
    public IntegerHierarchicalGraph getDataPropertyHierarchy() throws UnclassifiedOntologyException {
        if (!this.isReady()) {
            throw new UnclassifiedOntologyException();
        }
        return this.dataPropertyHierarchy;
    }

    private IntegerDataTypeFactory getDataTypeFactory() {
        return this.axiomFactory.getDataTypeFactory();
    }

    @Override
    public Map<Integer, Set<Integer>> getDirectTypes() {
        if (!this.isReady()) {
            throw new UnclassifiedOntologyException();
        }
        return this.directTypes;
    }

    @Override
    public IntegerHierarchicalGraph getObjectPropertyHierarchy() {
        if (!this.isReady()) {
            throw new UnclassifiedOntologyException();
        }
        return this.objectPropertyHierarchy;
    }

    private Set<Integer> getReachableClasses(Integer firstClassId, Set<ComplexIntegerAxiom> axiomSet) {
        HashSet<Integer> ret = new HashSet<Integer>();
        HashSet<Integer> toVisit = new HashSet<Integer>();
        toVisit.add(firstClassId);
        while (!toVisit.isEmpty()) {
            Integer classId = (Integer)toVisit.iterator().next();
            ret.add(classId);
            Set<Integer> reachable = this.classToClass.get(classId);
            if (Objects.nonNull(reachable)) {
                toVisit.addAll(reachable);
            }
            toVisit.removeAll(ret);
        }
        return ret;
    }

    @Override
    public Map<Integer, Set<Integer>> getSameIndividualMap() {
        if (!this.isReady()) {
            throw new UnclassifiedOntologyException();
        }
        return this.sameIndividualMap;
    }

    @Override
    public boolean isReady() {
        return this.isReady;
    }

    private void preProcess(Set<ComplexIntegerAxiom> axioms) {
        this.isReady = false;
        this.finalClassification = false;
        logger.fine("using " + this.getClass().getSimpleName() + " ...");
        this.dataPropertyHierarchy = new IntegerHierarchicalGraphImpl(new IntegerSubsumerGraphImpl(IntegerEntityManager.bottomDataPropertyId, IntegerEntityManager.topDataPropertyId));
        this.moduleList = this.findModules(axioms);
        logger.fine("modules found : " + this.moduleList.size());
        IntStream.range(0, this.moduleList.size()).forEach(index -> logger.fine("module " + index + " has " + this.moduleList.get(index).size() + " axioms"));
        this.moduleIndex = 0;
        this.accumulatedAxiomSet = new HashSet<ComplexIntegerAxiom>();
        this.directTypes = new HashMap<Integer, Set<Integer>>();
        this.sameIndividualMap = new HashMap<Integer, Set<Integer>>();
        logger.fine("");
        logger.fine("");
        logger.fine("classifying module " + this.moduleIndex + " ...");
        this.processor = this.processorFactory.createProcessor(this.moduleList.get(this.moduleIndex));
    }

    @Override
    public boolean process() {
        boolean hasMoreEntries;
        if (!this.isReady && !(hasMoreEntries = this.processor.process())) {
            if (this.finalClassification) {
                this.classHierarchy = this.processor.getClassHierarchy();
                this.objectPropertyHierarchy = this.processor.getObjectPropertyHierarchy();
                this.isReady = true;
            } else {
                hasMoreEntries = true;
                this.directTypes.putAll(this.processor.getDirectTypes());
                this.sameIndividualMap.putAll(this.processor.getSameIndividualMap());
                this.accumulatedAxiomSet.addAll(this.convertClassHierarchyToAxioms(this.processor.getClassHierarchy()));
                this.accumulatedAxiomSet.addAll(this.convertObjectPropertyHierarchyToAxioms(this.processor.getObjectPropertyHierarchy()));
                this.processor = null;
                logger.fine("module " + this.moduleIndex + " has been classified.");
                logger.fine("");
                ClassModuleProcessor classModuleProcessor = this;
                Integer n = classModuleProcessor.moduleIndex;
                Integer n2 = classModuleProcessor.moduleIndex = Integer.valueOf(classModuleProcessor.moduleIndex + 1);
                if (this.moduleIndex < this.moduleList.size()) {
                    logger.fine("classifying module " + this.moduleIndex + " ...");
                    this.processor = this.processorFactory.createProcessor(this.moduleList.get(this.moduleIndex));
                } else {
                    this.finalClassification = true;
                    logger.fine("classifying integration module ...");
                    this.processor = this.processorFactory.createProcessor(this.accumulatedAxiomSet);
                }
            }
        }
        return !this.isReady;
    }
}

