/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.cli;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.semanticweb.elk.loading.AxiomLoader;
import org.semanticweb.elk.loading.Owl2StreamLoader;
import org.semanticweb.elk.owl.exceptions.ElkException;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkNamedIndividual;
import org.semanticweb.elk.owl.parsing.Owl2ParserFactory;
import org.semanticweb.elk.owl.parsing.javacc.Owl2FunctionalStyleParserFactory;
import org.semanticweb.elk.reasoner.ElkInconsistentOntologyException;
import org.semanticweb.elk.reasoner.Reasoner;
import org.semanticweb.elk.reasoner.ReasonerFactory;
import org.semanticweb.elk.reasoner.config.ReasonerConfiguration;
import org.semanticweb.elk.reasoner.stages.LoggingStageExecutor;
import org.semanticweb.elk.reasoner.stages.ReasonerStageExecutor;
import org.semanticweb.elk.reasoner.taxonomy.TaxonomyPrinter;
import org.semanticweb.elk.reasoner.taxonomy.hashing.InstanceTaxonomyHasher;
import org.semanticweb.elk.reasoner.taxonomy.hashing.TaxonomyHasher;
import org.semanticweb.elk.reasoner.taxonomy.model.InstanceTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.Taxonomy;
import org.semanticweb.elk.util.logging.Statistics;

public class Main {
    private static final Logger LOGGER_ = Logger.getLogger(Main.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec inputFile = parser.acceptsAll(Arrays.asList("input", "i"), "input ontology file").withRequiredArg().ofType(File.class).describedAs("ontology");
        ArgumentAcceptingOptionSpec outputFile = parser.acceptsAll(Arrays.asList("output", "o"), "output taxonomy file").withRequiredArg().ofType(File.class).describedAs("taxonomy");
        OptionSpecBuilder printHash = parser.acceptsAll(Arrays.asList("print-hash"), "print taxonomy hash to log");
        OptionSpecBuilder classify = parser.acceptsAll(Arrays.asList("classify", "c"), "classify the ontology");
        OptionSpecBuilder realize = parser.acceptsAll(Arrays.asList("realize", "r"), "realize the ontology");
        OptionSpecBuilder satisfiable = parser.acceptsAll(Arrays.asList("consistent", "satisfiable", "s"), "check consistency of the ontology");
        ArgumentAcceptingOptionSpec nWorkers = parser.acceptsAll(Arrays.asList("workers", "w"), "number of concurrent worker threads").withRequiredArg().ofType(Integer.class);
        ArgumentAcceptingOptionSpec logging = parser.acceptsAll(Arrays.asList("logging", "l"), "logging level for log4j; default INFO").withRequiredArg().ofType(String.class).describedAs("level");
        OptionSpecBuilder verbose = parser.acceptsAll(Arrays.asList("verbose", "v"), "equivalent to --logging=DEBUG");
        OptionSpecBuilder Verbose = parser.acceptsAll(Arrays.asList("Verbose", "V"), "equivalent to --logging=TRACE");
        OptionSpecBuilder quiet = parser.acceptsAll(Arrays.asList("quiet", "q"), "equivalent to --logging=ERROR");
        OptionSpecBuilder version = parser.acceptsAll(Arrays.asList("version"), "print version information");
        OptionSpecBuilder help = parser.acceptsAll(Arrays.asList("help", "h", "?"), "show help");
        OptionSet options = parser.parse(args);
        if (!options.hasOptions() || options.has((OptionSpec)help)) {
            parser.printHelpOn((OutputStream)System.out);
            return;
        }
        if (options.has((OptionSpec)version)) {
            System.out.println(Main.class.getPackage().getImplementationTitle() + " " + Main.class.getPackage().getImplementationVersion());
            return;
        }
        if (!options.has((OptionSpec)inputFile) || Main.countOptions(options, new OptionSpec[]{satisfiable, classify, realize}) != 1) {
            System.err.println("An input ontology and exactly one reasoning task are required!");
            return;
        }
        if (Main.countOptions(options, new OptionSpec[]{logging, verbose, Verbose, quiet}) > 1) {
            System.err.println("Cannot set more than one logging level!");
            return;
        }
        Logger allLoggers = Logger.getLogger((String)"org.semanticweb.elk");
        if (options.has((OptionSpec)logging)) {
            allLoggers.setLevel(Level.toLevel((String)((String)options.valueOf((OptionSpec)logging)), (Level)Level.INFO));
        }
        if (options.has((OptionSpec)verbose)) {
            allLoggers.setLevel(Level.DEBUG);
        }
        if (options.has((OptionSpec)Verbose)) {
            allLoggers.setLevel(Level.TRACE);
        }
        if (options.has((OptionSpec)quiet)) {
            allLoggers.setLevel(Level.ERROR);
        }
        ReasonerConfiguration configuration = ReasonerConfiguration.getConfiguration();
        if (options.has((OptionSpec)nWorkers)) {
            configuration.setParameter("elk.reasoner.number_of_workers", ((Integer)options.valueOf((OptionSpec)nWorkers)).toString());
        }
        ReasonerFactory reasoningFactory = new ReasonerFactory();
        Owl2FunctionalStyleParserFactory parserFactory = new Owl2FunctionalStyleParserFactory();
        Owl2StreamLoader loader = new Owl2StreamLoader((Owl2ParserFactory)parserFactory, (File)options.valueOf((OptionSpec)inputFile));
        Reasoner reasoner = reasoningFactory.createReasoner((AxiomLoader)loader, (ReasonerStageExecutor)new LoggingStageExecutor(), configuration);
        try {
            if (options.has((OptionSpec)satisfiable)) {
                boolean inconsistent = reasoner.isInconsistent();
                if (options.hasArgument((OptionSpec)outputFile)) {
                    Main.writeConsistencyToFile((File)options.valueOf((OptionSpec)outputFile), !inconsistent);
                }
            }
            if (options.has((OptionSpec)classify)) {
                Taxonomy taxonomy = reasoner.getTaxonomyQuietly();
                if (options.hasArgument((OptionSpec)outputFile)) {
                    Main.writeClassTaxonomyToFile((File)options.valueOf((OptionSpec)outputFile), (Taxonomy<ElkClass>)taxonomy);
                }
                if (options.has((OptionSpec)printHash)) {
                    Main.printTaxonomyHash((Taxonomy<ElkClass>)taxonomy);
                }
            }
            if (options.has((OptionSpec)realize)) {
                InstanceTaxonomy taxonomy = null;
                taxonomy = reasoner.getInstanceTaxonomyQuietly();
                if (options.hasArgument((OptionSpec)outputFile)) {
                    Main.writeInstanceTaxonomyToFile((File)options.valueOf((OptionSpec)outputFile), (InstanceTaxonomy<ElkClass, ElkNamedIndividual>)taxonomy);
                }
                if (options.has((OptionSpec)printHash)) {
                    Main.printTaxonomyHash((InstanceTaxonomy<ElkClass, ElkNamedIndividual>)taxonomy);
                }
            }
        }
        finally {
            reasoner.shutdown();
        }
    }

    static void writeConsistencyToFile(File file, Boolean consistent) throws IOException, ElkException {
        if (LOGGER_.isInfoEnabled()) {
            LOGGER_.info((Object)("Writing consistency to " + file));
        }
        FileWriter fstream = new FileWriter(file);
        BufferedWriter writer = new BufferedWriter(fstream);
        writer.write(consistent.toString() + "\n");
        writer.write("# The ontology is " + (consistent != false ? "consistent" : "inconsistent") + ".\n");
        writer.close();
    }

    static void writeClassTaxonomyToFile(File file, Taxonomy<ElkClass> taxonomy) throws IOException, ElkInconsistentOntologyException, ElkException {
        if (LOGGER_.isInfoEnabled()) {
            LOGGER_.info((Object)("Writing taxonomy to " + file));
        }
        Statistics.logOperationStart((String)"Writing taxonomy", (Logger)LOGGER_);
        TaxonomyPrinter.dumpClassTaxomomyToFile(taxonomy, (String)file.getPath(), (boolean)true);
        Statistics.logOperationFinish((String)"Writing taxonomy", (Logger)LOGGER_);
    }

    static void writeInstanceTaxonomyToFile(File file, InstanceTaxonomy<ElkClass, ElkNamedIndividual> taxonomy) throws IOException, ElkInconsistentOntologyException, ElkException {
        if (LOGGER_.isInfoEnabled()) {
            LOGGER_.info((Object)("Writing taxonomy with instances to " + file));
        }
        Statistics.logOperationStart((String)"Writing taxonomy with instances", (Logger)LOGGER_);
        TaxonomyPrinter.dumpInstanceTaxomomyToFile(taxonomy, (String)file.getPath(), (boolean)true);
        Statistics.logOperationFinish((String)"Writing taxonomy with instances", (Logger)LOGGER_);
    }

    static void printTaxonomyHash(Taxonomy<ElkClass> taxonomy) {
        if (LOGGER_.isInfoEnabled()) {
            LOGGER_.info((Object)("Taxonomy hash: " + Integer.toHexString(TaxonomyHasher.hash(taxonomy))));
        }
    }

    static void printTaxonomyHash(InstanceTaxonomy<ElkClass, ElkNamedIndividual> taxonomy) {
        if (LOGGER_.isInfoEnabled()) {
            LOGGER_.info((Object)("Taxonomy hash: " + Integer.toHexString(InstanceTaxonomyHasher.hash(taxonomy))));
        }
    }

    static int countOptions(OptionSet options, OptionSpec<?> ... specs) {
        int count = 0;
        for (OptionSpec<?> s : specs) {
            if (!options.has(s)) continue;
            ++count;
        }
        return count;
    }
}

