/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.engine;

import java.util.HashMap;
import java.util.Iterator;
import java.util.StringJoiner;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.impl.Util;
import org.apache.jena.riot.other.G;
import org.apache.jena.shacl.engine.constraint.SparqlConstraint;
import org.apache.jena.shacl.lib.ShLib;
import org.apache.jena.shacl.parser.Constraint;
import org.apache.jena.shacl.parser.ShaclParseException;
import org.apache.jena.shacl.vocabulary.SHACL;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.graph.NodeConst;
import org.apache.jena.util.iterator.ExtendedIterator;

public class SparqlConstraints {
    private static String prefixesQueryString = StrUtils.strjoinNL((String[])new String[]{"PREFIX owl:     <http://www.w3.org/2002/07/owl#>", "PREFIX sh:      <http://www.w3.org/ns/shacl#>", "SELECT * { ?x sh:prefixes/owl:imports*/sh:declare [ sh:prefix ?prefix ; sh:namespace ?namespace ] }"});
    private static Query prefixesQuery = QueryFactory.create((String)prefixesQueryString);
    private static Var varPrefix = Var.alloc((String)"prefix");
    private static Var varNamespace = Var.alloc((String)"namespace");

    public static Constraint parseSparqlConstraint(Graph shapesGraph, Node shape, Node p, Node sparqlConstraintNode) {
        Node message = G.getZeroOrOneSP((Graph)shapesGraph, (Node)sparqlConstraintNode, (Node)SHACL.message);
        boolean deactivated = SparqlConstraints.absentOrOne(shapesGraph, sparqlConstraintNode, SHACL.deactivated, NodeConst.nodeTrue);
        String prefixes = SparqlConstraints.prefixes(shapesGraph, sparqlConstraintNode);
        Node selectNode = G.getOneSP((Graph)shapesGraph, (Node)sparqlConstraintNode, (Node)SHACL.select);
        if (!Util.isSimpleString((Node)selectNode)) {
            throw new ShaclParseException("Not a string for sh:select: " + ShLib.displayStr(selectNode));
        }
        String selectQuery = selectNode.getLiteralLexicalForm();
        String qs = prefixes + "\n" + selectQuery;
        String msg = message != null && message.isLiteral() ? message.getLiteralLexicalForm() : null;
        try {
            Query query = SparqlConstraints.parseQueryString(qs);
            return new SparqlConstraint(query, msg);
        }
        catch (QueryParseException ex) {
            throw new ShaclParseException("SPARQL parse error: " + ex.getMessage() + "\n" + qs);
        }
    }

    public static Query parseQueryString(String queryString) {
        Query query = new Query();
        QueryFactory.parse((Query)query, (String)queryString, null, (Syntax)Syntax.defaultQuerySyntax);
        return query;
    }

    private static boolean absentOrOne(Graph g, Node s, Node p, Node o) {
        try (ExtendedIterator iter = G.find((Graph)g, (Node)s, (Node)p, null);){
            if (!iter.hasNext()) {
                boolean bl = false;
                return bl;
            }
            iter.next();
            if (!iter.hasNext()) {
                boolean bl = true;
                return bl;
            }
            long x = Iter.count((Iterator)G.find((Graph)g, (Node)s, (Node)p, null));
            throw new ShaclParseException("More than one (" + x + ") of " + String.format("(%s %s %s)", s, p, o));
        }
    }

    public static String prefixes(Graph shapesGraph, Node sparqlNode) {
        StringJoiner prefixesSJ = new StringJoiner("\n");
        QueryExecution qExec = QueryExecutionFactory.create((Query)prefixesQuery, (DatasetGraph)DatasetGraphFactory.wrap((Graph)shapesGraph));
        ResultSet rs = qExec.execSelect();
        HashMap<String, String> seen = new HashMap<String, String>();
        while (rs.hasNext()) {
            Binding binding = rs.nextBinding();
            Node nPrefix = binding.get(varPrefix);
            Node nNamespace = binding.get(varNamespace);
            String prefix = nPrefix.getLiteralLexicalForm();
            String ns = nNamespace.getLiteralLexicalForm();
            if (seen.containsKey(prefix) && ((String)seen.get(prefix)).equals(ns)) continue;
            prefixesSJ.add("PREFIX " + prefix + ": <" + ns + ">");
            seen.put(prefix, ns);
        }
        return prefixesSJ.toString();
    }
}

