/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.dom;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class DOMMessageFormatter {
    public static final String DOM_DOMAIN = "http://www.w3.org/dom/DOMTR";
    public static final String XML_DOMAIN = "http://www.w3.org/TR/1998/REC-xml-19980210";
    public static final String SERIALIZER_DOMAIN = "http://apache.org/xml/serializer";
    private static ResourceBundle domResourceBundle = null;
    private static ResourceBundle xmlResourceBundle = null;
    private static ResourceBundle serResourceBundle = null;
    private static Locale locale = null;
    public static final String LEVEL3_NOT_SUPPORTED = "DOM Level 3 operations are not supported";
    public static final String NOT_REQUIRED_FOR_XMLSEC_OR_WSS4J = "This method is not required by Apache XML-Security Impl or WSS4J";
    private static final String[] exceptionKeys = new String[]{"INDEX_SIZE_ERR", "DOMSTRING_SIZE_ERR", "HIERARCHY_REQUEST_ERR", "WRONG_DOCUMENT_ERR", "INVALID_CHARACTER_ERR", "NO_DATA_ALLOWED_ERR", "NO_MODIFICATION_ALLOWED_ERR", "NOT_FOUND_ERR", "NOT_SUPPORTED_ERR", "INUSE_ATTRIBUTE_ERR", "INVALID_STATE_ERR", "SYNTAX_ERR", "INVALID_MODIFICATION_ERR", "NAMESPACE_ERR", "INVALID_ACCESS_ERR", "VALIDATION_ERR", "TYPE_MISMATCH_ERR"};

    DOMMessageFormatter() {
        locale = Locale.getDefault();
    }

    public static String formatMessage(String domain, String key, Object[] arguments) throws MissingResourceException {
        String msg2;
        ResourceBundle resourceBundle = DOMMessageFormatter.getResourceBundle(domain);
        if (resourceBundle == null) {
            DOMMessageFormatter.init();
            resourceBundle = DOMMessageFormatter.getResourceBundle(domain);
            if (resourceBundle == null) {
                throw new MissingResourceException("Unknown domain" + domain, null, key);
            }
        }
        try {
            msg2 = key + ": " + resourceBundle.getString(key);
            if (arguments != null) {
                try {
                    msg2 = MessageFormat.format(msg2, arguments);
                }
                catch (Exception e) {
                    msg2 = resourceBundle.getString("FormatFailed");
                    msg2 = msg2 + " " + resourceBundle.getString(key);
                }
            }
        }
        catch (MissingResourceException e) {
            String msg2 = resourceBundle.getString("BadMessageKey");
            throw new MissingResourceException(key, msg2, key);
        }
        if (msg2 == null) {
            msg2 = key;
            if (arguments.length > 0) {
                StringBuffer str = new StringBuffer(msg2);
                str.append('?');
                for (int i = 0; i < arguments.length; ++i) {
                    if (i > 0) {
                        str.append('&');
                    }
                    str.append(String.valueOf(arguments[i]));
                }
            }
        }
        return msg2;
    }

    public static String formatMessage(String domain, int exceptionId, Object[] arguments) throws MissingResourceException {
        return DOMMessageFormatter.formatMessage(domain, exceptionKeys[exceptionId - 1], arguments);
    }

    static ResourceBundle getResourceBundle(String domain) {
        if (domain == DOM_DOMAIN || domain.equals(DOM_DOMAIN)) {
            return domResourceBundle;
        }
        if (domain == XML_DOMAIN || domain.equals(XML_DOMAIN)) {
            return xmlResourceBundle;
        }
        if (domain == SERIALIZER_DOMAIN || domain.equals(SERIALIZER_DOMAIN)) {
            return serResourceBundle;
        }
        return null;
    }

    public static void init() {
        if (locale != null) {
            domResourceBundle = PropertyResourceBundle.getBundle("org.apache.axiom.om.impl.dom.msg.DOMMessages", locale);
            serResourceBundle = PropertyResourceBundle.getBundle("org.apache.axiom.om.impl.dom.msg.XMLSerializerMessages", locale);
            xmlResourceBundle = PropertyResourceBundle.getBundle("org.apache.axiom.om.impl.dom.msg.XMLMessages", locale);
        } else {
            domResourceBundle = PropertyResourceBundle.getBundle("org.apache.axiom.om.impl.dom.msg.DOMMessages");
            serResourceBundle = PropertyResourceBundle.getBundle("org.apache.axiom.om.impl.dom.msg.XMLSerializerMessages");
            xmlResourceBundle = PropertyResourceBundle.getBundle("org.apache.axiom.om.impl.dom.msg.XMLMessages");
        }
    }

    public static void setLocale(Locale dlocale) {
        locale = dlocale;
    }
}

