/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.dom;

import java.io.OutputStream;
import java.io.Writer;
import java.util.Hashtable;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMCloneOptions;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMInformationItem;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.MTOMXMLStreamWriter;
import org.apache.axiom.om.impl.OMNodeEx;
import org.apache.axiom.om.impl.builder.StAXBuilder;
import org.apache.axiom.om.impl.dom.AttrImpl;
import org.apache.axiom.om.impl.dom.DOMConfigurationImpl;
import org.apache.axiom.om.impl.dom.DOMUtil;
import org.apache.axiom.om.impl.dom.DocumentImpl;
import org.apache.axiom.om.impl.dom.ParentNode;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.UserDataHandler;

public abstract class NodeImpl
implements Node {
    private Hashtable userData;
    protected OMFactory factory;
    protected short flags;
    protected static final short HAS_PARENT = 2;
    protected static final short FIRSTCHILD = 4;
    protected static final short SPECIFIED = 16;

    protected NodeImpl(OMFactory factory) {
        this.factory = factory;
    }

    void normalize(DOMConfigurationImpl config) {
    }

    public void normalize() {
    }

    public boolean hasAttributes() {
        return false;
    }

    public boolean hasChildNodes() {
        return false;
    }

    public String getLocalName() {
        return null;
    }

    public String getNamespaceURI() {
        return null;
    }

    public String getNodeValue() throws DOMException {
        return null;
    }

    public String getPrefix() {
        return null;
    }

    public void setNodeValue(String nodeValue) throws DOMException {
    }

    public void setPrefix(String prefix) throws DOMException {
        throw DOMUtil.newDOMException((short)14);
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public Node getFirstChild() {
        return null;
    }

    public Node getLastChild() {
        return null;
    }

    public final Node cloneNode(boolean deep) {
        OMCloneOptions options = new OMCloneOptions();
        options.setPreserveModel(true);
        NodeImpl clone = this.clone(options, null, this.getNodeType() == 2 ? true : deep, false);
        if (!(clone instanceof DocumentImpl)) {
            clone.setOwnerDocument(this.ownerDocument());
        }
        return clone;
    }

    public boolean isSupported(String feature, String version) {
        throw new UnsupportedOperationException();
    }

    final boolean hasParent() {
        return (this.flags & 2) != 0;
    }

    final void hasParent(boolean value) {
        this.flags = (short)(value ? this.flags | 2 : this.flags & 0xFFFFFFFD);
    }

    final boolean isFirstChild() {
        return (this.flags & 4) != 0;
    }

    final void isFirstChild(boolean value) {
        this.flags = (short)(value ? this.flags | 4 : this.flags & 0xFFFFFFFB);
    }

    final boolean isSpecified() {
        return (this.flags & 0x10) != 0;
    }

    final void isSpecified(boolean value) {
        this.flags = (short)(value ? this.flags | 0x10 : this.flags & 0xFFFFFFEF);
    }

    public String getBaseURI() {
        throw new UnsupportedOperationException("TODO");
    }

    public short compareDocumentPosition(Node other) throws DOMException {
        throw DOMUtil.newDOMException((short)9);
    }

    public String getTextContent() throws DOMException {
        return this.getNodeValue();
    }

    void getTextContent(StringBuffer buf) throws DOMException {
        String content = this.getNodeValue();
        if (content != null) {
            buf.append(content);
        }
    }

    public void setTextContent(String textContent) throws DOMException {
        this.setNodeValue(textContent);
    }

    public boolean isSameNode(Node node) {
        return this == node;
    }

    public String lookupPrefix(String namespaceURI) {
        throw new UnsupportedOperationException("TODO");
    }

    public boolean isDefaultNamespace(String namespaceURI) {
        throw new UnsupportedOperationException("TODO");
    }

    public boolean isEqualNode(Node node) {
        boolean equal = true;
        boolean notEqual = false;
        if (this.getNodeType() != node.getNodeType()) {
            return false;
        }
        if (this.checkStringAttributeEquality(node)) {
            if (!this.checkNamedNodeMapEquality(node)) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean checkStringAttributeEquality(Node node) {
        boolean equal = true;
        boolean notEqual = false;
        if (node.getNodeName() == null ^ this.getNodeName() == null) {
            return false;
        }
        if (node.getNodeName() != null && !node.getNodeName().equals(this.getNodeName())) {
            return false;
        }
        if (node.getLocalName() == null ^ this.getLocalName() == null) {
            return false;
        }
        if (node.getLocalName() != null && !node.getLocalName().equals(this.getLocalName())) {
            return false;
        }
        if (node.getNamespaceURI() == null ^ this.getNamespaceURI() == null) {
            return false;
        }
        if (node.getNamespaceURI() != null && !node.getNamespaceURI().equals(this.getNamespaceURI())) {
            return false;
        }
        if (node.getPrefix() == null ^ this.getPrefix() == null) {
            return false;
        }
        if (node.getPrefix() != null && !node.getPrefix().equals(this.getPrefix())) {
            return false;
        }
        if (node.getNodeValue() == null ^ this.getNodeValue() == null) {
            return false;
        }
        return node.getNodeValue() == null || node.getNodeValue().equals(this.getNodeValue());
    }

    private boolean checkNamedNodeMapEquality(Node node) {
        NamedNodeMap nodeNamedNodeMap;
        boolean equal = true;
        boolean notEqual = false;
        if (node.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        NamedNodeMap thisNamedNodeMap = this.getAttributes();
        if (thisNamedNodeMap == null ^ (nodeNamedNodeMap = node.getAttributes()) == null) {
            return false;
        }
        if (thisNamedNodeMap != null) {
            if (thisNamedNodeMap.getLength() != nodeNamedNodeMap.getLength()) {
                return false;
            }
            int itemCount = thisNamedNodeMap.getLength();
            for (int a = 0; a < itemCount; ++a) {
                NodeImpl thisNode = (NodeImpl)thisNamedNodeMap.item(a);
                NodeImpl tmpNode = (NodeImpl)nodeNamedNodeMap.getNamedItem(thisNode.getNodeName());
                if (tmpNode == null) {
                    return false;
                }
                if (thisNode.isEqualNode(tmpNode)) continue;
                return false;
            }
        }
        return true;
    }

    public Object getFeature(String feature, String version) {
        throw new UnsupportedOperationException("TODO");
    }

    public Object setUserData(String key, Object value, UserDataHandler userDataHandler) {
        if (this.userData == null) {
            this.userData = new Hashtable();
        }
        return this.userData.put(key, value);
    }

    public Object getUserData(String key) {
        if (this.userData != null) {
            return this.userData.get(key);
        }
        return null;
    }

    public OMFactory getOMFactory() {
        if (this.factory == null) {
            this.factory = ((StAXSOAPModelBuilder)this.getBuilder()).getSOAPFactory();
        }
        return this.factory;
    }

    abstract ParentNode internalGetOwnerNode();

    abstract void internalSetOwnerNode(ParentNode var1);

    abstract NodeImpl internalGetPreviousSibling();

    abstract NodeImpl internalGetNextSibling();

    abstract void internalSetPreviousSibling(NodeImpl var1);

    abstract void internalSetNextSibling(NodeImpl var1);

    final DocumentImpl ownerDocument() {
        ParentNode ownerNode = this.internalGetOwnerNode();
        if (ownerNode == null) {
            DocumentImpl document = new DocumentImpl(this.factory.getMetaFactory().getOMFactory());
            this.internalSetOwnerNode(document);
            return document;
        }
        if (ownerNode instanceof DocumentImpl) {
            return (DocumentImpl)ownerNode;
        }
        return ownerNode.ownerDocument();
    }

    void checkSameOwnerDocument(Node otherNode) {
        if (this.ownerDocument() != (otherNode instanceof AttrImpl ? ((AttrImpl)otherNode).getOwnerDocument() : ((NodeImpl)otherNode).ownerDocument())) {
            throw DOMUtil.newDOMException((short)4);
        }
    }

    void setOwnerDocument(DocumentImpl document) {
        if (this.hasParent()) {
            throw new IllegalStateException();
        }
        this.internalSetOwnerNode(document);
    }

    public Document getOwnerDocument() {
        return this.ownerDocument();
    }

    ParentNode parentNode() {
        return this.hasParent() ? this.internalGetOwnerNode() : null;
    }

    public final OMNode getNextOMSiblingIfAvailable() {
        return (OMNode)this.internalGetNextSibling();
    }

    public final OMNode getPreviousOMSibling() {
        return (OMNode)this.internalGetPreviousSibling();
    }

    public final Node getPreviousSibling() {
        return this.internalGetPreviousSibling();
    }

    public final void setNextOMSibling(OMNode node) {
        if (node == null) {
            this.internalSetNextSibling(null);
            return;
        }
        if (!(node instanceof NodeImpl)) {
            throw new OMException("The node is not a " + NodeImpl.class);
        }
        this.internalSetNextSibling((NodeImpl)node);
    }

    public final void setPreviousOMSibling(OMNode node) {
        if (node == null) {
            this.internalSetPreviousSibling(null);
            return;
        }
        if (!(node instanceof NodeImpl)) {
            throw new OMException("The node is not a " + NodeImpl.class);
        }
        this.internalSetPreviousSibling((NodeImpl)node);
    }

    public final OMContainer getParent() throws OMException {
        ParentNode parent = this.parentNode();
        return parent instanceof OMContainer ? (OMContainer)this.parentNode() : null;
    }

    public Node getParentNode() {
        return this.parentNode();
    }

    public final void setParent(OMContainer element) {
        this.setParent((ParentNode)element, false);
    }

    protected void setParent(ParentNode parent, boolean useDomSemantics) {
        if (parent == null) {
            this.internalSetOwnerNode(useDomSemantics ? this.ownerDocument() : null);
            this.hasParent(false);
        } else {
            this.internalSetOwnerNode(parent);
            this.hasParent(true);
        }
    }

    public OMNode detach() throws OMException {
        return this.detach(false);
    }

    OMNode detach(boolean useDomSemantics) {
        ParentNode parentNode = this.parentNode();
        if (parentNode == null) {
            throw new OMException("Parent level elements cannot be detached");
        }
        NodeImpl previousSibling = this.internalGetPreviousSibling();
        NodeImpl nextSibling = this.internalGetNextSibling();
        if (previousSibling == null) {
            if (nextSibling != null) {
                parentNode.setFirstChild((OMNode)nextSibling);
            } else {
                parentNode.firstChild = null;
                parentNode.lastChild = null;
            }
        } else {
            previousSibling.setNextOMSibling((OMNode)nextSibling);
        }
        if (nextSibling != null) {
            nextSibling.setPreviousOMSibling((OMNode)previousSibling);
            this.internalSetNextSibling(null);
        }
        if (parentNode != null && parentNode.lastChild == this) {
            parentNode.lastChild = previousSibling;
        }
        this.setParent(null, useDomSemantics);
        this.internalSetPreviousSibling(null);
        return (OMNode)this;
    }

    public void insertSiblingAfter(OMNode sibling) throws OMException {
        NodeImpl nextSibling;
        NodeImpl domSibling;
        ParentNode parentNode = this.parentNode();
        if (parentNode == null) {
            throw new OMException("Parent can not be null");
        }
        if (this == sibling) {
            throw new OMException("Inserting self as the sibling is not allowed");
        }
        ((OMNodeEx)sibling).setParent((OMContainer)parentNode);
        if (sibling instanceof NodeImpl) {
            domSibling = (NodeImpl)sibling;
            domSibling.internalSetPreviousSibling(this);
            nextSibling = this.internalGetNextSibling();
            if (nextSibling == null) {
                parentNode.setLastChild(sibling);
            } else {
                nextSibling.internalSetPreviousSibling(domSibling);
            }
        } else {
            throw new OMException("The given child is not of type " + NodeImpl.class);
        }
        domSibling.internalSetNextSibling(nextSibling);
        this.internalSetNextSibling(domSibling);
    }

    public void insertSiblingBefore(OMNode sibling) throws OMException {
        NodeImpl siblingImpl;
        ParentNode parentNode = this.parentNode();
        if (parentNode == null) {
            throw new OMException("Parent can not be null");
        }
        if (this == sibling) {
            throw new OMException("Inserting self as the sibling is not allowed");
        }
        if (sibling instanceof NodeImpl) {
            siblingImpl = (NodeImpl)sibling;
            siblingImpl.internalSetNextSibling(this);
            NodeImpl previousSibling = this.internalGetPreviousSibling();
            if (previousSibling == null) {
                parentNode.setFirstChild((OMNode)siblingImpl);
                siblingImpl.internalSetPreviousSibling(null);
            } else {
                siblingImpl.setParent(parentNode, false);
                previousSibling.setNextOMSibling((OMNode)siblingImpl);
                siblingImpl.setPreviousOMSibling((OMNode)previousSibling);
            }
        } else {
            throw new OMException("The given child is not of type " + NodeImpl.class);
        }
        this.internalSetPreviousSibling(siblingImpl);
    }

    public abstract OMXMLParserWrapper getBuilder();

    public abstract void setComplete(boolean var1);

    public abstract boolean isComplete();

    abstract void build();

    public void buildWithAttachments() {
        if (!this.isComplete()) {
            this.build();
        }
    }

    public void close(boolean build) {
        OMXMLParserWrapper builder = this.getBuilder();
        if (build) {
            this.build();
        }
        this.setComplete(true);
        if (builder instanceof StAXBuilder && !((StAXBuilder)builder).isClosed()) {
            ((StAXBuilder)builder).releaseParserOnClose(true);
            ((StAXBuilder)builder).close();
        }
    }

    public void serialize(XMLStreamWriter xmlWriter) throws XMLStreamException {
        this.serialize(xmlWriter, true);
    }

    public void serializeAndConsume(XMLStreamWriter xmlWriter) throws XMLStreamException {
        this.serialize(xmlWriter, false);
    }

    public void serialize(XMLStreamWriter xmlWriter, boolean cache) throws XMLStreamException {
        MTOMXMLStreamWriter writer = xmlWriter instanceof MTOMXMLStreamWriter ? (MTOMXMLStreamWriter)xmlWriter : new MTOMXMLStreamWriter(xmlWriter);
        this.internalSerialize((XMLStreamWriter)writer, cache);
        writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(OutputStream output) throws XMLStreamException {
        XMLStreamWriter xmlStreamWriter = StAXUtils.createXMLStreamWriter((OutputStream)output);
        try {
            this.serialize(xmlStreamWriter);
        }
        finally {
            xmlStreamWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(Writer writer) throws XMLStreamException {
        XMLStreamWriter xmlStreamWriter = StAXUtils.createXMLStreamWriter((Writer)writer);
        try {
            this.serialize(xmlStreamWriter);
        }
        finally {
            xmlStreamWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serializeAndConsume(OutputStream output) throws XMLStreamException {
        XMLStreamWriter xmlStreamWriter = StAXUtils.createXMLStreamWriter((OutputStream)output);
        try {
            this.serializeAndConsume(xmlStreamWriter);
        }
        finally {
            xmlStreamWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serializeAndConsume(Writer writer) throws XMLStreamException {
        XMLStreamWriter xmlStreamWriter = StAXUtils.createXMLStreamWriter((Writer)writer);
        try {
            this.serializeAndConsume(xmlStreamWriter);
        }
        finally {
            xmlStreamWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        MTOMXMLStreamWriter writer = new MTOMXMLStreamWriter(output, format, true);
        try {
            this.internalSerialize((XMLStreamWriter)writer, true);
            writer.flush();
        }
        finally {
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(Writer writer2, OMOutputFormat format) throws XMLStreamException {
        MTOMXMLStreamWriter writer = new MTOMXMLStreamWriter(StAXUtils.createXMLStreamWriter((Writer)writer2));
        writer.setOutputFormat(format);
        try {
            this.internalSerialize((XMLStreamWriter)writer, true);
            writer.flush();
        }
        finally {
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serializeAndConsume(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        MTOMXMLStreamWriter writer = new MTOMXMLStreamWriter(output, format, false);
        try {
            this.internalSerialize((XMLStreamWriter)writer, false);
            writer.flush();
        }
        finally {
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serializeAndConsume(Writer writer2, OMOutputFormat format) throws XMLStreamException {
        MTOMXMLStreamWriter writer = new MTOMXMLStreamWriter(StAXUtils.createXMLStreamWriter((Writer)writer2));
        try {
            writer.setOutputFormat(format);
            this.internalSerialize((XMLStreamWriter)writer, false);
            writer.flush();
        }
        finally {
            writer.close();
        }
    }

    public void internalSerialize(XMLStreamWriter writer) throws XMLStreamException {
        this.internalSerialize(writer, true);
    }

    public void internalSerializeAndConsume(XMLStreamWriter writer) throws XMLStreamException {
        this.internalSerialize(writer, false);
    }

    public abstract void internalSerialize(XMLStreamWriter var1, boolean var2) throws XMLStreamException;

    public final OMInformationItem clone(OMCloneOptions options) {
        return (OMInformationItem)this.clone(options, null, true, true);
    }

    abstract NodeImpl clone(OMCloneOptions var1, ParentNode var2, boolean var3, boolean var4);
}

